/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo.weblogic;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.repodef.LocalizedConstants;
import weblogic.remoteconsole.common.repodef.Localizer;
import weblogic.remoteconsole.server.repo.ArrayValue;
import weblogic.remoteconsole.server.repo.BooleanValue;
import weblogic.remoteconsole.server.repo.DateAsLongValue;
import weblogic.remoteconsole.server.repo.DoubleValue;
import weblogic.remoteconsole.server.repo.IntValue;
import weblogic.remoteconsole.server.repo.LongValue;
import weblogic.remoteconsole.server.repo.ModelToken;
import weblogic.remoteconsole.server.repo.NullReference;
import weblogic.remoteconsole.server.repo.PropertiesValue;
import weblogic.remoteconsole.server.repo.ReferenceAsReferencesValue;
import weblogic.remoteconsole.server.repo.SecretValue;
import weblogic.remoteconsole.server.repo.StringValue;
import weblogic.remoteconsole.server.repo.UnresolvedReference;
import weblogic.remoteconsole.server.repo.Value;
import weblogic.remoteconsole.server.repo.weblogic.BeanTreeEntry;
import weblogic.remoteconsole.server.webapp.FailedRequestException;

public class WDTValueConverter {
    private static final Logger LOGGER = Logger.getLogger(WDTValueConverter.class.getName());

    public static Value getValueType(BeanTreeEntry value, BeanPropertyDef propertyDef, Localizer localizer) {
        if (propertyDef.isArray()) {
            Object propVal = value.getPropertyValue();
            if (WDTValueConverter.isArrayModelToken(propVal)) {
                return new ModelToken((String)String.class.cast(propVal));
            }
            ArrayList<Value> values = new ArrayList<Value>();
            if (propertyDef.isReference()) {
                List<Object> refs = value.getPropertyReference();
                if (value.containsReference()) {
                    for (Object ref : refs) {
                        if (ref instanceof BeanTreeEntry) {
                            values.add(((BeanTreeEntry)ref).getBeanTreePath());
                            continue;
                        }
                        String raw = ref.toString();
                        Value refValue = WDTValueConverter.isModelToken(raw) ? new ModelToken(raw) : new UnresolvedReference(raw);
                        values.add(refValue);
                    }
                }
                if (propertyDef.isReferenceAsReferences()) {
                    return new ReferenceAsReferencesValue(values);
                }
                return new ArrayValue(values);
            }
            if (propVal != null) {
                if (propVal instanceof List) {
                    List items = (List)propVal;
                    for (Object item : items) {
                        values.add(WDTValueConverter.getPropertyValue(item, propertyDef, value, localizer));
                    }
                } else if (propVal instanceof String && propVal.toString().contains(",")) {
                    String[] split;
                    for (String item : split = ((String)String.class.cast(propVal)).split(",")) {
                        values.add(WDTValueConverter.getPropertyValue(item.trim(), propertyDef, value, localizer));
                    }
                } else {
                    values.add(WDTValueConverter.getPropertyValue(propVal, propertyDef, value, localizer));
                }
            }
            return new ArrayValue(values);
        }
        return WDTValueConverter.getPropertyValue(value.getPropertyValue(), propertyDef, value, localizer);
    }

    private static Value getPropertyValue(Object item, BeanPropertyDef propertyDef, BeanTreeEntry entry, Localizer localizer) {
        if (item == null) {
            if (propertyDef.isString()) {
                return new StringValue(null);
            }
            if (propertyDef.isReference()) {
                return NullReference.INSTANCE;
            }
            LOGGER.warning("WARNING: " + WDTValueConverter.getMessageNullPropertyValue(entry.getPath(), propertyDef));
            return null;
        }
        if (WDTValueConverter.isModelToken(item)) {
            return new ModelToken((String)String.class.cast(item));
        }
        if (propertyDef.isReference()) {
            return WDTValueConverter.getReferencePropertyValue(entry, item, localizer);
        }
        if (propertyDef.isString()) {
            return WDTValueConverter.getStringPropertyValue(entry, item, localizer);
        }
        if (propertyDef.isSecret()) {
            return WDTValueConverter.getSecretPropertyValue(entry, item, localizer);
        }
        if (propertyDef.isBoolean()) {
            return WDTValueConverter.getBooleanPropertyValue(entry, item, localizer);
        }
        if (propertyDef.isInt()) {
            return WDTValueConverter.getIntPropertyValue(entry, item, localizer);
        }
        if (propertyDef.isLong()) {
            return WDTValueConverter.getLongPropertyValue(entry, item, localizer);
        }
        if (propertyDef.isDouble()) {
            return WDTValueConverter.getDoublePropertyValue(entry, item, localizer);
        }
        if (propertyDef.isDateAsLong()) {
            return new DateAsLongValue(WDTValueConverter.getLongPropertyValue(entry, item, localizer).asLong().getValue());
        }
        if (propertyDef.isProperties()) {
            return WDTValueConverter.getPropertiesPropertyValue(entry, item, localizer);
        }
        throw new AssertionError((Object)("Unknown property type: " + String.valueOf(propertyDef)));
    }

    private static Value getReferencePropertyValue(BeanTreeEntry entry, Object item, Localizer localizer) {
        if (entry.containsReference()) {
            Object ref = entry.getPropertyReference().get(0);
            if (ref instanceof BeanTreeEntry) {
                return ((BeanTreeEntry)ref).getBeanTreePath();
            }
            if (ref != null) {
                return new UnresolvedReference(ref.toString());
            }
            return NullReference.INSTANCE;
        }
        return new UnresolvedReference(WDTValueConverter.getStringPropertyValue(entry, item, localizer).asString().getValue());
    }

    private static Value getStringPropertyValue(BeanTreeEntry entry, Object item, Localizer localizer) {
        if (String.class.isAssignableFrom(item.getClass())) {
            String value = (String)String.class.cast(item);
            return new StringValue(value);
        }
        if (!(item instanceof List) && !(item instanceof Map)) {
            return new StringValue(item.toString());
        }
        throw WDTValueConverter.illegalPropertyValue(entry, item, localizer, LocalizedConstants.WDT_PROPERTY_VALUE_NOT_A_STRING);
    }

    private static Value getSecretPropertyValue(BeanTreeEntry entry, Object item, Localizer localizer) {
        if (String.class.isAssignableFrom(item.getClass())) {
            return new SecretValue((String)String.class.cast(item));
        }
        if (!(item instanceof List) && !(item instanceof Map)) {
            return new SecretValue(item.toString());
        }
        throw WDTValueConverter.illegalPropertyValue(entry, "********", localizer, LocalizedConstants.WDT_PROPERTY_VALUE_NOT_A_STRING);
    }

    private static Value getBooleanPropertyValue(BeanTreeEntry entry, Object item, Localizer localizer) {
        if (Boolean.class.isAssignableFrom(item.getClass())) {
            boolean value = (Boolean)Boolean.class.cast(item);
            return new BooleanValue(value);
        }
        if (String.class.isAssignableFrom(item.getClass())) {
            String str = ((String)String.class.cast(item)).toLowerCase();
            if ("true".equals(str)) {
                return new BooleanValue(true);
            }
            if ("false".equals(str)) {
                return new BooleanValue(false);
            }
        }
        throw WDTValueConverter.illegalPropertyValue(entry, item, localizer, LocalizedConstants.WDT_PROPERTY_VALUE_NOT_A_BOOLEAN);
    }

    private static Value getIntPropertyValue(BeanTreeEntry entry, Object item, Localizer localizer) {
        if (Integer.class.isAssignableFrom(item.getClass())) {
            int value = (Integer)Integer.class.cast(item);
            return new IntValue(value);
        }
        if (String.class.isAssignableFrom(item.getClass())) {
            try {
                int value = Integer.parseInt((String)String.class.cast(item));
                return new IntValue(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw WDTValueConverter.illegalPropertyValue(entry, item, localizer, LocalizedConstants.WDT_PROPERTY_VALUE_NOT_AN_INT);
    }

    private static Value getLongPropertyValue(BeanTreeEntry entry, Object item, Localizer localizer) {
        if (Integer.class.isAssignableFrom(item.getClass())) {
            long value = ((Integer)Integer.class.cast(item)).longValue();
            return new LongValue(value);
        }
        if (Long.class.isAssignableFrom(item.getClass())) {
            long value = (Long)Long.class.cast(item);
            return new LongValue(value);
        }
        if (String.class.isAssignableFrom(item.getClass())) {
            try {
                long value = Long.parseLong((String)String.class.cast(item));
                return new LongValue(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw WDTValueConverter.illegalPropertyValue(entry, item, localizer, LocalizedConstants.WDT_PROPERTY_VALUE_NOT_A_LONG);
    }

    private static Value getDoublePropertyValue(BeanTreeEntry entry, Object item, Localizer localizer) {
        if (Double.class.isAssignableFrom(item.getClass())) {
            Double value = (Double)Double.class.cast(item);
            return new DoubleValue(value);
        }
        if (String.class.isAssignableFrom(item.getClass())) {
            try {
                Double value = Double.parseDouble((String)String.class.cast(item));
                return new DoubleValue(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw WDTValueConverter.illegalPropertyValue(entry, item, localizer, LocalizedConstants.WDT_PROPERTY_VALUE_NOT_A_DOUBLE);
    }

    private static Value getPropertiesPropertyValue(BeanTreeEntry entry, Object item, Localizer localizer) {
        if (Map.class.isAssignableFrom(item.getClass())) {
            return new PropertiesValue(WDTValueConverter.getPropertiesFromMap(item));
        }
        if (String.class.isAssignableFrom(item.getClass())) {
            return new PropertiesValue(WDTValueConverter.getPropertiesFromString((String)String.class.cast(item)));
        }
        throw WDTValueConverter.illegalPropertyValue(entry, item, localizer, LocalizedConstants.WDT_PROPERTY_VALUE_NOT_PROPERTIES);
    }

    public static Object getJavaType(Value value, BeanPropertyDef propertyDef, Localizer localizer) {
        if (value.isString()) {
            return value.asString().getValue();
        }
        if (value.isSecret()) {
            return value.asSecret().getValue();
        }
        if (value.isBoolean()) {
            return value.asBoolean().getValue();
        }
        if (value.isInt()) {
            return value.asInt().getValue();
        }
        if (value.isLong()) {
            return value.asLong().getValue();
        }
        if (value.isDouble()) {
            return value.asDouble().getValue();
        }
        if (value.isModelToken()) {
            String token = value.asModelToken().getToken();
            if (!WDTValueConverter.isModelToken(token)) {
                throw WDTValueConverter.failedRequestException(localizer, LocalizedConstants.INVALID_MODEL_TOKEN, token);
            }
            return token;
        }
        if (value.isUnresolvedReference()) {
            String key = value.asUnresolvedReference().getKey();
            if (key == null || key.isBlank()) {
                throw WDTValueConverter.failedRequestException(localizer, LocalizedConstants.NO_UNRESOLVED_REF, propertyDef.getOfflinePropertyName());
            }
            return key;
        }
        if (value.isNullReference()) {
            return null;
        }
        if (value.isBeanTreePath()) {
            return value.asBeanTreePath().getLastSegment().getKey();
        }
        if (value.isReferenceAsReferences()) {
            Value ref = value.asReferenceAsReferences().asReference();
            if (ref == null) {
                throw WDTValueConverter.failedRequestException(localizer, LocalizedConstants.NO_REFS_VALUE, propertyDef.getOfflinePropertyName());
            }
            return WDTValueConverter.getJavaType(ref, propertyDef, localizer);
        }
        if (value.isDate()) {
            return value.asDate().getValue().toString();
        }
        if (value.isProperties()) {
            return WDTValueConverter.getMapFromProperties(value.asProperties().getValue());
        }
        if (value.isArray()) {
            ArrayList items = new ArrayList();
            List<Value> values = value.asArray().getValues();
            if (values != null && !values.isEmpty()) {
                values.forEach(val -> items.add(WDTValueConverter.getJavaType(val, propertyDef, localizer)));
            }
            return items;
        }
        throw new AssertionError((Object)("WDT Value Converter error using " + String.valueOf(propertyDef) + " for: " + String.valueOf(value)));
    }

    private static Map<String, Object> getMapFromProperties(Properties items) {
        LinkedHashMap result = null;
        if (items != null && !items.isEmpty()) {
            TreeMap<String, Object> sorter = new TreeMap<String, Object>();
            LinkedHashMap newItems = new LinkedHashMap();
            items.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, val) -> sorter.put(key.toString(), val)));
            sorter.forEach((key, val) -> newItems.put(key, val));
            result = newItems;
        }
        return result;
    }

    private static Properties getPropertiesFromMap(Object item) {
        Properties result = new Properties();
        if (item instanceof Map) {
            Map properties = (Map)item;
            properties.forEach((key, val) -> result.setProperty((String)key, val != null ? val.toString() : ""));
        }
        return result;
    }

    private static Properties getPropertiesFromString(String item) {
        Properties result = new Properties();
        if (item != null && !item.isBlank()) {
            String[] properties;
            for (String property : properties = item.split(";")) {
                String[] keyval;
                String[] stringArray = keyval = !property.isBlank() ? property.split("=") : null;
                if (keyval == null || keyval.length <= 1) continue;
                result.setProperty(keyval[0].trim(), keyval[1].trim());
            }
        }
        return result;
    }

    private static FailedRequestException illegalPropertyValue(BeanTreeEntry entry, Object item, Localizer localizer, LocalizableString errorMessage) {
        return WDTValueConverter.failedRequestException(localizer, errorMessage, entry.getKey(), item);
    }

    private static String getMessageNullPropertyValue(Path propertyPath, BeanPropertyDef propertyDef) {
        String message = "NULL value for Property " + propertyDef.getPropertyName();
        message = message + " (Type " + String.valueOf((Object)propertyDef.getValueKind()) + "): " + String.valueOf(propertyPath);
        return message;
    }

    public static boolean isPropertyModelToken(BeanTreeEntry entry) {
        if (!entry.isProperty()) {
            return false;
        }
        if (entry.getBeanPropertyDef().isArray()) {
            return WDTValueConverter.isArrayModelToken(entry.getPropertyValue());
        }
        return WDTValueConverter.isModelToken(entry.getPropertyValue());
    }

    private static boolean isArrayModelToken(Object item) {
        if (item instanceof String && !item.toString().contains(",")) {
            return WDTValueConverter.isModelToken(item);
        }
        return false;
    }

    private static boolean isModelToken(Object item) {
        boolean isString = item instanceof String;
        String value = isString ? item.toString() : "";
        return isString && value.startsWith("@@") && value.endsWith("@@");
    }

    private static FailedRequestException failedRequestException(Localizer localizer, LocalizableString errorMessage, Object ... args) {
        LOGGER.fine(errorMessage.getEnglishText(args));
        return new FailedRequestException(localizer.localizeString(errorMessage, args));
    }
}

