/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo.weblogic;

import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public class WDTModelRepresenter {
    private static final Logger LOGGER = Logger.getLogger(WDTModelRepresenter.class.getName());
    private static final String STRINGS_QUOTED_REGEX = "[`&%#,@:\\-\\=\\!\\?\\*\\<\\>\\[\\]\\{\\}]";

    public static Yaml getYamlEmitter() {
        DumperOptions options = new DumperOptions();
        options.setIndent(4);
        options.setSplitLines(false);
        options.setPrettyFlow(true);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        CustomRepresenter representer = new CustomRepresenter(options);
        return new Yaml((Representer)representer, options);
    }

    private static class CustomRepresenter
    extends Representer {
        private Pattern stringsPattern = Pattern.compile("[`&%#,@:\\-\\=\\!\\?\\*\\<\\>\\[\\]\\{\\}]");

        private CustomRepresenter(DumperOptions options) {
            super(options);
            LOGGER.fine("WDTModelRepresenter - Default " + String.valueOf(options.getDefaultScalarStyle()));
        }

        protected Node representScalar(Tag tag, String value, DumperOptions.ScalarStyle style) {
            Node node = super.representScalar(tag, value, style);
            if (node instanceof ScalarNode) {
                ScalarNode n = (ScalarNode)node;
                Tag nodeTag = n.getTag();
                String nodeValue = n.getValue();
                if (nodeTag == Tag.NULL) {
                    node = new ScalarNode(nodeTag, "", n.getStartMark(), n.getEndMark(), DumperOptions.ScalarStyle.PLAIN);
                } else if (nodeTag == Tag.STR && nodeValue != null && this.stringsPattern.matcher(nodeValue).find()) {
                    node = new ScalarNode(nodeTag, nodeValue, n.getStartMark(), n.getEndMark(), DumperOptions.ScalarStyle.SINGLE_QUOTED);
                }
            }
            return node;
        }

        protected Node representSequence(Tag tag, Iterable<?> sequence, DumperOptions.FlowStyle flowStyle) {
            Node node = super.representSequence(tag, sequence, flowStyle);
            if (node instanceof SequenceNode) {
                SequenceNode n = (SequenceNode)node;
                n.setFlowStyle(DumperOptions.FlowStyle.FLOW);
            }
            return node;
        }
    }
}

