/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo.weblogic;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.BeanChildDef;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.LocalizedConstants;
import weblogic.remoteconsole.common.repodef.Localizer;
import weblogic.remoteconsole.server.repo.weblogic.BeanTree;
import weblogic.remoteconsole.server.repo.weblogic.BeanTreeEntry;
import weblogic.remoteconsole.server.repo.weblogic.WDTModelSchema;

public class WDTModelBuilder {
    private static final Logger LOGGER = Logger.getLogger(WDTModelBuilder.class.getName());
    private static final String PROVIDER_NAME = "Name";
    private static final String PROVIDER_TYPE = "Type";
    private static final Set<String> NAVTREE_VALID_PATHS = new HashSet<String>();
    private BeanTree beanTree;
    private Localizer localizer;
    private Map<String, Object> model;

    private BeanTree getBeanTree() {
        return this.beanTree;
    }

    private List<Map<String, Object>> getOriginalModels() {
        return this.getBeanTree().getWDTModels();
    }

    private BeanTypeDef getSecurityProviderBeanTypeDef() {
        return this.getBeanTree().getSecurityProviderTypeDef();
    }

    private Map<String, Set<String>> getUnknownProperties() {
        return this.getBeanTree().getUnknownProperties();
    }

    public WDTModelBuilder(BeanTree beanTree, Localizer localizer) {
        this.beanTree = beanTree;
        this.localizer = localizer;
        this.model = new LinkedHashMap<String, Object>();
        this.copySectionsFromOriginalModels(this.model);
        WDTModelSchema.SUPPORTED_SECTIONS.forEach(section -> this.model.put((String)section, new LinkedHashMap()));
    }

    private static void makeValidNavtreeKeySet() {
        WDTModelSchema.SUPPORTED_SECTION_CONTENTS.forEach((section, contents) -> contents.forEach(WDTModelBuilder::addValidNavtreeKey));
        NAVTREE_VALID_PATHS.add("AppDeployments");
        NAVTREE_VALID_PATHS.add("RecentSearches");
    }

    private static void addValidNavtreeKey(String key) {
        NAVTREE_VALID_PATHS.add(key);
        NAVTREE_VALID_PATHS.add(StringUtils.getPlural((String)key));
    }

    public static boolean isValidPath(String dotPath) {
        Path path;
        Path path2 = path = dotPath != null ? new Path(dotPath) : null;
        if (path == null || path.getComponents().size() != 2 || !path.getFirstComponent().equals("Domain")) {
            return true;
        }
        return NAVTREE_VALID_PATHS.contains(path.getLastComponent());
    }

    public Map<String, Object> build() {
        BeanTreeEntry domain = this.beanTree.getDomain();
        this.copyDomain(domain.getBeanValue());
        this.copyUnsuportedSettings();
        this.cleanupModelSections();
        return this.model;
    }

    private void copyDomain(Map<String, BeanTreeEntry> domainBeanValue) {
        domainBeanValue.forEach((key, value) -> {
            if (value.isProperty()) {
                BeanPropertyDef propertyDef = value.getBeanPropertyDef();
                this.getTopology().put(propertyDef.getOfflinePropertyName(), value.getPropertyValue());
            } else if (!value.isTransient()) {
                BeanChildDef childDef = value.getBeanChildDef();
                if (!BeanTree.isMachineType(childDef)) {
                    String name = childDef.getOfflineChildName();
                    name = "AppDeployment".equals(name) ? "Application" : name;
                    this.getSection(name).put(name, this.copyBeanValue(value.getBeanValue()));
                } else {
                    this.copyMachines((BeanTreeEntry)value);
                }
            }
        });
    }

    private Map<String, Object> copyBeanValue(Map<String, BeanTreeEntry> beanValue) {
        if (beanValue == null || beanValue.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        beanValue.forEach((key, value) -> {
            if (value.isProperty()) {
                BeanPropertyDef propertyDef = value.getBeanPropertyDef();
                result.put(propertyDef.getOfflinePropertyName(), value.getPropertyValue());
            } else if (!value.isTransient()) {
                BeanChildDef childDef = value.getBeanChildDef();
                if (childDef.isCollapsedInWDT()) {
                    BeanTreeEntry childValue = value.getBeanValue().get(key);
                    result.put(childDef.getOfflineChildName(), this.copyBeanValue(childValue.getBeanValue()));
                } else if (this.isSecurityProviderBaseType(childDef)) {
                    result.put(childDef.getOfflineChildName(), this.copySecurityProviders((BeanTreeEntry)value));
                } else {
                    String name = key;
                    if (value.isBeanCollection() || !childDef.isCollection()) {
                        name = childDef.getOfflineChildName();
                    }
                    result.put(name, this.copyBeanValue(value.getBeanValue()));
                }
            }
        });
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    private Map<String, Object> getSection(String childName) {
        for (Map.Entry<String, Set<String>> entry : WDTModelSchema.SUPPORTED_SECTION_CONTENTS.entrySet()) {
            if (!entry.getValue().contains(childName)) continue;
            return (Map)this.model.get(entry.getKey());
        }
        LOGGER.warning("WARNING: WDTModelBuilder found unmapped section for: " + childName);
        String error = this.localizer.localizeString(LocalizedConstants.UNMAPPED_SECTION, childName);
        throw new IllegalArgumentException("WDT Model Builder - " + error);
    }

    private Map<String, Object> getTopology() {
        return (Map)this.model.get("topology");
    }

    private void copySectionsFromOriginalModels(Map<String, Object> newModel) {
        this.getOriginalModels().forEach(originalModel -> originalModel.entrySet().stream().forEach(entry -> {
            if (!WDTModelSchema.SUPPORTED_SECTIONS.contains(entry.getKey())) {
                Object newModelValue = newModel.get(entry.getKey());
                if (newModelValue == null) {
                    newModel.put((String)entry.getKey(), entry.getValue());
                } else {
                    Object orignalModelValue = entry.getValue();
                    if (newModelValue instanceof Map && orignalModelValue instanceof Map) {
                        ((Map)newModelValue).putAll((Map)orignalModelValue);
                    }
                }
            }
        }));
    }

    private void copyUnsuportedSettings() {
        this.getOriginalModels().forEach(originalModel -> this.getUnknownProperties().forEach((key, items) -> {
            Object val = originalModel.get(key);
            if (val instanceof Map) {
                Map section = (Map)val;
                items.forEach(item -> {
                    if (section.containsKey(item)) {
                        this.getSection((String)item).put((String)item, section.get(item));
                    }
                });
            }
        }));
    }

    private void cleanupModelSections() {
        WDTModelSchema.SUPPORTED_SECTIONS.forEach(section -> {
            Map value;
            Object val = this.model.get(section);
            if (val instanceof Map && (value = (Map)val).isEmpty()) {
                this.model.remove(section);
            }
        });
    }

    private boolean isSecurityProviderBaseType(BeanChildDef childDef) {
        return childDef.getChildTypeDef().isTypeDef(this.getSecurityProviderBeanTypeDef());
    }

    private Map<String, Object> copySecurityProviders(BeanTreeEntry value) {
        if (value == null || value.getBeanValue().isEmpty()) {
            return null;
        }
        BeanChildDef childDef = value.getBeanChildDef();
        if (!childDef.isCollection()) {
            return this.copySecurityProvider(value);
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        value.getBeanValue().forEach((name, provider) -> {
            Map<String, Object> providerValue = this.copySecurityProvider((BeanTreeEntry)provider);
            result.put((String)name, providerValue.get(name));
        });
        return result;
    }

    private Map<String, Object> copySecurityProvider(BeanTreeEntry provider) {
        Map<String, Object> settings = this.copyBeanValue(provider.getBeanValue());
        this.removeProperty(settings, PROVIDER_NAME);
        this.removeProperty(settings, PROVIDER_TYPE);
        settings = settings.isEmpty() ? null : settings;
        LinkedHashMap<String, Map<String, Object>> type = new LinkedHashMap<String, Map<String, Object>>();
        BeanTreeEntry typeValue = provider.getBeanTreeEntry(PROVIDER_TYPE);
        String typePropertyValue = this.getSecurityProviderType(typeValue);
        type.put(typePropertyValue, settings);
        BeanTreeEntry nameValue = provider.getBeanTreeEntry(PROVIDER_NAME);
        String name = nameValue != null ? nameValue.getPropertyValue().toString() : null;
        name = name == null ? provider.getKey() : name;
        LinkedHashMap<String, Object> providerValue = new LinkedHashMap<String, Object>();
        providerValue.put(name, type);
        return providerValue;
    }

    private String getSecurityProviderType(BeanTreeEntry typeValue) {
        String result = typeValue.getPropertyValue().toString();
        if (!result.equals("weblogic.security.providers.authentication.OracleIdentityCloudIntegrator") && (result.startsWith("weblogic.security.providers.") || result.startsWith("com.bea.security."))) {
            result = StringUtils.getLeafClassName((String)result);
        }
        return result;
    }

    private void copyMachines(BeanTreeEntry machines) {
        Set<String> machineNames;
        Set<String> set = machineNames = machines != null ? machines.getKeySet() : null;
        if (machineNames == null || machineNames.isEmpty()) {
            return;
        }
        BeanChildDef beanChildDef = machines.getBeanChildDef();
        BeanPropertyDef typePropDef = beanChildDef.getChildTypeDef().getSubTypeDiscriminatorPropertyDef();
        String typeProp = typePropDef.getPropertyName();
        LinkedHashMap<String, List> sortedMachines = new LinkedHashMap<String, List>();
        machineNames.forEach(name -> {
            BeanTreeEntry machine = machines.getBeanTreeEntry((String)name);
            BeanTreeEntry type = machine.getBeanValue().get(typeProp);
            if (type == null) {
                LOGGER.warning("WARNING: Machine contains no Type property!");
                return;
            }
            String offlineType = type.getPropertyValue().toString();
            if (!sortedMachines.containsKey(offlineType)) {
                sortedMachines.put(offlineType, new LinkedList());
            }
            ((List)sortedMachines.get(offlineType)).add(machine);
        });
        sortedMachines.forEach((offlineType, listMachines) -> {
            LinkedHashMap result = new LinkedHashMap();
            listMachines.forEach(machine -> {
                Map<String, Object> beanValue = this.copyBeanValue(machine.getBeanValue());
                result.put(machine.getKey(), this.checkRemoveProperty(beanValue, typeProp));
            });
            this.getTopology().put((String)offlineType, result);
        });
    }

    private Map<String, Object> checkRemoveProperty(Object beanValue, String propertyName) {
        Map result = null;
        if (beanValue instanceof Map) {
            Map bean = (Map)beanValue;
            this.removeProperty(bean, propertyName);
            result = bean.isEmpty() ? null : bean;
        }
        return result;
    }

    private void removeProperty(Map<String, Object> beanValue, String propertyName) {
        if (beanValue != null) {
            beanValue.remove(propertyName);
        }
    }

    static {
        WDTModelBuilder.makeValidNavtreeKeySet();
    }
}

