/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo.weblogic;

import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonWriterFactory;
import org.yaml.snakeyaml.Yaml;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanChildDef;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.Localizer;
import weblogic.remoteconsole.common.utils.WebLogicMBeansVersion;
import weblogic.remoteconsole.server.providers.WDTModelDataProvider;
import weblogic.remoteconsole.server.repo.BeanEditorRepo;
import weblogic.remoteconsole.server.repo.BeanPropertyValue;
import weblogic.remoteconsole.server.repo.BeanPropertyValues;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.DownloadBeanRepo;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.ModelTokenReader;
import weblogic.remoteconsole.server.repo.ModelTokens;
import weblogic.remoteconsole.server.repo.Option;
import weblogic.remoteconsole.server.repo.OptionsSource;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.SettableValue;
import weblogic.remoteconsole.server.repo.StringValue;
import weblogic.remoteconsole.server.repo.Value;
import weblogic.remoteconsole.server.repo.weblogic.BeanTree;
import weblogic.remoteconsole.server.repo.weblogic.BeanTreeBuilder;
import weblogic.remoteconsole.server.repo.weblogic.BeanTreeEntry;
import weblogic.remoteconsole.server.repo.weblogic.WDTBeanRepo;
import weblogic.remoteconsole.server.repo.weblogic.WDTBeanRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.weblogic.WDTModelBuilder;
import weblogic.remoteconsole.server.repo.weblogic.WDTModelRepresenter;
import weblogic.remoteconsole.server.repo.weblogic.WDTValueConverter;
import weblogic.remoteconsole.server.webapp.FailedRequestException;

public class WDTEditTreeBeanRepo
extends WDTBeanRepo
implements BeanEditorRepo,
DownloadBeanRepo,
ModelTokenReader {
    private static final Logger LOGGER = Logger.getLogger(WDTEditTreeBeanRepo.class.getName());
    private static final String DOMAIN = "Domain";
    private BeanTree beanTree = null;
    private Yaml emitter = null;
    private JsonWriterFactory writerFactory = null;
    private volatile Map<String, Object> cachedModel = null;

    public WDTEditTreeBeanRepo(WebLogicMBeansVersion mbeansVersion, Map<String, Object> model, InvocationContext ic) {
        super(mbeansVersion);
        if (model != null && !model.isEmpty()) {
            LOGGER.fine("WDT: WDTEditTreeBeanRepo created");
            BeanChildDef rootChildDef = this.getBeanRepoDef().getRootTypeDef().getChildDef(new Path(DOMAIN));
            BeanTreeBuilder builder = new BeanTreeBuilder(model, this, rootChildDef, ic.getLocalizer());
            builder.addModelSections();
            try {
                this.beanTree = builder.build();
            }
            catch (FailedRequestException fre) {
                throw fre;
            }
            catch (Exception exc) {
                throw new FailedRequestException(exc.getMessage());
            }
            if (LOGGER.isLoggable(Level.FINEST)) {
                BeanTreeEntry beanTreeEntry = this.beanTree.getDomain();
                LOGGER.finest("WDT: WDTEditTreeBeanRepo Tree - " + String.valueOf(beanTreeEntry.getBeanTreePath()) + ":" + String.valueOf(this.beanTree));
            }
            LOGGER.fine("WDT: WDTEditTreeBeanRepo bean tree built");
            LOGGER.fine("WDT: WDTEditTreeBeanRepo attempt reference resolution");
            this.beanTree.resolveReferences();
            LOGGER.fine("WDT: WDTEditTreeBeanRepo complete bean tree with required entries not in the model");
            this.beanTree.completeRequiredBeanTreeEntries();
            LOGGER.fine("WDT: WDTEditTreeBeanRepo completed");
        }
    }

    private synchronized void clearCachedModel() {
        this.cachedModel = null;
    }

    private synchronized Map<String, Object> getCachedModel(Localizer localizer) {
        if (this.cachedModel == null && this.beanTree != null) {
            WDTModelBuilder builder = new WDTModelBuilder(this.beanTree, localizer);
            LOGGER.fine("WDT: WDTEditTreeBeanRepo getCachedModel() building model...");
            this.cachedModel = Collections.unmodifiableMap(builder.build());
        }
        return this.cachedModel;
    }

    @Override
    public Map<String, Object> getContent(InvocationContext ic) {
        try {
            return this.getCachedModel(ic.getLocalizer());
        }
        catch (Exception exc) {
            String msg = exc.toString();
            LOGGER.log(Level.SEVERE, "WDT: WDTEditTreeBeanRepo getting model from BeanTree: " + msg, exc);
            throw new FailedRequestException(msg);
        }
    }

    @Override
    public void download(Writer writer, InvocationContext ic) {
        if (this.beanTree != null) {
            Map<String, Object> model = null;
            try {
                model = this.getCachedModel(ic.getLocalizer());
            }
            catch (Exception exc) {
                String msg = exc.toString();
                LOGGER.log(Level.SEVERE, "WDT: WDTEditTreeBeanRepo ERROR converting BeanTree: " + msg, exc);
                throw new FailedRequestException(msg);
            }
            boolean isJson = false;
            if (ic.getProvider() instanceof WDTModelDataProvider) {
                isJson = ((WDTModelDataProvider)ic.getProvider()).isJson();
            }
            LOGGER.fine("WDT: Writing model using " + (isJson ? "JSON" : "YAML"));
            if (isJson) {
                this.writeJson(writer, model);
            } else {
                this.writeYaml(writer, model);
            }
        }
    }

    private void writeYaml(Writer writer, Map<String, Object> model) {
        if (model != null) {
            this.emitter = this.emitter == null ? WDTModelRepresenter.getYamlEmitter() : this.emitter;
            try {
                this.emitter.dump(model, writer);
            }
            catch (Exception exc) {
                String msg = exc.toString();
                LOGGER.log(Level.SEVERE, "WDT: WDTEditTreeBeanRepo ERROR outputting YAML BeanTree: " + msg, exc);
                throw new FailedRequestException(msg);
            }
        }
    }

    private void writeJson(Writer writer, Map<String, Object> model) {
        if (model != null) {
            this.writerFactory = this.writerFactory == null ? WDTEditTreeBeanRepo.getJsonWriterFactory() : this.writerFactory;
            try {
                JsonObject jsonObject = Json.createObjectBuilder(model).build();
                this.writerFactory.createWriter(writer).writeObject(jsonObject);
            }
            catch (Exception exc) {
                String msg = exc.toString();
                LOGGER.log(Level.SEVERE, "WDT: WDTEditTreeBeanRepo ERROR outputting JSON BeanTree: " + msg, exc);
                throw new FailedRequestException(msg);
            }
        }
    }

    private static JsonWriterFactory getJsonWriterFactory() {
        return Json.createWriterFactory(Map.of("javax.json.stream.JsonGenerator.prettyPrinting", true));
    }

    @Override
    public ModelTokens getModelTokens(InvocationContext ic) {
        List<WDTModelDataProvider.PropertySource> sources;
        ModelTokens modelTokens = null;
        if (ic.getProvider() instanceof WDTModelDataProvider && (sources = ((WDTModelDataProvider)ic.getProvider()).getPropertySources()) != null && !sources.isEmpty()) {
            modelTokens = new ModelTokens();
            for (WDTModelDataProvider.PropertySource source : sources) {
                modelTokens.getOptionsSources().add(new OptionsSource(source.getName(), source.getResourceData()));
                List<Option> options = modelTokens.getOptions();
                source.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, val) -> {
                    String label = key.toString();
                    StringValue value = new StringValue("@@PROP:" + label + "@@");
                    options.add(new Option(label, (Value)value));
                }));
            }
        }
        return modelTokens;
    }

    @Override
    public BeanReaderRepoSearchBuilder createSearchBuilder(InvocationContext ic, boolean includeIsSet) {
        LOGGER.fine("WDT: WDTEditTreeBeanRepo createSearchBuilder() " + String.valueOf(ic.getBeanTreePath()) + " - includeSet: " + includeIsSet);
        return new WDTBeanRepoSearchBuilder(this.beanTree, includeIsSet, ic.getLocalizer());
    }

    @Override
    public Response<Void> updateBean(InvocationContext ic, BeanPropertyValues propertyValues) {
        LOGGER.fine("WDT: WDTEditTreeBeanRepo updateBean() " + String.valueOf(ic.getBeanTreePath()) + " - propertyValues: " + String.valueOf(propertyValues));
        Response<Void> response = new Response<Void>();
        if (this.beanTree == null) {
            return response.setNotFound();
        }
        BeanTreeEntry entry = this.beanTree.getBeanTreeEntry(propertyValues.getBeanTreePath());
        if (entry == null) {
            response.setNotFound();
        } else {
            LOGGER.finest("WDT: updateBean(): " + String.valueOf(entry.getPath()));
            Localizer localizer = ic.getLocalizer();
            boolean performReferenceResolution = false;
            for (BeanPropertyValue value : propertyValues.getPropertyValues()) {
                BeanPropertyDef propertyDef = value.getPropertyDef();
                LOGGER.finest("WDT: updateBean() for: " + String.valueOf(propertyDef));
                if (BeanTree.isKey(entry.getBeanTreePath(), propertyDef)) {
                    LOGGER.finest("WDT: updateBean() skipping key property!");
                    continue;
                }
                if (!propertyDef.getParentPath().isEmpty()) {
                    LOGGER.warning("WARNING: updateBean() - Property has parent: " + String.valueOf(propertyDef.getParentPath()));
                    continue;
                }
                boolean unset = value.getValue().isUnset();
                SettableValue newValue = value.getValue();
                BeanTreeEntry property = BeanTree.getProperty(entry, propertyDef.getPropertyPath());
                if (unset) {
                    LOGGER.finest("WDT: updateBean() UNSET: " + String.valueOf(newValue));
                    if (property == null) continue;
                    LOGGER.finest("WDT: updateBean() UNSET previous: " + WDTEditTreeBeanRepo.getDebugValue(property));
                    if (this.beanTree.removeProperty(entry, property)) continue;
                    LOGGER.warning("WDT: updateBean() unable to remove property: " + String.valueOf(property.getPath()));
                    continue;
                }
                if (property != null) {
                    LOGGER.finest("WDT: updateBean() UPDATE: " + String.valueOf(newValue) + " previous: " + WDTEditTreeBeanRepo.getDebugValue(property));
                    Object newPropertyValue = WDTValueConverter.getJavaType(newValue.getValue(), propertyDef, localizer);
                    if (!this.beanTree.updateProperty(entry, property, newPropertyValue)) {
                        LOGGER.warning("WDT: updateBean() unable to update property: " + String.valueOf(property.getPath()));
                    }
                    performReferenceResolution = !performReferenceResolution ? BeanTree.isReference(propertyDef) : true;
                    continue;
                }
                LOGGER.finest("WDT: updateBean() ADD: " + String.valueOf(newValue));
                Object propertyValue = WDTValueConverter.getJavaType(newValue.getValue(), propertyDef, localizer);
                if (!this.beanTree.addProperty(entry, propertyDef, propertyValue)) {
                    LOGGER.warning("WDT: updateBean() unable to add property: " + String.valueOf(propertyDef));
                }
                performReferenceResolution = !performReferenceResolution ? BeanTree.isReference(propertyDef) : true;
            }
            if (performReferenceResolution) {
                LOGGER.finest("WDT: updateBean() resolve only added or updated references!");
                this.beanTree.resolveReferences(false);
            }
        }
        return this.invalidateCachedModel(response);
    }

    @Override
    public Response<Void> createBean(InvocationContext ic, BeanPropertyValues propertyValues) {
        LOGGER.fine("WDT: WDTEditTreeBeanRepo createBean() " + String.valueOf(ic.getBeanTreePath()) + " - propertyValues: " + String.valueOf(propertyValues));
        BeanTreeEntry createdBean = null;
        Response<Void> response = new Response<Void>();
        if (this.beanTree == null) {
            return response.setNotFound();
        }
        BeanTreePath beanTreePath = propertyValues.getBeanTreePath();
        BeanChildDef beanChildDef = beanTreePath.getLastSegment().getChildDef();
        List<BeanPropertyValue> listPropertyValues = propertyValues.getPropertyValues();
        createdBean = !beanChildDef.isCollection() ? this.createSingletonBean(beanTreePath, beanChildDef) : this.createInstanceBean(beanTreePath, listPropertyValues);
        if (createdBean == null) {
            response.setFrontEndBadRequest();
        } else {
            LOGGER.finest("WDT: createBean() created: " + String.valueOf(createdBean.getPath()));
            Localizer localizer = ic.getLocalizer();
            boolean performReferenceResolution = false;
            for (BeanPropertyValue value : listPropertyValues) {
                BeanPropertyDef propertyDef = value.getPropertyDef();
                LOGGER.finest("WDT: createBean() for: " + String.valueOf(propertyDef));
                if (BeanTree.isKey(createdBean.getBeanTreePath(), propertyDef)) {
                    LOGGER.finest("WDT: createBean() skipping key property!");
                    continue;
                }
                if (!propertyDef.getParentPath().isEmpty()) {
                    LOGGER.warning("WARNING: createBean() - Property has parent: " + String.valueOf(propertyDef.getParentPath()));
                    continue;
                }
                boolean unset = value.getValue().isUnset();
                SettableValue newValue = value.getValue();
                if (unset) {
                    LOGGER.finest("WDT: createBean() UNSET: " + String.valueOf(newValue));
                    continue;
                }
                LOGGER.finest("WDT: createBean() ADD: " + String.valueOf(newValue));
                Object propertyValue = WDTValueConverter.getJavaType(newValue.getValue(), propertyDef, localizer);
                if (!this.beanTree.addProperty(createdBean, propertyDef, propertyValue)) {
                    LOGGER.warning("WDT: createBean() unable to add property: " + String.valueOf(propertyDef));
                }
                performReferenceResolution = !performReferenceResolution ? BeanTree.isReference(propertyDef) : true;
            }
            if (performReferenceResolution) {
                LOGGER.finest("WDT: createBean() resolve only added references!");
                this.beanTree.resolveReferences(false);
            }
        }
        return this.invalidateCachedModel(response);
    }

    private BeanTreeEntry createInstanceBean(BeanTreePath beanTreePath, List<BeanPropertyValue> listPropertyValues) {
        BeanTreeEntry parent = this.beanTree.getBeanTreeEntry(beanTreePath);
        if (parent == null) {
            LOGGER.warning("WDT: Unable to find parent bean: " + String.valueOf(beanTreePath.getPath()));
            return null;
        }
        Optional<BeanPropertyValue> keyPropertyValue = listPropertyValues.stream().filter(value -> value.getPropertyDef().isKey()).findFirst();
        if (!keyPropertyValue.isPresent() || keyPropertyValue.get().getValue().isUnset() || keyPropertyValue.get().getValue().getValue() == null || !keyPropertyValue.get().getValue().getValue().isString()) {
            LOGGER.warning("WDT: Unable to determine key property value: " + String.valueOf(keyPropertyValue));
            return null;
        }
        String key = keyPropertyValue.get().getValue().getValue().asString().getValue();
        if (key == null || !this.beanTree.addBean(parent, parent.getBeanChildDef(), key)) {
            LOGGER.warning("WDT: Unable to create bean: " + String.valueOf(parent.getPath()) + " - " + key);
            return null;
        }
        return parent.getBeanTreeEntry(key);
    }

    private BeanTreeEntry createSingletonBean(BeanTreePath beanTreePath, BeanChildDef beanChildDef) {
        String name = beanChildDef.getChildName();
        BeanTreeEntry parent = this.beanTree.getParentBeanTreeEntry(beanTreePath);
        if (parent == null || !this.beanTree.addBean(parent, beanChildDef, name)) {
            LOGGER.finest("WDT: singleton parent bean: " + String.valueOf(parent != null ? parent.getPath() : "None"));
            LOGGER.warning("WDT: Unable to create singleton: " + String.valueOf(beanTreePath.getPath()) + " - " + name);
            return null;
        }
        return parent.getBeanTreeEntry(name);
    }

    @Override
    public Response<Void> deleteBean(InvocationContext ic, BeanTreePath beanTreePath) {
        LOGGER.fine("WDT: WDTEditTreeBeanRepo deleteBean() " + String.valueOf(ic.getBeanTreePath()) + " - beanTreePath: " + String.valueOf(beanTreePath));
        Response<Void> response = new Response<Void>();
        if (this.beanTree == null) {
            return response.setNotFound();
        }
        BeanTreeEntry entry = this.beanTree.getBeanTreeEntry(beanTreePath);
        if (entry == null) {
            response.setNotFound();
        } else {
            LOGGER.finest("WDT: deleteBean(): " + String.valueOf(entry.getPath()));
            BeanTreeEntry parent = this.beanTree.getParentBeanTreeEntry(beanTreePath);
            LOGGER.finest("WDT: deleteBean() parent: " + String.valueOf(parent != null ? parent.getPath() : "None"));
            if (parent == null || !this.beanTree.removeBean(parent, entry)) {
                LOGGER.warning("WDT: deleteBean() unable to delete bean: " + String.valueOf(entry.getPath()));
                response.setServiceNotAvailable();
            }
        }
        return this.invalidateCachedModel(response);
    }

    private Response<Void> invalidateCachedModel(Response<Void> response) {
        if (response.isSuccess()) {
            this.clearCachedModel();
        }
        return response;
    }

    private static String getDebugValue(BeanTreeEntry property) {
        return property.getPropertyValue() != null ? property.getPropertyValue().toString() : "NULL";
    }
}

