/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo.weblogic;

import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.yaml.snakeyaml.Yaml;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanChildDef;
import weblogic.remoteconsole.common.utils.WebLogicMBeansVersion;
import weblogic.remoteconsole.server.repo.BeanReaderRepo;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.DownloadBeanRepo;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.weblogic.BeanTree;
import weblogic.remoteconsole.server.repo.weblogic.BeanTreeBuilder;
import weblogic.remoteconsole.server.repo.weblogic.BeanTreeEntry;
import weblogic.remoteconsole.server.repo.weblogic.WDTBeanRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.weblogic.WDTCompositeBeanRepo;
import weblogic.remoteconsole.server.repo.weblogic.WDTModelBuilder;
import weblogic.remoteconsole.server.repo.weblogic.WDTModelRepresenter;
import weblogic.remoteconsole.server.webapp.FailedRequestException;

public class WDTCompositeTreeBeanRepo
extends WDTCompositeBeanRepo
implements BeanReaderRepo,
DownloadBeanRepo {
    private static final Logger LOGGER = Logger.getLogger(WDTCompositeTreeBeanRepo.class.getName());
    private static final String DOMAIN = "Domain";
    private BeanTree beanTree = null;

    public WDTCompositeTreeBeanRepo(WebLogicMBeansVersion mbeansVersion, List<Map<String, Object>> models, InvocationContext ic) {
        super(mbeansVersion);
        if (models != null && !models.isEmpty()) {
            LOGGER.fine("WDT: WDTCompositeTreeBeanRepo create from " + models.size() + " model(s)");
            BeanChildDef rootChildDef = this.getBeanRepoDef().getRootTypeDef().getChildDef(new Path(DOMAIN));
            for (Map<String, Object> model : models) {
                BeanTreeBuilder builder = this.beanTree == null ? new BeanTreeBuilder(model, this, rootChildDef, ic.getLocalizer()) : new BeanTreeBuilder(this.beanTree, model, ic.getLocalizer());
                builder.addModelSections();
                try {
                    builder.setWDTDeleteApplied();
                    this.beanTree = builder.build();
                    LOGGER.fine("WDT: WDTCompositeTreeBeanRepo created from model: " + this.beanTree.getWDTModels().size());
                }
                catch (Exception exc) {
                    throw new FailedRequestException(exc.getMessage());
                }
            }
            if (LOGGER.isLoggable(Level.FINEST)) {
                BeanTreeEntry beanTreeEntry = this.beanTree.getDomain();
                LOGGER.finest("WDT: WDTCompositeTreeBeanRepo Tree - " + String.valueOf(beanTreeEntry.getBeanTreePath()) + ":" + String.valueOf(this.beanTree));
            }
            LOGGER.fine("WDT: WDTCompositeTreeBeanRepo merged bean tree built");
            LOGGER.fine("WDT: WDTCompositeTreeBeanRepo attempt reference resolution");
            this.beanTree.resolveReferences();
            LOGGER.fine("WDT: WDTCompositeTreeBeanRepo complete bean tree with required entries not in the model");
            this.beanTree.completeRequiredBeanTreeEntries();
            LOGGER.fine("WDT: WDTCompositeTreeBeanRepo completed");
        }
    }

    @Override
    public Map<String, Object> getContent(InvocationContext ic) {
        Map<String, Object> result = null;
        if (this.beanTree != null) {
            try {
                WDTModelBuilder builder = new WDTModelBuilder(this.beanTree, ic.getLocalizer());
                result = builder.build();
            }
            catch (Exception exc) {
                String msg = exc.toString();
                LOGGER.log(Level.SEVERE, "WDT: WDTCompositeTreeBeanRepo getting model from BeanTree: " + msg, exc);
                throw new FailedRequestException(msg);
            }
        }
        return result;
    }

    @Override
    public void download(Writer writer, InvocationContext ic) {
        if (this.beanTree != null) {
            try {
                Yaml emitter = WDTModelRepresenter.getYamlEmitter();
                emitter.dump(this.getContent(ic), writer);
            }
            catch (Exception exc) {
                String msg = exc.toString();
                LOGGER.log(Level.SEVERE, "WDT: WDTCompositeTreeBeanRepo downloading BeanTree: " + msg, exc);
                throw new FailedRequestException(msg);
            }
        }
    }

    @Override
    public BeanReaderRepoSearchBuilder createSearchBuilder(InvocationContext ic, boolean includeIsSet) {
        LOGGER.fine("WDT: WDTCompositeTreeBeanRepo createSearchBuilder() " + String.valueOf(ic.getBeanTreePath()) + " - includeSet: " + includeIsSet);
        return new WDTBeanRepoSearchBuilder(this.beanTree, includeIsSet, ic.getLocalizer());
    }
}

