/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo.weblogic;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.Localizer;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchResults;
import weblogic.remoteconsole.server.repo.BeanSearchResults;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.ReferenceAsReferencesValue;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.SettableValue;
import weblogic.remoteconsole.server.repo.StringValue;
import weblogic.remoteconsole.server.repo.UnknownValue;
import weblogic.remoteconsole.server.repo.Value;
import weblogic.remoteconsole.server.repo.weblogic.BeanTree;
import weblogic.remoteconsole.server.repo.weblogic.BeanTreeEntry;
import weblogic.remoteconsole.server.repo.weblogic.WDTValueConverter;

public class WDTBeanRepoSearchBuilder
implements BeanReaderRepoSearchBuilder {
    private static final Logger LOGGER = Logger.getLogger(WDTBeanRepoSearchBuilder.class.getName());
    private boolean includeIsSet = true;
    private BeanTree beanTree = null;
    private Localizer localizer = null;

    public WDTBeanRepoSearchBuilder(BeanTree beanTree, boolean includeIsSet, Localizer localizer) {
        this.beanTree = beanTree;
        this.includeIsSet = includeIsSet;
        this.localizer = localizer;
    }

    @Override
    public void addProperty(BeanTreePath beanTreePath, BeanPropertyDef propertyDef) {
    }

    @Override
    public Response<BeanReaderRepoSearchResults> search() {
        LOGGER.finest("WDT: BeanReaderRepoSearchResults search()");
        Response<WDTBeanReaderRepoSearchResults> response = new Response<WDTBeanReaderRepoSearchResults>();
        if (this.beanTree == null) {
            return response.setNotFound();
        }
        WDTBeanReaderRepoSearchResults results = new WDTBeanReaderRepoSearchResults(this.beanTree, this.includeIsSet);
        return response.setSuccess(results);
    }

    class WDTBeanReaderRepoSearchResults
    implements BeanReaderRepoSearchResults {
        private boolean includeIsSet = true;
        private BeanTree beanTree = null;
        boolean modeValuesResolved = false;
        boolean secureModeValue = false;
        boolean productionModeValue = false;
        BeanTreeEntry secureMode = null;
        BeanTreeEntry productionMode = null;

        public WDTBeanReaderRepoSearchResults(BeanTree beanTree, boolean includeIsSet) {
            this.beanTree = beanTree;
            this.includeIsSet = includeIsSet;
        }

        @Override
        public BeanSearchResults getBean(BeanTreePath beanTreePath) {
            LOGGER.fine("WDT: BeanReaderRepoSearchResults getBean(): " + String.valueOf(beanTreePath));
            if (beanTreePath.isCollection()) {
                throw new AssertionError((Object)("WDT: getBean() does not return collections: " + String.valueOf(beanTreePath)));
            }
            BeanTreeEntry entry = null;
            if (!beanTreePath.isRoot()) {
                entry = this.beanTree.getBeanTreeEntry(beanTreePath);
                if (entry == null) {
                    return null;
                }
                if (entry.isBeanCollection()) {
                    throw new AssertionError((Object)("WDT: Error getBean() found a bean collection: " + String.valueOf(entry)));
                }
            }
            return new WDTBeanSearchResults(this, beanTreePath, entry, this.includeIsSet);
        }

        @Override
        public List<BeanSearchResults> getUnsortedCollection(BeanTreePath beanTreePath) {
            LOGGER.fine("WDT: BeanReaderRepoSearchResults getUnsortedCollection(): " + String.valueOf(beanTreePath));
            if (!beanTreePath.isCollection()) {
                throw new AssertionError((Object)("WDT: getUnsortedCollection() cannot return a single bean: " + String.valueOf(beanTreePath)));
            }
            BeanTreeEntry entry = this.beanTree.getBeanTreeEntry(beanTreePath);
            if (entry == null) {
                return null;
            }
            if (entry.isBean()) {
                throw new AssertionError((Object)("WDT: Error getUnsortedCollection() found a bean: " + String.valueOf(entry)));
            }
            ArrayList<BeanSearchResults> result = new ArrayList<BeanSearchResults>();
            Set<String> items = entry.getKeySet();
            for (String item : items) {
                BeanTreeEntry instance = entry.getBeanTreeEntry(item);
                result.add(new WDTBeanSearchResults(this, instance.getBeanTreePath(), instance, this.includeIsSet));
            }
            return result;
        }

        Value getDefaultValue(BeanPropertyDef propertyDef) {
            if (!this.modeValuesResolved) {
                this.secureMode = this.beanTree.getSecureModeSetting();
                this.productionMode = this.beanTree.getProductionModeSetting();
                if (this.productionMode != null && this.secureMode != null) {
                    this.secureModeValue = WDTValueConverter.getValueType(this.secureMode, this.secureMode.getBeanPropertyDef(), WDTBeanRepoSearchBuilder.this.localizer).asBoolean().getValue();
                    this.productionModeValue = WDTValueConverter.getValueType(this.productionMode, this.productionMode.getBeanPropertyDef(), WDTBeanRepoSearchBuilder.this.localizer).asBoolean().getValue();
                }
                this.modeValuesResolved = true;
            }
            if (this.productionMode != null && this.secureMode != null) {
                return propertyDef.getDefaultValue(this.secureModeValue, this.productionModeValue);
            }
            return propertyDef.getDefaultValue();
        }
    }

    class WDTBeanSearchResults
    implements BeanSearchResults {
        private WDTBeanReaderRepoSearchResults results;
        private BeanTreePath beanTreePath;
        private BeanTreeEntry beanTreeEntry;
        private boolean includeIsSet;

        public WDTBeanSearchResults(WDTBeanReaderRepoSearchResults results, BeanTreePath beanTreePath, BeanTreeEntry beanTreeEntry, boolean includeIsSet) {
            this.results = results;
            this.beanTreePath = beanTreePath;
            this.beanTreeEntry = beanTreeEntry;
            this.includeIsSet = includeIsSet;
        }

        @Override
        public BeanReaderRepoSearchResults getSearchResults() {
            return this.results;
        }

        @Override
        public BeanTreePath getBeanTreePath() {
            return this.beanTreePath;
        }

        private BeanTreeEntry getBeanTreeEntry() {
            return this.beanTreeEntry;
        }

        private boolean isIncludeIsSet() {
            return this.includeIsSet;
        }

        @Override
        public Value getUnsortedValue(BeanPropertyDef propertyDef) {
            LOGGER.fine("WDT: BeanSearchResults getUnsortedValue() on " + String.valueOf(this.getBeanTreePath()) + " for: " + String.valueOf(propertyDef));
            if (this.getBeanTreePath().isRoot()) {
                return null;
            }
            if (propertyDef.isIdentity()) {
                return this.getReturnValue(this.getBeanTreePath(), false);
            }
            if (BeanTree.isKey(this.getBeanTreePath(), propertyDef)) {
                return this.getReturnValue(new StringValue(this.getBeanTreeEntry().getKey()), true);
            }
            Path propertyPath = propertyDef.getPropertyPath();
            BeanTreeEntry value = BeanTree.getProperty(this.getBeanTreeEntry(), propertyPath);
            LOGGER.fine("WDT: BeanSearchResults getUnsortedValue() lookup found value: " + String.valueOf(value));
            boolean isPropertySet = value != null;
            Value propertyValue = this.getValueOrDefault(value, propertyDef);
            propertyValue = propertyValue != null ? this.getReturnValue(propertyValue, isPropertySet) : this.getUnknownValue(isPropertySet);
            LOGGER.fine("WDT: BeanSearchResults getUnsortedValue() returning property value: " + String.valueOf(propertyValue));
            return propertyValue;
        }

        private Value getReturnValue(Value value, boolean set) {
            Value result = value;
            if (value != null && this.isIncludeIsSet()) {
                result = new SettableValue(value, set);
            }
            return result;
        }

        private Value getUnknownValue(boolean set) {
            Value result = UnknownValue.INSTANCE;
            if (this.isIncludeIsSet()) {
                result = new SettableValue(result, set);
            }
            return result;
        }

        private Value getValueOrDefault(BeanTreeEntry value, BeanPropertyDef propertyDef) {
            if (value == null) {
                Value defaultValue = this.results.getDefaultValue(propertyDef);
                if (propertyDef.isReferenceAsReferences() && defaultValue != null && defaultValue.isArray()) {
                    List<Value> values = defaultValue.asArray().getValues();
                    defaultValue = new ReferenceAsReferencesValue(values);
                }
                return defaultValue;
            }
            return WDTValueConverter.getValueType(value, propertyDef, WDTBeanRepoSearchBuilder.this.localizer);
        }
    }
}

