/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo.weblogic;

import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.weblogic.FabricatedRuntimeMBeanNameHandler;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.weblogic.DelegatedIdentityFixer;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicBeanTypeSearchHelper;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestBeanRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestBeanRepoSearchResults;

class DelegatedRuntimeMBeanWebLogicSearchHelper
extends WebLogicBeanTypeSearchHelper {
    private FabricatedRuntimeMBeanNameHandler nameHandler;
    private DelegatedIdentityFixer identityFixer;

    protected DelegatedRuntimeMBeanWebLogicSearchHelper(FabricatedRuntimeMBeanNameHandler nameHandler, DelegatedIdentityFixer identityFixer) {
        this.nameHandler = nameHandler;
        this.identityFixer = identityFixer;
    }

    @Override
    void addProperty(WebLogicRestBeanRepoSearchBuilder searchBuilder, BeanTreePath beanTreePath, BeanPropertyDef propertyDef) {
        super.addProperty(searchBuilder, this.nameHandler.getUnfabricatedBeanTreePath(beanTreePath), propertyDef);
    }

    @Override
    JsonObject findWebLogicSearchResults(WebLogicRestBeanRepoSearchResults searchResults, BeanTreePath beanTreePath, boolean haveExpandedValues) {
        if (haveExpandedValues) {
            throw new AssertionError((Object)"The server runtime tree never uses expanded values");
        }
        if (beanTreePath.isCollection()) {
            return this.getCollectionResults(searchResults, beanTreePath);
        }
        return this.getBeanResults(searchResults, beanTreePath);
    }

    private JsonObject getCollectionResults(WebLogicRestBeanRepoSearchResults searchResults, BeanTreePath beanTreePath) {
        JsonObject undelResults = super.findWebLogicSearchResults(searchResults, this.nameHandler.getUnfabricatedBeanTreePath(beanTreePath), false);
        if (undelResults == null) {
            return null;
        }
        JsonArrayBuilder items = Json.createArrayBuilder();
        JsonArray undelItems = undelResults.getJsonArray("items");
        for (int i = 0; i < undelItems.size(); ++i) {
            items.add((JsonValue)this.undelegatedBeanResultsToDelegatedBeanResults(beanTreePath.getTypeDef(), undelItems.getJsonObject(i)));
        }
        JsonObjectBuilder rtn = Json.createObjectBuilder();
        rtn.add("items", items);
        return rtn.build();
    }

    private JsonObject getBeanResults(WebLogicRestBeanRepoSearchResults searchResults, BeanTreePath beanTreePath) {
        JsonObject undelResults = super.findWebLogicSearchResults(searchResults, this.nameHandler.getUnfabricatedBeanTreePath(beanTreePath), false);
        if (undelResults == null) {
            return null;
        }
        return this.undelegatedBeanResultsToDelegatedBeanResults(beanTreePath.getTypeDef(), undelResults);
    }

    private JsonObject undelegatedBeanResultsToDelegatedBeanResults(BeanTypeDef beanTypeDef, JsonObject undelResults) {
        return this.identityFixer.undelegatedResultsToDelegatedResults(beanTypeDef, undelResults);
    }
}

