/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo.weblogic;

import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.BeanChildDef;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;

public abstract class DelegatedIdentityFixer {
    protected static final String PROP_IDENTITY = "identity";
    protected static final String PROP_ITEMS = "items";

    public JsonObject undelegatedResultsToDelegatedResults(BeanTypeDef typeDef, JsonObject undelegatedResults) {
        return new Fixer(typeDef, undelegatedResults).fixIdentities();
    }

    protected abstract JsonArray undelegatedIdentityToDelegatedIdentity(JsonArray var1);

    private class Fixer {
        private BeanTypeDef typeDef;
        JsonObject unfixedBean;
        private JsonObjectBuilder fixedBeanBuilder;

        private Fixer(BeanTypeDef typeDef, JsonObject unfixedBean) {
            this.typeDef = typeDef;
            this.unfixedBean = unfixedBean;
            this.fixedBeanBuilder = Json.createObjectBuilder((JsonObject)unfixedBean);
        }

        private JsonObject fixIdentities() {
            for (Map.Entry unfixedBeanProperty : this.unfixedBean.entrySet()) {
                String propertyName = (String)unfixedBeanProperty.getKey();
                if (DelegatedIdentityFixer.PROP_IDENTITY.equals(propertyName)) {
                    this.fixIdentityProperty(((JsonValue)unfixedBeanProperty.getValue()).asJsonArray());
                    continue;
                }
                this.fixNonIdentityProperty(propertyName, (JsonValue)unfixedBeanProperty.getValue());
            }
            return this.fixedBeanBuilder.build();
        }

        private void fixIdentityProperty(JsonArray unfixedIdentity) {
            this.fixedBeanBuilder.add(DelegatedIdentityFixer.PROP_IDENTITY, (JsonValue)this.fixIdentity(unfixedIdentity));
        }

        private void fixNonIdentityProperty(String propertyName, JsonValue unfixedPropertyValue) {
            BeanPropertyDef beanPropDef;
            boolean searchSubTypes;
            Path beanPath = new Path(StringUtils.getBeanName((String)propertyName));
            if (this.typeDef.hasChildDef(beanPath, searchSubTypes = true)) {
                BeanChildDef beanChildDef = this.typeDef.getChildDef(beanPath, searchSubTypes);
                if (beanChildDef.isCollection()) {
                    this.fixContainedCollection(beanChildDef, propertyName, unfixedPropertyValue.asJsonObject().getJsonArray(DelegatedIdentityFixer.PROP_ITEMS));
                } else {
                    this.fixContainedSingleton(beanChildDef, propertyName, unfixedPropertyValue);
                }
            } else if (this.typeDef.hasPropertyDef(beanPath, searchSubTypes) && (beanPropDef = this.typeDef.getPropertyDef(beanPath, searchSubTypes)).isReference()) {
                if (!beanPropDef.isArray()) {
                    this.fixReferenceProperty(propertyName, unfixedPropertyValue);
                } else {
                    this.fixReferencesProperty(propertyName, unfixedPropertyValue.asJsonArray());
                }
            }
        }

        private void fixReferenceProperty(String propertyName, JsonValue unfixedReference) {
            if (unfixedReference == JsonValue.NULL) {
                return;
            }
            this.fixedBeanBuilder.add(propertyName, (JsonValue)this.fixIdentity(unfixedReference.asJsonArray()));
        }

        private void fixReferencesProperty(String propertyName, JsonArray unfixedReferences) {
            if (unfixedReferences.isEmpty()) {
                return;
            }
            JsonArrayBuilder fixedReferencesBuilder = Json.createArrayBuilder();
            for (int i = 0; i < unfixedReferences.size(); ++i) {
                JsonValue unfixedReference = (JsonValue)unfixedReferences.getJsonObject(i).get((Object)DelegatedIdentityFixer.PROP_IDENTITY);
                JsonValue fixedReference = unfixedReference != JsonValue.NULL ? this.fixIdentity(unfixedReference.asJsonArray()) : JsonValue.NULL;
                fixedReferencesBuilder.add(fixedReference);
            }
            this.fixedBeanBuilder.add(propertyName, fixedReferencesBuilder);
        }

        private void fixContainedCollection(BeanChildDef beanChildDef, String propertyName, JsonArray unfixedChildBeans) {
            if (unfixedChildBeans.isEmpty()) {
                return;
            }
            JsonArrayBuilder fixedChildBeansBuilder = Json.createArrayBuilder();
            for (int i = 0; i < unfixedChildBeans.size(); ++i) {
                JsonObject unfixedChildBean = unfixedChildBeans.getJsonObject(i);
                Fixer childBeanFixer = new Fixer(beanChildDef.getChildTypeDef(), unfixedChildBean);
                fixedChildBeansBuilder.add((JsonValue)childBeanFixer.fixIdentities());
            }
            this.fixedBeanBuilder.add(propertyName, Json.createObjectBuilder().add(DelegatedIdentityFixer.PROP_ITEMS, fixedChildBeansBuilder));
        }

        private void fixContainedSingleton(BeanChildDef beanChildDef, String propertyName, JsonValue unfixedChildBean) {
            if (unfixedChildBean == JsonValue.NULL) {
                return;
            }
            Fixer childBeanFixer = new Fixer(beanChildDef.getChildTypeDef(), unfixedChildBean.asJsonObject());
            this.fixedBeanBuilder.add(propertyName, (JsonValue)childBeanFixer.fixIdentities());
        }

        private JsonArray fixIdentity(JsonArray unfixedIdentity) {
            return DelegatedIdentityFixer.this.undelegatedIdentityToDelegatedIdentity(unfixedIdentity);
        }
    }
}

