/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo.weblogic;

import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicBeanTypeSearchHelper;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestBeanRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestBeanRepoSearchResults;

class CombinedServerRuntimeMBeanWebLogicSearchHelper
extends WebLogicBeanTypeSearchHelper {
    CombinedServerRuntimeMBeanWebLogicSearchHelper() {
    }

    @Override
    void addProperty(WebLogicRestBeanRepoSearchBuilder searchBuilder, BeanTreePath beanTreePath, BeanPropertyDef propertyDef) {
        Path propertyPath = propertyDef.getPropertyPath();
        String firstComponent = propertyPath.getFirstComponent();
        Path restOfPath = propertyPath.subPath(1, propertyPath.length());
        BeanTreePath slcrtPath = this.getServerLifeCycleRuntimePath(beanTreePath);
        BeanTreePath srtPath = this.getServerRuntimePath(beanTreePath);
        if ("identity".equals(firstComponent) || "Type".equals(firstComponent) || "State".equals(firstComponent)) {
            Path identityPath = new Path("identity");
            this.addProperty(searchBuilder, slcrtPath, identityPath);
            this.addProperty(searchBuilder, srtPath, identityPath);
            this.addProperty(searchBuilder, srtPath, new Path("State"));
        } else if ("Name".equals(firstComponent)) {
            this.addProperty(searchBuilder, slcrtPath, new Path("Name"));
        } else if ("ServerRuntime".equals(firstComponent)) {
            this.addProperty(searchBuilder, srtPath, restOfPath);
        } else if ("ServerLifeCycleRuntime".equals(firstComponent)) {
            this.addProperty(searchBuilder, slcrtPath, restOfPath);
        } else {
            throw new AssertionError((Object)("Unknown property: " + String.valueOf(propertyDef)));
        }
    }

    private void addProperty(WebLogicRestBeanRepoSearchBuilder searchBuilder, BeanTreePath beanTreePath, Path propertyPath) {
        super.addProperty(searchBuilder, beanTreePath, beanTreePath.getTypeDef().getPropertyDef(propertyPath));
    }

    @Override
    JsonObject findWebLogicSearchResults(WebLogicRestBeanRepoSearchResults searchResults, BeanTreePath beanTreePath, boolean haveExpandedValues) {
        if (haveExpandedValues) {
            throw new AssertionError((Object)"The server runtime tree never uses expanded values");
        }
        if (beanTreePath.isCollection()) {
            return this.getCollectionResults(searchResults, beanTreePath);
        }
        return this.getBeanResults(searchResults, beanTreePath);
    }

    private JsonObject getCollectionResults(WebLogicRestBeanRepoSearchResults searchResults, BeanTreePath beanTreePath) {
        JsonObject slcrt = super.findWebLogicSearchResults(searchResults, this.getServerLifeCycleRuntimePath(beanTreePath), false);
        if (slcrt == null) {
            return null;
        }
        JsonArray items = slcrt.getJsonArray("items");
        JsonArrayBuilder itemsBuilder = Json.createArrayBuilder();
        for (int i = 0; i < items.size(); ++i) {
            String server = items.getJsonObject(i).getJsonArray("identity").getString(1);
            BeanTreePath combinedServerBeanTreePath = BeanTreePath.create(beanTreePath.getBeanRepo(), beanTreePath.getPath().childPath(server));
            JsonObject item = this.getBeanResults(searchResults, combinedServerBeanTreePath);
            itemsBuilder.add((JsonValue)item);
        }
        return Json.createObjectBuilder().add("items", itemsBuilder).build();
    }

    private JsonObject getBeanResults(WebLogicRestBeanRepoSearchResults searchResults, BeanTreePath beanTreePath) {
        JsonObjectBuilder rtn = Json.createObjectBuilder();
        JsonObject slcrt = super.findWebLogicSearchResults(searchResults, this.getServerLifeCycleRuntimePath(beanTreePath), false);
        if (slcrt == null) {
            return null;
        }
        rtn.add("serverLifeCycleRuntime", (JsonValue)slcrt);
        JsonArray slcrtIdentity = slcrt.getJsonArray("identity");
        String name = slcrtIdentity.getString(1);
        rtn.add("name", name);
        JsonArrayBuilder identity = Json.createArrayBuilder();
        identity.add("combinedServerRuntimes");
        identity.add(name);
        rtn.add("identity", identity);
        JsonObject srt = super.findWebLogicSearchResults(searchResults, this.getServerRuntimePath(beanTreePath), false);
        if (srt != null) {
            rtn.add("serverRuntime", (JsonValue)srt);
            rtn.add("type", "RunningServerRuntime");
            rtn.add("state", (JsonValue)srt.get((Object)"state"));
        } else {
            rtn.add("type", "UnreachableServerRuntime");
            rtn.add("state", "UNREACHABLE");
        }
        return rtn.build();
    }

    private BeanTreePath getServerLifeCycleRuntimePath(BeanTreePath beanTreePath) {
        return this.getCorrespondingBeanTreePath("DomainRuntime.ServerLifeCycleRuntimes", beanTreePath);
    }

    private BeanTreePath getServerRuntimePath(BeanTreePath beanTreePath) {
        return this.getCorrespondingBeanTreePath("DomainRuntime.ServerRuntimes", beanTreePath);
    }

    private BeanTreePath getCorrespondingBeanTreePath(String collectionPath, BeanTreePath beanTreePath) {
        Path path = new Path(collectionPath);
        if (beanTreePath.getLastSegment().isKeySet()) {
            path.addComponent(beanTreePath.getLastSegment().getKey());
        }
        return BeanTreePath.create(beanTreePath.getBeanRepo(), path);
    }
}

