/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo.weblogic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.weblogic.BeanTreeEntry;

public class BeanTreeReferenceResolver {
    private static final Logger LOGGER = Logger.getLogger(BeanTreeReferenceResolver.class.getName());
    private List<BeanTreePath> deletedBeans;
    private List<BeanTreeEntry> beanCollections;

    BeanTreeReferenceResolver(List<BeanTreeEntry> beanCollections) {
        this(beanCollections, null);
    }

    BeanTreeReferenceResolver(List<BeanTreeEntry> beanCollections, List<BeanTreePath> deletedBeans) {
        this.beanCollections = beanCollections != null ? beanCollections : List.of();
        this.deletedBeans = deletedBeans != null ? deletedBeans : List.of();
    }

    public void handleUnresolvedReference(BeanTreeEntry unresolved) {
        LOGGER.finest("ReferenceResolver Unresolved: " + String.valueOf(unresolved));
        List<String> keys = BeanTreeReferenceResolver.determineReferenceKeys(unresolved);
        LOGGER.finest("ReferenceResolver finding key(s): " + String.valueOf(keys));
        List<Object> references = this.findReferences(unresolved, keys);
        unresolved.setPropertyReference(references);
        BeanTreeReferenceResolver.debugLogReferences(references);
    }

    public boolean handleDeleteBean(BeanTreeEntry reference) {
        boolean isNullReference;
        LOGGER.finest("ReferenceResolver handle bean delete for: " + String.valueOf(reference));
        boolean isReferenceUpdated = false;
        for (BeanTreePath bean : this.deletedBeans) {
            if (!BeanTreeReferenceResolver.removeReferenceValue(reference, BeanTreeReferenceResolver.isReferenced(bean, reference))) continue;
            isReferenceUpdated = true;
        }
        boolean bl = isNullReference = isReferenceUpdated && reference.getPropertyValue() == null;
        if (isNullReference) {
            LOGGER.finest("ReferenceResolver updated reference is now NULL!");
        }
        BeanTreeReferenceResolver.debugLogReferences(reference.getPropertyReference());
        return isNullReference;
    }

    public static List<String> getReferenceKeys(BeanTreeEntry entry) {
        return BeanTreeReferenceResolver.determineReferenceKeys(entry);
    }

    private static void debugLogReferences(List<Object> references) {
        if (references != null && LOGGER.isLoggable(Level.FINEST)) {
            if (references.isEmpty()) {
                LOGGER.finest("ReferenceResolver resolved to: []");
            } else {
                references.forEach(reference -> {
                    Object logValue = reference;
                    if (reference instanceof BeanTreeEntry) {
                        logValue = ((BeanTreeEntry)reference).getPath();
                    }
                    LOGGER.finest("ReferenceResolver resolved to: " + String.valueOf(logValue));
                });
            }
        }
    }

    private static int isReferenced(BeanTreePath deleted, BeanTreeEntry reference) {
        int result = -1;
        if (reference.containsReference()) {
            List<Object> refs = reference.getPropertyReference();
            for (int i = 0; i < refs.size(); ++i) {
                Object ref = refs.get(i);
                if (!(ref instanceof BeanTreeEntry) || !BeanTreeReferenceResolver.isSameIdentity(deleted, (BeanTreeEntry)ref)) continue;
                result = i;
                break;
            }
        }
        return result;
    }

    private static boolean removeReferenceValue(BeanTreeEntry reference, int index) {
        if (index >= 0) {
            if (!reference.getBeanPropertyDef().isArray()) {
                reference.setPropertyValue(null);
                reference.setPropertyReference(BeanTreeReferenceResolver.getListOfNull());
            } else {
                List<Object> propertyRefs = reference.getPropertyReference();
                propertyRefs.remove(index);
                if (propertyRefs.isEmpty()) {
                    reference.setPropertyValue(null);
                } else {
                    ArrayList<String> propertyValue = new ArrayList<String>();
                    for (Object ref : propertyRefs) {
                        if (ref instanceof BeanTreeEntry) {
                            propertyValue.add(((BeanTreeEntry)ref).getKey());
                            continue;
                        }
                        propertyValue.add(ref.toString());
                    }
                    reference.setPropertyValue(propertyValue);
                }
            }
        }
        return index >= 0;
    }

    private static boolean isSameIdentity(BeanTreePath deleted, BeanTreeEntry reference) {
        List deletedPath = deleted.getPath().getComponents();
        List referencePath = reference.getPath().getComponents();
        if (referencePath.size() != deletedPath.size()) {
            return false;
        }
        for (int i = 0; i < referencePath.size(); ++i) {
            if (((String)referencePath.get(i)).equals(deletedPath.get(i))) continue;
            return false;
        }
        return true;
    }

    private static List<String> determineReferenceKeys(BeanTreeEntry unresolved) {
        LinkedList<String> keys = new LinkedList<String>();
        Object propVal = unresolved.getPropertyValue();
        if (propVal != null) {
            if (!unresolved.getBeanPropertyDef().isArray()) {
                keys.add(propVal.toString());
            } else if (propVal instanceof List) {
                List items = (List)propVal;
                items.forEach(item -> keys.add(item != null ? item.toString() : ""));
            } else if (propVal instanceof String && propVal.toString().contains(",")) {
                List<String> items = Arrays.asList(((String)String.class.cast(propVal)).split(","));
                items.forEach(item -> keys.add(item.trim()));
            } else {
                keys.add(propVal.toString());
            }
        }
        return keys;
    }

    private List<Object> findReferences(BeanTreeEntry unresolved, List<String> keys) {
        if (unresolved.getPropertyValue() == null && !unresolved.getBeanPropertyDef().isArray()) {
            return BeanTreeReferenceResolver.getListOfNull();
        }
        ArrayList<Object> references = new ArrayList<Object>(keys.size());
        for (int i = 0; i < keys.size(); ++i) {
            String key = keys.get(i);
            List<BeanTreeEntry> candidates = this.findReference(key, unresolved);
            references.add(i, BeanTreeReferenceResolver.determineReferenceValue(key, candidates, unresolved));
        }
        return references;
    }

    private List<BeanTreeEntry> findReference(String key, BeanTreeEntry unresolved) {
        LinkedList<BeanTreeEntry> candidates = new LinkedList<BeanTreeEntry>();
        BeanTypeDef refTypeDef = unresolved.getBeanPropertyDef().getReferenceTypeDef();
        for (BeanTreeEntry collection : this.beanCollections) {
            String typeKey;
            BeanTreeEntry candidate;
            if (collection.getBeanChildDef().getChildTypeDef().isTypeDef(refTypeDef)) {
                if (!collection.getKeySet().contains(key)) continue;
                candidate = collection.getBeanTreeEntry(key);
                LOGGER.finest("ReferenceResolver found candidate: " + String.valueOf(candidate.getPath()));
                candidates.add(candidate);
                continue;
            }
            if (!collection.getBeanChildDef().getChildTypeDef().isHeterogeneous() || !refTypeDef.isTypeDef(collection.getBeanChildDef().getChildTypeDef()) || !collection.getKeySet().contains(key)) continue;
            candidate = collection.getBeanTreeEntry(key);
            BeanPropertyDef prop = collection.getBeanChildDef().getChildTypeDef().getSubTypeDiscriminatorPropertyDef();
            String string = typeKey = prop != null ? prop.getPropertyName() : "Type";
            if (!candidate.getKeySet().contains(typeKey)) {
                LOGGER.warning("WARNING: ReferenceResolver NO SubTypeDiscriminator for: " + String.valueOf(candidate.getPath()));
                continue;
            }
            Object propertyValue = candidate.getBeanTreeEntry(typeKey).getPropertyValue();
            String type = propertyValue != null ? propertyValue.toString() : "";
            BeanTypeDef candidateTypeDef = collection.getBeanChildDef().getChildTypeDef().getSubTypeDef(type);
            if (candidateTypeDef == null) {
                LOGGER.warning("WARNING: ReferenceResolver NO BeanTypeDef found for: " + String.valueOf(candidate.getPath()));
                continue;
            }
            if (!candidateTypeDef.isTypeDef(refTypeDef)) continue;
            LOGGER.finest("ReferenceResolver found heterogeneous candidate: " + String.valueOf(candidate.getPath()));
            candidates.add(candidate);
        }
        return candidates;
    }

    private static Object determineReferenceValue(String key, List<BeanTreeEntry> candidates, BeanTreeEntry unresolved) {
        if (candidates.size() == 1) {
            return candidates.get(0);
        }
        if (candidates.size() > 1) {
            BeanTreeEntry candidate = BeanTreeReferenceResolver.determineCandidate(candidates, unresolved);
            if (candidate != null) {
                return candidate;
            }
            LOGGER.warning("WARNING: ReferenceResolver too many candidates found for: " + key);
            return key;
        }
        LOGGER.fine("ReferenceResolver unable to resolve: " + key);
        return key;
    }

    private static BeanTreeEntry determineCandidate(List<BeanTreeEntry> candidates, BeanTreeEntry unresolved) {
        int bestMatchLen = 0;
        BeanTreeEntry bestCandidate = null;
        LinkedList<BeanTreeEntry> bestCandidates = new LinkedList<BeanTreeEntry>();
        List unresolvedPath = unresolved.getPath().getComponents();
        block0: for (BeanTreeEntry candidate : candidates) {
            List candidatePath = candidate.getPath().getComponents();
            int maxLen = candidatePath.size() <= unresolvedPath.size() ? candidatePath.size() : unresolvedPath.size();
            for (int i = 0; i < maxLen; ++i) {
                if (((String)candidatePath.get(i)).equals(unresolvedPath.get(i))) continue;
                if (i > bestMatchLen) {
                    bestMatchLen = i;
                    bestCandidates = new LinkedList();
                    bestCandidates.add(candidate);
                    continue block0;
                }
                if (i != bestMatchLen) continue block0;
                bestCandidates.add(candidate);
                continue block0;
            }
        }
        if (bestCandidates.size() == 1) {
            bestCandidate = (BeanTreeEntry)bestCandidates.get(0);
            LOGGER.finest("ReferenceResolver found best candidate: " + String.valueOf(bestCandidate.getPath()));
        }
        return bestCandidate;
    }

    private static List<Object> getListOfNull() {
        ArrayList<Object> newList = new ArrayList<Object>();
        newList.add(null);
        return newList;
    }
}

