/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo.weblogic;

import java.util.List;
import java.util.Map;
import java.util.Set;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanChildDef;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.server.repo.BeanTreePath;

public class BeanTreeEntry {
    private String key;
    private boolean isProperty;
    private boolean isBean;
    private boolean isBeanCollection;
    private boolean containsReference = false;
    private boolean isTransient = false;
    private BeanTreePath identity;
    private BeanChildDef beanChildDef = null;
    private BeanPropertyDef beanPropertyDef = null;
    private Object propertyValue = null;
    private List<Object> referenceValue = null;
    private Map<String, BeanTreeEntry> beanValue = null;

    BeanTreeEntry(String key, Map<String, BeanTreeEntry> value, BeanTreePath identity, boolean collection, BeanChildDef childDef) {
        this.key = key;
        this.isProperty = false;
        this.isBean = !collection;
        this.isBeanCollection = collection;
        this.identity = identity;
        this.beanChildDef = childDef;
        this.beanValue = value;
    }

    BeanTreeEntry(String key, Object value, BeanTreePath identity, BeanPropertyDef propertyDef) {
        this.key = key;
        this.isProperty = true;
        this.isBean = false;
        this.isBeanCollection = false;
        this.identity = identity;
        this.beanPropertyDef = propertyDef;
        this.propertyValue = value;
    }

    public boolean isProperty() {
        return this.isProperty;
    }

    public boolean isBean() {
        return this.isBean;
    }

    public boolean isBeanCollection() {
        return this.isBeanCollection;
    }

    public boolean containsReference() {
        return this.containsReference;
    }

    public BeanPropertyDef getBeanPropertyDef() {
        return this.beanPropertyDef;
    }

    public BeanChildDef getBeanChildDef() {
        return this.beanChildDef;
    }

    public BeanTreePath getBeanTreePath() {
        return this.identity;
    }

    public Path getPath() {
        Path result = this.getBeanTreePath().getPath();
        if (this.isProperty) {
            result = result.childPath(this.getKey());
        }
        return result;
    }

    public String getKey() {
        return this.key;
    }

    public Set<String> getKeySet() {
        if (this.beanValue != null) {
            return this.beanValue.keySet();
        }
        return Set.of();
    }

    public BeanTreeEntry getBeanTreeEntry(String key) {
        BeanTreeEntry result = null;
        if (this.beanValue != null) {
            result = this.beanValue.get(key);
        }
        return result;
    }

    public Map<String, BeanTreeEntry> getBeanValue() {
        Map<String, BeanTreeEntry> result = null;
        if (!this.isProperty && this.beanValue != null) {
            result = this.beanValue;
        }
        return result;
    }

    public Object getPropertyValue() {
        Object result = null;
        if (this.isProperty && this.propertyValue != null) {
            result = this.propertyValue;
        }
        return result;
    }

    public boolean setPropertyValue(Object newPropertyValue) {
        boolean result = false;
        if (this.isProperty) {
            this.propertyValue = newPropertyValue;
            result = true;
        }
        return result;
    }

    public boolean putBeanTreeEntry(String key, BeanTreeEntry value) {
        boolean result = false;
        if (this.beanValue != null) {
            this.beanValue.put(key, value);
            result = true;
        }
        return result;
    }

    public List<Object> getPropertyReference() {
        List<Object> result = null;
        if (this.isProperty && this.containsReference) {
            result = this.referenceValue;
        }
        return result;
    }

    public boolean setPropertyReference(List<Object> references) {
        boolean result = false;
        if (this.isProperty && this.beanPropertyDef.isReference()) {
            this.referenceValue = references;
            this.containsReference = true;
            result = true;
        }
        return result;
    }

    public void clearReference() {
        if (this.isProperty && this.beanPropertyDef.isReference()) {
            this.referenceValue = null;
            this.containsReference = false;
        }
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient() {
        this.isTransient = true;
    }

    public void clearTransient() {
        this.isTransient = false;
    }

    public String toString() {
        String strValue = "[" + String.valueOf(this.getPath()) + "] ";
        return strValue + String.valueOf(this.isProperty ? this.propertyValue : this.beanValue);
    }
}

