/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo.weblogic;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.BeanChildDef;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.repodef.LocalizedConstants;
import weblogic.remoteconsole.common.repodef.Localizer;
import weblogic.remoteconsole.server.repo.BeanRepo;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.Value;
import weblogic.remoteconsole.server.repo.weblogic.BeanTree;
import weblogic.remoteconsole.server.repo.weblogic.BeanTreeEntry;
import weblogic.remoteconsole.server.repo.weblogic.BeanTreeReferenceResolver;
import weblogic.remoteconsole.server.repo.weblogic.WDTModelSchema;
import weblogic.remoteconsole.server.repo.weblogic.WDTValueConverter;
import weblogic.remoteconsole.server.webapp.FailedRequestException;

public class BeanTreeBuilder {
    private static final Logger LOGGER = Logger.getLogger(BeanTreeBuilder.class.getName());
    private static final String DOMAIN_PREFIX = "Domain.";
    private static final int DOMAIN_PREFIX_LEN = "Domain.".length();
    private static final String MACHINE = "Machine";
    private static final String MACHINES = "Machines";
    private static final String UNIX_MACHINE = "UnixMachine";
    private static final String DOMAIN_MBEAN_TYPE = "DomainMBean";
    private static final String DELETE_OPER = "!";
    private static final int DELETE_OPER_LEN = 1;
    private BeanTree beanTree;
    private Localizer localizer;
    private Map<String, Object> model;
    private BeanTypeDef beanTypeDef;
    private BeanTreePath identity;
    private BeanTreeEntry parent;
    private Map<String, Map<String, Object>> modelSections = null;
    private String currentModelSection = null;
    private boolean isWDTDeleteApplied = false;
    private boolean isSecurityProviderTypeApplied = false;

    private BeanTree getBeanTree() {
        return this.beanTree;
    }

    private Map<String, Object> getModel() {
        return this.model;
    }

    private BeanTypeDef getBeanTypeDef() {
        return this.beanTypeDef;
    }

    private BeanTreePath getIdentity() {
        return this.identity;
    }

    private BeanTreeEntry getParent() {
        return this.parent;
    }

    private BeanTypeDef getSecurityProviderBeanTypeDef() {
        return this.getBeanTree().getSecurityProviderTypeDef();
    }

    private Map<String, Set<String>> getUnknownProperties() {
        return this.getBeanTree().getUnknownProperties();
    }

    public boolean isWDTDeleteApplied() {
        return this.isWDTDeleteApplied;
    }

    public void setWDTDeleteApplied() {
        this.isWDTDeleteApplied = true;
    }

    private void setWDTDeleteApplied(boolean deleteApplied) {
        this.isWDTDeleteApplied = deleteApplied;
    }

    public boolean isSecurityProviderTypeApplied() {
        return this.isSecurityProviderTypeApplied;
    }

    public void setSecurityProviderTypeApplied() {
        this.isSecurityProviderTypeApplied = true;
    }

    public BeanTreeBuilder(Map<String, Object> wdtModel, BeanRepo beanRepo, BeanChildDef rootChildDef, Localizer localizer) {
        this.beanTree = new BeanTree(wdtModel, beanRepo, rootChildDef);
        this.initialize(localizer);
    }

    public BeanTreeBuilder(BeanTree baseBeanTree, Map<String, Object> wdtModel, Localizer localizer) {
        this.beanTree = baseBeanTree;
        this.beanTree.addWDTModel(wdtModel);
        this.initialize(localizer);
    }

    private void initialize(Localizer localizer) {
        this.localizer = localizer;
        this.parent = this.beanTree.getDomain();
        this.model = this.beanTree.getWDTModel();
        this.identity = this.parent.getBeanTreePath();
        this.beanTypeDef = this.parent.getBeanChildDef().getChildTypeDef();
        this.modelSections = new LinkedHashMap<String, Map<String, Object>>();
    }

    private BeanTreeBuilder(BeanTree beanTree, BeanTreeEntry parent, Map<String, Object> value, BeanTreePath identity, BeanTypeDef beanTypeDef, Localizer localizer) {
        this.beanTree = beanTree;
        this.parent = parent;
        this.model = value;
        this.identity = identity;
        this.beanTypeDef = beanTypeDef;
        this.localizer = localizer;
    }

    public void addModelSections() {
        this.getModel().keySet().forEach(section -> {
            if (!WDTModelSchema.KNOWN_SECTIONS.contains(section)) {
                throw this.failedRequestException(LocalizedConstants.WDT_INVALID_SECTION, section, WDTModelSchema.KNOWN_SECTIONS);
            }
        });
        WDTModelSchema.SUPPORTED_SECTIONS.forEach(section -> this.addModelSection((String)section));
    }

    private void addModelSection(String section) {
        if (section != null && !section.isEmpty() && this.getModel().containsKey(section)) {
            if (!"appDeployments".equals(section)) {
                this.modelSections.put(section, this.getMapValueFromKey(section, this.getModel()));
            } else {
                LinkedHashMap<String, Object> fixedSection = null;
                Map<String, Object> modelSection = this.getMapValueFromKey(section, this.getModel());
                if (modelSection != null) {
                    fixedSection = new LinkedHashMap<String, Object>();
                    for (String key : modelSection.keySet()) {
                        String fixedKey = "Application".equals(key) ? "AppDeployment" : key;
                        fixedSection.put(fixedKey, modelSection.get(key));
                    }
                }
                this.modelSections.put(section, fixedSection);
            }
        }
    }

    public BeanTree build() {
        for (Map.Entry<String, Map<String, Object>> entry : this.modelSections.entrySet()) {
            this.currentModelSection = entry.getKey();
            LOGGER.fine("BeanTreeBuilder adding section: " + this.currentModelSection);
            this.buildEntries(entry.getValue());
        }
        this.currentModelSection = null;
        return this.getBeanTree();
    }

    private void buildSubTree() {
        this.buildEntries(this.getModel());
    }

    private void buildEntries(Map<String, Object> value) {
        if (value != null && !value.isEmpty()) {
            for (String key : value.keySet()) {
                this.addTree(key, value.get(key));
            }
        }
    }

    private void createOrUpdateProperty(String key, Object value, BeanPropertyDef beanPropDef) {
        BeanTreeEntry property = this.getParent().getBeanTreeEntry(key);
        if (property == null) {
            property = this.createProperty(key, value, beanPropDef, this.getIdentity(), true);
            this.checkPropertyValueForDelete(property, beanPropDef);
            return;
        }
        this.mergeOrUpdateProperty(property, value, beanPropDef);
    }

    private void createOrUpdateProperty(String key, Object value, BeanPropertyDef beanPropDef, BeanTreeEntry parent) {
        BeanTreeEntry property = parent.getBeanTreeEntry(key);
        if (property == null) {
            property = this.createProperty(key, value, beanPropDef, parent.getBeanTreePath(), false);
            parent.putBeanTreeEntry(key, property);
            this.checkPropertyValueForDelete(property, beanPropDef);
            return;
        }
        this.mergeOrUpdateProperty(property, value, beanPropDef);
    }

    private BeanTreeEntry createProperty(String key, Object value, BeanPropertyDef beanPropDef, BeanTreePath identity, boolean addToParent) {
        BeanTreeEntry property = this.getBeanTree().createProperty(key, value, identity, beanPropDef);
        if (addToParent) {
            this.getParent().putBeanTreeEntry(key, property);
        }
        this.validatePropertyValue(property);
        return property;
    }

    private void mergeOrUpdateProperty(BeanTreeEntry currentProperty, Object value, BeanPropertyDef beanPropDef) {
        this.validatePropertyValue(currentProperty);
        if (beanPropDef.isProperties()) {
            this.mergePropertiesProperty(currentProperty, value, beanPropDef);
            return;
        }
        if (!beanPropDef.isArray()) {
            currentProperty.setPropertyValue(value);
            return;
        }
        if (beanPropDef.isReference()) {
            this.mergeReferenceArray(currentProperty, value, beanPropDef.isReferenceAsReferences());
            return;
        }
        this.mergeArrayProperty(currentProperty, value, beanPropDef);
    }

    private void validatePropertyValue(BeanTreeEntry property) {
        if (!property.getBeanPropertyDef().isSupportsModelTokens() && WDTValueConverter.isPropertyModelToken(property)) {
            throw this.failedRequestException(LocalizedConstants.WDT_MODEL_TOKEN_NOT_SUPPORTED, property.getKey(), property.getPropertyValue());
        }
        WDTValueConverter.getValueType(property, property.getBeanPropertyDef(), this.localizer);
    }

    private BeanTreeEntry getOrCreateBean(String key, boolean collection, BeanChildDef beanChildDef) {
        BeanTreeEntry bean = this.getParent().getBeanTreeEntry(key);
        return bean != null ? bean : this.createBean(key, collection, beanChildDef, this.getIdentity(), true);
    }

    private BeanTreeEntry getOrCreateBean(String key, boolean collection, BeanChildDef beanChildDef, BeanTreeEntry parent) {
        BeanTreeEntry bean = parent.getBeanTreeEntry(key);
        if (bean == null) {
            bean = this.createBean(key, collection, beanChildDef, parent.getBeanTreePath(), false);
            parent.putBeanTreeEntry(key, bean);
        }
        return bean;
    }

    private BeanTreeEntry createBean(String key, boolean collection, BeanChildDef beanChildDef, BeanTreePath identity, boolean addToParent) {
        BeanTreeEntry bean = this.getBeanTree().createBean(key, identity, collection, beanChildDef);
        if (addToParent) {
            this.getParent().putBeanTreeEntry(key, bean);
        }
        return bean;
    }

    private void buildChild(String key, Map<String, Object> value, BeanChildDef beanChildDef) {
        if (BeanTree.isMachineType(beanChildDef)) {
            this.buildMachines(MACHINE, value);
            return;
        }
        BeanTreeEntry bean = this.getOrCreateBean(key, beanChildDef.isCollection(), beanChildDef);
        if (beanChildDef.isCollection()) {
            this.buildChildCollection(bean, value, beanChildDef);
        } else if (beanChildDef.isCollapsedInWDT()) {
            LOGGER.finest("BeanTreeBuilder expanding child: " + key);
            BeanChildDef missingChildDef = beanChildDef.getChildTypeDef().getChildDef(new Path(key));
            if (missingChildDef == null || !missingChildDef.isCollection()) {
                throw this.failedRequestException(LocalizedConstants.WDT_INVALID_CHILD, key);
            }
            BeanTreeEntry missingChildBean = this.getOrCreateBean(key, missingChildDef.isCollection(), missingChildDef, bean);
            this.buildChildCollection(missingChildBean, value, missingChildDef);
        } else {
            this.buildChildInstance(bean, value, beanChildDef);
        }
    }

    private void buildChildCollection(BeanTreeEntry parent, Map<String, Object> value, BeanChildDef beanChildDef) {
        if (value != null && !value.isEmpty()) {
            for (String key : value.keySet()) {
                if (this.deleteBeanApplied(key, parent)) continue;
                BeanTreeEntry bean = this.getOrCreateBean(key, false, beanChildDef, parent);
                this.buildChildInstance(bean, this.getMapValueFromKey(key, value), beanChildDef);
            }
        }
    }

    private void buildSecurityProvider(String key, Map<String, Object> value) {
        Object curType;
        String providerName = this.getParent().getKey();
        if (this.isSingleton()) {
            providerName = key;
            if (value.keySet().size() != 1) {
                throw this.failedRequestException(LocalizedConstants.WDT_INVALID_SECURITY_PROVIDER_TYPE, key);
            }
            key = value.keySet().iterator().next();
            value = this.getMapValueFromKey(key, value);
        }
        BeanPropertyDef namePropDef = this.getBeanTypeDef().getPropertyDef(new Path("Name"));
        String nameProp = namePropDef.getPropertyName();
        this.createOrUpdateProperty(nameProp, providerName, namePropDef);
        String type = null;
        List<String> subTypes = this.getBeanTypeDef().getSubTypeDiscriminatorLegalValues();
        for (String subType : subTypes) {
            String subTypeName = StringUtils.getLeafClassName((String)subType);
            if (!key.equals(subTypeName) && !key.equals(subType)) continue;
            type = subType;
            break;
        }
        if (type == null) {
            throw this.failedRequestException(LocalizedConstants.WDT_INVALID_SECURITY_PROVIDER_TYPE, key);
        }
        BeanPropertyDef typePropDef = this.getBeanTypeDef().getSubTypeDiscriminatorPropertyDef();
        String typeProp = typePropDef.getPropertyName();
        if (this.getParent().getKeySet().contains(typeProp) && !type.equals((curType = this.getParent().getBeanTreeEntry(typeProp).getPropertyValue()).toString())) {
            throw this.failedRequestException(LocalizedConstants.WDT_INVALID_SECURITY_PROVIDER_TYPE, key);
        }
        this.createOrUpdateProperty(typeProp, type, typePropDef);
        BeanTypeDef subTypeDef = this.getBeanTypeDef().getSubTypeDef(type);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("BeanTreeBuilder buildSecurityProvider: " + String.valueOf(this.getParent()));
            LOGGER.finest("BeanTreeBuilder buildSecurityProvider SubType: " + String.valueOf(subTypeDef));
        }
        BeanTreeBuilder builder = new BeanTreeBuilder(this.getBeanTree(), this.getParent(), value, this.getIdentity(), subTypeDef, this.localizer);
        builder.setSecurityProviderTypeApplied();
        builder.setWDTDeleteApplied(this.isWDTDeleteApplied);
        builder.buildSubTree();
    }

    private void buildMachines(String type, Map<String, Object> value) {
        LOGGER.finest("BeanTreeBuilder building Machines for: " + type);
        BeanChildDef beanChildDef = this.getBeanTypeDef().getChildDef(new Path(MACHINES));
        if (beanChildDef == null) {
            throw this.failedRequestException(LocalizedConstants.NO_MACHINES_DEF, type);
        }
        BeanTreeEntry machines = this.getOrCreateBean(MACHINES, beanChildDef.isCollection(), beanChildDef);
        if (value != null && !value.isEmpty()) {
            for (String machineName : value.keySet()) {
                if (this.deleteBeanApplied(machineName, machines)) continue;
                BeanTreeEntry bean = this.getOrCreateBean(machineName, false, beanChildDef, machines);
                BeanPropertyDef typePropDef = beanChildDef.getChildTypeDef().getSubTypeDiscriminatorPropertyDef();
                String typeProp = typePropDef.getPropertyName();
                this.createOrUpdateProperty(typeProp, type, typePropDef, bean);
                BeanTypeDef typeDef = beanChildDef.getChildTypeDef().getSubTypeDef(type);
                Map<String, Object> machineValue = this.getMapValueFromKey(machineName, value);
                BeanTreeBuilder builder = new BeanTreeBuilder(this.getBeanTree(), bean, machineValue, bean.getBeanTreePath(), typeDef, this.localizer);
                builder.setWDTDeleteApplied(this.isWDTDeleteApplied);
                builder.buildSubTree();
            }
        }
    }

    private void buildChildInstance(BeanTreeEntry parent, Map<String, Object> value, BeanChildDef childDef) {
        BeanTreeBuilder builder = new BeanTreeBuilder(this.getBeanTree(), parent, value, parent.getBeanTreePath(), childDef.getChildTypeDef(), this.localizer);
        builder.setWDTDeleteApplied(this.isWDTDeleteApplied);
        builder.buildSubTree();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addTree(String key, Object value) {
        boolean isMap = value instanceof Map;
        LOGGER.finest("BeanTreeBuilder addTree: " + key + "=" + String.valueOf(isMap ? "MAP" : value));
        if (this.isSecurityProviderBaseType()) {
            this.buildSecurityProvider(key, this.getMapFromValue(value, key));
            return;
        }
        BeanPropertyDef propDef = this.getBeanTypeDef().getPropertyDefFromOfflineName(key);
        if (propDef != null) {
            this.createOrUpdateProperty(propDef.getPropertyName(), value, propDef);
            return;
        } else {
            BeanChildDef childDef = this.getBeanTypeDef().getChildDefFromOfflineName(key);
            if (childDef != null) {
                String name = childDef.getChildName();
                this.buildChild(name, this.getMapFromValue(value, name), childDef);
                return;
            } else {
                if (this.isUnixMachineType(key)) {
                    this.buildMachines(UNIX_MACHINE, this.getMapFromValue(value, key));
                    return;
                }
                Path beanPath = this.getIdentity().getPath().childPath(key);
                if (!isMap) throw this.failedRequestException(LocalizedConstants.WDT_INVALID_PROPERTY, key);
                if (!this.isKnownButNotSupported(key)) throw this.failedRequestException(LocalizedConstants.WDT_INVALID_CHILD, key);
                this.addUnknownProperty(beanPath.getDotSeparatedPath());
            }
        }
    }

    private boolean isKnownButNotSupported(String key) {
        if (this.currentModelSection != null) {
            return WDTModelSchema.SUPPORTED_SECTION_CONTENTS.get(this.currentModelSection).contains(key);
        }
        return false;
    }

    private void addUnknownProperty(String propertyPath) {
        LOGGER.finest("BeanTreeBuilder addUnknownProperty: " + propertyPath);
        if (this.currentModelSection != null && propertyPath != null && propertyPath.startsWith(DOMAIN_PREFIX)) {
            Map<String, Set<String>> unknownProperties = this.getUnknownProperties();
            if (!unknownProperties.containsKey(this.currentModelSection)) {
                unknownProperties.put(this.currentModelSection, new LinkedHashSet());
            }
            String unknownProperty = propertyPath.substring(DOMAIN_PREFIX_LEN);
            unknownProperties.get(this.currentModelSection).add(unknownProperty);
        }
    }

    private boolean isUnixMachineType(String key) {
        return UNIX_MACHINE.equals(key) && DOMAIN_MBEAN_TYPE.equals(this.getBeanTypeDef().getTypeName());
    }

    private boolean isSecurityProviderBaseType() {
        boolean result = false;
        if (this.getBeanTypeDef().isTypeDef(this.getSecurityProviderBeanTypeDef()) && !this.isSecurityProviderTypeApplied()) {
            result = true;
        }
        return result;
    }

    private boolean isSingleton() {
        return !this.getParent().getBeanChildDef().isCollection();
    }

    private Map<String, Object> getMapValueFromKey(String key, Map<String, Object> value) {
        Object result = value.get(key);
        if (result != null && !(result instanceof Map)) {
            throw this.failedRequestException(LocalizedConstants.KEY_VALUE_NOT_MAP, key);
        }
        return (Map)result;
    }

    private Map<String, Object> getMapFromValue(Object value, String key) {
        if (value != null && !(value instanceof Map)) {
            throw this.failedRequestException(LocalizedConstants.VALUE_NOT_MAP, key);
        }
        return (Map)value;
    }

    private void mergeReferenceArray(BeanTreeEntry currentProperty, Object value, boolean isRefAsRefs) {
        List<String> currentKeys = BeanTreeReferenceResolver.getReferenceKeys(currentProperty);
        currentProperty.setPropertyValue(value);
        List<String> newKeys = BeanTreeReferenceResolver.getReferenceKeys(currentProperty);
        boolean removedKeys = false;
        if (this.isWDTDeleteApplied() && !newKeys.isEmpty()) {
            LinkedHashSet removes = new LinkedHashSet();
            newKeys.stream().filter(key -> key != null ? key.startsWith(DELETE_OPER) : false).forEach(key -> removes.add(key));
            if (!removes.isEmpty()) {
                LOGGER.finest("BeanTreeBuilder remove merge reference keys: " + String.valueOf(removes));
                removes.forEach(key -> {
                    newKeys.remove(key);
                    currentKeys.remove(key.substring(1));
                });
                removedKeys = true;
            }
        }
        if (!currentKeys.isEmpty() || !newKeys.isEmpty() || removedKeys) {
            ArrayList<String> mergedKeys = new ArrayList<String>();
            mergedKeys.addAll(currentKeys);
            mergedKeys.addAll(newKeys);
            if (mergedKeys.isEmpty()) {
                currentProperty.setPropertyValue(null);
            } else {
                currentProperty.setPropertyValue(mergedKeys);
                if (isRefAsRefs && mergedKeys.size() > 1) {
                    String last = (String)mergedKeys.get(mergedKeys.size() - 1);
                    mergedKeys.clear();
                    mergedKeys.add(last);
                }
            }
        }
    }

    private void mergeArrayProperty(BeanTreeEntry currentProperty, Object value, BeanPropertyDef beanPropDef) {
        Value currentValue = WDTValueConverter.getValueType(currentProperty, beanPropDef, this.localizer);
        currentProperty.setPropertyValue(value);
        Value newValue = WDTValueConverter.getValueType(currentProperty, beanPropDef, this.localizer);
        if (this.isWDTDeleteApplied() && beanPropDef.isString() && newValue.isArray() && !newValue.asArray().getValues().isEmpty()) {
            this.mergeDeleteStringArray(currentProperty, beanPropDef, currentValue, newValue);
            return;
        }
        if (currentValue.isArray() && newValue.isArray()) {
            Object curVal = WDTValueConverter.getJavaType(currentValue, beanPropDef, this.localizer);
            Object newVal = WDTValueConverter.getJavaType(newValue, beanPropDef, this.localizer);
            if (curVal instanceof List && newVal instanceof List) {
                List mergedList = (List)curVal;
                mergedList.addAll((List)newVal);
                currentProperty.setPropertyValue(mergedList);
            }
        }
    }

    private void mergeDeleteStringArray(BeanTreeEntry currentProperty, BeanPropertyDef beanPropDef, Value currentValue, Value newValue) {
        LOGGER.finest("BeanTreeBuilder merge string array entries with delete");
        if (!currentValue.isArray()) {
            this.removeDeleteFromStringArray(currentProperty, beanPropDef);
            return;
        }
        Object newVal = WDTValueConverter.getJavaType(newValue, beanPropDef, this.localizer);
        if (newVal instanceof List) {
            List newValues = (List)newVal;
            LinkedHashSet removes = new LinkedHashSet();
            newValues.stream().filter(val -> val != null ? val.startsWith(DELETE_OPER) : false).forEach(val -> removes.add(val));
            Object curVal = WDTValueConverter.getJavaType(currentValue, beanPropDef, this.localizer);
            if (curVal instanceof List) {
                List curValues = (List)curVal;
                if (!removes.isEmpty()) {
                    LOGGER.finest("BeanTreeBuilder remove merge array entries: " + String.valueOf(removes));
                    removes.forEach(key -> {
                        newValues.remove(key);
                        curValues.remove(key.substring(1));
                    });
                }
                ArrayList mergedList = new ArrayList();
                mergedList.addAll(curValues);
                mergedList.addAll(newValues);
                currentProperty.setPropertyValue(mergedList);
            }
        }
    }

    private void mergePropertiesProperty(BeanTreeEntry currentProperty, Object value, BeanPropertyDef beanPropDef) {
        if (value == null) {
            return;
        }
        Value currentValue = WDTValueConverter.getValueType(currentProperty, beanPropDef, this.localizer);
        currentProperty.setPropertyValue(value);
        Value newValue = WDTValueConverter.getValueType(currentProperty, beanPropDef, this.localizer);
        if (this.isWDTDeleteApplied() && newValue != null && newValue.isProperties()) {
            LinkedHashSet removes = new LinkedHashSet();
            newValue.asProperties().getValue().stringPropertyNames().stream().filter(key -> key != null ? key.startsWith(DELETE_OPER) : false).forEach(key -> removes.add(key));
            if (!(removes.isEmpty() || currentValue != null && currentValue.isProperties())) {
                this.removeDeleteFromProperties(currentProperty, beanPropDef);
                return;
            }
            if (!removes.isEmpty() && currentValue != null && currentValue.isProperties()) {
                LOGGER.finest("BeanTreeBuilder remove merge property keys: " + String.valueOf(removes));
                Properties curVal = currentValue.asProperties().getValue();
                Properties newVal = newValue.asProperties().getValue();
                removes.forEach(key -> {
                    newVal.remove(key);
                    curVal.remove(key.substring(1));
                });
            }
        }
        if (currentValue != null && currentValue.isProperties() && newValue != null && newValue.isProperties()) {
            Object curVal = WDTValueConverter.getJavaType(currentValue, beanPropDef, this.localizer);
            curVal = curVal != null ? curVal : new LinkedHashMap();
            Object newVal = WDTValueConverter.getJavaType(newValue, beanPropDef, this.localizer);
            Object object = newVal = newVal != null ? newVal : new LinkedHashMap();
            if (curVal instanceof Map && newVal instanceof Map) {
                TreeMap<String, Object> sorter = new TreeMap<String, Object>();
                LinkedHashMap mergedMap = new LinkedHashMap();
                ((Map)curVal).forEach((key, val) -> sorter.put((String)key, val));
                ((Map)newVal).forEach((key, val) -> sorter.put((String)key, val));
                sorter.forEach((key, val) -> mergedMap.put(key, val));
                if (mergedMap.isEmpty()) {
                    currentProperty.setPropertyValue(null);
                } else {
                    currentProperty.setPropertyValue(mergedMap);
                }
            }
        }
    }

    private boolean deleteBeanApplied(String key, BeanTreeEntry parent) {
        if (this.isWDTDeleteApplied() && key.startsWith(DELETE_OPER)) {
            String deleteKey = key.substring(1);
            LOGGER.finest("BeanTreeBuilder attempting to delete instance: " + deleteKey);
            parent.getBeanValue().remove(deleteKey);
            return true;
        }
        return false;
    }

    private void checkPropertyValueForDelete(BeanTreeEntry currentProperty, BeanPropertyDef beanPropDef) {
        if (this.isWDTDeleteApplied()) {
            if (beanPropDef.isProperties()) {
                this.removeDeleteFromProperties(currentProperty, beanPropDef);
            } else if (beanPropDef.isReference() && beanPropDef.isArray()) {
                this.removeDeleteFromReferenceArray(currentProperty, beanPropDef);
            } else if (beanPropDef.isArray() && beanPropDef.isString()) {
                this.removeDeleteFromStringArray(currentProperty, beanPropDef);
            }
        }
    }

    private void removeDeleteFromReferenceArray(BeanTreeEntry currentProperty, BeanPropertyDef beanPropDef) {
        List<String> currentKeys = BeanTreeReferenceResolver.getReferenceKeys(currentProperty);
        if (!currentKeys.isEmpty()) {
            LinkedHashSet removes = new LinkedHashSet();
            currentKeys.stream().filter(key -> key != null ? key.startsWith(DELETE_OPER) : false).forEach(key -> removes.add(key));
            if (!removes.isEmpty()) {
                LOGGER.finest("BeanTreeBuilder remove reference keys: " + String.valueOf(removes));
                removes.forEach(key -> currentKeys.remove(key));
                if (currentKeys.isEmpty()) {
                    currentProperty.setPropertyValue(null);
                } else {
                    ArrayList<String> updatedKeys = new ArrayList<String>();
                    updatedKeys.addAll(currentKeys);
                    currentProperty.setPropertyValue(updatedKeys);
                }
            }
        }
    }

    private void removeDeleteFromProperties(BeanTreeEntry currentProperty, BeanPropertyDef beanPropDef) {
        Object curVal;
        Value currentValue = WDTValueConverter.getValueType(currentProperty, beanPropDef, this.localizer);
        if (currentValue != null && currentValue.isProperties() && (curVal = WDTValueConverter.getJavaType(currentValue, beanPropDef, this.localizer)) instanceof Map) {
            LinkedHashSet removes = new LinkedHashSet();
            Map properties = (Map)curVal;
            properties.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(DELETE_OPER)).forEach(entry -> removes.add((String)entry.getKey()));
            if (!removes.isEmpty()) {
                LOGGER.finest("BeanTreeBuilder remove property keys: " + String.valueOf(removes));
                removes.forEach(key -> properties.remove(key));
                if (properties.isEmpty()) {
                    currentProperty.setPropertyValue(null);
                } else {
                    currentProperty.setPropertyValue(properties);
                }
            }
        }
    }

    private void removeDeleteFromStringArray(BeanTreeEntry currentProperty, BeanPropertyDef beanPropDef) {
        Object curVal;
        Value currentValue = WDTValueConverter.getValueType(currentProperty, beanPropDef, this.localizer);
        if (currentValue.isArray() && (curVal = WDTValueConverter.getJavaType(currentValue, beanPropDef, this.localizer)) instanceof List) {
            LinkedHashSet removes = new LinkedHashSet();
            List updatedList = (List)curVal;
            updatedList.stream().filter(val -> val != null ? val.startsWith(DELETE_OPER) : false).forEach(val -> removes.add(val));
            if (!removes.isEmpty()) {
                LOGGER.finest("BeanTreeBuilder remove array entries: " + String.valueOf(removes));
                removes.forEach(key -> updatedList.remove(key));
                currentProperty.setPropertyValue(updatedList);
            }
        }
    }

    private FailedRequestException failedRequestException(LocalizableString errorMessage, Object ... args) {
        LOGGER.fine(errorMessage.getEnglishText(args));
        return new FailedRequestException(this.localizer.localizeString(errorMessage, args));
    }
}

