/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo.weblogic;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanChildDef;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.server.repo.BeanRepo;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.weblogic.BeanTreeEntry;
import weblogic.remoteconsole.server.repo.weblogic.BeanTreeReferenceResolver;

public class BeanTree {
    private static final Logger LOGGER = Logger.getLogger(BeanTree.class.getName());
    private static final String MACHINE_MBEAN_TYPE = "MachineMBean";
    private static final Path PRODUCTION_MODE_PATH = new Path("ProductionModeEnabled");
    private static final Path SECURE_MODE_PATH = new Path("SecurityConfiguration.SecureMode.SecureModeEnabled");
    private Map<String, BeanTreeEntry> beanTree;
    private BeanRepo beanRepo;
    private BeanTypeDef securityProviderTypeDef;
    private List<Map<String, Object>> wdtModels;
    private List<BeanTreeEntry> references;
    private List<BeanTreeEntry> beanCollections;
    private String domainKeyName;
    private Map<String, Set<String>> unknownProperties;

    private Map<String, BeanTreeEntry> getTree() {
        return this.beanTree;
    }

    private BeanRepo getBeanRepo() {
        return this.beanRepo;
    }

    public BeanTypeDef getSecurityProviderTypeDef() {
        return this.securityProviderTypeDef;
    }

    public Map<String, Object> getWDTModel() {
        int index = this.wdtModels.size() - 1;
        return index > -1 ? this.wdtModels.get(index) : null;
    }

    public List<Map<String, Object>> getWDTModels() {
        return this.wdtModels;
    }

    void addWDTModel(Map<String, Object> wdtModel) {
        this.wdtModels.add(wdtModel);
    }

    public Map<String, Set<String>> getUnknownProperties() {
        return this.unknownProperties;
    }

    BeanTree(Map<String, Object> wdtModel, BeanRepo beanRepo, BeanChildDef domainChildDef) {
        this.beanRepo = beanRepo;
        this.wdtModels = new LinkedList<Map<String, Object>>();
        this.addWDTModel(wdtModel);
        this.references = new LinkedList<BeanTreeEntry>();
        this.beanCollections = new LinkedList<BeanTreeEntry>();
        this.unknownProperties = new LinkedHashMap<String, Set<String>>();
        Path path = new Path(domainChildDef.getChildName());
        BeanTreePath domainIdentity = BeanTreePath.create(beanRepo, path);
        BeanTreeEntry domain = this.newBeanEntry(domainChildDef.getChildName(), domainIdentity, false, domainChildDef);
        this.domainKeyName = domain.getKey();
        this.beanTree = new LinkedHashMap<String, BeanTreeEntry>();
        this.beanTree.put(this.domainKeyName, domain);
        this.securityProviderTypeDef = beanRepo.getBeanRepoDef().getTypeDef("ProviderMBean");
    }

    private BeanTreeEntry newPropertyEntry(String key, Object value, BeanTreePath identity, BeanPropertyDef beanPropDef) {
        return new BeanTreeEntry(key, value, identity, beanPropDef);
    }

    private BeanTreeEntry newBeanEntry(String key, BeanTreePath identity, boolean isCollection, BeanChildDef beanChildDef) {
        LinkedHashMap<String, BeanTreeEntry> map = new LinkedHashMap<String, BeanTreeEntry>();
        return new BeanTreeEntry(key, map, identity, isCollection, beanChildDef);
    }

    public BeanTreeEntry createProperty(String key, Object value, BeanTreePath identity, BeanPropertyDef beanPropDef) {
        BeanTreeEntry result = this.newPropertyEntry(key, value, identity, beanPropDef);
        if (BeanTree.isReference(beanPropDef)) {
            this.references.add(result);
        }
        return result;
    }

    public boolean addProperty(BeanTreeEntry parent, BeanPropertyDef propertyDef, Object propertyValue) {
        BeanTreePath identity;
        BeanTreeEntry property;
        boolean added = false;
        String propertyName = propertyDef.getPropertyName();
        if (parent.putBeanTreeEntry(propertyName, property = this.createProperty(propertyName, propertyValue, identity = parent.getBeanTreePath(), propertyDef))) {
            this.clearTransientParent(parent);
            added = true;
        }
        return added;
    }

    public boolean updateProperty(BeanTreeEntry parent, BeanTreeEntry property, Object newPropertyValue) {
        boolean updated = false;
        if (property.setPropertyValue(newPropertyValue)) {
            updated = true;
        }
        if (updated && BeanTree.isReference(property)) {
            property.clearReference();
        }
        return updated;
    }

    public boolean removeProperty(BeanTreeEntry parent, BeanTreeEntry property) {
        boolean removed = false;
        Map<String, BeanTreeEntry> beanValue = parent.getBeanValue();
        if (beanValue.remove(property.getKey()) != null) {
            removed = true;
        }
        if (removed && BeanTree.isReference(property)) {
            this.references.remove(property);
        }
        if (removed) {
            this.setTransientParent(parent);
        }
        return removed;
    }

    public BeanTreeEntry createBean(String key, BeanTreePath parentIdentity, boolean isCollection, BeanChildDef beanChildDef) {
        Path beanPath = parentIdentity.getPath().childPath(key);
        BeanTreePath beanIdentity = BeanTreePath.create(this.getBeanRepo(), beanPath);
        BeanTreeEntry result = this.newBeanEntry(key, beanIdentity, isCollection, beanChildDef);
        if (isCollection) {
            this.beanCollections.add(result);
        }
        return result;
    }

    public boolean addBean(BeanTreeEntry parent, BeanChildDef beanChildDef, String key) {
        boolean added = false;
        BeanTreeEntry bean = this.createBean(key, parent.getBeanTreePath(), false, beanChildDef);
        if (parent.putBeanTreeEntry(key, bean)) {
            this.clearTransientParent(parent);
            added = true;
        }
        if (added) {
            this.updateBeanTreeEntry(bean, beanChildDef.getChildTypeDef());
            LOGGER.finest("BeanTree added: " + String.valueOf(bean.getPath()));
            if (beanChildDef.isCollection()) {
                LOGGER.fine("BeanTree handle references for added bean!");
                this.resolveReferences();
            }
        }
        return added;
    }

    public boolean removeBean(BeanTreeEntry parent, BeanTreeEntry bean) {
        boolean removed = false;
        Map<String, BeanTreeEntry> beanValue = parent.getBeanValue();
        if (beanValue.remove(bean.getKey()) != null) {
            removed = true;
        }
        if (removed) {
            ArrayList<BeanTreePath> removedBeans = new ArrayList<BeanTreePath>();
            this.removeBeanTreeEntry(bean, bean.getBeanChildDef().getChildTypeDef(), removedBeans);
            if (LOGGER.isLoggable(Level.FINEST)) {
                removedBeans.forEach(removedBean -> LOGGER.finest("BeanTree removed: " + String.valueOf(removedBean.getPath())));
            }
            this.resolveReferencesForDeletedBeans(removedBeans);
            this.setTransientParent(parent);
        }
        return removed;
    }

    public BeanTreeEntry getDomain() {
        return this.beanTree.get(this.domainKeyName);
    }

    public BeanTreeEntry getSecureModeSetting() {
        return BeanTree.getProperty(this.getDomain(), PRODUCTION_MODE_PATH);
    }

    public BeanTreeEntry getProductionModeSetting() {
        return BeanTree.getProperty(this.getDomain(), SECURE_MODE_PATH);
    }

    public BeanTreeEntry getBeanTreeEntry(BeanTreePath beanTreePath) {
        Path path = beanTreePath.getPath();
        LOGGER.finest("BeanTree getBeanTreeEntry(): " + String.valueOf(path));
        List components = path.getComponents();
        Map<String, BeanTreeEntry> tree = this.getTree();
        BeanTreeEntry entry = null;
        BeanTreeEntry value = null;
        for (int i = 0; i < components.size(); ++i) {
            String key = (String)components.get(i);
            entry = tree.get(key);
            if (entry == null) {
                value = null;
                break;
            }
            if (entry.isProperty()) {
                throw new AssertionError((Object)("Error BeanTree getBeanTreeEntry() found property: " + key));
            }
            value = entry;
            tree = entry.getBeanValue();
        }
        return value;
    }

    public BeanTreeEntry getParentBeanTreeEntry(BeanTreePath beanTreePath) {
        Path parentPath = beanTreePath.getPath().getParent();
        BeanTreePath parentIdentity = BeanTreePath.create(this.getBeanRepo(), parentPath);
        return this.getBeanTreeEntry(parentIdentity);
    }

    public void resolveReferences() {
        this.resolveReferences(true);
    }

    public void resolveReferences(boolean isFullResolve) {
        if (!this.references.isEmpty()) {
            LOGGER.fine("BeanTree resolve references: " + (isFullResolve ? "All" : "Only updated"));
            BeanTreeReferenceResolver resolver = new BeanTreeReferenceResolver(this.beanCollections);
            if (isFullResolve) {
                this.references.forEach(resolver::handleUnresolvedReference);
            } else {
                this.references.stream().filter(reference -> !reference.containsReference()).forEach(resolver::handleUnresolvedReference);
            }
        }
    }

    public void resolveReferencesForDeletedBeans(List<BeanTreePath> deletedBeans) {
        if (!this.references.isEmpty() && !deletedBeans.isEmpty()) {
            LOGGER.fine("BeanTree resolve references for deleted beans!");
            ArrayList nullRefs = new ArrayList();
            BeanTreeReferenceResolver resolver = new BeanTreeReferenceResolver(this.beanCollections, deletedBeans);
            this.references.stream().filter(resolver::handleDeleteBean).forEach(nullRefs::add);
            nullRefs.forEach(prop -> this.removeProperty(this.getBeanTreeEntry(prop.getBeanTreePath()), (BeanTreeEntry)prop));
        }
    }

    public void completeRequiredBeanTreeEntries() {
        LOGGER.fine("BeanTree update mandatory singletons and collections");
        BeanTreeEntry domain = this.getDomain();
        BeanTypeDef domainTypeDef = domain.getBeanChildDef().getChildTypeDef();
        this.updateBeanTreeEntry(domain, domainTypeDef);
    }

    private void updateBeanTreeEntry(BeanTreeEntry parent, BeanTypeDef parentTypeDef) {
        BeanTreePath parentIdentity = parent.getBeanTreePath();
        List<BeanChildDef> childDefs = parentTypeDef.getChildDefs();
        for (BeanChildDef childDef : childDefs) {
            String childKey = childDef.getChildName();
            if (!childDef.getParentPath().isEmpty() || BeanTree.isChildSkipped(childKey, parentTypeDef)) {
                LOGGER.finest("BeanTree update skipping ChildDef: " + String.valueOf(childDef.getChildPath()));
                continue;
            }
            BeanTreeEntry childEntry = parent.getBeanTreeEntry(childKey);
            if (childDef.isMandatorySingleton()) {
                if (childEntry == null) {
                    childEntry = this.createBean(childKey, parentIdentity, false, childDef);
                    if (!BeanTree.addTransientChild(parent, childKey, childEntry)) {
                        return;
                    }
                    LOGGER.finest("BeanTree added transient Singleton: " + String.valueOf(childEntry.getPath()));
                }
                this.updateBeanTreeEntry(childEntry, childDef.getChildTypeDef());
                continue;
            }
            if (!childDef.isCollection()) continue;
            if (childEntry == null) {
                childEntry = this.createBean(childKey, parentIdentity, true, childDef);
                BeanTree.addTransientChild(parent, childKey, childEntry);
                LOGGER.finest("BeanTree added transient Collection: " + String.valueOf(childEntry.getPath()));
                continue;
            }
            for (String instanceName : childEntry.getKeySet()) {
                BeanTreeEntry beanInstanceEntry = childEntry.getBeanTreeEntry(instanceName);
                BeanChildDef beanInstanceChildDef = beanInstanceEntry.getBeanChildDef();
                this.updateBeanTreeEntry(beanInstanceEntry, beanInstanceChildDef.getChildTypeDef());
            }
        }
    }

    private void removeBeanTreeEntry(BeanTreeEntry bean, BeanTypeDef beanTypeDef, List<BeanTreePath> removed) {
        if (bean.getBeanChildDef().isCollection()) {
            removed.add(bean.getBeanTreePath());
        }
        List<BeanChildDef> childDefs = beanTypeDef.getChildDefs();
        for (BeanChildDef childDef : childDefs) {
            String childKey = childDef.getChildName();
            if (!childDef.getParentPath().isEmpty() || BeanTree.isChildSkipped(childKey, beanTypeDef)) {
                LOGGER.finest("BeanTree remove skipping ChildDef: " + String.valueOf(childDef.getChildPath()));
                continue;
            }
            BeanTreeEntry childEntry = bean.getBeanTreeEntry(childKey);
            if (!childDef.isCollection() && childEntry != null) {
                bean.getBeanValue().remove(childKey);
                this.removeBeanTreeEntry(childEntry, childDef.getChildTypeDef(), removed);
                continue;
            }
            if (!childDef.isCollection()) continue;
            if (!childEntry.getKeySet().isEmpty()) {
                for (String instanceName : childEntry.getKeySet()) {
                    BeanTreeEntry beanInstanceEntry = childEntry.getBeanTreeEntry(instanceName);
                    BeanChildDef beanInstanceChildDef = beanInstanceEntry.getBeanChildDef();
                    this.removeBeanTreeEntry(beanInstanceEntry, beanInstanceChildDef.getChildTypeDef(), removed);
                }
            }
            bean.getBeanValue().remove(childKey);
            this.beanCollections.remove(childEntry);
        }
        bean.getBeanValue().entrySet().stream().filter(entry -> BeanTree.isReference((BeanTreeEntry)entry.getValue())).forEach(entry -> this.references.remove(entry.getValue()));
    }

    private void clearTransientParent(BeanTreeEntry entry) {
        if (entry.isTransient()) {
            entry.clearTransient();
            BeanTreeEntry parent = this.getParentBeanTreeEntry(entry.getBeanTreePath());
            if (parent != null) {
                this.clearTransientParent(parent);
            }
        }
    }

    private void setTransientParent(BeanTreeEntry entry) {
        boolean isTransient = false;
        BeanChildDef childDef = entry.getBeanChildDef();
        if (childDef.isMandatorySingleton()) {
            isTransient = true;
            for (String key : entry.getKeySet()) {
                if (entry.getBeanTreeEntry(key).isTransient()) continue;
                isTransient = false;
                break;
            }
        } else if (childDef.isCollection() && entry.isBeanCollection() && entry.getKeySet().isEmpty()) {
            isTransient = true;
        }
        if (isTransient) {
            entry.setTransient();
            BeanTreeEntry parent = this.getParentBeanTreeEntry(entry.getBeanTreePath());
            if (parent != null) {
                this.setTransientParent(parent);
            }
        }
    }

    private static boolean isChildSkipped(String key, BeanTypeDef parentTypeDef) {
        return "CustomResources".equals(key) && "DomainMBean".equals(parentTypeDef.getTypeName());
    }

    private static boolean addTransientChild(BeanTreeEntry parent, String childKey, BeanTreeEntry childEntry) {
        childEntry.setTransient();
        if (!parent.putBeanTreeEntry(childKey, childEntry)) {
            LOGGER.warning("BeanTree - Child bean entry NOT added: " + String.valueOf(childEntry.getPath()));
            return false;
        }
        return true;
    }

    public static boolean isKey(BeanTreePath beanTreePath, BeanPropertyDef propertyDef) {
        return beanTreePath.isCollectionChild() && propertyDef.isKey() && propertyDef.isString();
    }

    public static boolean isReference(BeanTreeEntry entry) {
        return entry.isProperty() && BeanTree.isReference(entry.getBeanPropertyDef());
    }

    public static boolean isReference(BeanPropertyDef propertyDef) {
        return propertyDef.isReference() && propertyDef.getReferenceTypeDef() != null;
    }

    public static boolean isMachineType(BeanChildDef childDef) {
        return MACHINE_MBEAN_TYPE.equals(childDef.getChildTypeDef().getTypeName());
    }

    public static BeanTreeEntry getProperty(BeanTreeEntry bean, Path propertyPath) {
        LOGGER.finest("BeanTree getProperty() on: " + String.valueOf(bean.getPath()) + " for " + String.valueOf(propertyPath));
        Map<String, BeanTreeEntry> tree = bean.getBeanValue();
        List components = propertyPath.getComponents();
        BeanTreeEntry value = null;
        BeanTreeEntry entry = null;
        int pathEnd = components.size() - 1;
        for (int i = 0; i < components.size(); ++i) {
            String key = (String)components.get(i);
            entry = tree.get(key);
            if (entry == null) {
                value = null;
                break;
            }
            if (!entry.isProperty() && i >= pathEnd) {
                throw new AssertionError((Object)("Error BeanTree getProperty() found a bean or collection: " + key));
            }
            value = entry;
            tree = entry.getBeanValue();
            if (value.isProperty() && i < pathEnd) {
                throw new AssertionError((Object)("Error BeanTree getProperty() found an unexpected property: " + key));
            }
        }
        return value;
    }

    public String toString() {
        return this.getTree().toString();
    }
}

