/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo.weblogic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.weblogic.AggregatedRuntimeMBeanNameHandler;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicBeanTypeSearchHelper;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestBeanRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestBeanRepoSearchResults;

class AggregatedRuntimeMBeanWebLogicSearchHelper
extends WebLogicBeanTypeSearchHelper {
    private static final AggregatedRuntimeMBeanNameHandler NAME_HANDLER = AggregatedRuntimeMBeanNameHandler.INSTANCE;
    private static final Path SERVER_RUNTIMES_PATH = new Path("DomainRuntime.ServerRuntimes");

    AggregatedRuntimeMBeanWebLogicSearchHelper() {
    }

    @Override
    void addProperty(WebLogicRestBeanRepoSearchBuilder searchBuilder, BeanTreePath beanTreePath, BeanPropertyDef propertyDef) {
        super.addProperty(searchBuilder, NAME_HANDLER.getUnfabricatedBeanTreePath(beanTreePath), propertyDef);
    }

    @Override
    JsonObject findWebLogicSearchResults(WebLogicRestBeanRepoSearchResults searchResults, BeanTreePath aggregatedBeanTreePath, boolean haveExpandedValues) {
        if (haveExpandedValues) {
            throw new AssertionError((Object)"The server runtime tree never uses expanded values");
        }
        Map<String, JsonObject> unaggregatedResults = this.getUnaggregatedWebLogicSearchResults(searchResults, aggregatedBeanTreePath);
        if (aggregatedBeanTreePath.isCollection()) {
            return this.aggregateCollectionResults(searchResults, aggregatedBeanTreePath, unaggregatedResults);
        }
        return this.aggregateBeanResults(searchResults, aggregatedBeanTreePath, unaggregatedResults);
    }

    private JsonObject aggregateCollectionResults(WebLogicRestBeanRepoSearchResults searchResults, BeanTreePath aggregatedCollectionPath, Map<String, JsonObject> unaggregatedResults) {
        HashMap<String, HashMap<String, JsonObject>> unaggregatedCollectionResults = new HashMap<String, HashMap<String, JsonObject>>();
        for (Map.Entry<String, JsonObject> entry : unaggregatedResults.entrySet()) {
            String string = entry.getKey();
            JsonArray items = entry.getValue().getJsonArray("items");
            for (int i = 0; i < items.size(); ++i) {
                JsonObject item = items.getJsonObject(i);
                String beanName = this.getName(item, aggregatedCollectionPath);
                HashMap<String, JsonObject> beanResults = (HashMap<String, JsonObject>)unaggregatedCollectionResults.get(beanName);
                if (beanResults == null) {
                    beanResults = new HashMap<String, JsonObject>();
                    unaggregatedCollectionResults.put(beanName, beanResults);
                }
                beanResults.put(string, item);
            }
        }
        JsonArrayBuilder itemsBldr = Json.createArrayBuilder();
        for (Map.Entry entry : unaggregatedCollectionResults.entrySet()) {
            String beanName = (String)entry.getKey();
            BeanTreePath aggregatedBeanPath = BeanTreePath.create(searchResults.getBuilder().getBeanRepo(), aggregatedCollectionPath.getPath().childPath(beanName));
            itemsBldr.add((JsonValue)this.aggregateBeanResults(searchResults, aggregatedBeanPath, (Map)entry.getValue()));
        }
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        jsonObjectBuilder.add("items", itemsBldr);
        return jsonObjectBuilder.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JsonObject aggregateBeanResults(WebLogicRestBeanRepoSearchResults searchResults, BeanTreePath aggregatedBeanPath, Map<String, JsonObject> unaggregatedBeanResults) {
        if (unaggregatedBeanResults.isEmpty() && aggregatedBeanPath.isCollectionChild()) {
            return null;
        }
        JsonObjectBuilder bldr = Json.createObjectBuilder();
        bldr.add("identity", searchResults.getBuilder().getBeanRepo().toJson(aggregatedBeanPath));
        if (!unaggregatedBeanResults.isEmpty()) {
            JsonObject first = unaggregatedBeanResults.values().iterator().next();
            bldr.add("name", this.getName(first, aggregatedBeanPath));
            bldr.add("type", this.getType(first, aggregatedBeanPath));
            BeanPropertyDef discDef = aggregatedBeanPath.getTypeDef().getSubTypeDiscriminatorPropertyDef();
            if (discDef == null) return bldr.build();
            String discName = discDef.getOnlinePropertyName();
            if (!first.containsKey((Object)discName)) throw new AssertionError((Object)("subtypediscriminator missing from unaggregated search results: " + String.valueOf(aggregatedBeanPath) + " " + String.valueOf(discDef) + " " + String.valueOf(first)));
            bldr.add(discName, (JsonValue)first.get((Object)discName));
            return bldr.build();
        } else {
            bldr.add("type", this.getTypeName(aggregatedBeanPath));
        }
        return bldr.build();
    }

    private Map<String, JsonObject> getUnaggregatedWebLogicSearchResults(WebLogicRestBeanRepoSearchResults searchResults, BeanTreePath aggregatedBeanTreePath) {
        HashMap<String, JsonObject> rtn = new HashMap<String, JsonObject>();
        for (String serverName : this.getServerRuntimeNames(searchResults)) {
            BeanTreePath perServerPath = this.getPerServerBeanTreePath(searchResults, serverName, aggregatedBeanTreePath);
            JsonObject perServerResults = super.findWebLogicSearchResults(searchResults, perServerPath, false);
            if (perServerResults == null) continue;
            rtn.put(serverName, perServerResults);
        }
        return rtn;
    }

    private List<String> getServerRuntimeNames(WebLogicRestBeanRepoSearchResults searchResults) {
        ArrayList<String> rtn = new ArrayList<String>();
        BeanTreePath serverRuntimesPath = BeanTreePath.create(searchResults.getBuilder().getBeanRepo(), SERVER_RUNTIMES_PATH);
        JsonObject serverRuntimes = super.findWebLogicSearchResults(searchResults, serverRuntimesPath, false);
        if (serverRuntimes != null) {
            JsonArray items = serverRuntimes.getJsonArray("items");
            for (int i = 0; i < items.size(); ++i) {
                String keyProp;
                JsonObject item = items.getJsonObject(i);
                if (!item.containsKey((Object)(keyProp = "name"))) continue;
                rtn.add(item.getString(keyProp));
            }
        }
        return rtn;
    }

    private BeanTreePath getPerServerBeanTreePath(WebLogicRestBeanRepoSearchResults searchResults, String serverName, BeanTreePath aggregatedBeanTreePath) {
        Path path = SERVER_RUNTIMES_PATH.childPath(serverName);
        Path aggregatedPath = aggregatedBeanTreePath.getPath();
        path.addComponent(NAME_HANDLER.getUnfabricatedName((String)aggregatedPath.getComponents().get(1)));
        if (aggregatedPath.length() > 2) {
            path.addPath(aggregatedPath.subPath(2, aggregatedPath.length()));
        }
        return BeanTreePath.create(searchResults.getBuilder().getBeanRepo(), path);
    }

    private String getName(JsonObject item, BeanTreePath aggregatedBeanPath) {
        JsonArray identity;
        if (item.containsKey((Object)"name")) {
            return item.getString("name");
        }
        if (item.containsKey((Object)"identity") && !(identity = item.getJsonArray("identity")).isEmpty()) {
            return identity.getString(identity.size() - 1);
        }
        return this.getTypeName(aggregatedBeanPath);
    }

    private String getType(JsonObject item, BeanTreePath aggregatedBeanPath) {
        if (item.containsKey((Object)"type")) {
            return item.getString("type");
        }
        return this.getTypeName(aggregatedBeanPath);
    }

    private String getTypeName(BeanTreePath aggregatedBeanPath) {
        return aggregatedBeanPath.getLastSegment().getChildDef().getChildTypeDef().getInstanceName();
    }
}

