/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import com.fasterxml.jackson.core.type.TypeReference;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.PageDef;
import weblogic.remoteconsole.common.repodef.PagePropertyDef;
import weblogic.remoteconsole.common.repodef.TableDef;
import weblogic.remoteconsole.common.utils.CustomizerInvocationUtils;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchResults;
import weblogic.remoteconsole.server.repo.BeanSearchResults;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Page;
import weblogic.remoteconsole.server.repo.PageReader;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.ResponseException;
import weblogic.remoteconsole.server.repo.Table;
import weblogic.remoteconsole.server.repo.TableCell;
import weblogic.remoteconsole.server.repo.TableCustomizations;
import weblogic.remoteconsole.server.repo.TableCustomizationsManager;
import weblogic.remoteconsole.server.repo.TableRow;
import weblogic.remoteconsole.server.repo.UnknownValue;
import weblogic.remoteconsole.server.repo.Value;

public class TableReader
extends PageReader {
    private static final Type GET_TABLE_ROWS_CUSTOMIZER_RETURN_TYPE = new TypeReference<List<TableRow>>(){}.getType();

    TableReader(InvocationContext invocationContext) {
        super(invocationContext);
    }

    Response<Page> getTable() {
        Response<TableDef> tableDefResponse = this.getTableDef();
        if (!tableDefResponse.isSuccess()) {
            return new Response().copyUnsuccessfulResponse(tableDefResponse);
        }
        TableDef tableDef = tableDefResponse.getResults();
        List<BeanPropertyDef> propDefs = this.createPropertyDefList();
        this.addPropertyDefsToReturn(propDefs, tableDef);
        return this.processTableSearchResults(tableDef, propDefs, this.performTableSearch(tableDef, propDefs));
    }

    private Response<TableDef> getTableDef() {
        Response<TableDef> response = new Response<TableDef>();
        Response<PageDef> pageDefResponse = this.getPageDef();
        if (!pageDefResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(pageDefResponse);
        }
        return response.setSuccess(pageDefResponse.getResults().asTableDef());
    }

    private void addPropertyDefsToReturn(List<BeanPropertyDef> propDefs, TableDef tableDef) {
        TableCustomizations customizations = this.getTableCustomizations(tableDef);
        List<String> displayedColumns = customizations != null ? customizations.getDisplayedColumns() : this.getTableCustomizationsManager().getDefaultDisplayedColumns(tableDef);
        for (PagePropertyDef propDef : tableDef.getAllPropertyDefs()) {
            if (!displayedColumns.contains(propDef.getFormFieldName()) && propDef.isDontReturnIfHiddenColumn()) continue;
            propDefs.add(propDef);
        }
    }

    private Response<BeanReaderRepoSearchResults> performTableSearch(TableDef tableDef, List<BeanPropertyDef> propDefs) {
        boolean includeIsSet = false;
        BeanReaderRepoSearchBuilder builder = this.getBeanRepo().asBeanReaderRepo().createSearchBuilder(this.getInvocationContext(), includeIsSet);
        if (this.populateRows(tableDef)) {
            this.addCollectionToSearch(builder, this.getBeanTreePath(), propDefs);
        }
        if (builder.isChangeManagerBeanRepoSearchBuilder()) {
            builder.asChangeManagerBeanRepoSearchBuilder().addChangeManagerStatus();
        }
        return builder.search();
    }

    private Response<Page> processTableSearchResults(TableDef tableDef, List<BeanPropertyDef> propDefs, Response<BeanReaderRepoSearchResults> searchResponse) {
        Response<List<TableRow>> rowsResponse;
        Response<Table> response = new Response<Table>();
        if (!searchResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(searchResponse);
        }
        BeanReaderRepoSearchResults searchResults = searchResponse.getResults();
        Response<PageDef> pageDefResponse = this.getPageDef();
        if (!pageDefResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(pageDefResponse);
        }
        Table table = new Table();
        this.setTableCustomizations(table, tableDef);
        this.setPageDef(table, pageDefResponse.getResults());
        this.addPageInfo(table);
        this.addChangeManagerStatus(table, searchResults);
        this.addLinks(table, false);
        Response<List<TableRow>> response2 = rowsResponse = this.populateRows(tableDef) ? this.getRowsStandard(propDefs, searchResults) : this.getRowsCustom(tableDef, searchResults);
        if (!rowsResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(rowsResponse);
        }
        table.getRows().clear();
        table.getRows().addAll((Collection<TableRow>)rowsResponse.getResults());
        return response.setSuccess(table);
    }

    private Response<List<TableRow>> getRowsStandard(List<BeanPropertyDef> propDefs, BeanReaderRepoSearchResults searchResults) {
        Response<List<TableRow>> response = new Response<List<TableRow>>();
        ArrayList<TableRow> rows = new ArrayList<TableRow>();
        Response<List<BeanSearchResults>> getCollectionResponse = this.getCollectionResults(searchResults, this.getBeanTreePath(), propDefs);
        if (!getCollectionResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(getCollectionResponse);
        }
        List<BeanSearchResults> collectionResults = getCollectionResponse.getResults();
        if (collectionResults == null) {
            response.setNotFound();
            return response;
        }
        for (BeanSearchResults beanResults : collectionResults) {
            Response<TableRow> rowResponse = this.createTableRow(beanResults, searchResults, propDefs);
            if (!rowResponse.isSuccess()) {
                return response.copyUnsuccessfulResponse(rowResponse);
            }
            rows.add(rowResponse.getResults());
        }
        return response.setSuccess(rows);
    }

    private boolean populateRows(TableDef tableDef) {
        return StringUtils.isEmpty((String)tableDef.getGetTableRowsMethod());
    }

    private Response<List<TableRow>> getRowsCustom(TableDef tableDef, BeanReaderRepoSearchResults searchResults) {
        Response<List> response = new Response<List>();
        Method method = CustomizerInvocationUtils.getMethod(tableDef.getGetTableRowsMethod());
        CustomizerInvocationUtils.checkSignature(method, GET_TABLE_ROWS_CUSTOMIZER_RETURN_TYPE, new Type[]{InvocationContext.class, BeanReaderRepoSearchResults.class});
        InvocationContext actualIc = new InvocationContext(this.getInvocationContext());
        actualIc.setPagePath(tableDef.getPagePath());
        List<Object> args = List.of(actualIc, searchResults);
        try {
            Object responseAsObject = CustomizerInvocationUtils.invokeMethod(method, args);
            List rows = (List)responseAsObject;
            return response.setSuccess(rows);
        }
        catch (ResponseException e) {
            return response.copyUnsuccessfulResponse(e.getResponse());
        }
    }

    private void setTableCustomizations(Table table, TableDef tableDef) {
        TableCustomizations customizations = this.getTableCustomizations(tableDef);
        if (customizations != null) {
            table.getDisplayedColumns().addAll(customizations.getDisplayedColumns());
        }
    }

    private TableCustomizations getTableCustomizations(TableDef tableDef) {
        return this.getTableCustomizationsManager().getTableCustomizations(this.getInvocationContext(), tableDef);
    }

    private TableCustomizationsManager getTableCustomizationsManager() {
        InvocationContext ic = this.getInvocationContext();
        return ic.getPageRepo().asPageReaderRepo().getTableCustomizationsManager(ic);
    }

    private Response<TableRow> createTableRow(BeanSearchResults beanResults, BeanReaderRepoSearchResults searchResults, List<BeanPropertyDef> propDefs) {
        Response<TableRow> response = new Response<TableRow>();
        boolean includeIsSet = false;
        Response<BeanTypeDef> rowTypeDefResponse = this.getRowTypeDef(beanResults, searchResults);
        if (!rowTypeDefResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(rowTypeDefResponse);
        }
        BeanTypeDef rowTypeDef = rowTypeDefResponse.getResults();
        TableRow row = new TableRow();
        for (BeanPropertyDef propDef : propDefs) {
            Value rowValue = null;
            if (this.getBeanTreePath().getTypeDef().isHomogeneous() || rowTypeDef.hasPropertyDef(propDef.getPropertyPath())) {
                Response<Value> valueResponse = this.getPropertyValue(propDef, beanResults, searchResults, includeIsSet);
                if (!valueResponse.isSuccess()) {
                    return response.copyUnsuccessfulResponse(valueResponse);
                }
                rowValue = valueResponse.getResults();
            } else {
                rowValue = UnknownValue.INSTANCE;
            }
            row.getCells().add(new TableCell(propDef.getFormFieldName(), rowValue));
        }
        return response.setSuccess(row);
    }

    private Response<BeanTypeDef> getRowTypeDef(BeanSearchResults beanResults, BeanReaderRepoSearchResults searchResults) {
        return this.getActualTypeDef(beanResults.getBeanTreePath(), beanResults, searchResults);
    }
}

