/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import weblogic.remoteconsole.common.repodef.PageDef;
import weblogic.remoteconsole.common.repodef.PagePropertyDef;
import weblogic.remoteconsole.server.PersistableFeature;
import weblogic.remoteconsole.server.PersistenceManager;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.PersistedTableCustomizations;
import weblogic.remoteconsole.server.repo.PersistedTablesCustomizations;
import weblogic.remoteconsole.server.repo.TableCustomizations;

public class TableCustomizationsManager
extends PersistableFeature<PersistedTablesCustomizations> {
    private PersistenceManager<PersistedTablesCustomizations> persistenceManager = new PersistenceManager<PersistedTablesCustomizations>(PersistedTablesCustomizations.class, "table-customizations");
    private PersistedTablesCustomizations customizations = new PersistedTablesCustomizations();

    TableCustomizationsManager() {
    }

    @Override
    protected PersistenceManager<PersistedTablesCustomizations> getPersistenceManager() {
        return this.persistenceManager;
    }

    @Override
    protected void fromPersistedData(InvocationContext ic, PersistedTablesCustomizations persistedData) {
        this.customizations = persistedData != null ? persistedData : new PersistedTablesCustomizations();
    }

    @Override
    protected PersistedTablesCustomizations toPersistedData(InvocationContext ic) {
        return this.customizations;
    }

    public TableCustomizations getTableCustomizations(InvocationContext ic, PageDef pageDef) {
        String tableId = this.getTableId(ic, pageDef);
        List<PagePropertyDef> defaultDisplayedColumnDefs = this.getDefaultDisplayedColumnDefs(pageDef);
        List<PagePropertyDef> defaultHiddenColumnDefs = this.getDefaultHiddenColumnDefs(pageDef);
        this.refresh(ic);
        PersistedTableCustomizations persisted = this.getTableIdToCustomizations().get(tableId);
        if (persisted == null) {
            return null;
        }
        List<String> persistedDisplayedColumns = persisted.getDisplayedColumns();
        List<String> defaultDisplayedColumns = TableCustomizationsManager.getColumns(defaultDisplayedColumnDefs);
        List<String> defaultHiddenColumns = TableCustomizationsManager.getColumns(defaultHiddenColumnDefs);
        return new TableCustomizations(tableId, TableCustomizationsManager.getDisplayedColumns(persistedDisplayedColumns, defaultDisplayedColumns, defaultHiddenColumns));
    }

    public List<String> getDefaultDisplayedColumns(PageDef pageDef) {
        return TableCustomizationsManager.getColumns(this.getDefaultDisplayedColumnDefs(pageDef));
    }

    private static List<String> getDisplayedColumns(List<String> persistedDisplayedColumns, List<String> defaultDisplayedColumns, List<String> defaultHiddenColumns) {
        ArrayList<String> displayedColumns = new ArrayList<String>();
        for (String column : persistedDisplayedColumns) {
            if (!defaultDisplayedColumns.contains(column) && !defaultHiddenColumns.contains(column)) continue;
            displayedColumns.add(column);
        }
        return displayedColumns;
    }

    private static List<String> getPersistedDisplayedColumns(List<String> newDisplayedColumns, List<PagePropertyDef> defaultDisplayedColumnDefs, List<PagePropertyDef> defaultHiddenColumnDefs, List<String> oldPersistedDisplayedColumns) {
        List<String> defaultDisplayedColumns = TableCustomizationsManager.getColumns(defaultDisplayedColumnDefs);
        List<String> defaultHiddenColumns = TableCustomizationsManager.getColumns(defaultHiddenColumnDefs);
        ArrayList<String> newPersistedDisplayedColumns = new ArrayList<String>();
        for (String column : newDisplayedColumns) {
            if (!defaultDisplayedColumns.contains(column) && !defaultHiddenColumns.contains(column)) continue;
            newPersistedDisplayedColumns.add(column);
        }
        for (String column : oldPersistedDisplayedColumns) {
            if (defaultDisplayedColumns.contains(column) || defaultHiddenColumns.contains(column)) continue;
            newPersistedDisplayedColumns.add(column);
        }
        return newPersistedDisplayedColumns;
    }

    private static List<String> getColumns(List<PagePropertyDef> columnDefs) {
        ArrayList<String> columns = new ArrayList<String>();
        for (PagePropertyDef columnDef : columnDefs) {
            columns.add(columnDef.getFormFieldName());
        }
        return columns;
    }

    public void setTableCustomizations(InvocationContext ic, PageDef pageDef, List<String> newDisplayedColumns) {
        String tableId = this.getTableId(ic, pageDef);
        List<PagePropertyDef> defaultDisplayedColumnDefs = this.getDefaultDisplayedColumnDefs(pageDef);
        List<PagePropertyDef> defaultHiddenColumnDefs = this.getDefaultHiddenColumnDefs(pageDef);
        this.refresh(ic);
        if (newDisplayedColumns == null) {
            if (this.getTableIdToCustomizations().containsKey(tableId)) {
                this.getTableIdToCustomizations().remove(tableId);
                this.update(ic);
            }
            return;
        }
        PersistedTableCustomizations oldPersisted = this.getTableIdToCustomizations().get(tableId);
        List<String> oldPersistedDisplayedColumns = oldPersisted != null ? oldPersisted.getDisplayedColumns() : List.of();
        List<String> newPersistedDisplayedColumns = TableCustomizationsManager.getPersistedDisplayedColumns(newDisplayedColumns, defaultDisplayedColumnDefs, defaultHiddenColumnDefs, oldPersistedDisplayedColumns);
        PersistedTableCustomizations newPersisted = new PersistedTableCustomizations();
        newPersisted.setDisplayedColumns(newPersistedDisplayedColumns);
        this.getTableIdToCustomizations().put(tableId, newPersisted);
        this.update(ic);
    }

    public synchronized void deleteTableCustomizations(InvocationContext ic, String tableId) {
        this.refresh(ic);
        if (this.getTableIdToCustomizations().containsKey(tableId)) {
            this.getTableIdToCustomizations().remove(tableId);
            this.update(ic);
        }
    }

    private String getTableId(InvocationContext ic, PageDef pageDef) {
        String typeName = pageDef.getPagePath().getPagesPath().getTypeDef().getTypeName();
        if (pageDef.isTableDef()) {
            return typeName;
        }
        if (pageDef.isSliceTableDef()) {
            String slice = pageDef.getPagePath().asSlicePagePath().getSlicePath().getDotSeparatedPath();
            if ("CustomFilteringDashboardMBean".equals(typeName) && "View".equals(slice)) {
                return this.getFilteringDashboardTableId(ic, false);
            }
            if ("BuiltinFilteringDashboardMBean".equals(typeName) && "View".equals(slice)) {
                return this.getFilteringDashboardTableId(ic, true);
            }
            return typeName + "?slice=" + slice;
        }
        throw new AssertionError((Object)(String.valueOf(pageDef.getPagePath()) + " is not a table or a slice table"));
    }

    String getFilteringDashboardTableId(InvocationContext ic, boolean builtin) {
        String prefix = builtin ? "Builtin" : "Custom";
        return prefix + "FilteringDashboard=" + ic.getBeanTreePath().getLastSegment().getKey();
    }

    private List<PagePropertyDef> getDefaultDisplayedColumnDefs(PageDef pageDef) {
        if (pageDef.isTableDef()) {
            return pageDef.asTableDef().getDisplayedColumnDefs();
        }
        if (pageDef.isSliceTableDef()) {
            return pageDef.asSliceTableDef().getDisplayedColumnDefs();
        }
        throw new AssertionError((Object)(String.valueOf(pageDef.getPagePath()) + " is not a table or a slice table"));
    }

    private List<PagePropertyDef> getDefaultHiddenColumnDefs(PageDef pageDef) {
        if (pageDef.isTableDef()) {
            return pageDef.asTableDef().getHiddenColumnDefs();
        }
        if (pageDef.isSliceTableDef()) {
            return pageDef.asSliceTableDef().getHiddenColumnDefs();
        }
        throw new AssertionError((Object)(String.valueOf(pageDef.getPagePath()) + " is not a table or a slice table"));
    }

    private Map<String, PersistedTableCustomizations> getTableIdToCustomizations() {
        return this.customizations.getTableCustomizations();
    }
}

