/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import com.fasterxml.jackson.core.type.TypeReference;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.PageDef;
import weblogic.remoteconsole.common.repodef.PagePropertyDef;
import weblogic.remoteconsole.common.repodef.SliceFormDef;
import weblogic.remoteconsole.common.repodef.SlicePagePath;
import weblogic.remoteconsole.common.repodef.SliceTableDef;
import weblogic.remoteconsole.common.utils.CustomizerInvocationUtils;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchResults;
import weblogic.remoteconsole.server.repo.BeanSearchResults;
import weblogic.remoteconsole.server.repo.Form;
import weblogic.remoteconsole.server.repo.FormProperty;
import weblogic.remoteconsole.server.repo.FormReader;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Page;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.ResponseException;
import weblogic.remoteconsole.server.repo.Table;
import weblogic.remoteconsole.server.repo.TableCustomizations;
import weblogic.remoteconsole.server.repo.TableRow;
import weblogic.remoteconsole.server.repo.Value;

class SliceReader
extends FormReader {
    private static final Type GET_TABLE_ROWS_CUSTOMIZER_RETURN_TYPE = new TypeReference<List<TableRow>>(){}.getType();

    SliceReader(InvocationContext invocationContext) {
        super(invocationContext);
    }

    Response<Page> getSlice() {
        Response<PageDef> pageDefResponse = this.getActualPageDef();
        if (!pageDefResponse.isSuccess()) {
            return new Response().copyUnsuccessfulResponse(pageDefResponse);
        }
        PageDef pageDef = pageDefResponse.getResults();
        if (pageDef.isSliceFormDef()) {
            return this.getSliceForm(pageDef.asSliceFormDef());
        }
        if (pageDef.isSliceTableDef()) {
            return this.getSliceTable(pageDef.asSliceTableDef());
        }
        throw new AssertionError((Object)("Slice is not a form or table: " + String.valueOf(pageDef)));
    }

    private Response<PageDef> getActualPageDef() {
        Response response = new Response();
        Response<SlicePagePath> pagePathResponse = this.getActualSlicePagePath();
        if (!pagePathResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(pagePathResponse);
        }
        SlicePagePath pagePath = pagePathResponse.getResults();
        return this.getPageDef(pagePath);
    }

    private Response<Page> getSliceTable(SliceTableDef sliceTableDef) {
        return this.processSliceTableSearchResults(sliceTableDef, this.performSliceTableSearch());
    }

    private Response<BeanReaderRepoSearchResults> performSliceTableSearch() {
        boolean includeIsSet = false;
        BeanReaderRepoSearchBuilder builder = this.getBeanRepo().asBeanReaderRepo().createSearchBuilder(this.getInvocationContext(), includeIsSet);
        builder.addProperty(this.getBeanTreePath(), this.getBeanTreePath().getTypeDef().getIdentityPropertyDef());
        BeanPropertyDef discDef = this.getBeanTreePath().getTypeDef().getSubTypeDiscriminatorPropertyDef();
        if (discDef != null) {
            builder.addProperty(this.getBeanTreePath(), discDef);
        }
        if (builder.isChangeManagerBeanRepoSearchBuilder()) {
            builder.asChangeManagerBeanRepoSearchBuilder().addChangeManagerStatus();
        }
        return builder.search();
    }

    private Response<Page> processSliceTableSearchResults(SliceTableDef sliceTableDef, Response<BeanReaderRepoSearchResults> searchResponse) {
        Response<Table> response = new Response<Table>();
        if (!searchResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(searchResponse);
        }
        BeanReaderRepoSearchResults searchResults = searchResponse.getResults();
        Response<List<TableRow>> getRowsResponse = this.getTableRows(searchResults, sliceTableDef);
        if (!getRowsResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(getRowsResponse);
        }
        Table table = new Table();
        this.setTableCustomizations(table, sliceTableDef);
        this.setPageDef(table, sliceTableDef);
        this.addChangeManagerStatus(table, searchResults);
        this.addPageInfo(table);
        this.addLinks(table, true);
        table.getRows().addAll((Collection<TableRow>)getRowsResponse.getResults());
        return response.setSuccess(table);
    }

    private void setTableCustomizations(Table table, SliceTableDef sliceTableDef) {
        InvocationContext ic = this.getInvocationContext();
        TableCustomizations customizations = ic.getPageRepo().asPageReaderRepo().getTableCustomizationsManager(ic).getTableCustomizations(this.getInvocationContext(), sliceTableDef);
        if (customizations != null) {
            table.getDisplayedColumns().addAll(customizations.getDisplayedColumns());
        }
    }

    private Response<List<TableRow>> getTableRows(BeanReaderRepoSearchResults searchResults, SliceTableDef sliceTableDef) {
        String methodName = sliceTableDef.getGetTableRowsMethod();
        if (StringUtils.isEmpty((String)methodName)) {
            return new Response().setSuccess(new ArrayList());
        }
        Method method = CustomizerInvocationUtils.getMethod(methodName);
        CustomizerInvocationUtils.checkSignature(method, GET_TABLE_ROWS_CUSTOMIZER_RETURN_TYPE, new Type[]{InvocationContext.class, BeanReaderRepoSearchResults.class});
        InvocationContext actualIc = new InvocationContext(this.getInvocationContext());
        actualIc.setPagePath(sliceTableDef.getPagePath());
        List<Object> args = List.of(actualIc, searchResults);
        Response<List> response = new Response<List>();
        try {
            Object responseAsObject = CustomizerInvocationUtils.invokeMethod(method, args);
            List rows = (List)responseAsObject;
            return response.setSuccess(rows);
        }
        catch (ResponseException e) {
            return response.copyUnsuccessfulResponse(e.getResponse());
        }
    }

    private Response<Page> getSliceForm(SliceFormDef sliceFormDef) {
        List<BeanPropertyDef> propDefs = this.createPropertyDefList();
        propDefs.addAll(sliceFormDef.getAllPropertyDefs());
        return this.processSliceFormSearchResults(sliceFormDef, propDefs, this.performSliceFormSearch(propDefs));
    }

    private Response<BeanReaderRepoSearchResults> performSliceFormSearch(List<BeanPropertyDef> propDefs) {
        boolean includeIsSet = true;
        BeanReaderRepoSearchBuilder builder = this.getBeanRepo().asBeanReaderRepo().createSearchBuilder(this.getInvocationContext(), includeIsSet);
        for (BeanPropertyDef propDef : propDefs) {
            builder.addProperty(this.getBeanTreePath(), propDef);
            this.addParamsToSearch(builder, this.getBeanTreePath(), propDef.getGetValueCustomizerDef());
            if (!propDef.isUpdateWritable()) continue;
            this.addParamsToSearch(builder, this.getBeanTreePath(), propDef.getGetOptionsCustomizerDef());
            this.addOptionsSourcesToSearch(builder, propDef);
        }
        if (builder.isChangeManagerBeanRepoSearchBuilder()) {
            builder.asChangeManagerBeanRepoSearchBuilder().addChangeManagerStatus();
        }
        return builder.search();
    }

    private Response<Page> processSliceFormSearchResults(PageDef pageDef, List<BeanPropertyDef> propDefs, Response<BeanReaderRepoSearchResults> searchResponse) {
        Response<Form> response = new Response<Form>();
        if (!searchResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(searchResponse);
        }
        BeanReaderRepoSearchResults searchResults = searchResponse.getResults();
        BeanSearchResults beanResults = searchResults.getBean(this.getBeanTreePath());
        if (beanResults == null && !this.getBeanTreePath().isOptionalSingleton() && StringUtils.isEmpty((String)pageDef.getCustomizePageMethod())) {
            return response.setNotFound();
        }
        Form form = new Form();
        form.setExists(beanResults != null);
        Response<Void> propsResponse = this.addFormProperties(form, propDefs, beanResults, searchResults);
        if (!propsResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(propsResponse);
        }
        this.setPageDef(form, pageDef);
        this.addPageInfo(form);
        this.addChangeManagerStatus(form, searchResults);
        this.addLinks(form, true);
        this.addModelTokens(form);
        return response.setSuccess(form);
    }

    private Response<Void> addFormProperties(Form form, List<BeanPropertyDef> propDefs, BeanSearchResults beanResults, BeanReaderRepoSearchResults searchResults) {
        Response response = new Response();
        if (beanResults == null) {
            return response.setSuccess(null);
        }
        for (BeanPropertyDef propDef : propDefs) {
            if (!propDef.isPagePropertyDef()) continue;
            Response<FormProperty> propResponse = this.getFormProperty(propDef.asPagePropertyDef(), beanResults, searchResults);
            if (!propResponse.isSuccess()) {
                return response.copyUnsuccessfulResponse(propResponse);
            }
            FormProperty formProperty = propResponse.getResults();
            if (formProperty == null) continue;
            form.getProperties().add(formProperty);
        }
        return response.setSuccess(null);
    }

    private Response<FormProperty> getFormProperty(PagePropertyDef propertyDef, BeanSearchResults beanResults, BeanReaderRepoSearchResults searchResults) {
        Response<FormProperty> optionsResponse;
        Response<FormProperty> response = new Response<FormProperty>();
        boolean includeIsSet = true;
        Response<Value> valueResponse = this.getPropertyValue(propertyDef, beanResults, searchResults, includeIsSet);
        if (!valueResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(valueResponse);
        }
        Value value = valueResponse.getResults();
        if (value == null) {
            return response.setSuccess(null);
        }
        FormProperty formProperty = new FormProperty(propertyDef, value);
        if (propertyDef.isUpdateWritable() && !(optionsResponse = this.addOptionsAndOptionsSources(propertyDef, formProperty, beanResults, searchResults)).isSuccess()) {
            return response.copyUnsuccessfulResponse(optionsResponse);
        }
        return response.setSuccess(formProperty);
    }

    public Response<SlicePagePath> getActualSlicePagePath() {
        Response<SlicePagePath> response = new Response<SlicePagePath>();
        SlicePagePath slicePagePath = this.getPagePath().asSlicePagePath();
        BeanTypeDef typeDef = slicePagePath.getPagesPath().getTypeDef();
        if (typeDef.isHomogeneous()) {
            return response.setSuccess(slicePagePath);
        }
        Response<String> valueResponse = this.getSubTypeDiscriminatorValue();
        if (this.getBeanTreePath().isOptionalSingleton() && this.getBeanTreePath().isCreatable() && valueResponse.isNotFound()) {
            return response.setSuccess(slicePagePath);
        }
        if (!valueResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(valueResponse);
        }
        BeanTypeDef subTypeDef = typeDef.getSubTypeDef(valueResponse.getResults());
        SlicePagePath subTypeSlicePagePath = this.getPageRepoDef().newSlicePagePath(subTypeDef, slicePagePath.getSlicePath());
        return response.setSuccess(subTypeSlicePagePath);
    }

    private Response<String> getSubTypeDiscriminatorValue() {
        Response<String> response = new Response<String>();
        boolean includeIsSet = false;
        BeanReaderRepoSearchBuilder builder = this.getBeanRepo().asBeanReaderRepo().createSearchBuilder(this.getInvocationContext(), includeIsSet);
        this.addSubTypeDiscriminatorToSearch(this.getBeanTreePath(), builder);
        Response<BeanReaderRepoSearchResults> searchResponse = builder.search();
        if (!searchResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(searchResponse);
        }
        Response<String> discResponse = this.getSubTypeDiscriminatorValue(this.getBeanTreePath(), searchResponse.getResults());
        if (!discResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(discResponse);
        }
        return response.setSuccess(discResponse.getResults());
    }
}

