/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import weblogic.remoteconsole.server.PersistableFeature;
import weblogic.remoteconsole.server.PersistenceManager;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchResults;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.PersistedRecentSearches;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.SearchBeanFilter;
import weblogic.remoteconsole.server.repo.SearchBeanFinder;
import weblogic.remoteconsole.server.repo.SearchBeanResults;
import weblogic.remoteconsole.server.repo.SearchCriteria;
import weblogic.remoteconsole.server.repo.SearchProperty;
import weblogic.remoteconsole.server.repo.SimpleSearch;
import weblogic.remoteconsole.server.repo.SimpleSearchCriteria;

public class SimpleSearchManager
extends PersistableFeature<PersistedRecentSearches> {
    private PersistenceManager<PersistedRecentSearches> persistenceManager = new PersistenceManager<PersistedRecentSearches>(PersistedRecentSearches.class, "recent-searches");
    private List<SimpleSearch> recentSearches = new ArrayList<SimpleSearch>();
    private static final int MAX_CACHED_SEARCHES = 25;
    private static final int MINIMUM_CACHEABLE_SEARCH_TIME = 3000;
    private static final int SEARCH_TIME_TO_EXPIRATION_TIME = 5;

    SimpleSearchManager() {
    }

    @Override
    protected PersistenceManager<PersistedRecentSearches> getPersistenceManager() {
        return this.persistenceManager;
    }

    @Override
    protected void fromPersistedData(InvocationContext ic, PersistedRecentSearches persistedData) {
        ArrayList<SimpleSearch> newRecentSearches = new ArrayList<SimpleSearch>();
        if (persistedData != null) {
            for (String recentSearch : persistedData.getRecentSearches()) {
                if (newRecentSearches.size() >= 25) break;
                SimpleSearch search = this.findSimpleSearch(ic, recentSearch, false);
                if (search == null) {
                    SimpleSearchCriteria criteria = new SimpleSearchCriteria();
                    criteria.setContains(recentSearch);
                    search = new SimpleSearch(criteria, "unknown", null, null, null);
                }
                newRecentSearches.add(search);
            }
        }
        this.recentSearches.clear();
        this.recentSearches.addAll(newRecentSearches);
    }

    @Override
    protected PersistedRecentSearches toPersistedData(InvocationContext ic) {
        ArrayList<String> searchNames = new ArrayList<String>();
        for (SimpleSearch recentSearch : this.recentSearches) {
            searchNames.add(recentSearch.getName());
        }
        PersistedRecentSearches rtn = new PersistedRecentSearches();
        rtn.setRecentSearches(searchNames);
        return rtn;
    }

    public synchronized List<SimpleSearch> getRecentSearches(InvocationContext ic) {
        this.refresh(ic);
        return List.copyOf(this.recentSearches);
    }

    public synchronized Response<String> createSearch(InvocationContext ic, SimpleSearchCriteria criteria) {
        this.refresh(ic);
        Response<String> response = new Response<String>();
        SimpleSearch search = new SimpleSearch(criteria, this.getLanguage(ic), null, null, null);
        this.recordSearch(ic, search);
        return response.setSuccess(search.getName());
    }

    public synchronized void clearSearches(InvocationContext ic) {
        this.refresh(ic);
        this.recentSearches.clear();
        this.update(ic);
    }

    private void recordSearch(InvocationContext ic, SimpleSearch newSearch) {
        ArrayList<SimpleSearch> newSearches = new ArrayList<SimpleSearch>();
        newSearches.add(newSearch);
        for (SimpleSearch oldSearch : this.recentSearches) {
            if (newSearches.size() >= 25) break;
            if (oldSearch.getName().equals(newSearch.getName())) continue;
            newSearches.add(oldSearch);
        }
        this.recentSearches.clear();
        this.recentSearches.addAll(newSearches);
        this.update(ic);
    }

    public synchronized Response<SimpleSearch> getSearchResults(InvocationContext ic, String searchName) {
        this.refresh(ic);
        Response<SimpleSearch> response = new Response<SimpleSearch>();
        SimpleSearch search = this.findSimpleSearch(ic, searchName, true);
        if (search == null) {
            return response.setNotFound();
        }
        String language = this.getLanguage(ic);
        if (!ic.isReload() && search.isCurrent() && language.equals(search.getLanguage())) {
            return response.setSuccess(search);
        }
        long startTime = System.currentTimeMillis();
        Response<List<SearchBeanResults>> searchResponse = this.doSearch(ic, search.getCriteria());
        if (!searchResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(searchResponse);
        }
        long endTime = System.currentTimeMillis();
        SimpleSearch newSearch = new SimpleSearch(search.getCriteria(), language, searchResponse.getResults(), new Date(endTime), this.getExpirationDate(startTime, endTime));
        this.recordSearch(ic, newSearch);
        return response.setSuccess(newSearch);
    }

    private SimpleSearch findSimpleSearch(InvocationContext ic, String searchName, boolean moveToTop) {
        for (int i = 0; i < this.recentSearches.size(); ++i) {
            SimpleSearch search = this.recentSearches.get(i);
            if (!search.getName().equals(searchName)) continue;
            if (i != 0 && moveToTop) {
                this.recentSearches.remove(i);
                this.recentSearches.add(0, search);
                this.update(ic);
            }
            return search;
        }
        return null;
    }

    public String getLanguage(InvocationContext ic) {
        return ic.getLocalizer().getLocale().getLanguage();
    }

    private Response<List<SearchBeanResults>> doSearch(InvocationContext ic, SimpleSearchCriteria criteria) {
        Response<List<SearchBeanResults>> response = new Response<List<SearchBeanResults>>();
        SearchBeanFilter filter = new SearchBeanFilter();
        filter.setPathContains(criteria.getContains());
        SearchCriteria genericCriteria = new SearchCriteria();
        genericCriteria.setFilters(List.of(filter));
        genericCriteria.setProperties(new ArrayList<SearchProperty>());
        SearchBeanFinder finder = new SearchBeanFinder(ic, genericCriteria);
        boolean includeIsSet = false;
        BeanReaderRepoSearchBuilder builder = ic.getPageRepo().getBeanRepo().asBeanReaderRepo().createSearchBuilder(ic, includeIsSet);
        finder.addToSearchBuilder(builder);
        Response<BeanReaderRepoSearchResults> searchResponse = builder.search();
        if (!searchResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(searchResponse);
        }
        List<SearchBeanResults> searchResults = finder.getResults(searchResponse.getResults());
        return response.setSuccess(searchResults);
    }

    private Date getExpirationDate(long startTime, long endTime) {
        long searchTime = endTime - startTime;
        if (searchTime < 3000L) {
            return new Date(endTime);
        }
        long expirationTime = endTime + 5L * searchTime;
        return new Date(expirationTime);
    }
}

