/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import java.util.Date;
import java.util.List;
import weblogic.remoteconsole.server.repo.SearchBeanResults;
import weblogic.remoteconsole.server.repo.SimpleSearchCriteria;

public class SimpleSearch {
    private SimpleSearchCriteria criteria;
    private String language;
    private List<SearchBeanResults> results;
    private Date resultsDate;
    private Date expirationDate;

    SimpleSearch(SimpleSearchCriteria criteria, String language, List<SearchBeanResults> results, Date resultsDate, Date expirationDate) {
        this.criteria = criteria;
        this.language = language;
        this.results = results;
        this.resultsDate = resultsDate;
        this.expirationDate = expirationDate;
    }

    public String getName() {
        return this.criteria.getContains();
    }

    public SimpleSearchCriteria getCriteria() {
        return this.criteria;
    }

    public String getLanguage() {
        return this.language;
    }

    public List<SearchBeanResults> getResults() {
        return this.results;
    }

    public Date getResultsDate() {
        return this.resultsDate;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public boolean isCurrent() {
        if (this.results == null) {
            return false;
        }
        Date now = new Date(System.currentTimeMillis());
        return now.before(this.expirationDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SimpleSearch<").append("criteria=").append(this.criteria.getContains());
        if (this.results != null) {
            sb.append(", resultsDate=").append(this.resultsDate).append(", numberOfMatches=").append(this.results.size());
            if (this.expirationDate != null) {
                sb.append(", expirationDate=").append(this.expirationDate);
            }
        }
        sb.append(">");
        return sb.toString();
    }
}

