/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import java.util.ArrayList;
import java.util.List;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.utils.DateUtils;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.BooleanValue;
import weblogic.remoteconsole.server.repo.DoubleValue;
import weblogic.remoteconsole.server.repo.LongValue;
import weblogic.remoteconsole.server.repo.SearchBeanFilter;
import weblogic.remoteconsole.server.repo.SearchBeanFinder;
import weblogic.remoteconsole.server.repo.SearchBeanPropertyResults;
import weblogic.remoteconsole.server.repo.SearchValueFilter;
import weblogic.remoteconsole.server.repo.StringValue;
import weblogic.remoteconsole.server.repo.Value;

public abstract class SearchValueFilterHandler {
    private SearchBeanFinder finder;
    private SearchBeanFilter filter;

    static SearchValueFilterHandler getHandler(SearchBeanFinder finder, SearchBeanFilter filter) {
        SearchValueFilter valueFilter = filter.getValueFilter();
        if (valueFilter == null) {
            return null;
        }
        if (valueFilter.getEquals() != null) {
            return new EqualsHandler(finder, filter);
        }
        if (valueFilter.getOneOf() != null && !valueFilter.getOneOf().isEmpty()) {
            return new OneOfHandler(finder, filter);
        }
        if (valueFilter.getLessThan() != null) {
            return new LessThanHandler(finder, filter);
        }
        if (valueFilter.getLessThanOrEquals() != null) {
            return new LessThanOrEqualsHandler(finder, filter);
        }
        if (valueFilter.getGreaterThan() != null) {
            return new GreaterThanHandler(finder, filter);
        }
        if (valueFilter.getGreaterThanOrEquals() != null) {
            return new GreaterThanOrEqualsHandler(finder, filter);
        }
        if (StringUtils.notEmpty((String)valueFilter.getContains())) {
            return new ContainsHandler(finder, filter);
        }
        throw new AssertionError((Object)("Unknown value filter type: " + String.valueOf(valueFilter)));
    }

    protected SearchValueFilterHandler(SearchBeanFinder finder, SearchBeanFilter filter) {
        this.finder = finder;
        this.filter = filter;
    }

    protected SearchBeanFinder getFinder() {
        return this.finder;
    }

    protected SearchBeanFilter getFilter() {
        return this.filter;
    }

    boolean valuePassesFilter(SearchBeanPropertyResults propertyResults) {
        Value value = propertyResults.getValue();
        if (value.isArray()) {
            for (Value val : value.asArray().getValues()) {
                if (!this.valueMatchesFilter(val)) continue;
                return true;
            }
            return false;
        }
        return this.valueMatchesFilter(value);
    }

    protected abstract boolean valueMatchesFilter(Value var1);

    protected StringValue getValueAsString(Value value) {
        if (value.isString()) {
            return value.asString();
        }
        if (value.isBoolean()) {
            return new StringValue("" + value.asBoolean().getValue());
        }
        if (value.isLong()) {
            return new StringValue("" + value.asLong().getValue());
        }
        if (value.isInt()) {
            return new StringValue("" + value.asInt().getValue());
        }
        if (value.isDouble()) {
            return new StringValue("" + value.asDouble().getValue());
        }
        if (value.isHealthState()) {
            return new StringValue(value.asHealthState().getValue());
        }
        if (value.isBeanTreePath()) {
            return new StringValue(value.asBeanTreePath().toString());
        }
        if (value.isDate()) {
            return new StringValue(DateUtils.formatDate(value.asDate().getValue()));
        }
        if (value.isDateAsLong()) {
            return new StringValue(DateUtils.formatDate(value.asDateAsLong().asDate().getValue()));
        }
        return null;
    }

    protected BooleanValue getValueAsBoolean(Value value) {
        return value.isBoolean() ? value.asBoolean() : null;
    }

    protected LongValue getValueAsLong(Value value) {
        if (value.isDate()) {
            long val = DateUtils.getRoundedDateAsLong(value.asDate().getValue());
            return new LongValue(val);
        }
        if (value.isDateAsLong()) {
            long val = DateUtils.getRoundedDateAsLong(value.asDateAsLong().asDate().getValue());
            return new LongValue(val);
        }
        if (value.isLong()) {
            return value.asLong();
        }
        if (value.isInt()) {
            return new LongValue(value.asInt().getValue());
        }
        return null;
    }

    protected DoubleValue getValueAsDouble(Value value) {
        if (value.isDouble()) {
            return value.asDouble();
        }
        if (value.isLong()) {
            return new DoubleValue(value.asLong().getValue());
        }
        if (value.isInt()) {
            return new DoubleValue(value.asInt().getValue());
        }
        return null;
    }

    protected BeanTreePath getValueAsBeanTreePath(Value value) {
        return value.isBeanTreePath() ? value.asBeanTreePath() : null;
    }

    private static class EqualsHandler
    extends SearchValueFilterHandler {
        private String want;

        private EqualsHandler(SearchBeanFinder finder, SearchBeanFilter filter) {
            super(finder, filter);
            this.want = this.getValueAsString(filter.getValueFilter().getEquals()).getValue();
        }

        @Override
        protected boolean valueMatchesFilter(Value value) {
            StringValue have = this.getValueAsString(value);
            if (have == null) {
                return false;
            }
            return this.want.equals(have.getValue());
        }
    }

    private static class OneOfHandler
    extends SearchValueFilterHandler {
        List<String> want = new ArrayList<String>();

        private OneOfHandler(SearchBeanFinder finder, SearchBeanFilter filter) {
            super(finder, filter);
            for (Value w : filter.getValueFilter().getOneOf()) {
                this.want.add(this.getValueAsString(w).getValue());
            }
        }

        @Override
        protected boolean valueMatchesFilter(Value value) {
            StringValue have = this.getValueAsString(value);
            if (have == null) {
                return false;
            }
            for (String w : this.want) {
                if (!w.equals(have.getValue())) continue;
                return true;
            }
            return false;
        }
    }

    private static class LessThanHandler
    extends NumberHandler {
        private LessThanHandler(SearchBeanFinder finder, SearchBeanFilter filter) {
            super(finder, filter, filter.getValueFilter().getLessThan());
        }

        @Override
        protected boolean valueMatches(long have, long want) {
            return have < want;
        }
    }

    private static class LessThanOrEqualsHandler
    extends NumberHandler {
        private LessThanOrEqualsHandler(SearchBeanFinder finder, SearchBeanFilter filter) {
            super(finder, filter, filter.getValueFilter().getLessThanOrEquals());
        }

        @Override
        protected boolean valueMatches(long have, long want) {
            return have <= want;
        }
    }

    private static class GreaterThanHandler
    extends NumberHandler {
        private GreaterThanHandler(SearchBeanFinder finder, SearchBeanFilter filter) {
            super(finder, filter, filter.getValueFilter().getGreaterThan());
        }

        @Override
        protected boolean valueMatches(long have, long want) {
            return have > want;
        }
    }

    private static class GreaterThanOrEqualsHandler
    extends NumberHandler {
        private GreaterThanOrEqualsHandler(SearchBeanFinder finder, SearchBeanFilter filter) {
            super(finder, filter, filter.getValueFilter().getGreaterThanOrEquals());
        }

        @Override
        protected boolean valueMatches(long have, long want) {
            return have >= want;
        }
    }

    private static class ContainsHandler
    extends SearchValueFilterHandler {
        String want;

        private ContainsHandler(SearchBeanFinder finder, SearchBeanFilter filter) {
            super(finder, filter);
            this.want = filter.getValueFilter().getContains().toLowerCase();
        }

        @Override
        protected boolean valueMatchesFilter(Value value) {
            StringValue have = this.getValueAsString(value);
            if (have == null) {
                return false;
            }
            return this.getFinder().contains(have.getValue(), this.want);
        }
    }

    private static abstract class NumberHandler
    extends SearchValueFilterHandler {
        private long want;

        protected NumberHandler(SearchBeanFinder finder, SearchBeanFilter filter, Value want) {
            super(finder, filter);
            this.want = this.getValueAsLong(want).getValue();
        }

        @Override
        protected boolean valueMatchesFilter(Value value) {
            LongValue have = this.getValueAsLong(value);
            if (have == null) {
                return false;
            }
            return this.valueMatches(have.getValue(), this.want);
        }

        protected abstract boolean valueMatches(long var1, long var3);
    }
}

