/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.PageDef;
import weblogic.remoteconsole.common.repodef.PagePath;
import weblogic.remoteconsole.common.repodef.PagePropertyDef;
import weblogic.remoteconsole.common.repodef.PageRepoDef;
import weblogic.remoteconsole.common.repodef.SliceDef;
import weblogic.remoteconsole.common.repodef.SliceFormDef;
import weblogic.remoteconsole.common.repodef.SliceTableDef;
import weblogic.remoteconsole.common.repodef.SlicesDef;

public class SearchUtils {
    public static List<PagePropertyDef> getBasicPagePropertyDefs(PageRepoDef pageRepoDef, BeanTypeDef typeDef) {
        PageDef pageDef = pageRepoDef.getPageDef(pageRepoDef.newTablePagePath(typeDef));
        if (pageDef != null) {
            return SearchUtils.removePageLevelProperties(pageDef.asTableDef().getDisplayedColumnDefs());
        }
        SliceFormDef formDef = SearchUtils.getDefaultSliceFormDef(pageRepoDef, typeDef);
        if (formDef != null) {
            return SearchUtils.removePageLevelProperties(formDef.getPropertyDefs());
        }
        SliceTableDef sliceTableDef = SearchUtils.getDefaultSliceTableDef(pageRepoDef, typeDef);
        if (sliceTableDef != null) {
            return SearchUtils.removePageLevelProperties(sliceTableDef.getDisplayedColumnDefs());
        }
        throw new AssertionError((Object)(String.valueOf(typeDef) + " is not a table and does not have a slice form"));
    }

    private static SliceFormDef getDefaultSliceFormDef(PageRepoDef pageRepoDef, BeanTypeDef typeDef) {
        PageDef pageDef = pageRepoDef.getPageDef(pageRepoDef.newSlicePagePath(typeDef, new Path()));
        if (pageDef != null && pageDef.isSliceFormDef()) {
            return pageDef.asSliceFormDef();
        }
        return null;
    }

    private static SliceTableDef getDefaultSliceTableDef(PageRepoDef pageRepoDef, BeanTypeDef typeDef) {
        PageDef pageDef = pageRepoDef.getPageDef(pageRepoDef.newSlicePagePath(typeDef, new Path()));
        if (pageDef != null && pageDef.isSliceTableDef()) {
            return pageDef.asSliceTableDef();
        }
        return null;
    }

    public static Map<String, PagePropertyDef> getPagePropertyDefs(PageRepoDef pageRepoDef, BeanTypeDef baseTypeDef) {
        HashMap<String, PagePropertyDef> propertyDefs = new HashMap<String, PagePropertyDef>();
        for (BeanTypeDef typeDef : SearchUtils.getTypeDefs(baseTypeDef)) {
            SearchUtils.addTablePropertyDefs(pageRepoDef, typeDef, propertyDefs);
            SearchUtils.addSlicesPropertyDefs(pageRepoDef, typeDef, propertyDefs);
        }
        return propertyDefs;
    }

    public static List<BeanTypeDef> getTypeDefs(BeanTypeDef baseTypeDef) {
        if (baseTypeDef.isHomogeneous()) {
            return List.of(baseTypeDef);
        }
        ArrayList<BeanTypeDef> typeDefs = new ArrayList<BeanTypeDef>();
        typeDefs.add(baseTypeDef);
        for (String disc : baseTypeDef.getSubTypeDiscriminatorLegalValues()) {
            typeDefs.add(baseTypeDef.getSubTypeDef(disc));
        }
        return typeDefs;
    }

    private static void addTablePropertyDefs(PageRepoDef pageRepoDef, BeanTypeDef typeDef, Map<String, PagePropertyDef> propertyDefs) {
        SearchUtils.addPagePathPropertyDefs(pageRepoDef, pageRepoDef.newTablePagePath(typeDef), propertyDefs);
    }

    private static void addSlicesPropertyDefs(PageRepoDef pageRepoDef, BeanTypeDef typeDef, Map<String, PagePropertyDef> propertyDefs) {
        SlicesDef slicesDef = pageRepoDef.getSlicesDef(typeDef);
        if (slicesDef != null) {
            SearchUtils.addSlicesPropertyDefs(pageRepoDef, typeDef, new Path(), slicesDef.getContentDefs(), propertyDefs);
        }
    }

    private static void addSlicesPropertyDefs(PageRepoDef pageRepoDef, BeanTypeDef typeDef, Path parentPath, List<SliceDef> sliceDefs, Map<String, PagePropertyDef> propertyDefs) {
        if (sliceDefs != null) {
            for (SliceDef sliceDef : sliceDefs) {
                Path slicePath = parentPath.childPath(sliceDef.getName());
                SearchUtils.addPagePathPropertyDefs(pageRepoDef, pageRepoDef.newSlicePagePath(typeDef, slicePath), propertyDefs);
                SearchUtils.addSlicesPropertyDefs(pageRepoDef, typeDef, slicePath, sliceDef.getContentDefs(), propertyDefs);
            }
        }
    }

    private static void addPagePathPropertyDefs(PageRepoDef pageRepoDef, PagePath pagePath, Map<String, PagePropertyDef> propertyDefs) {
        PageDef pageDef = pageRepoDef.getPageDef(pagePath);
        if (pageDef != null && !pageDef.isSliceTableDef()) {
            for (PagePropertyDef propertyDef : SearchUtils.removePageLevelProperties(pageDef.getAllPropertyDefs())) {
                String propertyName = propertyDef.getFormFieldName();
                if (propertyDefs.containsKey(propertyName)) continue;
                propertyDefs.put(propertyName, propertyDef);
            }
        }
    }

    private static List<PagePropertyDef> removePageLevelProperties(List<PagePropertyDef> propertyDefs) {
        ArrayList<PagePropertyDef> rtn = new ArrayList<PagePropertyDef>();
        for (PagePropertyDef propertyDef : propertyDefs) {
            if (propertyDef.isPageLevelField()) continue;
            rtn.add(propertyDef);
        }
        return rtn;
    }
}

