/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.PagePropertyDef;
import weblogic.remoteconsole.server.repo.BeanSearchResults;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.SearchBeanFinder;
import weblogic.remoteconsole.server.repo.SearchBeanPropertyResults;
import weblogic.remoteconsole.server.repo.SearchProperty;

public abstract class SearchPropertyHandler {
    private SearchBeanFinder finder;
    private SearchProperty property;
    private Map<String, List<PagePropertyDef>> typeNameToPropertyDefs = new HashMap<String, List<PagePropertyDef>>();

    static SearchPropertyHandler getHandler(SearchBeanFinder finder, SearchProperty property) {
        if (StringUtils.notEmpty((String)property.getPropertyName())) {
            return new PropertyNameHandler(finder, property);
        }
        if (StringUtils.notEmpty((String)property.getPropertyLabelContains())) {
            return new PropertyLabelContainsHandler(finder, property);
        }
        throw new AssertionError((Object)("Unknown property type: " + String.valueOf(property)));
    }

    protected SearchPropertyHandler(SearchBeanFinder finder, SearchProperty property) {
        this.finder = finder;
        this.property = property;
    }

    protected SearchBeanFinder getFinder() {
        return this.finder;
    }

    protected SearchProperty getProperty() {
        return this.property;
    }

    List<PagePropertyDef> getPropertyDefs(BeanTreePath beanTreePath) {
        String typeName = beanTreePath.getTypeDef().getTypeName();
        List<PagePropertyDef> rtn = this.typeNameToPropertyDefs.get(typeName);
        if (rtn == null) {
            rtn = new ArrayList<PagePropertyDef>();
            this.findPropertyDefs(beanTreePath, rtn);
            this.typeNameToPropertyDefs.put(typeName, rtn);
        }
        return rtn;
    }

    protected abstract void findPropertyDefs(BeanTreePath var1, List<PagePropertyDef> var2);

    List<SearchBeanPropertyResults> getResults(BeanSearchResults beanResults) {
        ArrayList<SearchBeanPropertyResults> rtn = new ArrayList<SearchBeanPropertyResults>();
        for (PagePropertyDef propertyDef : this.getPropertyDefs(beanResults.getBeanTreePath())) {
            SearchBeanPropertyResults propertyResults = this.getFinder().findProperty(propertyDef, beanResults);
            if (propertyResults == null) continue;
            rtn.add(propertyResults);
        }
        return rtn;
    }

    private static class PropertyNameHandler
    extends SearchPropertyHandler {
        private PropertyNameHandler(SearchBeanFinder finder, SearchProperty property) {
            super(finder, property);
        }

        @Override
        protected void findPropertyDefs(BeanTreePath beanTreePath, List<PagePropertyDef> propertyDefs) {
            this.getFinder().addPropertyDefMatchingPropertyName(beanTreePath, propertyDefs, this.getProperty().getPropertyName());
        }
    }

    private static class PropertyLabelContainsHandler
    extends SearchPropertyHandler {
        private PropertyLabelContainsHandler(SearchBeanFinder finder, SearchProperty property) {
            super(finder, property);
        }

        @Override
        protected void findPropertyDefs(BeanTreePath beanTreePath, List<PagePropertyDef> propertyDefs) {
            this.getFinder().addPropertyDefsMatchingPropertyLabelContains(beanTreePath, propertyDefs, this.getProperty().getPropertyLabelContains());
        }
    }
}

