/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.BeanChildNavTreeNodeDef;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.NavTreeDef;
import weblogic.remoteconsole.common.repodef.NavTreeNodeDef;
import weblogic.remoteconsole.common.repodef.PagePropertyDef;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchResults;
import weblogic.remoteconsole.server.repo.BeanSearchResults;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.BeanTreePathSegment;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.PageReader;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.SearchBeanFilter;
import weblogic.remoteconsole.server.repo.SearchBeanFilterHandler;
import weblogic.remoteconsole.server.repo.SearchBeanPropertyResults;
import weblogic.remoteconsole.server.repo.SearchBeanResults;
import weblogic.remoteconsole.server.repo.SearchCriteria;
import weblogic.remoteconsole.server.repo.SearchProperty;
import weblogic.remoteconsole.server.repo.SearchPropertyHandler;
import weblogic.remoteconsole.server.repo.SearchUtils;
import weblogic.remoteconsole.server.repo.Value;

public class SearchBeanFinder
extends PageReader {
    private SearchCriteria criteria;
    private List<SearchBeanFilterHandler> filterHandlers = new ArrayList<SearchBeanFilterHandler>();
    private List<SearchPropertyHandler> propertyHandlers = new ArrayList<SearchPropertyHandler>();
    private Map<String, List<BeanTypeDef>> typeNameToTypeDefs = new HashMap<String, List<BeanTypeDef>>();

    public SearchBeanFinder(InvocationContext ic, SearchCriteria criteria) {
        super(ic);
        this.criteria = criteria;
        for (SearchBeanFilter filter : criteria.getFilters()) {
            this.filterHandlers.add(SearchBeanFilterHandler.getHandler(this, filter));
        }
        for (SearchProperty property : criteria.getProperties()) {
            this.propertyHandlers.add(SearchPropertyHandler.getHandler(this, property));
        }
    }

    public void addToSearchBuilder(BeanReaderRepoSearchBuilder searchBuilder) {
        new FinderSearchBuilder(BeanTreePath.create(this.getInvocationContext().getPageRepo().getBeanRepo(), new Path()), searchBuilder).addToSearchBuilder();
    }

    public List<SearchBeanResults> getResults(BeanReaderRepoSearchResults searchResults) {
        ArrayList<SearchBeanResults> unsortedResults = new ArrayList<SearchBeanResults>();
        new FinderResults(BeanTreePath.create(this.getInvocationContext().getPageRepo().getBeanRepo(), new Path()), searchResults, unsortedResults).findResults();
        TreeMap<String, SearchBeanResults> sorter = new TreeMap<String, SearchBeanResults>();
        for (SearchBeanResults beanResults : unsortedResults) {
            sorter.put(beanResults.getBeanTreePath().getPath().getDotSeparatedPath(), beanResults);
        }
        return List.copyOf(sorter.values());
    }

    SearchCriteria getCriteria() {
        return this.criteria;
    }

    SearchBeanPropertyResults findProperty(PagePropertyDef propertyDef, BeanSearchResults beanResults) {
        if (propertyDef == null) {
            return null;
        }
        Response<Value> response = this.getPropertyValue(propertyDef, beanResults, beanResults.getSearchResults(), false);
        if (!response.isSuccess()) {
            return null;
        }
        Value value = response.getResults();
        if (value == null) {
            return null;
        }
        return new SearchBeanPropertyResults(propertyDef, value);
    }

    void addPropertyDefMatchingPropertyName(BeanTreePath beanTreePath, List<PagePropertyDef> propertyDefs, String want) {
        if (StringUtils.isEmpty((String)want)) {
            return;
        }
        for (BeanTypeDef typeDef : this.getTypeDefs(beanTreePath)) {
            PagePropertyDef propertyDef = this.getPagePropertyDefs(typeDef).get(want);
            if (propertyDef == null) continue;
            propertyDefs.add(propertyDef);
            return;
        }
    }

    void addPropertyDefsMatchingPropertyNameContains(BeanTreePath beanTreePath, List<PagePropertyDef> propertyDefs, String want) {
        if (StringUtils.isEmpty((String)want)) {
            return;
        }
        for (BeanTypeDef typeDef : this.getTypeDefs(beanTreePath)) {
            for (PagePropertyDef propertyDef : this.getPagePropertyDefs(typeDef).values()) {
                if (!this.contains(propertyDef.getPropertyName(), want)) continue;
                propertyDefs.add(propertyDef);
            }
        }
    }

    void addPropertyDefsMatchingPropertyLabelContains(BeanTreePath beanTreePath, List<PagePropertyDef> propertyDefs, String want) {
        if (StringUtils.isEmpty((String)want)) {
            return;
        }
        for (BeanTypeDef typeDef : this.getTypeDefs(beanTreePath)) {
            for (PagePropertyDef propertyDef : this.getPagePropertyDefs(typeDef).values()) {
                String localizedPropertyLabel = this.getInvocationContext().getLocalizer().localizeString(propertyDef.getLabel(), new Object[0]);
                if (!this.contains(localizedPropertyLabel, want)) continue;
                propertyDefs.add(propertyDef);
            }
        }
    }

    private Map<String, PagePropertyDef> getPagePropertyDefs(BeanTypeDef typeDef) {
        return SearchUtils.getPagePropertyDefs(this.getPageRepoDef(), typeDef);
    }

    void addPropertyDefsMatchingPropertyType(BeanTreePath beanTreePath, List<PagePropertyDef> propertyDefs, SearchBeanFilter.PropertyType want) {
        if (want == null) {
            return;
        }
        for (BeanTypeDef typeDef : this.getTypeDefs(beanTreePath)) {
            for (PagePropertyDef propertyDef : this.getPagePropertyDefs(typeDef).values()) {
                if (!this.propertyDefIsPropertyType(propertyDef, want)) continue;
                propertyDefs.add(propertyDef);
            }
        }
    }

    private boolean propertyDefIsPropertyType(PagePropertyDef propertyDef, SearchBeanFilter.PropertyType want) {
        if (want == SearchBeanFilter.PropertyType.HEALTH_STATE) {
            return propertyDef.isHealthState();
        }
        if (want == SearchBeanFilter.PropertyType.REFERENCE) {
            return !propertyDef.isIdentity() && propertyDef.isReference();
        }
        throw new AssertionError((Object)("Unknown property type: " + String.valueOf((Object)want)));
    }

    private List<BeanTypeDef> getTypeDefs(BeanTreePath beanTreePath) {
        String typeName = beanTreePath.getTypeDef().getTypeName();
        List<BeanTypeDef> rtn = this.typeNameToTypeDefs.get(typeName);
        if (rtn == null) {
            rtn = SearchUtils.getTypeDefs(beanTreePath.getTypeDef());
            this.typeNameToTypeDefs.put(typeName, rtn);
        }
        return rtn;
    }

    boolean contains(String have, String want) {
        return this.normalize(have).contains(this.normalize(want));
    }

    private String normalize(String str) {
        return StringUtils.nonNull((String)str).toLowerCase().replaceAll("\\s", "");
    }

    private class FinderSearchBuilder {
        private String indent;
        private BeanReaderRepoSearchBuilder searchBuilder;
        private BeanTreePath beanTreePath;
        private boolean addedThisOrChildToSearch = false;

        private FinderSearchBuilder(BeanTreePath beanTreePath, BeanReaderRepoSearchBuilder searchBuilder) {
            this.indent = "";
            this.beanTreePath = beanTreePath;
            this.searchBuilder = searchBuilder;
        }

        private FinderSearchBuilder(BeanTreePath beanTreePath, FinderSearchBuilder parent) {
            this.beanTreePath = beanTreePath;
            this.indent = parent.indent + "  ";
            this.searchBuilder = parent.searchBuilder;
        }

        private void addToSearchBuilder() {
            if (this.isRecursive()) {
                return;
            }
            if (this.matchesDesiredBeanType(this.beanTreePath)) {
                this.addedThisOrChildToSearch = true;
                this.addProperties();
            }
            this.addChildrenToSearch();
            if (this.addedThisOrChildToSearch && this.beanTreePath.getTypeDef().isHeterogeneous()) {
                SearchBeanFinder.this.addSubTypeDiscriminatorToSearch(this.beanTreePath, this.searchBuilder);
            }
        }

        private boolean matchesDesiredBeanType(BeanTreePath beanTreePath) {
            if (!beanTreePath.getTypeDef().isAllowSearch()) {
                return false;
            }
            boolean matchedAFilter = false;
            for (SearchBeanFilterHandler handler : SearchBeanFinder.this.filterHandlers) {
                if (handler.beanTypePassesFilter(beanTreePath)) {
                    matchedAFilter = true;
                    continue;
                }
                if (!handler.getFilter().isRequired()) continue;
                return false;
            }
            return matchedAFilter;
        }

        private boolean isRecursive() {
            int count = 0;
            List<BeanTreePathSegment> segments = this.beanTreePath.getSegments();
            String currentType = this.beanTreePath.getTypeDef().getTypeName();
            for (int i = 0; i < segments.size() - 1; ++i) {
                String segmentType = segments.get(i).getChildDef().getChildTypeDef().getTypeName();
                if (!segmentType.equals(currentType) || ++count <= 1) continue;
                return true;
            }
            return false;
        }

        private void addProperties() {
            BeanTypeDef thisTypeDef = this.beanTreePath.getTypeDef();
            this.addProperty(thisTypeDef.getIdentityPropertyDef());
            this.addProperty(thisTypeDef.getKeyPropertyDef());
            for (SearchBeanFilterHandler searchBeanFilterHandler : SearchBeanFinder.this.filterHandlers) {
                for (PagePropertyDef propertyDef : searchBeanFilterHandler.getPropertyDefs(this.beanTreePath)) {
                    this.addProperty(propertyDef);
                }
            }
            for (SearchPropertyHandler searchPropertyHandler : SearchBeanFinder.this.propertyHandlers) {
                for (PagePropertyDef propertyDef : searchPropertyHandler.getPropertyDefs(this.beanTreePath)) {
                    this.addProperty(propertyDef);
                }
            }
        }

        private void addProperty(BeanPropertyDef propertyDef) {
            if (propertyDef != null) {
                this.searchBuilder.addProperty(this.beanTreePath, propertyDef);
                SearchBeanFinder.this.addParamsToSearch(this.searchBuilder, this.beanTreePath, propertyDef.getGetValueCustomizerDef());
            }
        }

        private void addChildrenToSearch() {
            if (this.beanTreePath.getPath().isEmpty()) {
                this.addNavTreeNodesToSearch(SearchBeanFinder.this.getInvocationContext().getPageRepo().getPageRepoDef().getRootNavTreeDef());
            } else {
                for (BeanTypeDef typeDef : SearchBeanFinder.this.getTypeDefs(this.beanTreePath)) {
                    this.addNavTreeNodesToSearch(SearchBeanFinder.this.getInvocationContext().getPageRepo().getPageRepoDef().getNavTreeDef(typeDef));
                }
            }
        }

        private void addNavTreeNodesToSearch(NavTreeDef navTreeDef) {
            if (navTreeDef != null) {
                this.addNavTreeNodesToSearch(navTreeDef.getContentDefs());
            }
        }

        private void addNavTreeNodesToSearch(List<NavTreeNodeDef> nodeDefs) {
            for (NavTreeNodeDef nodeDef : nodeDefs) {
                this.addNavTreeNodeToSearch(nodeDef);
            }
        }

        private void addNavTreeNodeToSearch(NavTreeNodeDef nodeDef) {
            if (nodeDef.isGroupNodeDef()) {
                this.addNavTreeNodesToSearch(nodeDef.asGroupNodeDef().getContentDefs());
                return;
            }
            BeanChildNavTreeNodeDef childNodeDef = nodeDef.asChildNodeDef();
            FinderSearchBuilder childBuilder = new FinderSearchBuilder(this.beanTreePath.childPath(childNodeDef.getChildNodePath()), this);
            childBuilder.addToSearchBuilder();
            if (childBuilder.addedThisOrChildToSearch) {
                this.addedThisOrChildToSearch = true;
            }
        }
    }

    private class FinderResults {
        private String indent;
        private BeanTreePath beanTreePath;
        private BeanReaderRepoSearchResults searchResults;
        private BeanSearchResults beanResults;
        List<SearchBeanResults> results;

        private FinderResults(BeanTreePath beanTreePath, BeanReaderRepoSearchResults searchResults, List<SearchBeanResults> results) {
            this.indent = "";
            this.beanTreePath = beanTreePath;
            this.searchResults = searchResults;
            this.results = results;
        }

        private FinderResults(BeanTreePath beanTreePath, FinderResults parent) {
            this.beanTreePath = beanTreePath;
            this.indent = parent.indent + "  ";
            this.searchResults = parent.searchResults;
            this.beanResults = parent.beanResults;
            this.results = parent.results;
        }

        private void findResults() {
            if (this.beanTreePath.isCollection()) {
                List<BeanSearchResults> collectionResults = this.searchResults.getCollection(this.beanTreePath);
                if (collectionResults != null) {
                    for (BeanSearchResults br : collectionResults) {
                        this.findBeanResults(br);
                    }
                }
            } else {
                BeanSearchResults br = this.searchResults.getBean(this.beanTreePath);
                if (br != null) {
                    this.findBeanResults(br);
                }
            }
        }

        private void findBeanResults(BeanSearchResults br) {
            this.beanResults = br;
            this.findProperties();
            this.findChildrenResults();
        }

        private void findProperties() {
            boolean haveAnOptionalFilter = false;
            boolean passedAnOptionalFilter = false;
            HashMap<String, SearchBeanPropertyResults> propertyNameToPropertyResults = new HashMap<String, SearchBeanPropertyResults>();
            for (SearchBeanFilterHandler searchBeanFilterHandler : SearchBeanFinder.this.filterHandlers) {
                boolean required = searchBeanFilterHandler.getFilter().isRequired();
                boolean passes = searchBeanFilterHandler.beanPassesFilter(this.beanResults);
                if (!required) {
                    haveAnOptionalFilter = true;
                    if (passes) {
                        passedAnOptionalFilter = true;
                    }
                } else if (!passes) {
                    return;
                }
                this.collectPropertyResults(propertyNameToPropertyResults, searchBeanFilterHandler.getResults());
            }
            if (haveAnOptionalFilter && !passedAnOptionalFilter) {
                return;
            }
            for (SearchPropertyHandler searchPropertyHandler : SearchBeanFinder.this.propertyHandlers) {
                this.collectPropertyResults(propertyNameToPropertyResults, searchPropertyHandler.getResults(this.beanResults));
            }
            Response<BeanTypeDef> typeResponse = SearchBeanFinder.this.getActualTypeDef(this.beanResults.getBeanTreePath(), this.beanResults.getSearchResults());
            if (!typeResponse.isSuccess()) {
                return;
            }
            SearchBeanResults searchBeanResults = new SearchBeanResults(this.beanResults.getBeanTreePath(), typeResponse.getResults());
            searchBeanResults.getPropertiesResults().addAll(propertyNameToPropertyResults.values());
            this.results.add(searchBeanResults);
        }

        private void collectPropertyResults(Map<String, SearchBeanPropertyResults> propertyNameToPropertyResults, List<SearchBeanPropertyResults> propertiesResults) {
            for (SearchBeanPropertyResults propertyResults : propertiesResults) {
                String propertyName = propertyResults.getPropertyDef().getPropertyPath().toString();
                propertyNameToPropertyResults.put(propertyName, propertyResults);
            }
        }

        private void findChildrenResults() {
            if (this.beanTreePath.getPath().isEmpty()) {
                this.findNavTreeNodesResults(SearchBeanFinder.this.getInvocationContext().getPageRepo().getPageRepoDef().getRootNavTreeDef());
            } else {
                for (BeanTypeDef typeDef : SearchBeanFinder.this.getTypeDefs(this.beanTreePath)) {
                    this.findNavTreeNodesResults(SearchBeanFinder.this.getInvocationContext().getPageRepo().getPageRepoDef().getNavTreeDef(typeDef));
                }
            }
        }

        private void findNavTreeNodesResults(NavTreeDef navTreeDef) {
            if (navTreeDef != null) {
                this.findNavTreeNodesResults(navTreeDef.getContentDefs());
            }
        }

        private void findNavTreeNodesResults(List<NavTreeNodeDef> nodeDefs) {
            for (NavTreeNodeDef nodeDef : nodeDefs) {
                this.findNavTreeNodeResults(nodeDef);
            }
        }

        private void findNavTreeNodeResults(NavTreeNodeDef nodeDef) {
            if (nodeDef.isGroupNodeDef()) {
                this.findNavTreeNodesResults(nodeDef.asGroupNodeDef().getContentDefs());
                return;
            }
            BeanChildNavTreeNodeDef childNodeDef = nodeDef.asChildNodeDef();
            new FinderResults(this.beanResults.getBeanTreePath().childPath(childNodeDef.getChildNodePath()), this).findResults();
        }
    }
}

