/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.BeanChildDef;
import weblogic.remoteconsole.common.repodef.PagePropertyDef;
import weblogic.remoteconsole.server.repo.BeanSearchResults;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.BeanTreePathSegment;
import weblogic.remoteconsole.server.repo.NavTreePath;
import weblogic.remoteconsole.server.repo.NavTreePathSegment;
import weblogic.remoteconsole.server.repo.SearchBeanFilter;
import weblogic.remoteconsole.server.repo.SearchBeanFinder;
import weblogic.remoteconsole.server.repo.SearchBeanPropertyResults;
import weblogic.remoteconsole.server.repo.SearchPathSegmentFilter;
import weblogic.remoteconsole.server.repo.SearchValueFilterHandler;

public abstract class SearchBeanFilterHandler {
    private SearchBeanFinder finder;
    private SearchBeanFilter filter;
    private Map<String, List<PagePropertyDef>> typeNameToPropertyDefs = new HashMap<String, List<PagePropertyDef>>();
    private List<SearchBeanPropertyResults> results = new ArrayList<SearchBeanPropertyResults>();

    static SearchBeanFilterHandler getHandler(SearchBeanFinder finder, SearchBeanFilter filter) {
        if (filter.getBeanTreePath() != null) {
            return new BeanTreePathHandler(finder, filter);
        }
        if (filter.getNavTreePath() != null) {
            return new NavTreePathHandler(finder, filter);
        }
        if (filter.getBeanTypeDef() != null) {
            return new BeanTypeDefHandler(finder, filter);
        }
        if (StringUtils.notEmpty((String)filter.getBeanTypeContains())) {
            return new BeanTypeContainsHandler(finder, filter);
        }
        if (StringUtils.notEmpty((String)filter.getPathContains())) {
            return new PathContainsHandler(finder, filter);
        }
        if (StringUtils.notEmpty((String)filter.getKey())) {
            return new KeyHandler(finder, filter);
        }
        if (StringUtils.notEmpty((String)filter.getKeyContains())) {
            return new KeyContainsHandler(finder, filter);
        }
        if (StringUtils.notEmpty((String)filter.getPropertyName())) {
            return new PropertyNameHandler(finder, filter);
        }
        if (StringUtils.notEmpty((String)filter.getPropertyLabelContains())) {
            return new PropertyLabelContainsHandler(finder, filter);
        }
        if (filter.getPropertyType() != null) {
            return new PropertyTypeHandler(finder, filter);
        }
        throw new AssertionError((Object)("Unknown filter type: " + String.valueOf(filter)));
    }

    protected SearchBeanFilterHandler(SearchBeanFinder finder, SearchBeanFilter filter) {
        this.finder = finder;
        this.filter = filter;
    }

    protected SearchBeanFinder getFinder() {
        return this.finder;
    }

    protected SearchBeanFilter getFilter() {
        return this.filter;
    }

    List<PagePropertyDef> getPropertyDefs(BeanTreePath beanTreePath) {
        String typeName = beanTreePath.getTypeDef().getTypeName();
        List<PagePropertyDef> rtn = this.typeNameToPropertyDefs.get(typeName);
        if (rtn == null) {
            rtn = new ArrayList<PagePropertyDef>();
            this.findPropertyDefs(beanTreePath, rtn);
            this.typeNameToPropertyDefs.put(typeName, rtn);
        }
        return rtn;
    }

    protected void findPropertyDefs(BeanTreePath beanTreePath, List<PagePropertyDef> propertyDefs) {
    }

    List<SearchBeanPropertyResults> getResults() {
        return this.results;
    }

    boolean beanPassesFilter(BeanSearchResults beanResults) {
        this.results.clear();
        boolean matches = this.beanMatchesFilter(beanResults);
        SearchBeanFilter.IncludeInResults include = this.getFilter().getIncludeInResults();
        if (include == SearchBeanFilter.IncludeInResults.NEVER || include == SearchBeanFilter.IncludeInResults.IF_MATCHES && !matches) {
            this.results.clear();
        }
        return matches;
    }

    boolean beanTypePassesFilter(BeanTreePath beanTreePath) {
        return this.beanTypeMatchesFilter(beanTreePath);
    }

    protected abstract boolean beanTypeMatchesFilter(BeanTreePath var1);

    protected abstract boolean beanMatchesFilter(BeanSearchResults var1);

    private static class BeanTreePathHandler
    extends SearchBeanFilterHandler {
        private BeanTreePathHandler(SearchBeanFinder finder, SearchBeanFilter filter) {
            super(finder, filter);
        }

        @Override
        protected boolean beanTypeMatchesFilter(BeanTreePath beanTreePath) {
            boolean haveKeys = false;
            return this.beanTreePathMatchesFilter(beanTreePath, haveKeys) == this.getFilter().isMatches();
        }

        @Override
        protected boolean beanMatchesFilter(BeanSearchResults beanResults) {
            boolean haveKeys = true;
            return this.beanTreePathMatchesFilter(beanResults.getBeanTreePath(), haveKeys) == this.getFilter().isMatches();
        }

        boolean beanTreePathMatchesFilter(BeanTreePath beanTreePath, boolean haveKeys) {
            if (beanTreePath.isRoot()) {
                return false;
            }
            List<SearchPathSegmentFilter> segmentFilters = this.getSegmentFilters();
            int filterCount = segmentFilters.size();
            int filterIndex = 0;
            for (BeanTreePathSegment segment : beanTreePath.getSegments()) {
                BeanChildDef childDef = segment.getChildDef();
                if (filterIndex >= filterCount) {
                    return false;
                }
                if (!this.segmentMatches(segmentFilters.get(filterIndex), this.getSegmentValue(segment))) {
                    return false;
                }
                ++filterIndex;
                if (!childDef.isCollection()) continue;
                if (filterIndex >= filterCount) {
                    return false;
                }
                if (segment.isKeySet() && haveKeys && !this.segmentMatches(segmentFilters.get(filterIndex), segment.getKey())) {
                    return false;
                }
                ++filterIndex;
            }
            return filterIndex >= filterCount;
        }

        private boolean segmentMatches(SearchPathSegmentFilter segmentFilter, String segmentHave) {
            if (segmentFilter.isAnyValue()) {
                return true;
            }
            String equals = segmentFilter.getEquals();
            if (StringUtils.notEmpty((String)equals)) {
                return equals.equals(segmentHave);
            }
            String contains = segmentFilter.getContains();
            if (StringUtils.notEmpty((String)contains)) {
                return this.getFinder().contains(segmentHave, contains);
            }
            throw new AssertionError((Object)("Unsupported path segment filter: " + String.valueOf(segmentFilter)));
        }

        private String getSegmentValue(BeanTreePathSegment segment) {
            return segment.getChildDef().getChildPath().getDotSeparatedPath();
        }

        private List<SearchPathSegmentFilter> getSegmentFilters() {
            return this.getFilter().getBeanTreePath();
        }
    }

    private static class NavTreePathHandler
    extends SearchBeanFilterHandler {
        private NavTreePathHandler(SearchBeanFinder finder, SearchBeanFilter filter) {
            super(finder, filter);
        }

        @Override
        protected boolean beanTypeMatchesFilter(BeanTreePath beanTreePath) {
            boolean haveKeys = false;
            return this.beanTreePathMatchesFilter(beanTreePath, haveKeys) == this.getFilter().isMatches();
        }

        @Override
        protected boolean beanMatchesFilter(BeanSearchResults beanResults) {
            boolean haveKeys = true;
            return this.beanTreePathMatchesFilter(beanResults.getBeanTreePath(), haveKeys) == this.getFilter().isMatches();
        }

        boolean beanTreePathMatchesFilter(BeanTreePath beanTreePath, boolean haveKeys) {
            if (beanTreePath.isRoot()) {
                return false;
            }
            List<SearchPathSegmentFilter> segmentFilters = this.getSegmentFilters();
            int filterCount = segmentFilters.size();
            int filterIndex = 0;
            NavTreePath navTreePath = this.getNavTreePath(beanTreePath);
            for (NavTreePathSegment segment : navTreePath.getSegments()) {
                if (filterIndex >= filterCount) {
                    return false;
                }
                if (!this.segmentMatches(segmentFilters.get(filterIndex), this.getSegmentValue(segment))) {
                    return false;
                }
                ++filterIndex;
                if (!segment.getNavTreeNodeDef().isChildNodeDef()) continue;
                BeanTreePath segmentBTP = segment.getBeanTreePath();
                if (haveKeys) {
                    if (!segmentBTP.isCollectionChild()) continue;
                    if (filterIndex >= filterCount) {
                        return false;
                    }
                    if (!this.segmentMatches(segmentFilters.get(filterIndex), segmentBTP.getLastSegment().getKey())) {
                        return false;
                    }
                    ++filterIndex;
                    continue;
                }
                if (!segmentBTP.isCollection()) continue;
                if (filterIndex >= filterCount) {
                    return false;
                }
                ++filterIndex;
            }
            return filterIndex >= filterCount;
        }

        private boolean segmentMatches(SearchPathSegmentFilter segmentFilter, String segmentHave) {
            if (segmentFilter.isAnyValue()) {
                return true;
            }
            String equals = segmentFilter.getEquals();
            if (StringUtils.notEmpty((String)equals)) {
                return equals.equals(segmentHave);
            }
            String contains = segmentFilter.getContains();
            if (StringUtils.notEmpty((String)contains)) {
                return this.getFinder().contains(segmentHave, contains);
            }
            throw new AssertionError((Object)("Unsupported nav tree path segment filter: " + String.valueOf(segmentFilter)));
        }

        private String getSegmentValue(NavTreePathSegment segment) {
            return this.getFinder().getInvocationContext().getLocalizer().localizeString(segment.getNavTreeNodeDef().getLabel(), new Object[0]);
        }

        private NavTreePath getNavTreePath(BeanTreePath beanTreePath) {
            return new NavTreePath(this.getFinder().getInvocationContext().getPageRepo(), beanTreePath);
        }

        private List<SearchPathSegmentFilter> getSegmentFilters() {
            return this.getFilter().getNavTreePath();
        }
    }

    private static class BeanTypeDefHandler
    extends SearchBeanFilterHandler {
        private BeanTypeDefHandler(SearchBeanFinder finder, SearchBeanFilter filter) {
            super(finder, filter);
        }

        @Override
        protected boolean beanTypeMatchesFilter(BeanTreePath beanTreePath) {
            boolean matches = beanTreePath.getTypeDef().isTypeDef(this.getFilter().getBeanTypeDef());
            return matches == this.getFilter().isMatches();
        }

        @Override
        protected boolean beanMatchesFilter(BeanSearchResults beanResults) {
            return this.beanTypeMatchesFilter(beanResults.getBeanTreePath());
        }
    }

    private static class BeanTypeContainsHandler
    extends SearchBeanFilterHandler {
        private BeanTypeContainsHandler(SearchBeanFinder finder, SearchBeanFilter filter) {
            super(finder, filter);
        }

        @Override
        protected boolean beanTypeMatchesFilter(BeanTreePath beanTreePath) {
            String typeLabel = this.getFinder().getInvocationContext().getLocalizer().localizeString(beanTreePath.getTypeDef().getInstanceNameLabel(), new Object[0]);
            boolean matches = this.getFinder().contains(typeLabel, this.getFilter().getBeanTypeContains());
            return matches == this.getFilter().isMatches();
        }

        @Override
        protected boolean beanMatchesFilter(BeanSearchResults beanResults) {
            return this.beanTypeMatchesFilter(beanResults.getBeanTreePath());
        }
    }

    private static class PathContainsHandler
    extends SearchBeanFilterHandler {
        private PathContainsHandler(SearchBeanFinder finder, SearchBeanFilter filter) {
            super(finder, filter);
        }

        @Override
        protected boolean beanTypeMatchesFilter(BeanTreePath beanTreePath) {
            if (beanTreePath.isCollection()) {
                return true;
            }
            if (beanTreePath.isCollectionChild()) {
                throw new AssertionError((Object)("beanTreePath must not be a collection child:" + String.valueOf(beanTreePath)));
            }
            return this.lastNavTreePathSegmentLabelMatchesFilter(beanTreePath) == this.getFilter().isMatches();
        }

        @Override
        protected boolean beanMatchesFilter(BeanSearchResults beanResults) {
            boolean matches = false;
            BeanTreePath beanTreePath = beanResults.getBeanTreePath();
            if (beanTreePath.isCollectionChild() && this.getFinder().contains(beanTreePath.getLastSegment().getKey(), this.getFilter().getPathContains())) {
                matches = true;
            }
            if (!matches) {
                matches = this.lastNavTreePathSegmentLabelMatchesFilter(beanTreePath);
            }
            return matches == this.getFilter().isMatches();
        }

        private boolean lastNavTreePathSegmentLabelMatchesFilter(BeanTreePath beanTreePath) {
            boolean matches = false;
            NavTreePathSegment lastSegment = new NavTreePath(this.getFinder().getPageRepo(), beanTreePath).getLastSegment();
            if (lastSegment != null) {
                String lastSegmentLabel = this.getFinder().getInvocationContext().getLocalizer().localizeString(lastSegment.getNavTreeNodeDef().getLabel(), new Object[0]);
                matches = this.getFinder().contains(lastSegmentLabel, this.getFilter().getPathContains());
            }
            return matches;
        }
    }

    private static class KeyHandler
    extends SearchBeanFilterHandler {
        private KeyHandler(SearchBeanFinder finder, SearchBeanFilter filter) {
            super(finder, filter);
        }

        @Override
        protected boolean beanTypeMatchesFilter(BeanTreePath beanTreePath) {
            return beanTreePath.isCollection();
        }

        @Override
        protected boolean beanMatchesFilter(BeanSearchResults beanResults) {
            BeanTreePath beanTreePath = beanResults.getBeanTreePath();
            if (!beanTreePath.isCollectionChild()) {
                return false;
            }
            String keyHave = beanTreePath.getLastSegment().getKey();
            boolean matches = this.getFilter().getKey().equals(keyHave);
            return matches == this.getFilter().isMatches();
        }
    }

    private static class KeyContainsHandler
    extends SearchBeanFilterHandler {
        private KeyContainsHandler(SearchBeanFinder finder, SearchBeanFilter filter) {
            super(finder, filter);
        }

        @Override
        protected boolean beanTypeMatchesFilter(BeanTreePath beanTreePath) {
            return beanTreePath.isCollection();
        }

        @Override
        protected boolean beanMatchesFilter(BeanSearchResults beanResults) {
            BeanTreePath beanTreePath = beanResults.getBeanTreePath();
            if (!beanTreePath.isCollectionChild()) {
                return false;
            }
            String keyHave = beanTreePath.getLastSegment().getKey();
            boolean matches = this.getFinder().contains(keyHave, this.getFilter().getKeyContains());
            return matches == this.getFilter().isMatches();
        }
    }

    private static class PropertyNameHandler
    extends PropertyHandler {
        private PropertyNameHandler(SearchBeanFinder finder, SearchBeanFilter filter) {
            super(finder, filter);
        }

        @Override
        protected void findPropertyDefs(BeanTreePath beanTreePath, List<PagePropertyDef> propertyDefs) {
            this.getFinder().addPropertyDefMatchingPropertyName(beanTreePath, propertyDefs, this.getFilter().getPropertyName());
        }
    }

    private static class PropertyLabelContainsHandler
    extends PropertyHandler {
        private PropertyLabelContainsHandler(SearchBeanFinder finder, SearchBeanFilter filter) {
            super(finder, filter);
        }

        @Override
        protected void findPropertyDefs(BeanTreePath beanTreePath, List<PagePropertyDef> propertyDefs) {
            this.getFinder().addPropertyDefsMatchingPropertyLabelContains(beanTreePath, propertyDefs, this.getFilter().getPropertyLabelContains());
        }
    }

    private static class PropertyTypeHandler
    extends PropertyHandler {
        private PropertyTypeHandler(SearchBeanFinder finder, SearchBeanFilter filter) {
            super(finder, filter);
        }

        @Override
        protected void findPropertyDefs(BeanTreePath beanTreePath, List<PagePropertyDef> propertyDefs) {
            this.getFinder().addPropertyDefsMatchingPropertyType(beanTreePath, propertyDefs, this.getFilter().getPropertyType());
        }
    }

    private static abstract class PropertyHandler
    extends SearchBeanFilterHandler {
        private SearchValueFilterHandler valueHandler;

        private PropertyHandler(SearchBeanFinder finder, SearchBeanFilter filter) {
            super(finder, filter);
            this.valueHandler = SearchValueFilterHandler.getHandler(finder, filter);
        }

        @Override
        protected boolean beanTypeMatchesFilter(BeanTreePath beanTreePath) {
            return !this.getPropertyDefs(beanTreePath).isEmpty();
        }

        @Override
        protected boolean beanMatchesFilter(BeanSearchResults beanResults) {
            this.getResults().clear();
            SearchBeanFilter.IncludeInResults include = this.getFilter().getIncludeInResults();
            List<PagePropertyDef> propertyDefs = this.getPropertyDefs(beanResults.getBeanTreePath());
            if (propertyDefs.isEmpty()) {
                return false;
            }
            boolean matches = false;
            for (PagePropertyDef propertyDef : propertyDefs) {
                SearchBeanPropertyResults propertyResults = this.getFinder().findProperty(propertyDef, beanResults);
                if (propertyResults == null) continue;
                boolean valueMatches = this.valueMatchesFilter(propertyResults);
                if (include == SearchBeanFilter.IncludeInResults.ALWAYS || valueMatches && include == SearchBeanFilter.IncludeInResults.IF_MATCHES) {
                    this.getResults().add(propertyResults);
                }
                if (!valueMatches) continue;
                matches = true;
            }
            return matches;
        }

        private boolean valueMatchesFilter(SearchBeanPropertyResults propertyResults) {
            if (this.valueHandler != null) {
                return this.valueHandler.valuePassesFilter(propertyResults) == this.getFilter().isMatches();
            }
            return true;
        }
    }
}

