/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import java.util.ArrayList;
import java.util.List;
import weblogic.remoteconsole.common.utils.Message;
import weblogic.remoteconsole.server.repo.ResponseException;

public class Response<T> {
    private List<Message> messages = new ArrayList<Message>();
    private Status status = Status.SUCCESS;
    private T results;

    public List<Message> getMessages() {
        return this.messages;
    }

    public Response<T> addFailureMessage(String message) {
        return this.addMessage(Message.newFailureMessage(message));
    }

    public Response<T> addSuccessMessage(String message) {
        return this.addMessage(Message.newSuccessMessage(message));
    }

    public Response<T> addWarningMessage(String message) {
        return this.addMessage(Message.newWarningMessage(message));
    }

    public Response<T> addMessage(Message message) {
        this.getMessages().add(message);
        return this;
    }

    public Status getStatus() {
        return this.status;
    }

    private void setStatus(Status status) {
        this.setStatus(status, null);
    }

    private void setStatus(Status status, T results) {
        this.status = status;
        this.results = results;
    }

    public boolean isSuccess() {
        return Status.SUCCESS == this.getStatus();
    }

    public Response<T> setSuccess(T results) {
        this.setStatus(Status.SUCCESS, results);
        this.results = results;
        return this;
    }

    public boolean isNotFound() {
        return Status.NOT_FOUND == this.getStatus();
    }

    public static ResponseException notFoundException() {
        return new Response().setNotFound().asResponseException();
    }

    public Response<T> setNotFound() {
        this.setStatus(Status.NOT_FOUND);
        return this;
    }

    public boolean isServiceNotAvailable() {
        return Status.SERVICE_NOT_AVAILABLE == this.getStatus();
    }

    public static ResponseException serviceNotAvailable() {
        return new Response().setServiceNotAvailable().asResponseException();
    }

    public Response<T> setServiceNotAvailable() {
        this.setStatus(Status.SERVICE_NOT_AVAILABLE);
        return this;
    }

    public boolean isTimeout() {
        return Status.TIMEOUT == this.getStatus();
    }

    public Response<T> setTimeout() {
        this.setStatus(Status.TIMEOUT);
        return this;
    }

    public boolean isUserBadRequest() {
        return Status.USER_BAD_REQUEST == this.getStatus();
    }

    public static ResponseException userBadRequestException() {
        return new Response().setUserBadRequest().asResponseException();
    }

    public Response<T> setUserBadRequest() {
        this.setStatus(Status.USER_BAD_REQUEST);
        return this;
    }

    public boolean isFrontEndBadRequest() {
        return Status.FRONT_END_BAD_REQUEST == this.getStatus();
    }

    public static ResponseException frontEndBadRequestException() {
        return new Response().setFrontEndBadRequest().asResponseException();
    }

    public Response<T> setFrontEndBadRequest() {
        this.setStatus(Status.FRONT_END_BAD_REQUEST);
        return this;
    }

    public Response<T> copyStatus(Response<?> other) {
        this.setStatus(other.getStatus());
        return this;
    }

    public Response<T> copyUnsuccessfulResponse(Response<?> other) {
        return this.copyUnsuccessfulResponse(other, false);
    }

    public Response<T> copyUnsuccessfulResponse(Response<?> other, boolean retainEarlierMessages) {
        if (other.isSuccess()) {
            throw new AssertionError((Object)"Other response is successful");
        }
        this.results = null;
        this.copyStatus(other);
        if (!retainEarlierMessages) {
            this.getMessages().clear();
        }
        return this.copyMessages(other);
    }

    public Response<T> copyMessages(Response<?> other) {
        List<Message> otherMessages = other.getMessages();
        for (Message message : otherMessages) {
            this.addMessage(message);
        }
        return this;
    }

    public T getResults() {
        if (!this.isSuccess()) {
            throw this.asResponseException();
        }
        return this.results;
    }

    public ResponseException asResponseException() {
        return new ResponseException(this);
    }

    public static enum Status {
        SUCCESS,
        NOT_FOUND,
        SERVICE_NOT_AVAILABLE,
        TIMEOUT,
        USER_BAD_REQUEST,
        FRONT_END_BAD_REQUEST;

    }
}

