/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import java.util.ArrayList;
import java.util.List;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.NullReference;
import weblogic.remoteconsole.server.repo.Value;

public class ReferenceAsReferencesValue
extends Value {
    private List<Value> values;

    public ReferenceAsReferencesValue(List<Value> values) {
        if (values == null || values.size() > 1) {
            throw new AssertionError((Object)"References list must be empty or contain a single Reference!");
        }
        this.values = values;
    }

    public ReferenceAsReferencesValue(Value value) {
        this.values = new ArrayList<Value>();
        if (value != null && !value.isNullReference()) {
            this.values.add(value);
        }
    }

    public Value asReference() {
        Value result = NullReference.INSTANCE;
        if (this.values != null && this.values.size() > 0) {
            result = this.values.get(0);
        }
        return result;
    }

    public List<Value> asReferences() {
        return this.values;
    }

    @Override
    public boolean isNullReference() {
        boolean result = false;
        Value value = this.asReference();
        if (value != null && value.isNullReference()) {
            result = true;
        }
        return result;
    }

    @Override
    public BeanTreePath asBeanTreePath() {
        BeanTreePath result = null;
        Value value = this.asReference();
        if (value != null && value.isBeanTreePath()) {
            result = value.asBeanTreePath();
        }
        return result;
    }

    public String toString() {
        return "ReferenceAsReferencesValue<" + String.valueOf(this.asReferences()) + ">";
    }
}

