/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.PagePropertyDef;
import weblogic.remoteconsole.common.utils.DateUtils;
import weblogic.remoteconsole.server.repo.BeanRepo;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.BooleanValue;
import weblogic.remoteconsole.server.repo.BuiltinFilteringDashboard;
import weblogic.remoteconsole.server.repo.CustomFilteringDashboard;
import weblogic.remoteconsole.server.repo.Dashboard;
import weblogic.remoteconsole.server.repo.Dashboards;
import weblogic.remoteconsole.server.repo.DateAsLongValue;
import weblogic.remoteconsole.server.repo.DateValue;
import weblogic.remoteconsole.server.repo.DoubleValue;
import weblogic.remoteconsole.server.repo.FilteringDashboard;
import weblogic.remoteconsole.server.repo.FilteringDashboardConfig;
import weblogic.remoteconsole.server.repo.FilteringDashboardConfigManager;
import weblogic.remoteconsole.server.repo.FilteringDashboardPathSegment;
import weblogic.remoteconsole.server.repo.FilteringDashboardPathSegmentDef;
import weblogic.remoteconsole.server.repo.FilteringDashboardProperty;
import weblogic.remoteconsole.server.repo.FilteringDashboardPropertyDef;
import weblogic.remoteconsole.server.repo.IntValue;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.LongValue;
import weblogic.remoteconsole.server.repo.PersistedBeanKeyFilter;
import weblogic.remoteconsole.server.repo.PersistedDashboard;
import weblogic.remoteconsole.server.repo.PersistedDashboards;
import weblogic.remoteconsole.server.repo.PersistedFilteringDashboard;
import weblogic.remoteconsole.server.repo.PersistedPropertyFilter;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.StringValue;

class PersistedDashboardsToDashboards {
    private PersistedDashboardsToDashboards() {
    }

    public static Dashboards fromPersistedData(InvocationContext ic, Dashboards oldDashboards, PersistedDashboards persistedBuiltinDashboards, PersistedDashboards persistedCustomDashboards) {
        Dashboards newDashboards = new Dashboards();
        PersistedDashboardsToDashboards.addDashboards(ic, oldDashboards, newDashboards, persistedBuiltinDashboards, true);
        PersistedDashboardsToDashboards.addDashboards(ic, oldDashboards, newDashboards, persistedCustomDashboards, false);
        return newDashboards;
    }

    private static void addDashboards(InvocationContext ic, Dashboards oldDashboards, Dashboards newDashboards, PersistedDashboards persistedDashboards, boolean builtin) {
        if (persistedDashboards != null) {
            for (Map.Entry<String, PersistedDashboard> entry : persistedDashboards.getDashboards().entrySet()) {
                FilteringDashboard newDashboard;
                String dashboardName = entry.getKey();
                PersistedDashboard persistedDashboard = entry.getValue();
                boolean unsupported = true;
                if (!newDashboards.getDashboards().containsKey(dashboardName) && persistedDashboard.isFilteringDashboard() && (newDashboard = PersistedDashboardsToDashboards.filteringDashboardFromPersistedData(ic, builtin, dashboardName, persistedDashboard.asFilteringDashboard())) != null) {
                    FilteringDashboard oldDashboard;
                    Dashboard oldDash = oldDashboards.getDashboards().get(dashboardName);
                    FilteringDashboard filteringDashboard = oldDashboard = oldDash != null ? oldDash.asFilteringDashboard() : null;
                    if (PersistedDashboardsToDashboards.reuseCachedResults(oldDashboard, newDashboard)) {
                        newDashboard = newDashboard.clone(oldDashboard.getResults(), oldDashboard.getResultsDate(), oldDashboard.getExpirationDate());
                    }
                    newDashboards.getDashboards().put(dashboardName, newDashboard);
                    unsupported = false;
                }
                if (!unsupported) continue;
                newDashboards.getUnsupportedDashboards().put(dashboardName, persistedDashboard);
            }
        }
    }

    private static FilteringDashboard filteringDashboardFromPersistedData(InvocationContext ic, boolean builtin, String dashboardName, PersistedFilteringDashboard persistedDashboard) {
        BeanTreePath btpTemplate = PersistedDashboardsToDashboards.getBeanTreePathTemplate(ic, persistedDashboard);
        if (btpTemplate == null) {
            return null;
        }
        Response<FilteringDashboardConfig> configResponse = FilteringDashboardConfigManager.createDefaultConfig(ic, btpTemplate, dashboardName, persistedDashboard.getDescription(), persistedDashboard.getDefaultColumns());
        if (!configResponse.isSuccess()) {
            return null;
        }
        FilteringDashboardConfig defaultConfig = configResponse.getResults();
        FilteringDashboardConfig config = new FilteringDashboardConfig(defaultConfig.getDashboardDef(), defaultConfig.getName(), defaultConfig.getDescription(), defaultConfig.getDefaultColumns(), PersistedDashboardsToDashboards.computePath(defaultConfig, persistedDashboard), PersistedDashboardsToDashboards.computeProperties(defaultConfig, persistedDashboard), PersistedDashboardsToDashboards.computeUnsupportedPropertyFilters(defaultConfig, persistedDashboard));
        return builtin ? new BuiltinFilteringDashboard(config) : new CustomFilteringDashboard(config);
    }

    private static List<FilteringDashboardPathSegment> computePath(FilteringDashboardConfig defaultConfig, PersistedFilteringDashboard persistedDashboard) {
        ArrayList<FilteringDashboardPathSegment> path = new ArrayList<FilteringDashboardPathSegment>();
        for (FilteringDashboardPathSegment defaultSegment : defaultConfig.getPath()) {
            path.add(PersistedDashboardsToDashboards.computeSegment(defaultSegment, persistedDashboard));
        }
        return path;
    }

    private static FilteringDashboardPathSegment computeSegment(FilteringDashboardPathSegment defaultSegment, PersistedFilteringDashboard persistedDashboard) {
        String beanKey = defaultSegment.getSegmentDef().getSegmentTemplate().getChildDef().getChildTypeDef().getInstanceName();
        PersistedBeanKeyFilter filter = persistedDashboard.getBeanFilters().get(beanKey);
        if (filter == null) {
            return defaultSegment;
        }
        FilteringDashboardPathSegmentDef segmentDef = defaultSegment.getSegmentDef();
        String criteria = null;
        String value = filter.getEquals();
        if (value != null) {
            criteria = "equals";
        }
        if (criteria == null && (value = filter.getContains()) != null) {
            criteria = "contains";
        }
        if (criteria == null) {
            throw new AssertionError((Object)(beanKey + " must specify == or contains"));
        }
        return new FilteringDashboardPathSegment(segmentDef, criteria, value);
    }

    public static List<FilteringDashboardProperty> computeProperties(FilteringDashboardConfig defaultConfig, PersistedFilteringDashboard persistedDashboard) {
        ArrayList<FilteringDashboardProperty> properties = new ArrayList<FilteringDashboardProperty>();
        for (FilteringDashboardProperty defaultProperty : defaultConfig.getProperties()) {
            properties.add(PersistedDashboardsToDashboards.computeProperty(defaultProperty, persistedDashboard));
        }
        return properties;
    }

    private static FilteringDashboardProperty computeProperty(FilteringDashboardProperty defaultProperty, PersistedFilteringDashboard persistedDashboard) {
        FilteringDashboardPropertyDef propertyDef = defaultProperty.getPropertyDef();
        PersistedPropertyFilter filter = persistedDashboard.getPropertyFilters().get(PersistedDashboardsToDashboards.getPropertyPath(propertyDef));
        if (filter == null) {
            return defaultProperty;
        }
        PagePropertyDef sourceDef = propertyDef.getSourcePropertyDef();
        if (sourceDef.isString() || sourceDef.isHealthState()) {
            boolean isEnum = !sourceDef.getLegalValueDefs().isEmpty();
            return PersistedDashboardsToDashboards.computeStringProperty(isEnum, propertyDef, filter);
        }
        if (sourceDef.isInt()) {
            return PersistedDashboardsToDashboards.computeIntProperty(propertyDef, filter);
        }
        if (sourceDef.isLong()) {
            return PersistedDashboardsToDashboards.computeLongProperty(propertyDef, filter);
        }
        if (sourceDef.isDouble()) {
            return PersistedDashboardsToDashboards.computeDoubleProperty(propertyDef, filter);
        }
        if (sourceDef.isBoolean()) {
            return PersistedDashboardsToDashboards.computeBooleanProperty(propertyDef, filter);
        }
        if (sourceDef.isDate()) {
            return PersistedDashboardsToDashboards.computeDateProperty(propertyDef, filter);
        }
        if (sourceDef.isDateAsLong()) {
            return PersistedDashboardsToDashboards.computeDateAsLongProperty(propertyDef, filter);
        }
        return PersistedDashboardsToDashboards.computeGenericProperty(propertyDef, filter);
    }

    private static FilteringDashboardProperty computeStringProperty(boolean isEnum, FilteringDashboardPropertyDef propertyDef, PersistedPropertyFilter filter) {
        String criteria = null;
        Object value = filter.getEquals();
        if (value != null) {
            criteria = "equals";
        }
        if (criteria == null && (value = filter.getNotEquals()) != null) {
            criteria = "notEquals";
        }
        if (isEnum) {
            if (criteria == null) {
                throw new AssertionError((Object)(PersistedDashboardsToDashboards.getPropertyPath(propertyDef) + " must specify == or !="));
            }
        } else {
            if (criteria == null && (value = filter.getContains()) != null) {
                criteria = "contains";
            }
            if (criteria == null) {
                throw new AssertionError((Object)(PersistedDashboardsToDashboards.getPropertyPath(propertyDef) + " must specify ==, != or contains"));
            }
        }
        return new FilteringDashboardProperty(propertyDef, criteria, new StringValue(value.toString()));
    }

    private static FilteringDashboardProperty computeIntProperty(FilteringDashboardPropertyDef propertyDef, PersistedPropertyFilter filter) {
        boolean isEnum = !propertyDef.getSourcePropertyDef().getLegalValueDefs().isEmpty();
        String criteria = PersistedDashboardsToDashboards.getNumberPropertyCriteria(isEnum, propertyDef, filter);
        Object value = PersistedDashboardsToDashboards.getNumberPropertyValue(propertyDef, filter);
        try {
            return new FilteringDashboardProperty(propertyDef, criteria, new IntValue(Integer.parseInt(value.toString())));
        }
        catch (NumberFormatException e) {
            throw new AssertionError((Object)(PersistedDashboardsToDashboards.getPropertyPath(propertyDef) + " must be an int: " + String.valueOf(value)));
        }
    }

    private static FilteringDashboardProperty computeLongProperty(FilteringDashboardPropertyDef propertyDef, PersistedPropertyFilter filter) {
        String criteria = PersistedDashboardsToDashboards.getNumberPropertyCriteria(propertyDef, filter);
        Object value = PersistedDashboardsToDashboards.getNumberPropertyValue(propertyDef, filter);
        try {
            return new FilteringDashboardProperty(propertyDef, criteria, new LongValue(Long.parseLong(value.toString())));
        }
        catch (NumberFormatException e) {
            throw new AssertionError((Object)(PersistedDashboardsToDashboards.getPropertyPath(propertyDef) + " must be a long: " + String.valueOf(value)));
        }
    }

    private static FilteringDashboardProperty computeDoubleProperty(FilteringDashboardPropertyDef propertyDef, PersistedPropertyFilter filter) {
        String criteria = PersistedDashboardsToDashboards.getNumberPropertyCriteria(propertyDef, filter);
        Object value = PersistedDashboardsToDashboards.getNumberPropertyValue(propertyDef, filter);
        try {
            return new FilteringDashboardProperty(propertyDef, criteria, new DoubleValue(Double.parseDouble(value.toString())));
        }
        catch (NumberFormatException e) {
            throw new AssertionError((Object)(PersistedDashboardsToDashboards.getPropertyPath(propertyDef) + " must be  double: " + String.valueOf(value)));
        }
    }

    private static FilteringDashboardProperty computeDateProperty(FilteringDashboardPropertyDef propertyDef, PersistedPropertyFilter filter) {
        String criteria = PersistedDashboardsToDashboards.getNumberPropertyCriteria(propertyDef, filter);
        Object value = PersistedDashboardsToDashboards.getNumberPropertyValue(propertyDef, filter);
        return new FilteringDashboardProperty(propertyDef, criteria, new DateValue(PersistedDashboardsToDashboards.getDateFromPersistedValue(propertyDef, value)));
    }

    private static FilteringDashboardProperty computeDateAsLongProperty(FilteringDashboardPropertyDef propertyDef, PersistedPropertyFilter filter) {
        String criteria = PersistedDashboardsToDashboards.getNumberPropertyCriteria(propertyDef, filter);
        Object value = PersistedDashboardsToDashboards.getNumberPropertyValue(propertyDef, filter);
        return new FilteringDashboardProperty(propertyDef, criteria, new DateAsLongValue(PersistedDashboardsToDashboards.getDateFromPersistedValue(propertyDef, value)));
    }

    private static Date getDateFromPersistedValue(FilteringDashboardPropertyDef propertyDef, Object value) {
        try {
            return DateUtils.parseDate((String)value);
        }
        catch (ParseException e) {
            long sampleTime = 1675691213448L;
            throw new AssertionError((Object)(PersistedDashboardsToDashboards.getPropertyPath(propertyDef) + " must be a date and time, e.g. " + DateUtils.formatDate(new Date(sampleTime)) + " : " + String.valueOf(value)));
        }
    }

    private static String getNumberPropertyCriteria(FilteringDashboardPropertyDef propertyDef, PersistedPropertyFilter filter) {
        return PersistedDashboardsToDashboards.getNumberPropertyCriteria(false, propertyDef, filter);
    }

    private static String getNumberPropertyCriteria(boolean isEnum, FilteringDashboardPropertyDef propertyDef, PersistedPropertyFilter filter) {
        if (filter.getEquals() != null) {
            return "equals";
        }
        if (filter.getNotEquals() != null) {
            return "notEquals";
        }
        if (isEnum) {
            throw new AssertionError((Object)(PersistedDashboardsToDashboards.getPropertyPath(propertyDef) + " must specify == or !="));
        }
        if (filter.getLessThan() != null) {
            return "lessThan";
        }
        if (filter.getLessThanOrEquals() != null) {
            return "lessThanOrEquals";
        }
        if (filter.getGreaterThan() != null) {
            return "greaterThan";
        }
        if (filter.getGreaterThanOrEquals() != null) {
            return "greaterThanOrEquals";
        }
        throw new AssertionError((Object)(PersistedDashboardsToDashboards.getPropertyPath(propertyDef) + " must specify ==, !=, <, <=, > or >="));
    }

    private static Object getNumberPropertyValue(FilteringDashboardPropertyDef propertyDef, PersistedPropertyFilter filter) {
        Object value = filter.getEquals();
        if (value == null) {
            value = filter.getNotEquals();
        }
        if (value == null) {
            value = filter.getLessThan();
        }
        if (value == null) {
            value = filter.getLessThanOrEquals();
        }
        if (value == null) {
            value = filter.getGreaterThan();
        }
        if (value == null) {
            value = filter.getGreaterThanOrEquals();
        }
        if (value == null) {
            throw new AssertionError((Object)(PersistedDashboardsToDashboards.getPropertyPath(propertyDef) + " must specify ==, !=, <, <=, > or >="));
        }
        return value;
    }

    private static FilteringDashboardProperty computeBooleanProperty(FilteringDashboardPropertyDef propertyDef, PersistedPropertyFilter filter) {
        Object value = filter.getEquals();
        if (value == null) {
            throw new AssertionError((Object)(PersistedDashboardsToDashboards.getPropertyPath(propertyDef) + " must specify =="));
        }
        String str = value.toString();
        BooleanValue boolVal = null;
        if ("true".equals(str)) {
            boolVal = new BooleanValue(true);
        } else if ("false".equals(str)) {
            boolVal = new BooleanValue(false);
        } else {
            throw new AssertionError((Object)(PersistedDashboardsToDashboards.getPropertyPath(propertyDef) + " must be true or false: " + String.valueOf(value)));
        }
        return new FilteringDashboardProperty(propertyDef, "equals", boolVal);
    }

    private static FilteringDashboardProperty computeGenericProperty(FilteringDashboardPropertyDef propertyDef, PersistedPropertyFilter filter) {
        String value = filter.getContains();
        if (value != null) {
            return new FilteringDashboardProperty(propertyDef, "contains", new StringValue(value));
        }
        throw new AssertionError((Object)(PersistedDashboardsToDashboards.getPropertyPath(propertyDef) + " must specify contains"));
    }

    private static String getPropertyPath(FilteringDashboardPropertyDef propertyDef) {
        return propertyDef.getSourcePropertyDef().getPropertyPath().getDotSeparatedPath();
    }

    public static Map<String, PersistedPropertyFilter> computeUnsupportedPropertyFilters(FilteringDashboardConfig defaultConfig, PersistedFilteringDashboard persistedDashboard) {
        HashMap<String, PersistedPropertyFilter> unsupported = new HashMap<String, PersistedPropertyFilter>();
        for (Map.Entry<String, PersistedPropertyFilter> entry : persistedDashboard.getPropertyFilters().entrySet()) {
            if (PersistedDashboardsToDashboards.isSupportedProperty(entry.getKey(), defaultConfig)) continue;
            unsupported.put(entry.getKey(), entry.getValue());
        }
        return unsupported;
    }

    private static boolean isSupportedProperty(String property, FilteringDashboardConfig defaultConfig) {
        for (FilteringDashboardPropertyDef propertyDef : defaultConfig.getDashboardDef().getAllPropertyDefs()) {
            if (!propertyDef.getSourcePropertyDef().getPropertyPath().getDotSeparatedPath().equals(property)) continue;
            return true;
        }
        return false;
    }

    private static BeanTreePath getBeanTreePathTemplate(InvocationContext ic, PersistedFilteringDashboard persistedDashboard) {
        BeanRepo beanRepo = ic.getPageRepo().getBeanRepo();
        BeanTreePath btpTemplate = BeanTreePath.create(beanRepo, new Path());
        boolean searchSubTypes = true;
        for (String childName : new Path(persistedDashboard.getBeanTreePathTemplate()).getComponents()) {
            Path childPath = new Path(childName);
            BeanTypeDef typeDef = btpTemplate.getTypeDef();
            if (typeDef.hasChildDef(childPath, searchSubTypes)) {
                btpTemplate = btpTemplate.childPath(childPath);
                continue;
            }
            return null;
        }
        return btpTemplate;
    }

    private static boolean reuseCachedResults(FilteringDashboard oldDashboard, FilteringDashboard newDashboard) {
        Object newValue;
        Object oldValue;
        String newCriteria;
        String oldCriteria;
        int i;
        int newSize;
        if (oldDashboard == null) {
            return false;
        }
        FilteringDashboardConfig oldConfig = oldDashboard.getConfig();
        FilteringDashboardConfig newConfig = newDashboard.getConfig();
        int oldSize = oldConfig.getPath().size();
        if (oldSize != (newSize = newConfig.getPath().size())) {
            return false;
        }
        for (i = 0; i < newSize; ++i) {
            Path newChildPath;
            FilteringDashboardPathSegment oldSegment = oldConfig.getPath().get(i);
            FilteringDashboardPathSegment newSegment = newConfig.getPath().get(i);
            Path oldChildPath = oldSegment.getSegmentDef().getSegmentTemplate().getChildDef().getChildPath();
            if (!oldChildPath.equals((Object)(newChildPath = newSegment.getSegmentDef().getSegmentTemplate().getChildDef().getChildPath()))) {
                return false;
            }
            oldCriteria = StringUtils.nonNull((String)oldSegment.getCriteria());
            if (!oldCriteria.equals(newCriteria = StringUtils.nonNull((String)newSegment.getCriteria()))) {
                return false;
            }
            oldValue = StringUtils.nonNull((String)oldSegment.getValue());
            if (((String)oldValue).equals(newValue = StringUtils.nonNull((String)newSegment.getValue()))) continue;
            return false;
        }
        oldSize = oldConfig.getProperties().size();
        if (oldSize != (newSize = newConfig.getProperties().size())) {
            return false;
        }
        for (i = 0; i < newSize; ++i) {
            String newValueAsString;
            Path newPropPath;
            FilteringDashboardProperty oldProperty = oldConfig.getProperties().get(i);
            FilteringDashboardProperty newProperty = newConfig.getProperties().get(i);
            Path oldPropPath = oldProperty.getPropertyDef().getSourcePropertyDef().getPropertyPath();
            if (!oldPropPath.equals((Object)(newPropPath = newProperty.getPropertyDef().getSourcePropertyDef().getPropertyPath()))) {
                return false;
            }
            oldCriteria = StringUtils.nonNull((String)oldProperty.getCriteria());
            if (!oldCriteria.equals(newCriteria = StringUtils.nonNull((String)newProperty.getCriteria()))) {
                return false;
            }
            oldValue = oldProperty.getValue();
            newValue = newProperty.getValue();
            String oldValueAsString = oldValue != null ? oldValue.toString() : "";
            String string = newValueAsString = newValue != null ? newValue.toString() : "";
            if (oldValueAsString.equals(newValueAsString)) continue;
            return false;
        }
        return true;
    }
}

