/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.logging.Logger;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.PageActionDef;
import weblogic.remoteconsole.common.repodef.PageDef;
import weblogic.remoteconsole.common.repodef.PageRepoDef;
import weblogic.remoteconsole.common.repodef.SlicePagePath;
import weblogic.remoteconsole.common.utils.CustomizerInvocationUtils;
import weblogic.remoteconsole.server.repo.ActionInputFormReader;
import weblogic.remoteconsole.server.repo.ActionInvoker;
import weblogic.remoteconsole.server.repo.BeanRepo;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.CreateFormReader;
import weblogic.remoteconsole.server.repo.DashboardManager;
import weblogic.remoteconsole.server.repo.FormProperty;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.NavTreeNode;
import weblogic.remoteconsole.server.repo.NavTreeReader;
import weblogic.remoteconsole.server.repo.Page;
import weblogic.remoteconsole.server.repo.PageReader;
import weblogic.remoteconsole.server.repo.PageRepo;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.ResponseException;
import weblogic.remoteconsole.server.repo.SimpleSearchManager;
import weblogic.remoteconsole.server.repo.SliceReader;
import weblogic.remoteconsole.server.repo.TableCustomizationsManager;
import weblogic.remoteconsole.server.repo.TableReader;

public abstract class PageReaderRepo
extends PageRepo {
    private static final Logger LOGGER = Logger.getLogger(PageReaderRepo.class.getName());
    private static final Type CUSTOMIZE_PAGE_RETURN_TYPE = Void.TYPE;

    protected PageReaderRepo(PageRepoDef pageRepoDef, BeanRepo beanRepo) {
        super(pageRepoDef, beanRepo);
    }

    @Override
    public void prepareForRemoval(InvocationContext ic) {
        ic.removeSessionData("SimpleSearchManager", this);
        ic.removeSessionData("DashboardManager", this);
        ic.removeSessionData("TableCustomizationsManager", this);
    }

    public Response<PageDef> getPageDef(InvocationContext ic) {
        LOGGER.finest("PageReaderRepo.getPageDef " + String.valueOf(ic.getPagePath()));
        PageReader reader = null;
        if (ic.getPagePath().isSlicePagePath()) {
            reader = new SliceReader(ic);
        } else if (ic.getPagePath().isCreateFormPagePath()) {
            reader = new CreateFormReader(ic);
        } else if (ic.getPagePath().isTablePagePath()) {
            reader = new TableReader(ic);
        } else if (ic.getPagePath().isActionInputFormPagePath()) {
            reader = new ActionInputFormReader(ic);
        } else {
            throw new AssertionError((Object)("Unknown PagePath type : " + String.valueOf(ic.getPagePath())));
        }
        return reader.getPageDef();
    }

    public Response<Page> getPage(InvocationContext ic) {
        LOGGER.finest("PageReaderRepo.getPage " + String.valueOf(ic.getPagePath()) + " " + String.valueOf(ic.getBeanTreePath()));
        if (ic.getPagePath().isSlicePagePath()) {
            return this.customizePage(ic, new SliceReader(ic).getSlice());
        }
        if (ic.getPagePath().isCreateFormPagePath()) {
            return this.customizePage(ic, new CreateFormReader(ic).getCreateForm());
        }
        if (ic.getPagePath().isTablePagePath()) {
            return this.customizePage(ic, new TableReader(ic).getTable());
        }
        if (ic.getPagePath().isActionInputFormPagePath()) {
            return this.customizePage(ic, new ActionInputFormReader(ic).getInputForm());
        }
        throw new AssertionError((Object)("Unknown PagePath type : " + String.valueOf(ic.getPagePath())));
    }

    private Response<Page> customizePage(InvocationContext ic, Response<Page> pageResponse) {
        if (!pageResponse.isSuccess()) {
            return pageResponse;
        }
        Page page = pageResponse.getResults();
        String methodName = page.getPageDef().getCustomizePageMethod();
        if (StringUtils.isEmpty((String)methodName)) {
            return pageResponse;
        }
        Method method = CustomizerInvocationUtils.getMethod(methodName);
        CustomizerInvocationUtils.checkSignature(method, CUSTOMIZE_PAGE_RETURN_TYPE, new Type[]{InvocationContext.class, Page.class});
        try {
            CustomizerInvocationUtils.invokeMethod(method, List.of(ic, page));
            return pageResponse;
        }
        catch (ResponseException re) {
            return pageResponse.copyUnsuccessfulResponse(re.getResponse());
        }
    }

    public Response<SlicePagePath> getActualSlicePagePath(InvocationContext ic) {
        if (ic.getPagePath().isSlicePagePath()) {
            return new SliceReader(ic).getActualSlicePagePath();
        }
        throw new AssertionError((Object)("Not a slice : " + String.valueOf(ic.getPagePath())));
    }

    public Response<InvocationContext> getActualSliceInvocationContext(InvocationContext ic) {
        Response<InvocationContext> response = new Response<InvocationContext>();
        Response<SlicePagePath> sliceResponse = this.getActualSlicePagePath(ic);
        if (!sliceResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(sliceResponse);
        }
        InvocationContext actualIc = new InvocationContext(ic);
        actualIc.setPagePath(sliceResponse.getResults());
        return response.setSuccess(actualIc);
    }

    public Response<List<NavTreeNode>> expandNavTreeNodes(InvocationContext ic, List<NavTreeNode> nodes) {
        return new NavTreeReader(ic).expandNavTreeNodes(nodes);
    }

    public Response<Void> verifyExists(InvocationContext ic, BeanTreePath beanPath) {
        return this.getBeanRepo().asBeanReaderRepo().verifyExists(ic, beanPath);
    }

    public Response<Void> verifyDoesntExist(InvocationContext ic, BeanTreePath beanPath) {
        return this.getBeanRepo().asBeanReaderRepo().verifyDoesntExist(ic, beanPath);
    }

    public Response<Void> invokeAction(InvocationContext ic, PageActionDef pageActionDef, List<FormProperty> formProperties) {
        return new ActionInvoker(ic, pageActionDef, formProperties).invokeAction();
    }

    public synchronized SimpleSearchManager getSimpleSearchManager(InvocationContext ic) {
        SimpleSearchManager ret = (SimpleSearchManager)ic.getSessionData("SimpleSearchManager", this);
        if (ret == null) {
            ret = new SimpleSearchManager();
            ic.storeSessionData("SimpleSearchManager", this, ret);
        }
        return ret;
    }

    public DashboardManager getDashboardManager(InvocationContext ic) {
        if (!this.getPageRepoDef().isSupportsDashboards()) {
            return null;
        }
        DashboardManager ret = (DashboardManager)ic.getSessionData("DashboardManager", this);
        if (ret == null) {
            ret = new DashboardManager();
            ic.storeSessionData("DashboardManager", this, ret);
        }
        return ret;
    }

    public TableCustomizationsManager getTableCustomizationsManager(InvocationContext ic) {
        TableCustomizationsManager ret = (TableCustomizationsManager)ic.getSessionData("TableCustomizationsManager", this);
        if (ret == null) {
            ret = new TableCustomizationsManager();
            ic.storeSessionData("TableCustomizationsManager", this, ret);
        }
        return ret;
    }
}

