/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.CollectionParamDef;
import weblogic.remoteconsole.common.repodef.CustomizerDef;
import weblogic.remoteconsole.common.repodef.GetPropertyValueCustomizerDef;
import weblogic.remoteconsole.common.repodef.ParamDef;
import weblogic.remoteconsole.common.utils.CustomizerInvocationUtils;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchResults;
import weblogic.remoteconsole.server.repo.BeanRepo;
import weblogic.remoteconsole.server.repo.BeanSearchResults;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.ResponseException;
import weblogic.remoteconsole.server.repo.SettableValue;
import weblogic.remoteconsole.server.repo.Value;

public class PageReaderHelper {
    private InvocationContext ic;

    public PageReaderHelper(InvocationContext ic) {
        this.ic = ic;
    }

    public Response<Value> getPropertyValue(BeanPropertyDef propertyDef, BeanSearchResults beanResults, BeanReaderRepoSearchResults searchResults, boolean includeIsSet) {
        return this.getPropertyValue(propertyDef, this.getBeanTreePath(), beanResults, searchResults, includeIsSet);
    }

    public Response<Value> getPropertyValue(BeanPropertyDef propertyDef, BeanTreePath beanTreePath, BeanSearchResults beanResults, BeanReaderRepoSearchResults searchResults, boolean includeIsSet) {
        Response<Value> response = new Response<Value>();
        if (propertyDef.getGetValueCustomizerDef() == null) {
            if (beanResults == null) {
                return response.setNotFound();
            }
            return response.setSuccess(beanResults.getValue(propertyDef));
        }
        return this.getCustomPropertyValue(propertyDef, beanTreePath, beanResults, searchResults, includeIsSet);
    }

    private Response<Value> getCustomPropertyValue(BeanPropertyDef propertyDef, BeanTreePath beanTreePath, BeanSearchResults beanResults, BeanReaderRepoSearchResults searchResults, boolean includeIsSet) {
        boolean argsIncludeIsSet;
        Response<Value> response = new Response<Value>();
        GetPropertyValueCustomizerDef customizerDef = propertyDef.getGetValueCustomizerDef();
        Response<List<Object>> argsResponse = this.getArguments(customizerDef, beanTreePath, beanResults, searchResults, argsIncludeIsSet = true);
        if (!argsResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(argsResponse);
        }
        try {
            Object rtn = CustomizerInvocationUtils.invokeMethod(customizerDef.getMethod(), argsResponse.getResults());
            SettableValue settableValue = (SettableValue)rtn;
            return response.setSuccess(this.getValue(settableValue, includeIsSet));
        }
        catch (ResponseException e) {
            return response.copyUnsuccessfulResponse(e.getResponse());
        }
    }

    public Response<List<Object>> getArguments(CustomizerDef customizerDef, BeanSearchResults beanResults, BeanReaderRepoSearchResults searchResults, boolean includeIsSet) {
        return this.getArguments(customizerDef, this.getBeanTreePath(), beanResults, searchResults, includeIsSet);
    }

    public Response<List<Object>> getArguments(CustomizerDef customizerDef, BeanTreePath beanTreePath, BeanSearchResults beanResults, BeanReaderRepoSearchResults searchResults, boolean includeIsSet) {
        Response response = new Response();
        BeanTreePath btp = beanResults != null ? beanResults.getBeanTreePath() : beanTreePath;
        ArrayList<Object> args = new ArrayList<Object>();
        for (ParamDef paramDef : customizerDef.getParamDefs()) {
            Response<Object> argResponse = this.getArgument(paramDef, btp, beanResults, searchResults, includeIsSet);
            if (!argResponse.isSuccess()) {
                return response.copyUnsuccessfulResponse(argResponse);
            }
            args.add(argResponse.getResults());
        }
        return response.setSuccess(args);
    }

    private Response<Object> getArgument(ParamDef paramDef, BeanTreePath beanTreePath, BeanSearchResults beanResults, BeanReaderRepoSearchResults searchResults, boolean includeIsSet) {
        Response<Object> response = new Response<Object>();
        if (paramDef.isInvocationContext()) {
            InvocationContext beanIc = new InvocationContext(this.getInvocationContext());
            beanIc.setIdentity(beanTreePath);
            return response.setSuccess(beanIc);
        }
        if (paramDef.isProperty()) {
            if (beanResults == null) {
                return response.setNotFound();
            }
            return response.setSuccess(this.argumentValue(beanResults.getValue(paramDef.asProperty().getPropertyDef()), includeIsSet));
        }
        if (paramDef.isCollection()) {
            return response.setSuccess(this.getCollectionArgument(paramDef.asCollection(), beanResults, searchResults, includeIsSet));
        }
        throw new AssertionError((Object)("Unsupported parameter " + String.valueOf(paramDef)));
    }

    private Object getCollectionArgument(CollectionParamDef paramDef, BeanSearchResults beanResults, BeanReaderRepoSearchResults searchResults, boolean includeIsSet) {
        Path collectionPath = this.getCollectionPath(paramDef, beanResults);
        List<BeanSearchResults> collectionResults = searchResults.getCollection(BeanTreePath.create(this.getBeanRepo(), collectionPath));
        if (collectionResults == null) {
            return null;
        }
        ArrayList collection = new ArrayList();
        for (BeanSearchResults collectionChildResults : collectionResults) {
            HashMap<String, Value> collectionChild = new HashMap<String, Value>();
            for (BeanPropertyDef propertyDef : paramDef.getPropertyDefs()) {
                collectionChild.put(propertyDef.getPropertyPath().getDotSeparatedPath(), this.argumentValue(collectionChildResults.getValue(propertyDef), includeIsSet));
            }
            collection.add(collectionChild);
        }
        return collection;
    }

    private Path getCollectionPath(CollectionParamDef paramDef, BeanSearchResults beanResults) {
        Path collectionPath = paramDef.getCollectionPath();
        if (!collectionPath.isEmpty()) {
            return collectionPath;
        }
        if (beanResults == null) {
            throw new AssertionError((Object)"Null beanResults");
        }
        BeanPropertyDef propertyDef = paramDef.getCustomizerDef().asProperty().getPropertyDef();
        BeanPropertyDef identityDef = propertyDef.getTypeDef().getIdentityPropertyDef();
        BeanTreePath parentBeanPath = Value.unsettableValue(beanResults.getValue(identityDef)).asBeanTreePath();
        return parentBeanPath.getPath().childPath(paramDef.getCollectionDef().getChildPath());
    }

    private Value getValue(SettableValue settableValue, boolean includeIsSet) {
        if (includeIsSet || settableValue == null) {
            return settableValue;
        }
        return settableValue.getValue();
    }

    private Value argumentValue(Value value, boolean includeIsSet) {
        return includeIsSet ? Value.settableValue(value) : Value.unsettableValue(value);
    }

    public void addParamsToSearch(BeanReaderRepoSearchBuilder builder, BeanTreePath beanTreePath, CustomizerDef customizerDef) {
        if (customizerDef == null) {
            return;
        }
        for (ParamDef paramDef : customizerDef.getParamDefs()) {
            this.addParamToSearch(builder, beanTreePath, paramDef);
        }
    }

    private void addParamToSearch(BeanReaderRepoSearchBuilder builder, BeanTreePath beanTreePath, ParamDef paramDef) {
        if (!paramDef.isInvocationContext()) {
            if (paramDef.isProperty()) {
                builder.addProperty(beanTreePath, paramDef.asProperty().getPropertyDef());
            } else if (paramDef.isCollection()) {
                CollectionParamDef collParamDef = paramDef.asCollection();
                BeanTreePath collBeanTreePath = this.getCollectionBeanTreePath(beanTreePath, collParamDef);
                for (BeanPropertyDef propertyDef : collParamDef.getPropertyDefs()) {
                    builder.addProperty(collBeanTreePath, propertyDef);
                }
            } else {
                throw new AssertionError((Object)("Unsupported customizer parameter: " + String.valueOf(paramDef)));
            }
        }
    }

    private BeanTreePath getCollectionBeanTreePath(BeanTreePath beanTreePath, CollectionParamDef paramDef) {
        Path collectionPath = paramDef.getCollectionPath();
        if (collectionPath.isEmpty()) {
            return beanTreePath.childPath(paramDef.getCollectionDef().getChildPath());
        }
        return BeanTreePath.create(this.getBeanRepo(), collectionPath);
    }

    private BeanRepo getBeanRepo() {
        return this.getInvocationContext().getPageRepo().getBeanRepo();
    }

    private BeanTreePath getBeanTreePath() {
        return this.getInvocationContext().getBeanTreePath();
    }

    private InvocationContext getInvocationContext() {
        return this.ic;
    }
}

