/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import com.fasterxml.jackson.core.type.TypeReference;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.CollectionParamDef;
import weblogic.remoteconsole.common.repodef.CustomizerDef;
import weblogic.remoteconsole.common.repodef.LinkDef;
import weblogic.remoteconsole.common.repodef.LinksDef;
import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.repodef.NavTreeDef;
import weblogic.remoteconsole.common.repodef.NavTreeNodeDef;
import weblogic.remoteconsole.common.repodef.PageDef;
import weblogic.remoteconsole.common.repodef.PagePath;
import weblogic.remoteconsole.common.utils.CustomizerInvocationUtils;
import weblogic.remoteconsole.server.providers.Root;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchResults;
import weblogic.remoteconsole.server.repo.BeanSearchResults;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.BeanTreePathTemplate;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Link;
import weblogic.remoteconsole.server.repo.NavTreePath;
import weblogic.remoteconsole.server.repo.NavTreePathSegment;
import weblogic.remoteconsole.server.repo.Page;
import weblogic.remoteconsole.server.repo.PageManager;
import weblogic.remoteconsole.server.repo.PageReaderHelper;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.ResponseException;
import weblogic.remoteconsole.server.repo.Value;
import weblogic.remoteconsole.server.webapp.UriUtils;

class PageReader
extends PageManager {
    private static final Logger LOGGER = Logger.getLogger(PageReader.class.getName());
    private static final Type GET_COLLECTION_CUSTOMIZER_RETURN_TYPE = new TypeReference<List<BeanSearchResults>>(){}.getType();
    private static final Type CUSTOMIZE_PAGE_DEF_RETURN_TYPE = new TypeReference<PageDef>(){}.getType();
    private static final Type PROPERTY_DEF_LIST_TYPE = new TypeReference<List<BeanPropertyDef>>(){}.getType();

    protected PageReader(InvocationContext invocationContext) {
        super(invocationContext);
    }

    protected void addPageInfo(Page page) {
        this.addSelf(page);
        this.addBreadCrumbs(page);
    }

    protected void setPageDef(Page page, PageDef pageDef) {
        page.setPageDef(pageDef);
        page.setBackendRelativePDJURI(UriUtils.getBackendRelativePDJUri(this.getInvocationContext(), pageDef.getPagePath()));
    }

    protected void addCollectionToSearch(BeanReaderRepoSearchBuilder builder, BeanTreePath beanTreePath, List<BeanPropertyDef> propertyDefs) {
        for (BeanPropertyDef propertyDef : propertyDefs) {
            builder.addProperty(beanTreePath, propertyDef);
            this.addParamsToSearch(builder, beanTreePath, propertyDef.getGetValueCustomizerDef());
        }
        if (beanTreePath.getTypeDef().isHeterogeneous()) {
            this.addSubTypeDiscriminatorToSearch(beanTreePath, builder);
        }
    }

    protected Response<List<BeanSearchResults>> getCollectionResults(BeanReaderRepoSearchResults searchResults, BeanTreePath beanTreePath, List<BeanPropertyDef> propertyDefs) {
        Response<List<BeanSearchResults>> response = new Response<List<BeanSearchResults>>();
        String getCollectionMethod = beanTreePath.getTypeDef().getGetCollectionMethod();
        if (StringUtils.notEmpty((String)getCollectionMethod)) {
            Method method = CustomizerInvocationUtils.getMethod(getCollectionMethod);
            CustomizerInvocationUtils.checkSignature(method, GET_COLLECTION_CUSTOMIZER_RETURN_TYPE, new Type[]{InvocationContext.class, BeanTreePath.class, BeanReaderRepoSearchResults.class, PROPERTY_DEF_LIST_TYPE});
            try {
                List<Object> args = List.of(this.getInvocationContext(), beanTreePath, searchResults, propertyDefs);
                Object rtn = CustomizerInvocationUtils.invokeMethod(method, args);
                List results = (List)rtn;
                return response.setSuccess(results);
            }
            catch (ResponseException e) {
                return response.copyUnsuccessfulResponse(e.getResponse());
            }
        }
        return response.setSuccess(searchResults.getCollection(beanTreePath));
    }

    protected void addSubTypeDiscriminatorToSearch(BeanTreePath beanTreePath, BeanReaderRepoSearchBuilder builder) {
        BeanPropertyDef discPropertyDef = beanTreePath.getTypeDef().getSubTypeDiscriminatorPropertyDef();
        builder.addProperty(beanTreePath, discPropertyDef);
        builder.addProperty(beanTreePath, discPropertyDef.getTypeDef().getIdentityPropertyDef());
        this.addParamsToSearch(builder, beanTreePath, discPropertyDef.getGetValueCustomizerDef());
    }

    protected Response<BeanTypeDef> getActualTypeDef(BeanTreePath beanTreePath, BeanReaderRepoSearchResults searchResults) {
        Response<BeanTypeDef> response = new Response<BeanTypeDef>();
        BeanTypeDef typeDef = beanTreePath.getTypeDef();
        if (typeDef.isHomogeneous()) {
            return response.setSuccess(typeDef);
        }
        Response<String> discResponse = this.getSubTypeDiscriminatorValue(beanTreePath, searchResults);
        if (!discResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(discResponse);
        }
        return response.setSuccess(typeDef.getSubTypeDef(discResponse.getResults()));
    }

    protected Response<BeanTypeDef> getActualTypeDef(BeanTreePath beanTreePath, BeanSearchResults beanResults, BeanReaderRepoSearchResults searchResults) {
        Response<BeanTypeDef> response = new Response<BeanTypeDef>();
        BeanTypeDef typeDef = beanTreePath.getTypeDef();
        if (typeDef.isHomogeneous()) {
            return response.setSuccess(typeDef);
        }
        Response<String> discResponse = this.getSubTypeDiscriminatorValue(beanTreePath, beanResults, searchResults);
        if (!discResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(discResponse);
        }
        return response.setSuccess(typeDef.getSubTypeDef(discResponse.getResults()));
    }

    protected Response<String> getSubTypeDiscriminatorValue(BeanTreePath beanTreePath, BeanReaderRepoSearchResults searchResults) {
        return this.getSubTypeDiscriminatorValue(beanTreePath, searchResults.getBean(beanTreePath), searchResults);
    }

    protected Response<String> getSubTypeDiscriminatorValue(BeanTreePath beanTreePath, BeanSearchResults beanResults, BeanReaderRepoSearchResults searchResults) {
        boolean includeIsSet;
        Response<String> response = new Response<String>();
        BeanPropertyDef discPropertyDef = beanTreePath.getTypeDef().getSubTypeDiscriminatorPropertyDef();
        Response<Value> valueResponse = this.getPropertyValue(discPropertyDef, beanTreePath, beanResults, searchResults, includeIsSet = false);
        if (!valueResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(valueResponse);
        }
        Value value = Value.unsettableValue(valueResponse.getResults());
        return response.setSuccess(value.asString().getValue());
    }

    protected void addParamsToSearch(BeanReaderRepoSearchBuilder builder, BeanTreePath beanTreePath, CustomizerDef customizerDef) {
        new PageReaderHelper(this.getInvocationContext()).addParamsToSearch(builder, beanTreePath, customizerDef);
    }

    private BeanTreePath getCollectionBeanTreePath(BeanTreePath beanTreePath, CollectionParamDef paramDef) {
        Path collectionPath = paramDef.getCollectionPath();
        if (collectionPath.isEmpty()) {
            return beanTreePath.childPath(paramDef.getCollectionDef().getChildPath());
        }
        return BeanTreePath.create(this.getBeanRepo(), collectionPath);
    }

    private void addSelf(Page page) {
        NavTreePath navTreePath = new NavTreePath(this.getInvocationContext());
        page.setNavTreePath(navTreePath.getPath());
        page.setSelf(this.getBeanTreePath());
        page.setBeanTreePath(this.getBeanTreePath().getPath());
    }

    private void addBreadCrumbs(Page page) {
        ArrayList<BeanTreePath> breadCrumbs = new ArrayList<BeanTreePath>();
        NavTreePath navTreePath = new NavTreePath(this.getInvocationContext());
        List<NavTreePathSegment> segments = navTreePath.getSegments();
        for (int i = 0; i < segments.size(); ++i) {
            NavTreePathSegment segment = segments.get(i);
            NavTreeNodeDef node = segment.getNavTreeNodeDef();
            if (!node.isChildNodeDef()) continue;
            BeanTreePath btp = segment.getBeanTreePath();
            if (btp.isCollectionChild()) {
                breadCrumbs.add(BeanTreePath.create(btp.getBeanRepo(), btp.getPath().getParent()));
            }
            if (i >= segments.size() - 1) continue;
            breadCrumbs.add(btp);
        }
        page.setBreadCrumbs(breadCrumbs);
    }

    protected Response<PageDef> getPageDef() {
        return this.getPageDef(this.getInvocationContext().getPagePath());
    }

    protected Response<PageDef> getPageDef(PagePath pagePath) {
        Response<PageDef> pageDefResponse = this.getUncustomizedPageDef(pagePath);
        if (!pageDefResponse.isSuccess()) {
            return pageDefResponse;
        }
        PageDef uncustomizedPageDef = pageDefResponse.getResults();
        String methodName = uncustomizedPageDef.getCustomizePageDefMethod();
        if (StringUtils.isEmpty((String)methodName)) {
            return new Response<PageDef>().setSuccess(uncustomizedPageDef);
        }
        Method method = CustomizerInvocationUtils.getMethod(methodName);
        CustomizerInvocationUtils.checkSignature(method, CUSTOMIZE_PAGE_DEF_RETURN_TYPE, new Type[]{InvocationContext.class, PageDef.class});
        try {
            List<Object> args = List.of(this.getInvocationContext(), uncustomizedPageDef);
            Object rtn = CustomizerInvocationUtils.invokeMethod(method, args);
            PageDef results = (PageDef)rtn;
            return pageDefResponse.setSuccess(results);
        }
        catch (ResponseException e) {
            return pageDefResponse.copyUnsuccessfulResponse(e.getResponse());
        }
    }

    protected Response<PageDef> getUncustomizedPageDef(PagePath pagePath) {
        Response<PageDef> response = new Response<PageDef>();
        PageDef pageDef = this.getPageRepoDef().getPageDef(pagePath);
        if (pageDef == null) {
            LOGGER.warning("Can't find page " + String.valueOf(pagePath));
            Thread.dumpStack();
            return response.setNotFound();
        }
        return response.setSuccess(pageDef);
    }

    protected void addLinks(Page page, boolean forInstance) {
        ArrayList<Link> links = new ArrayList<Link>();
        LinksDef linksDef = this.getPageRepoDef().getLinksDef(page.getPageDef().getPagePath().getPagesPath().getTypeDef());
        if (linksDef != null) {
            for (LinkDef linkDef : linksDef.getLinkDefs(forInstance)) {
                links.addAll(this.createLinks(linkDef));
            }
        }
        this.addLinksFromChildren(links, page);
        if (!links.isEmpty()) {
            page.setLinks(links);
        }
    }

    protected void addChangeManagerStatus(Page page, BeanReaderRepoSearchResults searchResults) {
        if (searchResults.isChangeManagerBeanRepoSearchResults()) {
            page.setChangeManagerStatus(searchResults.asChangeManagerBeanRepoSearchResults().getChangeManagerStatus());
        }
    }

    private void addLinksFromChildren(List<Link> links, Page page) {
        if (page.getSelf().isCollection()) {
            return;
        }
        NavTreeDef nav = this.getInvocationContext().getPageRepo().getPageRepoDef().getNavTreeDef(page.getPageDef().getPagePath().getPagesPath().getTypeDef());
        if (nav == null) {
            return;
        }
        for (NavTreeNodeDef node : nav.getContentDefs()) {
            if (!node.isChildNodeDef()) continue;
            Link link = new Link();
            link.setLabel(this.getInvocationContext().getLocalizer().localizeString(node.getLabel(), new Object[0]) + " - " + page.getNavTreePath().getLastComponent());
            Path path = new Path(this.getInvocationContext().getPageRepo().getPageRepoDef().getName());
            path.addComponent("data");
            path.addPath(page.getSelf().getPath());
            path.addPath(node.asChildNodeDef().getChildNodePath());
            link.setResourceData(path);
            links.add(link);
        }
    }

    private List<Link> createLinks(LinkDef linkDef) {
        ArrayList<Link> links = new ArrayList<Link>();
        Path pageRepoRelativeResourceData = this.getPageRepoRelativeResourceData(linkDef);
        if (pageRepoRelativeResourceData == null) {
            return links;
        }
        for (Root root : this.getRootsThatSupportLink(linkDef)) {
            links.add(this.createLink(linkDef, pageRepoRelativeResourceData, root));
        }
        return links;
    }

    private Path getPageRepoRelativeResourceData(LinkDef linkDef) {
        return new BeanTreePathTemplate(linkDef.getResourceData()).expand(this.getBeanTreePath());
    }

    private List<Root> getRootsThatSupportLink(LinkDef linkDef) {
        String rootName = linkDef.getRoot();
        ArrayList<Root> roots = new ArrayList<Root>();
        for (Root root : this.getInvocationContext().getProvider().getRoots().values()) {
            if (!root.getRootName().equals(rootName)) continue;
            roots.add(root);
        }
        return roots;
    }

    private Link createLink(LinkDef linkDef, Path pageRepoRelativeResourceData, Root root) {
        Link link = new Link();
        link.setResourceData(this.getLinkResourceData(pageRepoRelativeResourceData, root));
        link.setLabel(this.getLinkLabel(linkDef, root));
        LocalizableString nfm = linkDef.getNotFoundMessage();
        if (nfm != null) {
            link.setNotFoundMessage(this.getInvocationContext().getLocalizer().localizeString(nfm, new Object[0]));
        }
        return link;
    }

    private Path getLinkResourceData(Path pageRepoRelativeResourceData, Root root) {
        Path resourceData = new Path(root.getName());
        resourceData.addComponent("data");
        resourceData.addPath(pageRepoRelativeResourceData);
        return resourceData;
    }

    private String getLinkLabel(LinkDef linkDef, Root root) {
        return this.getInvocationContext().getLocalizer().localizeString(linkDef.getLabel(), new Object[0]) + " - " + this.getInvocationContext().getLocalizer().localizeString(root.getLabel(), new Object[0]);
    }

    protected List<BeanPropertyDef> createPropertyDefList() {
        ArrayList<BeanPropertyDef> propDefs = new ArrayList<BeanPropertyDef>();
        propDefs.add(this.getBeanTreePath().getTypeDef().getIdentityPropertyDef());
        return propDefs;
    }

    protected Response<Value> getPropertyValue(BeanPropertyDef propertyDef, BeanSearchResults beanResults, BeanReaderRepoSearchResults searchResults, boolean includeIsSet) {
        return this.getPropertyValue(propertyDef, this.getBeanTreePath(), beanResults, searchResults, includeIsSet);
    }

    protected Response<Value> getPropertyValue(BeanPropertyDef propertyDef, BeanTreePath beanTreePath, BeanSearchResults beanResults, BeanReaderRepoSearchResults searchResults, boolean includeIsSet) {
        return new PageReaderHelper(this.getInvocationContext()).getPropertyValue(propertyDef, beanTreePath, beanResults, searchResults, includeIsSet);
    }

    protected Response<List<Object>> getArguments(CustomizerDef customizerDef, BeanSearchResults beanResults, BeanReaderRepoSearchResults searchResults, boolean includeIsSet) {
        return this.getArguments(customizerDef, this.getBeanTreePath(), beanResults, searchResults, includeIsSet);
    }

    protected Response<List<Object>> getArguments(CustomizerDef customizerDef, BeanTreePath beanTreePath, BeanSearchResults beanResults, BeanReaderRepoSearchResults searchResults, boolean includeIsSet) {
        return new PageReaderHelper(this.getInvocationContext()).getArguments(customizerDef, beanTreePath, beanResults, searchResults, includeIsSet);
    }
}

