/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.ActionInputFormDef;
import weblogic.remoteconsole.common.repodef.ActionInputFormPresentationDef;
import weblogic.remoteconsole.common.repodef.BeanValueDef;
import weblogic.remoteconsole.common.repodef.CreateFormDef;
import weblogic.remoteconsole.common.repodef.CreateFormPresentationDef;
import weblogic.remoteconsole.common.repodef.FormSectionDef;
import weblogic.remoteconsole.common.repodef.HelpTopicDef;
import weblogic.remoteconsole.common.repodef.LegalValueDef;
import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.repodef.PageActionDef;
import weblogic.remoteconsole.common.repodef.PageActionExternalHelpDef;
import weblogic.remoteconsole.common.repodef.PageActionParamDef;
import weblogic.remoteconsole.common.repodef.PageActionPollingDef;
import weblogic.remoteconsole.common.repodef.PageDef;
import weblogic.remoteconsole.common.repodef.PageFieldPresentationDef;
import weblogic.remoteconsole.common.repodef.PagePropertyDef;
import weblogic.remoteconsole.common.repodef.PagePropertyExternalHelpDef;
import weblogic.remoteconsole.common.repodef.SliceDef;
import weblogic.remoteconsole.common.repodef.SliceFormDef;
import weblogic.remoteconsole.common.repodef.SliceFormPresentationDef;
import weblogic.remoteconsole.common.repodef.SliceTableDef;
import weblogic.remoteconsole.common.repodef.SlicesDef;
import weblogic.remoteconsole.common.repodef.TableDef;
import weblogic.remoteconsole.common.repodef.UsedIfDef;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Value;

public class PageDescription {
    private InvocationContext ic;
    private static final String READ_ONLY = "readOnly";

    public static JsonObject getPageDescription(PageDef pageDef, InvocationContext ic) {
        return new PageDescription(ic).pageDefToJson(pageDef);
    }

    private PageDescription(InvocationContext ic) {
        this.ic = ic;
    }

    private JsonObject pageDefToJson(PageDef pageDef) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.addIfNotEmpty(builder, "introductionHTML", pageDef.getIntroductionHTML());
        this.addIfNotEmpty(builder, "helpPageTitle", pageDef.getHelpPageTitle());
        this.addIfNotEmpty(builder, "helpTopics", this.helpTopicDefsToJson(pageDef.getHelpTopicDefs()));
        if (pageDef.isTableDef()) {
            this.addIfNotEmpty(builder, "table", this.tableDefToJson(pageDef.asTableDef()));
        }
        if (pageDef.isSliceFormDef()) {
            this.addIfNotEmpty(builder, "sliceForm", this.sliceFormDefToJson(pageDef.asSliceFormDef()));
        }
        if (pageDef.isSliceTableDef()) {
            this.addIfNotEmpty(builder, "sliceTable", this.sliceTableDefToJson(pageDef.asSliceTableDef()));
        }
        if (pageDef.isCreateFormDef()) {
            this.addIfNotEmpty(builder, "createForm", this.createFormDefToJson(pageDef.asCreateFormDef()));
        }
        if (pageDef.isActionInputFormDef()) {
            this.addIfNotEmpty(builder, "actionInputForm", this.actionInputFormDefToJson(pageDef.asActionInputFormDef()));
        }
        return builder.build();
    }

    private JsonArray helpTopicDefsToJson(List<HelpTopicDef> helpTopicDefs) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (HelpTopicDef helpTopicDef : helpTopicDefs) {
            builder.add((JsonValue)this.helpTopicDefToJson(helpTopicDef));
        }
        return builder.build();
    }

    private JsonObject helpTopicDefToJson(HelpTopicDef helpTopicDef) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.addIfNotEmpty(builder, "label", helpTopicDef.getLabel());
        this.addIfNotEmpty(builder, "href", helpTopicDef.getHref());
        return builder.build();
    }

    private JsonObject tableDefToJson(TableDef tableDef) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.addIfTrue(builder, "ordered", tableDef.getPagePath().getPagesPath().getTypeDef().isOrdered());
        this.addIfNotEmpty(builder, "displayedColumns", this.columnPropertyDefsToJson(tableDef.getDisplayedColumnDefs()));
        List<PagePropertyDef> sortedHiddenColumns = this.sortHiddenColumnDefs(tableDef.getHiddenColumnDefs());
        this.addIfNotEmpty(builder, "hiddenColumns", this.columnPropertyDefsToJson(sortedHiddenColumns));
        this.addIfNotEmpty(builder, "actions", this.actionDefsToJson(tableDef.getActionDefs()));
        if (this.requiresRowSelection(tableDef.getActionDefs())) {
            builder.add("requiresRowSelection", true);
            builder.add("rowSelectionProperty", "identity");
        } else {
            builder.add("requiresRowSelection", false);
            builder.add("rowSelectionProperty", "none");
        }
        builder.add("navigationProperty", "identity");
        PagePropertyDef defaultSortPropertyDef = this.getDefaultSortPropertyDef(tableDef);
        if (defaultSortPropertyDef != null) {
            builder.add("defaultSortProperty", defaultSortPropertyDef.getFormFieldName());
        }
        return builder.build();
    }

    private PagePropertyDef getDefaultSortPropertyDef(TableDef tableDef) {
        ArrayList<PagePropertyDef> allPropertyDefs = new ArrayList<PagePropertyDef>(tableDef.getDisplayedColumnDefs());
        allPropertyDefs.addAll(tableDef.getHiddenColumnDefs());
        for (PagePropertyDef propertyDef : allPropertyDefs) {
            if (!propertyDef.isKey()) continue;
            return propertyDef;
        }
        if (!allPropertyDefs.isEmpty()) {
            return (PagePropertyDef)allPropertyDefs.get(0);
        }
        return null;
    }

    private JsonObject sliceFormDefToJson(SliceFormDef sliceFormDef) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.addIfNotEmpty(builder, "slices", this.slicesDefToJson(sliceFormDef.getSlicesDef()));
        JsonArray properties = this.sliceFormPropertyDefsToJson(sliceFormDef.getPropertyDefs());
        JsonArray advancedProperties = this.sliceFormPropertyDefsToJson(sliceFormDef.getAdvancedPropertyDefs());
        JsonArray sections = this.sliceFormSectionDefsToJson(sliceFormDef.getSectionDefs());
        if (properties.isEmpty() && advancedProperties.isEmpty() && sections.isEmpty()) {
            builder.add("properties", (JsonValue)properties);
        } else {
            this.addIfNotEmpty(builder, "properties", properties);
            this.addIfNotEmpty(builder, "advancedProperties", advancedProperties);
            this.addIfNotEmpty(builder, "sections", sections);
        }
        this.addIfNotEmpty(builder, "presentation", this.sliceFormPresentationDefToJson(sliceFormDef.getPresentationDef()));
        this.addIfNotEmpty(builder, "actions", this.actionDefsToJson(sliceFormDef.getActionDefs()));
        builder.add(READ_ONLY, sliceFormDef.isReadOnly());
        return builder.build();
    }

    private JsonObject sliceTableDefToJson(SliceTableDef sliceTableDef) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.addIfNotEmpty(builder, "slices", this.slicesDefToJson(sliceTableDef.getSlicesDef()));
        this.addIfNotEmpty(builder, "displayedColumns", this.columnPropertyDefsToJson(sliceTableDef.getDisplayedColumnDefs()));
        List<PagePropertyDef> sortedHiddenColumns = this.sortHiddenColumnDefs(sliceTableDef.getHiddenColumnDefs());
        this.addIfNotEmpty(builder, "hiddenColumns", this.columnPropertyDefsToJson(sortedHiddenColumns));
        this.addIfNotEmpty(builder, "actions", this.actionDefsToJson(sliceTableDef.getActionDefs()));
        if (this.requiresRowSelection(sliceTableDef.getActionDefs())) {
            builder.add("requiresRowSelection", true);
            String rowSelectionProperty = sliceTableDef.isUseRowIdentities() ? "identity" : "identifier";
            builder.add("rowSelectionProperty", rowSelectionProperty);
        } else {
            builder.add("requiresRowSelection", false);
            builder.add("rowSelectionProperty", "none");
        }
        String navigationProperty = sliceTableDef.isSupportsNavigation() ? "identity" : "none";
        builder.add("navigationProperty", navigationProperty);
        builder.add(READ_ONLY, sliceTableDef.isReadOnly());
        return builder.build();
    }

    private JsonObject createFormDefToJson(CreateFormDef createFormDef) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.addIfNotEmpty(builder, "properties", this.createFormPropertyDefsToJson(createFormDef.getPropertyDefs()));
        this.addIfNotEmpty(builder, "sections", this.createFormSectionDefsToJson(createFormDef.getSectionDefs()));
        this.addIfNotEmpty(builder, "actions", this.actionDefsToJson(createFormDef.getActionDefs()));
        this.addIfNotEmpty(builder, "presentation", this.createFormPresentationDefToJson(createFormDef.getPresentationDef()));
        return builder.build();
    }

    private JsonObject actionInputFormDefToJson(ActionInputFormDef inputFormDef) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("properties", (JsonValue)this.actionParamDefsToJson(inputFormDef.getParamDefs()));
        this.addIfNotEmpty(builder, "presentation", this.actionInputFormPresentationDefToJson(inputFormDef.getPresentationDef()));
        return builder.build();
    }

    private JsonArray slicesDefToJson(SlicesDef slicesDef) {
        List<SliceDef> sliceDefs = slicesDef.getContentDefs();
        if (sliceDefs.size() == 1 && sliceDefs.get(0).getContentDefs().isEmpty()) {
            return null;
        }
        return this.sliceDefsToJson(sliceDefs);
    }

    private JsonArray sliceDefsToJson(List<SliceDef> sliceDefs) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (SliceDef sliceDef : sliceDefs) {
            builder.add((JsonValue)this.sliceDefToJson(sliceDef));
        }
        return builder.build();
    }

    private JsonObject sliceDefToJson(SliceDef sliceDef) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.addIfNotEmpty(builder, "name", sliceDef.getName());
        this.addIfNotEmpty(builder, "label", sliceDef.getLabel());
        this.addIfNotEmpty(builder, "slices", this.sliceDefsToJson(sliceDef.getContentDefs()));
        return builder.build();
    }

    private JsonArray sliceFormSectionDefsToJson(List<FormSectionDef> sectionDefs) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (FormSectionDef sectionDef : sectionDefs) {
            builder.add((JsonValue)this.sliceFormSectionDefToJson(sectionDef));
        }
        return builder.build();
    }

    private JsonArray createFormSectionDefsToJson(List<FormSectionDef> sectionDefs) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (FormSectionDef sectionDef : sectionDefs) {
            builder.add((JsonValue)this.createFormSectionDefToJson(sectionDef));
        }
        return builder.build();
    }

    private JsonObject sliceFormSectionDefToJson(FormSectionDef sectionDef) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.formSectionDefToJson(builder, sectionDef);
        this.addIfNotEmpty(builder, "properties", this.sliceFormPropertyDefsToJson(sectionDef.getPropertyDefs()));
        this.addIfNotEmpty(builder, "sections", this.sliceFormSectionDefsToJson(sectionDef.getSectionDefs()));
        return builder.build();
    }

    private JsonObject createFormSectionDefToJson(FormSectionDef sectionDef) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.formSectionDefToJson(builder, sectionDef);
        this.addIfNotEmpty(builder, "properties", this.createFormPropertyDefsToJson(sectionDef.getPropertyDefs()));
        this.addIfNotEmpty(builder, "sections", this.createFormSectionDefsToJson(sectionDef.getSectionDefs()));
        return builder.build();
    }

    private void formSectionDefToJson(JsonObjectBuilder builder, FormSectionDef sectionDef) {
        this.addIfNotEmpty(builder, "title", sectionDef.getTitle());
        this.addIfNotEmpty(builder, "introductionHTML", sectionDef.getIntroductionHTML());
        this.addIfNotEmpty(builder, "usedIf", this.usedIfDefToJson(sectionDef.getUsedIfDef()));
    }

    private List<PagePropertyDef> sortHiddenColumnDefs(List<PagePropertyDef> hiddenColumnDefs) {
        TreeMap<String, PagePropertyDef> sorter = new TreeMap<String, PagePropertyDef>();
        for (PagePropertyDef hiddenColumnDef : hiddenColumnDefs) {
            String sortingKey = this.ic.getLocalizer().localizeString(hiddenColumnDef.getLabel(), new Object[0]);
            sorter.put(sortingKey, hiddenColumnDef);
        }
        return List.copyOf(sorter.values());
    }

    private JsonArray columnPropertyDefsToJson(List<PagePropertyDef> propertyDefs) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (PagePropertyDef propertyDef : propertyDefs) {
            builder.add((JsonValue)this.columnPropertyDefToJson(propertyDef));
        }
        return builder.build();
    }

    private JsonObject columnPropertyDefToJson(PagePropertyDef propertyDef) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.propertyDefToJson(builder, propertyDef);
        this.addIfTrue(builder, "valueNotReturnedIfHidden", propertyDef.isDontReturnIfHiddenColumn());
        this.addIfTrue(builder, "key", propertyDef.isKey());
        return builder.build();
    }

    private JsonArray sliceFormPropertyDefsToJson(List<PagePropertyDef> propertyDefs) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (PagePropertyDef propertyDef : propertyDefs) {
            builder.add((JsonValue)this.sliceFormPropertyDefToJson(propertyDef));
        }
        return builder.build();
    }

    private JsonObject sliceFormPropertyDefToJson(PagePropertyDef propertyDef) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.formPropertyDefToJson(builder, propertyDef, propertyDef.isUpdateWritable());
        return builder.build();
    }

    private JsonArray createFormPropertyDefsToJson(List<PagePropertyDef> propertyDefs) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (PagePropertyDef propertyDef : propertyDefs) {
            builder.add((JsonValue)this.createFormPropertyDefToJson(propertyDef));
        }
        return builder.build();
    }

    private JsonObject createFormPropertyDefToJson(PagePropertyDef propertyDef) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.formPropertyDefToJson(builder, propertyDef, propertyDef.isCreateWritable());
        return builder.build();
    }

    private JsonArray actionParamDefsToJson(List<PageActionParamDef> paramDefs) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (PageActionParamDef paramDef : paramDefs) {
            builder.add((JsonValue)this.actionParamDefToJson(paramDef));
        }
        return builder.build();
    }

    private JsonObject actionParamDefToJson(PageActionParamDef paramDef) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.addIfTrue(builder, "ordered", paramDef.isOrdered());
        this.addIfNotEmpty(builder, "name", paramDef.getFormFieldName());
        this.addIfNotEmpty(builder, "label", paramDef.getLabel());
        this.addIfTrue(builder, READ_ONLY, paramDef.isReadOnly());
        this.addIfNotEmpty(builder, "helpLabel", paramDef.getLabel());
        this.addIfNotEmpty(builder, "type", this.getType(paramDef, true));
        this.addIfTrue(builder, "array", this.isArray(paramDef));
        this.addIfNotEmpty(builder, "helpSummaryHTML", paramDef.getHelpSummaryHTML());
        this.addIfNotEmpty(builder, "detailedHelpHTML", paramDef.getDetailedHelpHTML());
        this.addIfTrue(builder, "required", paramDef.isRequired());
        this.addIfNotEmpty(builder, "presentation", this.pageFieldPresentationDefToJson(paramDef.getPresentationDef()));
        this.addIfNotEmpty(builder, "legalValues", this.legalValueDefsToJson(paramDef.getLegalValueDefs()));
        return builder.build();
    }

    private JsonArray actionDefsToJson(List<PageActionDef> actionDefs) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (PageActionDef actionDef : actionDefs) {
            builder.add((JsonValue)this.actionDefToJson(actionDef));
        }
        return builder.build();
    }

    private boolean requiresRowSelection(List<PageActionDef> actionDefs) {
        for (PageActionDef actionDef : actionDefs) {
            if (!this.requiresRowSelection(actionDef)) continue;
            return true;
        }
        return false;
    }

    private boolean requiresRowSelection(PageActionDef actionDef) {
        if (this.requiresRowSelection(actionDef.getActionDefs())) {
            return true;
        }
        return actionDef.isInvokable() && !"none".equals(actionDef.getRows());
    }

    private JsonObject actionDefToJson(PageActionDef actionDef) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.addIfNotEmpty(builder, "name", actionDef.getActionPath().getDotSeparatedPath());
        this.addIfNotEmpty(builder, "label", actionDef.getLabel());
        if (actionDef.isInvokable()) {
            this.addIfNotEmpty(builder, "rows", actionDef.getRows());
            this.addIfNotEmpty(builder, "helpLabel", actionDef.getHelpLabel());
            this.addIfNotEmpty(builder, "helpSummaryHTML", actionDef.getHelpSummaryHTML());
            this.addIfNotEmpty(builder, "detailedHelpHTML", actionDef.getDetailedHelpHTML());
            this.addIfNotEmpty(builder, "externalHelp", this.pageActionExternalHelpDefToJson(actionDef.getExternalHelpDef()));
            this.addIfTrue(builder, "affectsChangeManager", this.actionAffectsChangeManager(actionDef));
        }
        this.addIfNotEmpty(builder, "actions", this.actionDefsToJson(actionDef.getActionDefs()));
        this.addIfNotEmpty(builder, "polling", this.pageActionPollingDefToJson(actionDef.getPollingDef()));
        return builder.build();
    }

    private boolean actionAffectsChangeManager(PageActionDef actionDef) {
        String impact;
        return this.ic.getPageRepo().isChangeManagerPageRepo() && ("action".equals(impact = actionDef.getImpact()) || "action_info".equals(impact));
    }

    private void formPropertyDefToJson(JsonObjectBuilder builder, PagePropertyDef propertyDef, boolean writable) {
        this.propertyDefToJson(builder, propertyDef);
        this.addIfTrue(builder, READ_ONLY, !writable);
        if (writable) {
            this.addIfNotUnknown(builder, "secureDefaultValue", propertyDef.getSecureDefaultValue());
            this.addIfNotUnknown(builder, "productionDefaultValue", propertyDef.getProductionDefaultValue());
            this.addIfNotUnknown(builder, "defaultValue", propertyDef.getDefaultValue());
        }
        this.addIfTrue(builder, "required", propertyDef.isRequired());
        this.addIfTrue(builder, "restartNeeded", writable && propertyDef.isRestartNeeded());
        this.addIfTrue(builder, "supportsModelTokens", propertyDef.isSupportsModelTokens());
        this.addIfTrue(builder, "supportsUnresolvedReferences", propertyDef.isSupportsUnresolvedReferences());
        this.addIfNotEmpty(builder, "presentation", this.pageFieldPresentationDefToJson(propertyDef.getPresentationDef()));
    }

    private void propertyDefToJson(JsonObjectBuilder builder, PagePropertyDef propertyDef) {
        this.addIfTrue(builder, "ordered", propertyDef.isOrdered());
        this.addIfNotEmpty(builder, "name", propertyDef.getFormFieldName());
        this.addIfNotEmpty(builder, "label", propertyDef.getLabel());
        this.addIfNotEmpty(builder, "helpLabel", propertyDef.getLabel());
        this.addIfNotEmpty(builder, "type", this.getPropertyType(propertyDef));
        this.addIfTrue(builder, "array", this.isArray(propertyDef));
        this.addIfNotEmpty(builder, "helpSummaryHTML", propertyDef.getHelpSummaryHTML());
        this.addIfNotEmpty(builder, "detailedHelpHTML", propertyDef.getDetailedHelpHTML());
        this.addIfNotEmpty(builder, "legalValues", this.legalValueDefsToJson(propertyDef.getLegalValueDefs()));
        this.addIfNotEmpty(builder, "usedIf", this.usedIfDefToJson(propertyDef.getUsedIfDef()));
        this.addIfNotEmpty(builder, "externalHelp", this.pagePropertyExternalHelpDefToJson(propertyDef.getExternalHelpDef()));
    }

    private JsonObject pagePropertyExternalHelpDefToJson(PagePropertyExternalHelpDef externalHelpDef) {
        if (externalHelpDef == null) {
            return null;
        }
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.addIfNotEmpty(builder, "title", externalHelpDef.getTitle());
        this.addIfNotEmpty(builder, "label", externalHelpDef.getLabel());
        this.addIfNotEmpty(builder, "introLabel", externalHelpDef.getIntroLabel());
        this.addIfNotEmpty(builder, "href", externalHelpDef.getHref());
        return builder.build();
    }

    private JsonObject pageActionExternalHelpDefToJson(PageActionExternalHelpDef externalHelpDef) {
        if (externalHelpDef == null) {
            return null;
        }
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.addIfNotEmpty(builder, "title", externalHelpDef.getTitle());
        this.addIfNotEmpty(builder, "label", externalHelpDef.getLabel());
        this.addIfNotEmpty(builder, "introLabel", externalHelpDef.getIntroLabel());
        this.addIfNotEmpty(builder, "href", externalHelpDef.getHref());
        return builder.build();
    }

    private JsonObject pageActionPollingDefToJson(PageActionPollingDef pollingDef) {
        if (pollingDef == null) {
            return null;
        }
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("reloadSeconds", pollingDef.getReloadSeconds());
        builder.add("maxAttempts", pollingDef.getMaxAttempts());
        return builder.build();
    }

    private JsonObject pageFieldPresentationDefToJson(PageFieldPresentationDef presentationDef) {
        if (presentationDef == null) {
            return null;
        }
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.addIfNotEmpty(builder, "inlineFieldHelp", presentationDef.getInlineFieldHelp());
        this.addIfTrue(builder, "displayAsHex", presentationDef.isDisplayAsHex());
        this.addIfNotEmpty(builder, "width", presentationDef.getWidth());
        return builder.build();
    }

    private JsonObject sliceFormPresentationDefToJson(SliceFormPresentationDef presentationDef) {
        if (presentationDef == null) {
            return null;
        }
        boolean singleColumn = this.computeIsSingleColumn(presentationDef.isSingleColumn(), presentationDef.getSliceFormDef().getAllPropertyDefs().size());
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.addIfTrue(builder, "singleColumn", singleColumn);
        this.addIfTrue(builder, "useCheckBoxesForBooleans", presentationDef.isUseCheckBoxesForBooleans());
        return builder.build();
    }

    private JsonObject createFormPresentationDefToJson(CreateFormPresentationDef presentationDef) {
        if (presentationDef == null) {
            return null;
        }
        boolean singleColumn = this.computeIsSingleColumn(presentationDef.isSingleColumn(), presentationDef.getCreateFormDef().getAllPropertyDefs().size());
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.addIfTrue(builder, "singleColumn", singleColumn);
        return builder.build();
    }

    private JsonObject actionInputFormPresentationDefToJson(ActionInputFormPresentationDef presentationDef) {
        if (presentationDef == null) {
            return null;
        }
        boolean singleColumn = this.computeIsSingleColumn(presentationDef.isSingleColumn(), presentationDef.getActionInputFormDef().getParamDefs().size());
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.addIfTrue(builder, "singleColumn", singleColumn);
        return builder.build();
    }

    private boolean computeIsSingleColumn(boolean configuredIsSingleColumn, int numberOfFormProperties) {
        if (!configuredIsSingleColumn) {
            return numberOfFormProperties <= 5;
        }
        return true;
    }

    private JsonObject usedIfDefToJson(UsedIfDef usedIfDef) {
        if (usedIfDef == null) {
            return null;
        }
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.addIfNotEmpty(builder, "property", usedIfDef.getPropertyDef().getFormFieldName());
        builder.add("values", (JsonValue)this.valuesToJson(usedIfDef.getValues()));
        return builder.build();
    }

    private JsonArray legalValueDefsToJson(List<LegalValueDef> legalValueDefs) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (LegalValueDef legalValueDef : legalValueDefs) {
            builder.add((JsonValue)this.legalValueDefToJson(legalValueDef));
        }
        return builder.build();
    }

    private JsonObject legalValueDefToJson(LegalValueDef legalValueDef) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("value", this.valueToJson(legalValueDef.getValue()));
        this.addIfNotEmpty(builder, "label", legalValueDef.getLabel());
        return builder.build();
    }

    private boolean isArray(BeanValueDef valueDef) {
        if (valueDef.isReferenceAsReferences()) {
            return false;
        }
        return valueDef.isArray();
    }

    private String getPropertyType(PagePropertyDef propertyDef) {
        return this.getType(propertyDef, this.isWritable(propertyDef));
    }

    private String getType(BeanValueDef valueDef, boolean writable) {
        if (valueDef.isString()) {
            if (valueDef.isMultiLineString()) {
                return "multiLineString";
            }
            if (writable && valueDef.isDynamicEnum()) {
                return "string-dynamic-enum";
            }
            return null;
        }
        if (valueDef.isInt()) {
            return "int";
        }
        if (valueDef.isLong()) {
            return "long";
        }
        if (valueDef.isDouble()) {
            return "double";
        }
        if (valueDef.isBoolean()) {
            return "boolean";
        }
        if (valueDef.isSecret()) {
            return "secret";
        }
        if (valueDef.isDate()) {
            return "date";
        }
        if (valueDef.isProperties()) {
            return "properties";
        }
        if (valueDef.isReference()) {
            return writable ? "reference-dynamic-enum" : "reference";
        }
        if (valueDef.isThrowable()) {
            return "throwable";
        }
        if (valueDef.isFileContents()) {
            return writable ? "fileContents" : "href";
        }
        if (valueDef.isHealthState()) {
            return null;
        }
        if (valueDef.isEntitleNetExpression()) {
            return "entitleNetExpression";
        }
        throw new AssertionError((Object)("Unknown value type: " + String.valueOf((Object)valueDef.getValueKind())));
    }

    private boolean isWritable(PagePropertyDef propertyDef) {
        PageDef pageDef = propertyDef.getPageDef();
        if (pageDef.isCreateFormDef()) {
            return propertyDef.isCreateWritable();
        }
        if (pageDef.isSliceFormDef()) {
            return propertyDef.isUpdateWritable();
        }
        if (pageDef.isSliceTableDef()) {
            return false;
        }
        if (pageDef.isTableDef()) {
            return false;
        }
        throw new AssertionError((Object)("Unsupported page type: " + String.valueOf(pageDef)));
    }

    private JsonArray valuesToJson(List<Value> values) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (Value value : values) {
            builder.add(this.valueToJson(value));
        }
        return builder.build();
    }

    private JsonValue valueToJson(Value value) {
        if (value.isString()) {
            String val = value.asString().getValue();
            if (val == null) {
                return JsonValue.NULL;
            }
            return Json.createValue((String)val);
        }
        if (value.isBoolean()) {
            if (value.asBoolean().getValue()) {
                return JsonValue.TRUE;
            }
            return JsonValue.FALSE;
        }
        if (value.isInt()) {
            return Json.createValue((int)value.asInt().getValue());
        }
        if (value.isLong()) {
            return Json.createValue((long)value.asLong().getValue());
        }
        if (value.isDouble()) {
            return Json.createValue((double)value.asDouble().getValue());
        }
        if (value.isArray()) {
            JsonArrayBuilder builder = Json.createArrayBuilder();
            for (Value val : value.asArray().getValues()) {
                builder.add(this.valueToJson(val));
            }
            return builder.build();
        }
        if (value.isNullReference()) {
            return JsonValue.NULL;
        }
        throw new AssertionError((Object)("Unsupported value: " + String.valueOf(value)));
    }

    private void addIfNotEmpty(JsonObjectBuilder builder, String name, LocalizableString localizableString) {
        this.addIfNotEmpty(builder, name, this.ic.getLocalizer().localizeString(localizableString, new Object[0]));
    }

    private void addIfNotEmpty(JsonObjectBuilder builder, String name, String value) {
        if (StringUtils.notEmpty((String)value)) {
            builder.add(name, value);
        }
    }

    private void addIfNotEmpty(JsonObjectBuilder builder, String name, JsonObject value) {
        if (value != null && !value.isEmpty()) {
            builder.add(name, (JsonValue)value);
        }
    }

    private void addIfNotEmpty(JsonObjectBuilder builder, String name, JsonArray value) {
        if (value != null && !value.isEmpty()) {
            builder.add(name, (JsonValue)value);
        }
    }

    private void addIfNotUnknown(JsonObjectBuilder builder, String name, Value value) {
        if (!value.isUnknown()) {
            builder.add(name, this.valueToJson(value));
        }
    }

    private void addIfTrue(JsonObjectBuilder builder, String name, boolean value) {
        if (value) {
            builder.add(name, value);
        }
    }
}

