/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import weblogic.remoteconsole.common.repodef.LocalizedConstants;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Value;

public class Option {
    private String label;
    private Value value;

    public Option(InvocationContext ic, Value value) {
        this(Option.computeLabel(ic, value), value);
    }

    public Option(String label, Value value) {
        this.label = label;
        this.value = value;
    }

    private static String computeLabel(InvocationContext ic, Value value) {
        if (value.isNullReference()) {
            return ic.getLocalizer().localizeString(LocalizedConstants.NULL_REFERENCE, new Object[0]);
        }
        if (value.isBeanTreePath()) {
            return value.asBeanTreePath().getLastSegment().getKey();
        }
        throw new AssertionError((Object)("Non-reference options are not supported yet: " + String.valueOf(value)));
    }

    public String getLabel() {
        return this.label;
    }

    public Value getValue() {
        return this.value;
    }

    public String toString() {
        return "Option<" + this.getLabel() + ", " + String.valueOf(this.getValue()) + ">";
    }
}

