/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import java.util.ArrayList;
import java.util.List;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanChildDef;
import weblogic.remoteconsole.common.repodef.BeanChildNavTreeNodeDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.GroupNavTreeNodeDef;
import weblogic.remoteconsole.common.repodef.NavTreeDef;
import weblogic.remoteconsole.common.repodef.NavTreeNodeDef;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchResults;
import weblogic.remoteconsole.server.repo.BeanSearchResults;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.NavTreeNode;
import weblogic.remoteconsole.server.repo.NavTreePath;
import weblogic.remoteconsole.server.repo.PageReader;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.UnsuccessfulResponseException;
import weblogic.remoteconsole.server.repo.Value;

class NavTreeReader
extends PageReader {
    SearchManager searchManager = new SearchManager();

    NavTreeReader(InvocationContext invocationContext) {
        super(invocationContext);
    }

    Response<List<NavTreeNode>> expandNavTreeNodes(List<NavTreeNode> nodesToExpand) {
        Response<List<NavTreeNode>> response = new Response<List<NavTreeNode>>();
        try {
            Response<Void> searchResponse = this.performSearch(nodesToExpand);
            if (!searchResponse.isSuccess()) {
                return response.copyUnsuccessfulResponse(searchResponse);
            }
            return response.setSuccess(this.expandNodes(nodesToExpand));
        }
        catch (UnsuccessfulResponseException e) {
            return response.copyUnsuccessfulResponse(e.getUnsuccessfulResponse());
        }
    }

    private Response<Void> performSearch(List<NavTreeNode> nodesToExpand) {
        SearchBuilder searchBuilder = new SearchBuilder();
        searchBuilder.addNodesToExpand(new Path(), this.getRootNodeDefs(), nodesToExpand);
        return this.searchManager.performSearch();
    }

    private List<NavTreeNode> expandNodes(List<NavTreeNode> nodesToExpand) {
        NodeExpander nodeExpander = new NodeExpander();
        return nodeExpander.expandNodes(new Path(), this.getRootNodeDefs(), nodesToExpand);
    }

    private NavTreeNode findNodeToExpand(NavTreeNodeDef nodeDef, List<NavTreeNode> nodesToExpand) {
        return this.findNodeToExpand(nodeDef.getNodeName(), nodesToExpand);
    }

    private NavTreeNode findNodeToExpand(String name, List<NavTreeNode> nodesToExpand) {
        for (NavTreeNode nodeToExpand : nodesToExpand) {
            if (!nodeToExpand.isExpanded() || !name.equals(nodeToExpand.getName())) continue;
            return nodeToExpand;
        }
        return null;
    }

    private List<NavTreeNodeDef> getRootNodeDefs() {
        return this.getNodeDefs(this.getPageRepoDef().getRootNavTreeDef());
    }

    private List<NavTreeNodeDef> getNodeDefs(BeanTypeDef typeDef, boolean includeSubTypes) {
        if (includeSubTypes && typeDef.isHeterogeneous()) {
            ArrayList<NavTreeNodeDef> allNodeDefs = null;
            for (String discriminator : typeDef.getSubTypeDiscriminatorLegalValues()) {
                List<NavTreeNodeDef> nodeDefs = this.getNodeDefs(typeDef.getSubTypeDef(discriminator));
                if (nodeDefs == null || nodeDefs.isEmpty()) continue;
                if (allNodeDefs == null) {
                    allNodeDefs = new ArrayList<NavTreeNodeDef>(nodeDefs);
                    continue;
                }
                allNodeDefs.addAll(nodeDefs);
            }
            return allNodeDefs;
        }
        return this.getNodeDefs(typeDef);
    }

    private List<NavTreeNodeDef> getNodeDefs(BeanTypeDef typeDef) {
        return this.getNodeDefs(this.getPageRepoDef().getNavTreeDef(typeDef));
    }

    private List<NavTreeNodeDef> getNodeDefs(NavTreeDef navTreeDef) {
        return navTreeDef != null ? navTreeDef.getContentDefs() : null;
    }

    private class SearchManager {
        private SearchWrapper primarySearch;
        private SearchWrapper parsedDeploymentsSearch;

        private SearchManager() {
            this.primarySearch = new SearchWrapper();
            this.parsedDeploymentsSearch = new SearchWrapper();
        }

        private SearchWrapper getSearchWrapper(BeanTreePath btp) {
            if (this.needsParsedDeployment(btp)) {
                return this.parsedDeploymentsSearch;
            }
            return this.primarySearch;
        }

        private Response<Void> performSearch() {
            Response response = new Response();
            Response<Void> searchResponse = this.primarySearch.performSearch();
            if (!searchResponse.isSuccess()) {
                return response.copyUnsuccessfulResponse(searchResponse);
            }
            searchResponse = this.parsedDeploymentsSearch.performSearch();
            if (!searchResponse.isSuccess()) {
                return response.copyUnsuccessfulResponse(searchResponse);
            }
            return response.setSuccess(null);
        }

        private boolean needsParsedDeployment(BeanTreePath btp) {
            List c = btp.getPath().getComponents();
            return c.size() > 6 && "Deployment".equals(c.get(5)) && "Configuration".equals(c.get(4)) && "AppDeploymentRuntimes".equals(c.get(2));
        }
    }

    private class SearchBuilder {
        private SearchBuilder() {
        }

        private void addNodesToExpand(Path parentNavTreePath, List<NavTreeNodeDef> nodeDefs, List<NavTreeNode> nodesToExpand) {
            if (nodeDefs == null) {
                return;
            }
            for (NavTreeNodeDef nodeDef : nodeDefs) {
                this.addNodeToExpand(parentNavTreePath, nodeDef, NavTreeReader.this.findNodeToExpand(nodeDef, nodesToExpand));
            }
        }

        private void addNodeToExpand(Path parentNavTreePath, NavTreeNodeDef nodeDef, NavTreeNode nodeToExpand) {
            String nodeName = nodeToExpand != null ? nodeToExpand.getName() : nodeDef.getNodeName();
            NavTreePath navTreePath = new NavTreePath(NavTreeReader.this.getPageRepo(), parentNavTreePath.childPath(nodeName));
            if (nodeDef.isChildNodeDef()) {
                BeanChildNavTreeNodeDef childNodeDef = nodeDef.asChildNodeDef();
                if (!childNodeDef.isForceNotExpandable()) {
                    BeanTreePath beanPath = navTreePath.getLastSegment().getBeanTreePath();
                    BeanTypeDef typeDef = beanPath.getTypeDef();
                    NavTreeReader.this.addCollectionToSearch(this.getSearchBuilder(beanPath), beanPath, List.of(typeDef.getIdentityPropertyDef()));
                    if (beanPath.isCollection()) {
                        this.addCollectionNodeChildrenToExpand(navTreePath, childNodeDef, nodeToExpand);
                    } else {
                        this.addChildNodeChildrenToExpand(navTreePath, childNodeDef, nodeToExpand);
                    }
                }
            } else if (nodeDef.isGroupNodeDef()) {
                this.addGroupNodeChildrenToExpand(navTreePath, nodeDef.asGroupNodeDef(), nodeToExpand);
            } else {
                throw new AssertionError((Object)"NavTreeNodeDef is not a group or child");
            }
        }

        private void addGroupNodeChildrenToExpand(NavTreePath groupNavTreePath, GroupNavTreeNodeDef groupNodeDef, NavTreeNode groupNodeToExpand) {
            if (groupNodeToExpand != null) {
                this.addNodesToExpand(groupNavTreePath.getPath(), groupNodeDef.getContentDefs(), groupNodeToExpand.getContents());
            }
        }

        private void addCollectionNodeChildrenToExpand(NavTreePath collectionNavTreePath, BeanChildNavTreeNodeDef collectionNodeDef, NavTreeNode collectionNodeToExpand) {
            List<NavTreeNode> collectionChildNodesToExpand;
            if (collectionNodeToExpand != null && (collectionChildNodesToExpand = collectionNodeToExpand.getContents()) != null) {
                for (NavTreeNode collectionChildNodeToExpand : collectionChildNodesToExpand) {
                    this.addNodeToExpand(collectionNavTreePath.getPath(), collectionNodeDef, collectionChildNodeToExpand);
                }
            }
        }

        private void addChildNodeChildrenToExpand(NavTreePath childNavTreePath, BeanChildNavTreeNodeDef childNodeDef, NavTreeNode childNodeToExpand) {
            if (childNodeToExpand != null) {
                this.addNodesToExpand(childNavTreePath.getPath(), NavTreeReader.this.getNodeDefs(childNodeDef.getLastChildDef().getChildTypeDef(), true), childNodeToExpand.getContents());
            }
        }

        private BeanReaderRepoSearchBuilder getSearchBuilder(BeanTreePath btp) {
            return NavTreeReader.this.searchManager.getSearchWrapper(btp).getSearchBuilder();
        }
    }

    private class NodeExpander {
        private NodeExpander() {
        }

        private List<NavTreeNode> expandNodes(Path parentNavTreePath, List<NavTreeNodeDef> nodeDefs, List<NavTreeNode> nodesToExpand) {
            ArrayList<NavTreeNode> expandedNodes = new ArrayList<NavTreeNode>();
            for (NavTreeNodeDef nodeDef : nodeDefs) {
                NavTreeNode expandedNode = this.expandNode(parentNavTreePath, nodeDef, NavTreeReader.this.findNodeToExpand(nodeDef, nodesToExpand));
                if (expandedNode == null) continue;
                expandedNodes.add(expandedNode);
            }
            return expandedNodes;
        }

        private NavTreeNode expandNode(Path parentNavTreePath, NavTreeNodeDef nodeDef, NavTreeNode nodeToExpand) {
            String name = nodeDef.getNodeName();
            NavTreePath navTreePath = new NavTreePath(NavTreeReader.this.getPageRepo(), parentNavTreePath.childPath(name));
            NavTreeNode expandedNode = new NavTreeNode();
            expandedNode.setName(name);
            expandedNode.setExpanded(nodeToExpand != null);
            if (nodeDef.isGroupNodeDef()) {
                return this.completeGroupNode(expandedNode, navTreePath, nodeDef.asGroupNodeDef(), nodeToExpand);
            }
            if (nodeDef.isChildNodeDef()) {
                return this.completeChildNode(expandedNode, navTreePath, nodeDef.asChildNodeDef(), nodeToExpand);
            }
            throw new AssertionError((Object)"NavTreeNodeDef is not a group or child");
        }

        private NavTreeNode completeGroupNode(NavTreeNode nodeToComplete, NavTreePath navTreePath, GroupNavTreeNodeDef groupNodeDef, NavTreeNode nodeToExpand) {
            nodeToComplete.setLabel(NavTreeReader.this.getLocalizer().localizeString(groupNodeDef.getLabel(), new Object[0]));
            nodeToComplete.setSelectable(false);
            List<NavTreeNodeDef> contentsNodeDefs = groupNodeDef.getContentDefs();
            nodeToComplete.setType(NavTreeNode.Type.GROUP);
            if (contentsNodeDefs.isEmpty()) {
                nodeToComplete.setExpandable(false);
            } else {
                nodeToComplete.setExpandable(true);
                if (nodeToExpand != null) {
                    nodeToComplete.setContents(this.expandNodes(navTreePath.getPath(), contentsNodeDefs, nodeToExpand.getContents()));
                }
            }
            return nodeToComplete;
        }

        private NavTreeNode completeChildNode(NavTreeNode nodeToComplete, NavTreePath navTreePath, BeanChildNavTreeNodeDef childNodeDef, NavTreeNode nodeToExpand) {
            BeanChildDef childDef = childNodeDef.getLastChildDef();
            BeanTreePath beanPath = navTreePath.getLastSegment().getBeanTreePath();
            nodeToComplete.setResourceData(beanPath);
            nodeToComplete.setLabel(NavTreeReader.this.getLocalizer().localizeString(childNodeDef.getLabel(), new Object[0]));
            if (childDef.isCollection()) {
                return this.completeCollectionNode(nodeToComplete, navTreePath, childNodeDef, nodeToExpand);
            }
            if (childDef.isMandatorySingleton() || childDef.isOptionalSingleton()) {
                return this.completeSingletonNode(nodeToComplete, navTreePath, childNodeDef, nodeToExpand);
            }
            throw new AssertionError((Object)(String.valueOf(childDef) + " is not a collection, mandatory singleton or optional singleton"));
        }

        private NavTreeNode completeCollectionNode(NavTreeNode nodeToComplete, NavTreePath navTreePath, BeanChildNavTreeNodeDef childNodeDef, NavTreeNode nodeToExpand) {
            if (childNodeDef.isForceNotExpandable()) {
                nodeToComplete.setSelectable(true);
                nodeToComplete.setType(NavTreeNode.Type.COLLECTION);
                nodeToComplete.setExpandable(false);
                nodeToComplete.setExpanded(false);
                return nodeToComplete;
            }
            Response<List<BeanSearchResults>> getCollectionResponse = NavTreeReader.this.getCollectionResults(this.getSearchResults(navTreePath.getLastSegment().getBeanTreePath()), nodeToComplete.getResourceData(), List.of(nodeToComplete.getResourceData().getTypeDef().getIdentityPropertyDef()));
            List<BeanSearchResults> collectionResults = null;
            collectionResults = getCollectionResponse.isSuccess() ? getCollectionResponse.getResults() : null;
            if (collectionResults == null) {
                return null;
            }
            nodeToComplete.setSelectable(true);
            nodeToComplete.setType(NavTreeNode.Type.COLLECTION);
            if (collectionResults.isEmpty()) {
                nodeToComplete.setExpandable(false);
                nodeToComplete.setExpanded(false);
            } else {
                nodeToComplete.setExpandable(true);
                if (nodeToExpand != null) {
                    nodeToComplete.setExpanded(true);
                    nodeToComplete.setContents(this.expandCollectionChildNodes(childNodeDef, collectionResults, nodeToExpand));
                } else {
                    nodeToComplete.setExpanded(false);
                }
            }
            return nodeToComplete;
        }

        private List<NavTreeNode> expandCollectionChildNodes(BeanChildNavTreeNodeDef collectionNodeDef, List<BeanSearchResults> collectionResults, NavTreeNode collectionNodeToExpand) {
            List<NavTreeNode> collectionChildNodesToExpand = collectionNodeToExpand.getContents();
            ArrayList<NavTreeNode> nodes = new ArrayList<NavTreeNode>();
            for (BeanSearchResults collectionChildResults : collectionResults) {
                NavTreeNode node = this.expandCollectionChildNode(collectionNodeDef, collectionChildResults, collectionChildNodesToExpand);
                if (node == null) continue;
                nodes.add(node);
            }
            return nodes;
        }

        private NavTreeNode expandCollectionChildNode(BeanChildNavTreeNodeDef collectionNodeDef, BeanSearchResults childResults, List<NavTreeNode> childNodesToExpand) {
            BeanChildDef childDef = collectionNodeDef.getLastChildDef();
            String key = this.getStringValue(childResults.getValue(childDef.getChildTypeDef().getKeyPropertyDef()));
            NavTreeNode node = new NavTreeNode();
            node.setType(NavTreeNode.Type.COLLECTION_CHILD);
            node.setSelectable(true);
            node.setName(key);
            node.setLabel(key);
            node.setResourceData(childResults.getBeanTreePath());
            this.expandChildChildrenNodes(node, NavTreeReader.this.findNodeToExpand(key, childNodesToExpand));
            return node;
        }

        private String getStringValue(Value value) {
            if (value.isString()) {
                return value.asString().getValue();
            }
            throw new AssertionError((Object)("Non-string value: " + String.valueOf(value)));
        }

        private NavTreeNode completeSingletonNode(NavTreeNode nodeToComplete, NavTreePath navTreePath, BeanChildNavTreeNodeDef childNodeDef, NavTreeNode nodeToExpand) {
            nodeToComplete.setSelectable(true);
            BeanTreePath beanPath = navTreePath.getLastSegment().getBeanTreePath();
            if (beanPath.getLastSegment().getChildDef().isRoot()) {
                nodeToComplete.setType(NavTreeNode.Type.ROOT);
            } else {
                nodeToComplete.setType(NavTreeNode.Type.SINGLETON);
            }
            BeanSearchResults singletonResults = this.getSearchResults(beanPath).getBean(nodeToComplete.getResourceData());
            if (singletonResults != null) {
                this.expandChildChildrenNodes(nodeToComplete, nodeToExpand);
            } else if (beanPath.isCreatable()) {
                nodeToComplete.setExpandable(false);
            } else if (beanPath.getLastSegment().getChildDef().isOptional()) {
                nodeToComplete.setExpandable(false);
            } else {
                return null;
            }
            return nodeToComplete;
        }

        private void expandChildChildrenNodes(NavTreeNode nodeToComplete, NavTreeNode nodeToExpand) {
            List<NavTreeNodeDef> nodeDefs = NavTreeReader.this.getNodeDefs(this.getChildTypeDef(nodeToComplete));
            if (nodeDefs != null) {
                nodeToComplete.setExpandable(true);
                if (nodeToExpand != null) {
                    nodeToComplete.setExpanded(true);
                    NavTreePath navTreePath = new NavTreePath(NavTreeReader.this.getPageRepo(), nodeToComplete.getResourceData());
                    nodeToComplete.setContents(this.expandNodes(navTreePath.getPath(), nodeDefs, nodeToExpand.getContents()));
                } else {
                    nodeToComplete.setExpanded(false);
                }
            } else {
                nodeToComplete.setExpandable(false);
            }
        }

        private BeanTypeDef getChildTypeDef(NavTreeNode nodeToComplete) {
            Response<BeanTypeDef> response = NavTreeReader.this.getActualTypeDef(nodeToComplete.getResourceData(), this.getSearchResults(nodeToComplete.getResourceData()));
            if (!response.isSuccess()) {
                throw new UnsuccessfulResponseException(response);
            }
            return response.getResults();
        }

        private BeanReaderRepoSearchResults getSearchResults(BeanTreePath btp) {
            return NavTreeReader.this.searchManager.getSearchWrapper(btp).getSearchResults();
        }
    }

    private class SearchWrapper {
        private BeanReaderRepoSearchBuilder searchBuilder;
        private BeanReaderRepoSearchResults searchResults;

        private SearchWrapper() {
        }

        private BeanReaderRepoSearchBuilder getSearchBuilder() {
            if (this.searchBuilder == null) {
                this.searchBuilder = NavTreeReader.this.getBeanRepo().asBeanReaderRepo().createSearchBuilder(NavTreeReader.this.getInvocationContext(), false);
            }
            return this.searchBuilder;
        }

        private Response<Void> performSearch() {
            Response response = new Response();
            if (this.searchBuilder != null) {
                Response<BeanReaderRepoSearchResults> searchResponse = this.searchBuilder.search();
                if (!searchResponse.isSuccess()) {
                    return response.copyUnsuccessfulResponse(searchResponse);
                }
                this.searchResults = searchResponse.getResults();
            }
            return response.setSuccess(null);
        }

        private BeanReaderRepoSearchResults getSearchResults() {
            return this.searchResults;
        }
    }
}

