/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import java.util.ArrayList;
import java.util.List;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanChildDef;
import weblogic.remoteconsole.common.repodef.BeanChildNavTreeNodeDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.NavTreeDef;
import weblogic.remoteconsole.common.repodef.NavTreeNodeDef;
import weblogic.remoteconsole.common.utils.UrlUtils;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.NavTreePathSegment;
import weblogic.remoteconsole.server.repo.PageRepo;

public class NavTreePath {
    private PageRepo pageRepo;
    private Path path;
    private List<NavTreePathSegment> segments = new ArrayList<NavTreePathSegment>();

    public NavTreePath(InvocationContext ic) {
        this(ic.getPageRepo(), ic.getBeanTreePath());
    }

    public NavTreePath(PageRepo pageRepo, BeanTreePath beanTreePath) {
        this.pageRepo = pageRepo;
        this.path = this.computeNavTreePathFromBeanTreePath(beanTreePath);
        this.initialize();
    }

    public NavTreePath(PageRepo pageRepo, Path navTreePath) {
        this.pageRepo = pageRepo;
        this.path = navTreePath;
        this.initialize();
    }

    public PageRepo getPageRepo() {
        return this.pageRepo;
    }

    public Path getPath() {
        return this.path;
    }

    public List<NavTreePathSegment> getSegments() {
        return this.segments;
    }

    private void initialize() {
        BeanTypeDef typeDef = null;
        Path beanTreePath = new Path();
        Path typeRelativeNavTreePath = new Path();
        List components = this.getPath().getComponents();
        for (int i = 0; i < components.size(); ++i) {
            String component = (String)components.get(i);
            typeRelativeNavTreePath.addComponent(component);
            NavTreeNodeDef nodeDef = this.findNodeByNavTreePathInTypeOrSubType(typeDef, typeRelativeNavTreePath);
            if (nodeDef.isChildNodeDef()) {
                List<BeanChildDef> childDefs = nodeDef.asChildNodeDef().getChildDefs();
                for (BeanChildDef childDef : childDefs) {
                    beanTreePath.addPath(childDef.getChildPath());
                }
                BeanChildDef lastChildDef = childDefs.get(childDefs.size() - 1);
                if (lastChildDef.isCollection() && i < components.size() - 1) {
                    String key = (String)components.get(++i);
                    beanTreePath.addComponent(key);
                }
                this.getSegments().add(new NavTreePathSegment(this, nodeDef.asChildNodeDef(), BeanTreePath.create(this.getPageRepo().getBeanRepo(), beanTreePath)));
                typeDef = lastChildDef.getChildTypeDef();
                typeRelativeNavTreePath = new Path();
                continue;
            }
            this.getSegments().add(new NavTreePathSegment(this, nodeDef.asGroupNodeDef()));
        }
    }

    private Path computeNavTreePathFromBeanTreePath(BeanTreePath beanTreePath) {
        Path navTreePath = new Path();
        Path restOfBeanTreePath = beanTreePath.getPath();
        BeanTypeDef typeDef = null;
        while (!restOfBeanTreePath.isEmpty()) {
            BeanChildNavTreeNodeDef nodeDef = this.findMostSpecificMatchingNodeInTypeOrSubTypes(beanTreePath, typeDef, restOfBeanTreePath);
            navTreePath.addPath(nodeDef.getNodePath());
            restOfBeanTreePath = restOfBeanTreePath.subPath(nodeDef.getChildNodePath().length(), restOfBeanTreePath.length());
            if (nodeDef.getLastChildDef().isCollection() && !restOfBeanTreePath.isEmpty()) {
                navTreePath.addComponent(restOfBeanTreePath.getFirstComponent());
                restOfBeanTreePath = restOfBeanTreePath.subPath(1, restOfBeanTreePath.length());
            }
            typeDef = nodeDef.getLastChildDef().getChildTypeDef();
        }
        return navTreePath;
    }

    private BeanChildNavTreeNodeDef findMostSpecificMatchingNodeInTypeOrSubTypes(BeanTreePath beanTreePath, BeanTypeDef typeDef, Path restOfBeanTreePath) {
        BeanChildNavTreeNodeDef nodeDef = this.findMostSpecificMatchingNodeInType(typeDef, restOfBeanTreePath);
        if (nodeDef != null) {
            return nodeDef;
        }
        if (typeDef != null && typeDef.isHeterogeneous()) {
            for (String discriminator : typeDef.getSubTypeDiscriminatorLegalValues()) {
                BeanTypeDef subTypeDef = typeDef.getSubTypeDef(discriminator);
                if (subTypeDef.getTypeName().equals(typeDef.getTypeName()) || (nodeDef = this.findMostSpecificMatchingNodeInType(subTypeDef, restOfBeanTreePath)) == null) continue;
                return nodeDef;
            }
        }
        throw new AssertionError((Object)("Couldn't find navigation node: " + String.valueOf(typeDef) + " " + String.valueOf(restOfBeanTreePath) + " " + String.valueOf(beanTreePath)));
    }

    private BeanChildNavTreeNodeDef findMostSpecificMatchingNodeInType(BeanTypeDef typeDef, Path restOfBeanTreePath) {
        NavTreeDef navTreeDef = this.getNavTreeDef(typeDef);
        if (navTreeDef == null) {
            return null;
        }
        Path relativeChildPath = restOfBeanTreePath;
        while (!relativeChildPath.isEmpty()) {
            BeanChildNavTreeNodeDef nodeDef = navTreeDef.findNodeByChildPath(relativeChildPath);
            if (nodeDef != null) {
                return nodeDef;
            }
            relativeChildPath = relativeChildPath.getParent();
        }
        return null;
    }

    NavTreeNodeDef findNodeByNavTreePathInTypeOrSubType(BeanTypeDef typeDef, Path typeRelativeNavTreePath) {
        NavTreeNodeDef nodeDef = this.findNodeByNavTreePathInType(typeDef, typeRelativeNavTreePath);
        if (nodeDef != null) {
            return nodeDef;
        }
        if (typeDef.isHeterogeneous()) {
            for (String discriminator : typeDef.getSubTypeDiscriminatorLegalValues()) {
                BeanTypeDef subTypeDef = typeDef.getSubTypeDef(discriminator);
                if (subTypeDef.getTypeName().equals(typeDef.getTypeName()) || (nodeDef = this.findNodeByNavTreePathInType(subTypeDef, typeRelativeNavTreePath)) == null) continue;
                return nodeDef;
            }
        }
        throw new AssertionError((Object)("Couldn't find navigation node: " + String.valueOf(typeDef) + " " + String.valueOf(typeRelativeNavTreePath)));
    }

    NavTreeNodeDef findNodeByNavTreePathInType(BeanTypeDef typeDef, Path typeRelativeNavTreePath) {
        NavTreeDef navTreeDef = this.getNavTreeDef(typeDef);
        if (navTreeDef == null) {
            return null;
        }
        return navTreeDef.findNodeByNavTreePath(typeRelativeNavTreePath);
    }

    NavTreeDef getNavTreeDef(BeanTypeDef typeDef) {
        return typeDef != null ? this.getPageRepo().getPageRepoDef().getNavTreeDef(typeDef) : this.getPageRepo().getPageRepoDef().getRootNavTreeDef();
    }

    public String toString() {
        return UrlUtils.pathToRelativeUri(this.getPath());
    }

    public boolean isRoot() {
        return this.getSegments().isEmpty();
    }

    public NavTreePathSegment getLastSegment() {
        return this.isRoot() ? null : this.getSegments().get(this.getSegments().size() - 1);
    }
}

