/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import weblogic.remoteconsole.common.repodef.Localizer;
import weblogic.remoteconsole.common.repodef.PagePath;
import weblogic.remoteconsole.common.repodef.weblogic.WebLogicLocalizationUtils;
import weblogic.remoteconsole.common.utils.WebLogicVersions;
import weblogic.remoteconsole.server.ConsoleBackendRuntime;
import weblogic.remoteconsole.server.connection.Connection;
import weblogic.remoteconsole.server.connection.ConnectionManager;
import weblogic.remoteconsole.server.providers.Provider;
import weblogic.remoteconsole.server.providers.Root;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.Frontend;
import weblogic.remoteconsole.server.repo.PageRepo;

public class InvocationContext {
    public static final String CONSOLE_BACKEND_SESSION_ID = "wls.console.backend.session";
    private Frontend frontend;
    private Connection connection;
    private List<Locale> locales;
    private PageRepo pageRepo;
    private Provider provider;
    private Localizer localizer;
    private BeanTreePath beanTreePath;
    private String identifier;
    private List<String> identifiers;
    private List<BeanTreePath> identities;
    private HashSet<String> properties;
    private boolean reload;
    private UriInfo uriInfo;
    private String user;
    private PagePath pagePath;
    private Map<String, Object> cache = new ConcurrentHashMap<String, Object>();

    public InvocationContext() {
        this.setLocales(new ArrayList<Locale>());
    }

    public InvocationContext(ResourceContext resourceContext, HttpHeaders httpHeaders, UriInfo uriInfo) {
        this.setLocales(InvocationContext.getLocales(httpHeaders));
        this.setConnection(InvocationContext.getConnection(resourceContext));
        this.setUriInfo(uriInfo);
        this.uriInfo = uriInfo;
    }

    public InvocationContext(InvocationContext toClone) {
        this.connection = toClone.connection;
        this.locales = toClone.locales;
        this.pageRepo = toClone.pageRepo;
        this.provider = toClone.provider;
        this.localizer = toClone.localizer;
        this.beanTreePath = toClone.beanTreePath;
        this.identifier = toClone.identifier;
        this.identifiers = toClone.identifiers;
        this.identities = toClone.identities;
        this.properties = toClone.properties;
        this.reload = toClone.reload;
        this.uriInfo = toClone.uriInfo;
        this.pagePath = toClone.pagePath;
        this.user = toClone.user;
        this.frontend = toClone.frontend;
        this.cache = toClone.cache;
    }

    public InvocationContext(InvocationContext toClone, BeanTreePath beanTreePath) {
        this(toClone);
        this.setIdentity(beanTreePath);
    }

    public InvocationContext clone() {
        return new InvocationContext(this);
    }

    public InvocationContext clone(BeanTreePath beanTreePath) {
        return new InvocationContext(this, beanTreePath);
    }

    public PageRepo getPageRepo() {
        return this.pageRepo;
    }

    public void setPageRepo(PageRepo pageRepo) {
        this.pageRepo = pageRepo;
        this.localizer = new Localizer(pageRepo.getPageRepoDef().getResourceBundleName(), this.locales);
    }

    public boolean setPageRepoByName(String rootName) {
        Root root = this.provider.getRoots().get(rootName);
        if (root == null) {
            return false;
        }
        this.setPageRepo(root.getPageRepo());
        return true;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
    }

    public Localizer getLocalizer() {
        return this.localizer;
    }

    public BeanTreePath getBeanTreePath() {
        return this.beanTreePath;
    }

    public void setIdentity(BeanTreePath beanTreePath) {
        this.beanTreePath = beanTreePath;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public List<String> getIdentifiers() {
        return this.identifiers;
    }

    public void setIdentifiers(List<String> identifiers) {
        this.identifiers = identifiers;
    }

    public List<BeanTreePath> getIdentities() {
        return this.identities;
    }

    public void setIdentities(List<BeanTreePath> identities) {
        this.identities = identities;
    }

    public PagePath getPagePath() {
        return this.pagePath;
    }

    public void setPagePath(PagePath pagePath) {
        this.pagePath = pagePath;
    }

    public boolean filtersProperties() {
        return this.properties != null;
    }

    public boolean includeProperty(String propertyName) {
        if (!this.filtersProperties()) {
            return true;
        }
        return this.properties.contains(propertyName);
    }

    public void setProperties(String commaSeparatedPropertyNames) {
        if (commaSeparatedPropertyNames == null) {
            this.properties = null;
        } else {
            this.properties = new HashSet();
            for (String property : commaSeparatedPropertyNames.split(",")) {
                this.properties.add(property.trim());
            }
        }
    }

    public boolean isReload() {
        return this.reload;
    }

    public void setReload(boolean reload) {
        this.reload = reload;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void setLocales(List<Locale> locales) {
        this.locales = locales;
        this.localizer = new Localizer(WebLogicLocalizationUtils.getResourceBundleName(WebLogicVersions.getLatestVersion().getDomainVersion()), this.locales);
    }

    public void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    private String getDomainVersion() {
        return this.connection != null ? this.connection.getWebLogicVersion().getDomainVersion() : null;
    }

    public Connection getConnection() {
        return this.connection;
    }

    private static Connection getConnection(ResourceContext resourceContext) {
        String connectionId = InvocationContext.getConnectionId(resourceContext);
        if (connectionId == null) {
            return null;
        }
        ConnectionManager cm = ConsoleBackendRuntime.INSTANCE.getConnectionManager();
        if (!cm.isValidConnection(connectionId)) {
            throw new AssertionError((Object)("Invalid connection id: " + connectionId));
        }
        Connection connection = cm.getConnection(connectionId);
        if (connection == null) {
            throw new AssertionError((Object)("Connection not found: " + connectionId));
        }
        return connection;
    }

    private static String getConnectionId(ResourceContext resourceContext) {
        return InvocationContext.getStandaloneModeConnectionId(resourceContext);
    }

    private static String getStandaloneModeConnectionId(ResourceContext resourceContext) {
        if (resourceContext == null) {
            throw new AssertionError((Object)"Null ResourceContext");
        }
        ContainerRequestContext reqCtx = (ContainerRequestContext)resourceContext.getResource(ContainerRequestContext.class);
        if (reqCtx == null) {
            throw new AssertionError((Object)"Null ContainerRequestContext");
        }
        Object id = reqCtx.getProperty(CONSOLE_BACKEND_SESSION_ID);
        if (id == null) {
            throw new AssertionError((Object)"Null wls.console.backend.session");
        }
        if (!(id instanceof String)) {
            throw new AssertionError((Object)("Non-String wls.console.backend.session : " + String.valueOf(id)));
        }
        return (String)id;
    }

    private static List<Locale> getLocales(HttpHeaders httpHeaders) {
        return httpHeaders != null ? httpHeaders.getAcceptableLanguages() : null;
    }

    public List<Locale> getLocales() {
        return this.locales;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public Object getSessionData(String key, Object referenceObject) {
        if (this.frontend == null) {
            return null;
        }
        return this.frontend.getData(key, referenceObject);
    }

    public void storeSessionData(String key, Object referenceObject, Object data) {
        if (this.frontend != null) {
            this.frontend.storeData(key, referenceObject, data);
        }
    }

    public void removeSessionData(String key, Object referenceObject) {
        if (this.frontend != null) {
            this.frontend.removeData(key, referenceObject);
        }
    }

    public void setFrontend(Frontend frontend) {
        this.frontend = frontend;
    }

    public Map getCache() {
        return this.cache;
    }

    public String toString() {
        String connection = this.getConnection() != null ? this.getConnection().getId() : "disconnected";
        String domainVersion = this.getDomainVersion();
        if (domainVersion == null) {
            domainVersion = "unknown";
        }
        Locale locale = this.getLocalizer() != null ? this.getLocalizer().getLocale() : null;
        return "InvocationContext(connection=" + connection + ", domainVersion=" + domainVersion + ", locale=" + String.valueOf(locale) + ")";
    }
}

