/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;
import weblogic.remoteconsole.server.repo.Frontend;

public class FrontendManager {
    private static final Logger LOGGER = Logger.getLogger(FrontendManager.class.getName());
    private static Map<String, Frontend> frontends = new HashMap<String, Frontend>();
    private static final int MAX_ENTRIES_CHECK = 10;
    private static final int HOUR = 3600000;

    public static synchronized Frontend find(String id, String subId) {
        return frontends.get(Frontend.makeFullID(id, subId));
    }

    public static synchronized Frontend create(String id, String subId) {
        Frontend ret = new Frontend(id, subId);
        if (frontends.size() >= 10) {
            Frontend oldest = null;
            for (Frontend walk : frontends.values()) {
                if (oldest == null) {
                    oldest = walk;
                    continue;
                }
                if (walk.getLastRequestTime() >= oldest.getLastRequestTime()) continue;
                oldest = walk;
            }
            if (frontends.size() > 100 || oldest.getLastRequestTime() + 3600000L < new Date().getTime()) {
                LOGGER.fine("Terminating frontend: " + oldest.getFullID() + ", " + String.valueOf(oldest));
                oldest.terminate();
                frontends.remove(oldest.getFullID());
            }
        }
        LOGGER.fine("Creating frontend with ID: " + ret.getID());
        frontends.put(id + "-" + subId, ret);
        return ret;
    }

    public static synchronized boolean destroy(String id) {
        boolean ret = false;
        for (Frontend frontend : new LinkedList<Frontend>(frontends.values())) {
            if (!frontend.getID().equals(id)) continue;
            frontend.terminate();
            frontends.remove(frontend.getFullID());
            ret = true;
        }
        return ret;
    }
}

