/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.ws.rs.container.ContainerRequestContext;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.server.ConsoleBackendRuntimeConfig;
import weblogic.remoteconsole.server.providers.ProviderManager;

public class Frontend {
    private String id;
    private String subId;
    private long lastRequestTime;
    private ProviderManager pm = new ProviderManager();
    private static boolean isSameSiteCookieEnabled = ConsoleBackendRuntimeConfig.isSameSiteCookieEnabled();
    private static String valueSameSiteCookie = ConsoleBackendRuntimeConfig.getSameSiteCookieValue();
    private Map<String, StoredDataObject> storedData = new HashMap<String, StoredDataObject>();

    public Frontend(String id, String subId) {
        this.id = id;
        this.subId = subId;
    }

    public String getID() {
        return this.id;
    }

    public String getSubID() {
        return this.subId;
    }

    public String getFullID() {
        return Frontend.makeFullID(this.id, this.subId);
    }

    public static String makeFullID(String id, String subId) {
        return id + "-" + subId;
    }

    public void setLastRequestTime() {
        this.lastRequestTime = new Date().getTime();
    }

    public long getLastRequestTime() {
        return this.lastRequestTime;
    }

    public void terminate() {
        this.pm.terminate();
    }

    public void storeInRequestContext(ContainerRequestContext context) {
        context.setProperty(Frontend.class.getName(), (Object)this);
    }

    public static Frontend getFromContext(ContainerRequestContext context) {
        return (Frontend)context.getProperty(Frontend.class.getName());
    }

    public ProviderManager getProviderManager() {
        return this.pm;
    }

    public boolean isSameSiteCookieEnabled() {
        return isSameSiteCookieEnabled && !StringUtils.isEmpty((String)valueSameSiteCookie);
    }

    public String getValueSameSiteCookie() {
        return valueSameSiteCookie;
    }

    public synchronized Object getData(String key, Object referenceKey) {
        this.clean();
        StoredDataObject ret = this.storedData.get(key + String.valueOf(referenceKey));
        if (ret == null) {
            return null;
        }
        return ret.value;
    }

    public void clean() {
        LinkedList<String> removeList = new LinkedList<String>();
        for (Map.Entry<String, StoredDataObject> entry : this.storedData.entrySet()) {
            if (entry.getValue().referenceKey.get() != null) continue;
            removeList.add(entry.getKey());
        }
        for (String key : removeList) {
            this.storedData.remove(key);
        }
    }

    public synchronized void storeData(String key, Object referenceKey, Object data) {
        this.storedData.put(key + String.valueOf(referenceKey), new StoredDataObject(referenceKey, data));
        this.clean();
    }

    public synchronized void removeData(String key, Object referenceKey) {
        this.storedData.remove(key + String.valueOf(referenceKey));
        this.clean();
    }

    private static class StoredDataObject {
        public WeakReference<Object> referenceKey;
        public Object value;

        private StoredDataObject(Object referenceKey, Object value) {
            this.referenceKey = new WeakReference<Object>(referenceKey);
            this.value = value;
        }
    }
}

