/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import java.util.ArrayList;
import java.util.List;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.GetPropertyOptionsCustomizerDef;
import weblogic.remoteconsole.common.repodef.PagePropertyDef;
import weblogic.remoteconsole.common.utils.CustomizerInvocationUtils;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchResults;
import weblogic.remoteconsole.server.repo.BeanSearchResults;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.BeanTreePathSegment;
import weblogic.remoteconsole.server.repo.BeanTreePathTemplate;
import weblogic.remoteconsole.server.repo.Form;
import weblogic.remoteconsole.server.repo.FormProperty;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.ModelTokenReader;
import weblogic.remoteconsole.server.repo.NullReference;
import weblogic.remoteconsole.server.repo.Option;
import weblogic.remoteconsole.server.repo.OptionsSource;
import weblogic.remoteconsole.server.repo.PageReader;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.ResponseException;
import weblogic.remoteconsole.server.repo.Value;

class FormReader
extends PageReader {
    FormReader(InvocationContext invocationContext) {
        super(invocationContext);
    }

    protected void addOptionsSourcesToSearch(BeanReaderRepoSearchBuilder builder, BeanPropertyDef beanPropertyDef) {
        if (!beanPropertyDef.isPagePropertyDef()) {
            return;
        }
        PagePropertyDef pagePropertyDef = beanPropertyDef.asPagePropertyDef();
        if (!pagePropertyDef.isSupportsOptions()) {
            return;
        }
        for (String optionsSource : pagePropertyDef.getOptionsSources()) {
            this.addOptionsSourceToSearch(builder, optionsSource);
        }
    }

    private void addOptionsSourceToSearch(BeanReaderRepoSearchBuilder builder, String optionsSource) {
        BeanTreePath optionsSourceBeanTreePath = this.getOptionsSourceBeanTreePath(optionsSource);
        if (optionsSourceBeanTreePath == null) {
            return;
        }
        builder.addProperty(optionsSourceBeanTreePath, optionsSourceBeanTreePath.getTypeDef().getIdentityPropertyDef());
    }

    protected Response<FormProperty> addOptionsAndOptionsSources(BeanPropertyDef beanPropertyDef, FormProperty formProperty, BeanSearchResults beanResults, BeanReaderRepoSearchResults searchResults) {
        Response<FormProperty> response = new Response<FormProperty>();
        if (!beanPropertyDef.isPagePropertyDef()) {
            return response.setSuccess(formProperty);
        }
        PagePropertyDef pagePropertyDef = beanPropertyDef.asPagePropertyDef();
        if (!pagePropertyDef.isSupportsOptions()) {
            return response.setSuccess(formProperty);
        }
        Response<List<OptionsSource>> optionsSourcesResponse = this.getOptionsSources(pagePropertyDef, searchResults);
        if (!optionsSourcesResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(optionsSourcesResponse);
        }
        formProperty.setOptionsSources(optionsSourcesResponse.getResults());
        Response<List<Option>> optionsResponse = this.getOptions(pagePropertyDef, beanResults, searchResults);
        if (!optionsResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(optionsResponse);
        }
        formProperty.setOptions(optionsResponse.getResults());
        return response.setSuccess(formProperty);
    }

    private Response<List<OptionsSource>> getOptionsSources(PagePropertyDef pagePropertyDef, BeanReaderRepoSearchResults searchResults) {
        Response<ArrayList<OptionsSource>> response = new Response<ArrayList<OptionsSource>>();
        if (!pagePropertyDef.isReference()) {
            return response.setSuccess(null);
        }
        ArrayList<OptionsSource> optionsSources = new ArrayList<OptionsSource>();
        for (String optionsSource : pagePropertyDef.getOptionsSources()) {
            this.addOptionsSources(optionsSources, optionsSource, searchResults);
        }
        return response.setSuccess(optionsSources);
    }

    private void addOptionsSources(List<OptionsSource> optionsSources, String optionsSource, BeanReaderRepoSearchResults searchResults) {
        BeanTreePath optionsSourceBeanTreePath = this.getOptionsSourceBeanTreePath(optionsSource);
        if (optionsSourceBeanTreePath == null) {
            return;
        }
        optionsSources.add(new OptionsSource(optionsSourceBeanTreePath));
    }

    private Response<List<Option>> getOptions(PagePropertyDef pagePropertyDef, BeanSearchResults beanResults, BeanReaderRepoSearchResults searchResults) {
        Response<List<Object>> response = new Response<List<Object>>();
        ArrayList<Option> options = null;
        if (!pagePropertyDef.isReference()) {
            return response.setSuccess(options);
        }
        if (pagePropertyDef.getGetOptionsCustomizerDef() != null) {
            Response<List<Option>> customizerResponse = this.getCustomPropertyOptions(pagePropertyDef, beanResults, searchResults);
            if (!customizerResponse.isSuccess()) {
                return response.copyUnsuccessfulResponse(customizerResponse);
            }
            options = customizerResponse.getResults();
        } else {
            options = new ArrayList();
            for (String optionsSource : pagePropertyDef.getOptionsSources()) {
                this.addOptions(pagePropertyDef, options, optionsSource, searchResults);
            }
        }
        return response.setSuccess(this.completeOptions(pagePropertyDef, options));
    }

    private List<Option> completeOptions(PagePropertyDef pagePropertyDef, List<Option> options) {
        ArrayList<Option> completedOptions = new ArrayList<Option>(options);
        if (pagePropertyDef.isAllowNoneOption()) {
            if (pagePropertyDef.isReference()) {
                completedOptions.add(0, new Option(this.getInvocationContext(), (Value)NullReference.INSTANCE));
            } else {
                throw new AssertionError((Object)("None option not supported for non-references: " + String.valueOf(pagePropertyDef)));
            }
        }
        return completedOptions;
    }

    private Response<List<Option>> getCustomPropertyOptions(BeanPropertyDef propertyDef, BeanSearchResults beanResults, BeanReaderRepoSearchResults searchResults) {
        boolean argsIncludeIsSet;
        GetPropertyOptionsCustomizerDef customizerDef = propertyDef.getGetOptionsCustomizerDef();
        Response<List<Object>> argsResponse = this.getArguments(customizerDef, beanResults, searchResults, argsIncludeIsSet = false);
        if (!argsResponse.isSuccess()) {
            Response errorResponse = new Response();
            return errorResponse.copyUnsuccessfulResponse(argsResponse);
        }
        Response<List> response = new Response<List>();
        try {
            Object rtn = CustomizerInvocationUtils.invokeMethod(customizerDef.getMethod(), argsResponse.getResults());
            List options = (List)rtn;
            return response.setSuccess(options);
        }
        catch (ResponseException e) {
            return response.copyUnsuccessfulResponse(e.getResponse());
        }
    }

    private void addOptions(PagePropertyDef pagePropertyDef, List<Option> options, String optionsSource, BeanReaderRepoSearchResults searchResults) {
        BeanTreePath optionsSourceBeanTreePath = this.getOptionsSourceBeanTreePath(optionsSource);
        if (optionsSourceBeanTreePath == null) {
            return;
        }
        List<BeanSearchResults> optionsResults = searchResults.getCollection(optionsSourceBeanTreePath);
        for (BeanSearchResults optionResults : optionsResults) {
            Value option = optionResults.getValue(pagePropertyDef.getTypeDef().getIdentityPropertyDef());
            if (option.isSettable()) {
                option = option.asSettable().getValue();
            }
            options.add(new Option(this.getInvocationContext(), option));
        }
    }

    private BeanTreePath getOptionsSourceBeanTreePath(String optionsSource) {
        BeanTreePathTemplate template = new BeanTreePathTemplate(optionsSource);
        Path optionsSourcePath = template.expand(this.getBeanTreePath());
        if (optionsSourcePath == null) {
            throw new AssertionError((Object)("Can't resolve optionsSource " + optionsSource + " from " + String.valueOf(this.getBeanTreePath())));
        }
        BeanTreePath beanTreePath = BeanTreePath.createAllowUnresolved(this.getBeanRepo(), optionsSourcePath);
        if (beanTreePath == null) {
            return null;
        }
        if (!this.isCollection(beanTreePath.getLastSegment())) {
            throw new AssertionError((Object)("Last segment is not a collection " + optionsSource + " from " + String.valueOf(this.getBeanTreePath())));
        }
        for (int i = 0; i < beanTreePath.getSegments().size() - 1; ++i) {
            BeanTreePathSegment segment = beanTreePath.getSegments().get(i);
            if (this.isCollection(segment)) {
                throw new AssertionError((Object)("Intermediate wildcard collections in optionsSources not supported " + optionsSource + " from " + String.valueOf(this.getBeanTreePath())));
            }
        }
        return beanTreePath;
    }

    private boolean isCollection(BeanTreePathSegment segment) {
        return segment.getChildDef().isCollection() && !segment.isKeySet();
    }

    protected void addModelTokens(Form form) {
        if (!form.getProperties().isEmpty() && this.getBeanRepo() instanceof ModelTokenReader) {
            form.setModelTokens(((ModelTokenReader)((Object)this.getBeanRepo())).getModelTokens(this.getInvocationContext()));
        }
    }
}

