/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import java.util.List;
import weblogic.remoteconsole.common.repodef.PageFieldDef;
import weblogic.remoteconsole.server.repo.Option;
import weblogic.remoteconsole.server.repo.OptionsSource;
import weblogic.remoteconsole.server.repo.StringValue;
import weblogic.remoteconsole.server.repo.Value;

public class FormProperty {
    private PageFieldDef fieldDef;
    private Value value;
    private List<Option> options;
    private List<OptionsSource> optionsSources;

    public FormProperty(PageFieldDef fieldDef, Value value) {
        this.fieldDef = fieldDef;
        this.value = value;
    }

    public PageFieldDef getFieldDef() {
        return this.fieldDef;
    }

    public String getName() {
        return this.fieldDef.getFormFieldName();
    }

    public Value getValue() {
        return this.value;
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public void setOptions(List<Option> val) {
        this.options = val;
    }

    public List<OptionsSource> getOptionsSources() {
        return this.optionsSources;
    }

    public void setOptionsSources(List<OptionsSource> val) {
        this.optionsSources = val;
    }

    public String toString() {
        return "FormProperty<" + this.getName() + ", " + String.valueOf(this.getValue()) + ">";
    }

    public static String getStringPropertyValue(String formFieldName, List<FormProperty> properties, String defaultValue) {
        return FormProperty.getPropertyValue(formFieldName, properties, new StringValue(defaultValue)).asString().getValue();
    }

    public static Value getPropertyValue(String formFieldName, List<FormProperty> properties, Value defaultValue) {
        Value value = FormProperty.findPropertyValue(formFieldName, properties);
        return value != null ? value : defaultValue;
    }

    public static Value findPropertyValue(String formFieldName, List<FormProperty> properties) {
        FormProperty property = FormProperty.findProperty(formFieldName, properties);
        return property != null ? property.getValue().asSettable().getValue() : null;
    }

    public static FormProperty findProperty(String formFieldName, List<FormProperty> properties) {
        for (FormProperty property : properties) {
            if (!formFieldName.equals(property.getName())) continue;
            return property;
        }
        return null;
    }
}

