/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import java.util.ArrayList;
import java.util.List;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.utils.Message;
import weblogic.remoteconsole.server.repo.ArrayValue;
import weblogic.remoteconsole.server.repo.BeanPropertyValue;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.BeansPropertyValues;
import weblogic.remoteconsole.server.repo.FormProperty;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.PageManager;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.SettableValue;
import weblogic.remoteconsole.server.repo.Value;

class FormManager
extends PageManager {
    private BeansPropertyValues beansPropertyValues;

    protected FormManager(InvocationContext ic, List<FormProperty> formProperties) {
        this(ic, FormManager.convertFormPropertyValuesToBeanPropertyValues(ic, formProperties));
    }

    protected FormManager(InvocationContext ic, BeansPropertyValues beansPropertyValues) {
        super(ic);
        this.beansPropertyValues = beansPropertyValues;
    }

    private static BeansPropertyValues convertFormPropertyValuesToBeanPropertyValues(InvocationContext ic, List<FormProperty> formProperties) {
        BeansPropertyValues rtn = new BeansPropertyValues(ic.getBeanTreePath());
        for (FormProperty formProperty : formProperties) {
            rtn.addPropertyValue(FormManager.convertFormPropertyValueToBeanPropertyValue(formProperty));
        }
        return rtn;
    }

    private static BeanPropertyValue convertFormPropertyValueToBeanPropertyValue(FormProperty formProperty) {
        BeanPropertyDef propertyDef = formProperty.getFieldDef().asBeanPropertyDef();
        SettableValue settableValue = formProperty.getValue().asSettable();
        if (propertyDef.isReferenceAsReferences() && settableValue.getValue() != null) {
            ArrayList<Value> references = new ArrayList<Value>();
            Value value = settableValue.getValue();
            if (!value.isNullReference()) {
                references.add(value);
            }
            settableValue = new SettableValue((Value)new ArrayValue(references), settableValue.getState());
        }
        return new BeanPropertyValue(propertyDef, settableValue);
    }

    protected BeansPropertyValues getBeansPropertyValues() {
        return this.beansPropertyValues;
    }

    protected void convertBeanMessagesToFormMessages(BeanTreePath beanPath, Response<?> beanResponse, Response<?> formResponse) {
        int formPathLength = this.getInvocationContext().getBeanTreePath().getPath().length();
        int beanPathLength = beanPath.getPath().length();
        Path formRelativeBeanPath = beanPath.getPath().subPath(formPathLength, beanPathLength);
        for (Message beanMessage : beanResponse.getMessages()) {
            String beanProperty = beanMessage.getProperty();
            String formProperty = beanProperty != null ? formRelativeBeanPath.childPath(beanProperty).getDotSeparatedPath() : null;
            formResponse.addMessage(new Message(beanMessage.getSeverity(), formProperty, beanMessage.getText()));
        }
    }
}

