/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanChildDef;
import weblogic.remoteconsole.common.repodef.CreateFormPagePath;
import weblogic.remoteconsole.common.repodef.CustomCreateFormDef;
import weblogic.remoteconsole.common.repodef.CustomFormSectionDef;
import weblogic.remoteconsole.common.repodef.CustomPageActionDef;
import weblogic.remoteconsole.common.repodef.CustomPagePropertyDef;
import weblogic.remoteconsole.common.repodef.CustomPagePropertyUsedIfDef;
import weblogic.remoteconsole.common.repodef.CustomSliceFormDef;
import weblogic.remoteconsole.common.repodef.CustomSliceTableDef;
import weblogic.remoteconsole.common.repodef.FormSectionDef;
import weblogic.remoteconsole.common.repodef.LegalValueDef;
import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.repodef.LocalizedConstants;
import weblogic.remoteconsole.common.repodef.PageActionDef;
import weblogic.remoteconsole.common.repodef.PageDef;
import weblogic.remoteconsole.common.repodef.PagePath;
import weblogic.remoteconsole.common.repodef.PagePropertyDef;
import weblogic.remoteconsole.common.repodef.PageRepoDef;
import weblogic.remoteconsole.common.repodef.PagesPath;
import weblogic.remoteconsole.common.repodef.weblogic.AggregatedRuntimeMBeanNameHandler;
import weblogic.remoteconsole.common.utils.UrlUtils;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.BeanTreePathSegment;
import weblogic.remoteconsole.server.repo.Dashboard;
import weblogic.remoteconsole.server.repo.FilteringDashboardConfig;
import weblogic.remoteconsole.server.repo.FilteringDashboardDef;
import weblogic.remoteconsole.server.repo.FilteringDashboardPathSegmentDef;
import weblogic.remoteconsole.server.repo.FilteringDashboardPropertyDef;
import weblogic.remoteconsole.server.repo.FormProperty;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Page;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.SearchUtils;
import weblogic.remoteconsole.server.repo.StringValue;
import weblogic.remoteconsole.server.repo.Value;

public class FilteringDashboardDefManager {
    private FilteringDashboardDefManager() {
    }

    public static boolean isSupportsFilteringDashboards(InvocationContext ic, BeanTreePath btpTemplate) {
        if (!FilteringDashboardDefManager.getPageRepoDef(ic).isSupportsFilteringDashboards()) {
            return false;
        }
        btpTemplate = AggregatedRuntimeMBeanNameHandler.INSTANCE.getUnaggregatedBeanTreePath(btpTemplate);
        HashSet<String> childNames = new HashSet<String>();
        boolean hasCollection = false;
        for (BeanTreePathSegment segment : btpTemplate.getSegments()) {
            String childName = segment.getChildDef().getChildName();
            if (childNames.contains(childName)) {
                return false;
            }
            childNames.add(childName);
            if (!segment.getChildDef().getChildTypeDef().isSupportsFilteringDashboards()) {
                return false;
            }
            if (!segment.getChildDef().isCollection()) continue;
            hasCollection = true;
        }
        return hasCollection;
    }

    public static String computePathQueryParam(BeanTreePath btp) {
        btp = AggregatedRuntimeMBeanNameHandler.INSTANCE.getUnaggregatedBeanTreePath(btp);
        return UrlUtils.computeQueryParam("path", btp.getPath().getComponents());
    }

    public static BeanTreePath getBeanTreePathTemplateFromPathQueryParam(InvocationContext ic) {
        BeanTreePath btp = FilteringDashboardDefManager.getBeanTreePathFromPathQueryParam(ic);
        if (btp == null) {
            return null;
        }
        BeanTreePath btpTemplate = BeanTreePath.create(btp.getBeanRepo(), new Path());
        for (BeanTreePathSegment segment : btp.getSegments()) {
            btpTemplate = btpTemplate.childPath(segment.getChildDef().getChildPath());
        }
        return btpTemplate;
    }

    public static BeanTreePath getBeanTreePathFromPathQueryParam(InvocationContext ic) {
        List pathComponents = (List)ic.getUriInfo().getQueryParameters().get((Object)"path");
        if (pathComponents == null) {
            return null;
        }
        Path path = new Path();
        for (String pathComponent : pathComponents) {
            path.addComponent(pathComponent);
        }
        return BeanTreePath.create(ic.getPageRepo().getBeanRepo(), path);
    }

    public static Response<PageDef> customizeCreateFormDef(InvocationContext ic, PageDef uncustomizedPageDef) {
        Response<CustomCreateFormDef> response = new Response<CustomCreateFormDef>();
        Response<FilteringDashboardDef> dashboardDefResponse = FilteringDashboardDefManager.getDashboardDef(ic);
        if (!dashboardDefResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(dashboardDefResponse);
        }
        return response.setSuccess(new CustomCreateFormDef(uncustomizedPageDef.asCreateFormDef()).sectionDefs(FilteringDashboardDefManager.getCustomizedSectionDefs(ic, dashboardDefResponse.getResults(), uncustomizedPageDef)).propertyDefs(List.of()));
    }

    public static Response<PageDef> customizeFiltersSliceDef(InvocationContext ic, PageDef uncustomizedPageDef) {
        Response<CustomSliceFormDef> response = new Response<CustomSliceFormDef>();
        Response<FilteringDashboardDef> dashboardDefResponse = FilteringDashboardDefManager.getDashboardDef(ic);
        if (!dashboardDefResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(dashboardDefResponse);
        }
        return response.setSuccess(new CustomSliceFormDef(uncustomizedPageDef.asSliceFormDef()).sectionDefs(FilteringDashboardDefManager.getCustomizedSectionDefs(ic, dashboardDefResponse.getResults(), uncustomizedPageDef)).propertyDefs(List.of()));
    }

    public static void customizeCreateForm(InvocationContext ic, Page page) {
        List<FormProperty> properties = page.asForm().getProperties();
        for (int i = 0; i < properties.size(); ++i) {
            FormProperty property = properties.get(i);
            properties.set(i, new FormProperty(property.getFieldDef(), Value.unsettableValue(property.getValue())));
        }
    }

    public static Response<PageDef> customizeViewSliceDef(InvocationContext ic, PageDef uncustomizedPageDef) {
        Response<CustomSliceTableDef> response = new Response<CustomSliceTableDef>();
        Response<FilteringDashboardDef> dashboardDefResponse = FilteringDashboardDefManager.getDashboardDef(ic);
        if (!dashboardDefResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(dashboardDefResponse);
        }
        FilteringDashboardDef dashboardDef = dashboardDefResponse.getResults();
        Response<List<String>> columnsResponse = FilteringDashboardDefManager.getDefaultColumns(ic);
        if (!columnsResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(columnsResponse);
        }
        List<String> defaultColumns = columnsResponse.getResults();
        CustomSliceTableDef sliceTableDef = new CustomSliceTableDef(uncustomizedPageDef.asSliceTableDef());
        ArrayList<PagePropertyDef> defaultDisplayedColumnDefs = new ArrayList<PagePropertyDef>();
        for (FilteringDashboardPathSegmentDef filteringDashboardPathSegmentDef : dashboardDef.getPathDef()) {
            if (!filteringDashboardPathSegmentDef.isFilterable()) continue;
            defaultDisplayedColumnDefs.add(FilteringDashboardDefManager.clonePropertyDef(filteringDashboardPathSegmentDef.getResultPropertyDef(), sliceTableDef).writable(false));
        }
        ArrayList<PagePropertyDef> defaultHiddenColumnDefs = new ArrayList<PagePropertyDef>();
        for (FilteringDashboardPropertyDef propertyDef : dashboardDef.getBasicPropertyDefs()) {
            defaultDisplayedColumnDefs.add(FilteringDashboardDefManager.clonePropertyDef(propertyDef.getSourcePropertyDef(), sliceTableDef));
        }
        for (FilteringDashboardPropertyDef propertyDef : FilteringDashboardDefManager.sortPropertyDefs(ic, dashboardDef.getAdvancedPropertyDefs())) {
            defaultHiddenColumnDefs.add(FilteringDashboardDefManager.clonePropertyDef(propertyDef.getSourcePropertyDef(), sliceTableDef));
        }
        FilteringDashboardDefManager.setColumnDefs(ic, sliceTableDef, defaultColumns, defaultDisplayedColumnDefs, defaultHiddenColumnDefs);
        ArrayList<PageActionDef> arrayList = new ArrayList<PageActionDef>();
        for (PageActionDef actionDef : dashboardDef.getActionDefs()) {
            arrayList.add(FilteringDashboardDefManager.cloneActionDef(actionDef, sliceTableDef));
        }
        sliceTableDef.setActionDefs(arrayList);
        sliceTableDef.setUseRowIdentities(true);
        sliceTableDef.setSupportsNavigation(true);
        return response.setSuccess(sliceTableDef);
    }

    private static CustomPagePropertyDef clonePropertyDef(PagePropertyDef pagePropertyDef, PageDef pageDef) {
        return new CustomPagePropertyDef(pagePropertyDef).pageDef(pageDef);
    }

    private static CustomPageActionDef cloneActionDef(PageActionDef actionDef, PageDef pageDef) {
        CustomPageActionDef clone = new CustomPageActionDef(actionDef).pageDef(pageDef);
        ArrayList<PageActionDef> childActionDefs = new ArrayList<PageActionDef>();
        for (PageActionDef childActionDef : actionDef.getActionDefs()) {
            childActionDefs.add(FilteringDashboardDefManager.cloneActionDef(childActionDef, pageDef));
        }
        return clone.actionDefs(childActionDefs);
    }

    private static void setColumnDefs(InvocationContext ic, CustomSliceTableDef sliceTableDef, List<String> defaultColumns, List<PagePropertyDef> defaultDisplayedColumnDefs, List<PagePropertyDef> defaultHiddenColumnDefs) {
        if (defaultColumns.isEmpty()) {
            sliceTableDef.setDisplayedColumnDefs(defaultDisplayedColumnDefs);
            sliceTableDef.setHiddenColumnDefs(defaultHiddenColumnDefs);
        } else {
            ArrayList<PagePropertyDef> allColumnDefs = new ArrayList<PagePropertyDef>(defaultDisplayedColumnDefs);
            allColumnDefs.addAll(defaultHiddenColumnDefs);
            for (String column : defaultColumns) {
                PagePropertyDef propertyDef = FilteringDashboardDefManager.findPropertyDef(column, allColumnDefs);
                if (propertyDef == null) continue;
                sliceTableDef.getDisplayedColumnDefs().add(propertyDef);
            }
            for (PagePropertyDef propertyDef : allColumnDefs) {
                if (defaultColumns.contains(propertyDef.getFormFieldName())) continue;
                sliceTableDef.getHiddenColumnDefs().add(propertyDef);
            }
        }
    }

    private static PagePropertyDef findPropertyDef(String column, List<PagePropertyDef> propertyDefs) {
        for (PagePropertyDef propertyDef : propertyDefs) {
            if (!column.equals(propertyDef.getFormFieldName())) continue;
            return propertyDef;
        }
        return null;
    }

    private static Response<List<String>> getDefaultColumns(InvocationContext ic) {
        Response<List<String>> response = new Response<List<String>>();
        Response<FilteringDashboardConfig> dashboardConfigResponse = FilteringDashboardDefManager.getDashboardConfig(ic);
        if (!dashboardConfigResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(dashboardConfigResponse);
        }
        FilteringDashboardConfig dashboardConfig = dashboardConfigResponse.getResults();
        List<String> defaultColumns = null;
        if (dashboardConfig != null) {
            defaultColumns = dashboardConfig.getDefaultColumns();
        }
        if (defaultColumns == null) {
            defaultColumns = List.of();
        }
        return response.setSuccess(defaultColumns);
    }

    private static List<FilteringDashboardPropertyDef> sortPropertyDefs(InvocationContext ic, List<FilteringDashboardPropertyDef> unsortedPropertyDefs) {
        TreeMap<String, TreeMap<String, FilteringDashboardPropertyDef>> localizedLabelToFormNameToPropertyDef = new TreeMap<String, TreeMap<String, FilteringDashboardPropertyDef>>();
        for (FilteringDashboardPropertyDef propertyDef : unsortedPropertyDefs) {
            PagePropertyDef pagePropertyDef = propertyDef.getSourcePropertyDef();
            String localizedLabel = ic.getLocalizer().localizeString(pagePropertyDef.getLabel(), new Object[0]);
            TreeMap<String, FilteringDashboardPropertyDef> formNameToPropertyDef = (TreeMap<String, FilteringDashboardPropertyDef>)localizedLabelToFormNameToPropertyDef.get(localizedLabel);
            if (formNameToPropertyDef == null) {
                formNameToPropertyDef = new TreeMap<String, FilteringDashboardPropertyDef>();
                localizedLabelToFormNameToPropertyDef.put(localizedLabel, formNameToPropertyDef);
            }
            formNameToPropertyDef.put(pagePropertyDef.getFormFieldName(), propertyDef);
        }
        ArrayList<FilteringDashboardPropertyDef> sortedPropertyDefs = new ArrayList<FilteringDashboardPropertyDef>();
        for (Map formNameToPropertyDef : localizedLabelToFormNameToPropertyDef.values()) {
            for (FilteringDashboardPropertyDef propertyDef : formNameToPropertyDef.values()) {
                sortedPropertyDefs.add(propertyDef);
            }
        }
        return sortedPropertyDefs;
    }

    private static List<FormSectionDef> getCustomizedSectionDefs(InvocationContext ic, FilteringDashboardDef dashboardDef, PageDef uncustomizedPageDef) {
        List<FormSectionDef> uncustomizedSectionDefs = uncustomizedPageDef.asFormDef().getSectionDefs();
        CustomFormSectionDef nameSectionDef = new CustomFormSectionDef(uncustomizedSectionDefs.get(0));
        CustomPagePropertyDef namePropertyDef = new CustomPagePropertyDef(nameSectionDef.getPropertyDefs().get(0)).createWritable(true);
        nameSectionDef.setPropertyDefs(List.of(namePropertyDef));
        CustomFormSectionDef descriptionSectionDef = new CustomFormSectionDef(uncustomizedSectionDefs.get(1));
        CustomPagePropertyDef descriptionPropertyDef = new CustomPagePropertyDef(descriptionSectionDef.getPropertyDefs().get(0)).createWritable(true).updateWritable(true);
        descriptionSectionDef.setPropertyDefs(List.of(descriptionPropertyDef));
        CustomFormSectionDef pathSegmentsSectionDef = new CustomFormSectionDef(uncustomizedSectionDefs.get(2));
        for (FilteringDashboardPathSegmentDef segmentDef : dashboardDef.getPathDef()) {
            if (!segmentDef.isFilterable()) continue;
            pathSegmentsSectionDef.getPropertyDefs().add(segmentDef.getCriteriaPropertyDef());
            pathSegmentsSectionDef.getPropertyDefs().add(segmentDef.getValuePropertyDef());
        }
        CustomFormSectionDef propertiesSectionDef = new CustomFormSectionDef(uncustomizedSectionDefs.get(3));
        for (FilteringDashboardPropertyDef propertyDef : FilteringDashboardDefManager.sortPropertyDefs(ic, dashboardDef.getAllPropertyDefs())) {
            propertiesSectionDef.getPropertyDefs().add(propertyDef.getCriteriaPropertyDef());
            propertiesSectionDef.getPropertyDefs().add(propertyDef.getValuePropertyDef());
        }
        return List.of(nameSectionDef, descriptionSectionDef, pathSegmentsSectionDef, propertiesSectionDef);
    }

    public static Response<FilteringDashboardConfig> getDashboardConfig(InvocationContext ic) {
        Response<FilteringDashboardConfig> response = new Response<FilteringDashboardConfig>();
        BeanTreePath btpTemplate = FilteringDashboardDefManager.getBeanTreePathFromPathQueryParam(ic);
        if (btpTemplate != null) {
            return response.setSuccess(null);
        }
        Response<Dashboard> dashboardResponse = FilteringDashboardDefManager.getDashboard(ic);
        if (!dashboardResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(dashboardResponse);
        }
        return response.setSuccess(dashboardResponse.getResults().asFilteringDashboard().getConfig());
    }

    public static Response<FilteringDashboardDef> getDashboardDef(InvocationContext ic) {
        BeanTreePath btpTemplate = FilteringDashboardDefManager.getBeanTreePathFromPathQueryParam(ic);
        if (btpTemplate == null) {
            Response response = new Response();
            Response<Dashboard> dashboardResponse = FilteringDashboardDefManager.getDashboard(ic);
            if (!dashboardResponse.isSuccess()) {
                return response.copyUnsuccessfulResponse(dashboardResponse);
            }
            btpTemplate = dashboardResponse.getResults().asFilteringDashboard().getConfig().getDashboardDef().getBeanTreePathTemplate();
        }
        return FilteringDashboardDefManager.createLocalizedDashboardDef(ic, btpTemplate);
    }

    private static Response<Dashboard> getDashboard(InvocationContext ic) {
        String dashboardName = (String)ic.getUriInfo().getQueryParameters().getFirst((Object)"dashboard");
        if (dashboardName == null) {
            return ic.getPageRepo().asPageReaderRepo().getDashboardManager(ic).getDashboard(ic);
        }
        return ic.getPageRepo().asPageReaderRepo().getDashboardManager(ic).getDashboard(ic, dashboardName);
    }

    public static Response<FilteringDashboardDef> createLocalizedDashboardDef(InvocationContext ic, BeanTreePath btpTemplate) {
        PageDef uncustomizedCreateFormDef = FilteringDashboardDefManager.getUncustomizedCreateFormDef(ic, btpTemplate);
        Response<FilteringDashboardDef> response = new Response<FilteringDashboardDef>();
        if (!FilteringDashboardDefManager.isSupportsFilteringDashboards(ic, btpTemplate)) {
            throw new AssertionError((Object)(String.valueOf(btpTemplate) + " doesn't support filtering dashboards."));
        }
        HashMap<String, PagePropertyDef> templatePagePropertyDefs = new HashMap<String, PagePropertyDef>();
        for (PagePropertyDef templatePagePropertyDef : uncustomizedCreateFormDef.getAllPropertyDefs()) {
            templatePagePropertyDefs.put(templatePagePropertyDef.getFormFieldName(), templatePagePropertyDef);
        }
        List<PagePropertyDef> basicPagePropertyDefs = SearchUtils.getBasicPagePropertyDefs(FilteringDashboardDefManager.getPageRepoDef(ic), btpTemplate.getTypeDef());
        Collection<PagePropertyDef> allPagePropertyDefs = SearchUtils.getPagePropertyDefs(FilteringDashboardDefManager.getPageRepoDef(ic), btpTemplate.getTypeDef()).values();
        return response.setSuccess(new FilteringDashboardDef(btpTemplate, FilteringDashboardDefManager.createPathDefFromTemplate(ic, btpTemplate, templatePagePropertyDefs), FilteringDashboardDefManager.createPropertyDefsFromTemplate(ic, btpTemplate, templatePagePropertyDefs, basicPagePropertyDefs), FilteringDashboardDefManager.createPropertyDefsFromTemplate(ic, btpTemplate, templatePagePropertyDefs, FilteringDashboardDefManager.getAdvancedPagePropertyDefs(ic, basicPagePropertyDefs, allPagePropertyDefs)), FilteringDashboardDefManager.createActionDefsFromTemplate(ic, btpTemplate)));
    }

    private static List<FilteringDashboardPathSegmentDef> createPathDefFromTemplate(InvocationContext ic, BeanTreePath btpTemplate, Map<String, PagePropertyDef> templatePagePropertyDefs) {
        ArrayList<FilteringDashboardPathSegmentDef> pathDef = new ArrayList<FilteringDashboardPathSegmentDef>();
        for (BeanTreePathSegment segmentTemplate : btpTemplate.getSegments()) {
            FilteringDashboardPathSegmentDef segmentDef = null;
            BeanChildDef childDef = segmentTemplate.getChildDef();
            if (childDef.isCollection()) {
                LocalizableString name = childDef.getSingularLabel();
                String baseFormFieldName = childDef.getChildName();
                CustomPagePropertyDef criteriaDef = FilteringDashboardDefManager.customizePropertyDef(ic, name, templatePagePropertyDefs.get("TemplateBeanKeyCriteria"), "BeanKeyCriteria_" + baseFormFieldName);
                CustomPagePropertyDef valueDef = FilteringDashboardDefManager.customizePropertyDef(ic, LocalizedConstants.UNLABELED_PROPERTY, templatePagePropertyDefs.get("TemplateBeanKeyValue"), "BeanKeyValue_" + baseFormFieldName);
                FilteringDashboardDefManager.setValuesPropertyUsedIfDef(criteriaDef, valueDef);
                if (segmentTemplate.isKeySet()) {
                    valueDef.setStandardDefaultValue(new StringValue(segmentTemplate.getKey()));
                }
                CustomPagePropertyDef resultDef = FilteringDashboardDefManager.customizePropertyDef(ic, name, templatePagePropertyDefs.get("TemplateBeanKeyResult"), "BeanKeyResult_" + baseFormFieldName);
                segmentDef = new FilteringDashboardPathSegmentDef(segmentTemplate, criteriaDef, valueDef, resultDef);
            } else {
                segmentDef = new FilteringDashboardPathSegmentDef(segmentTemplate);
            }
            pathDef.add(segmentDef);
        }
        return pathDef;
    }

    private static List<PagePropertyDef> getAdvancedPagePropertyDefs(InvocationContext ic, List<PagePropertyDef> basicPagePropertyDefs, Collection<PagePropertyDef> allPagePropertyDefs) {
        HashSet<String> basicFormNames = new HashSet<String>();
        for (PagePropertyDef pagePropertyDef : basicPagePropertyDefs) {
            basicFormNames.add(pagePropertyDef.getFormFieldName());
        }
        ArrayList<PagePropertyDef> advancedPagePropertyDefs = new ArrayList<PagePropertyDef>();
        for (PagePropertyDef pagePropertyDef : allPagePropertyDefs) {
            if (basicFormNames.contains(pagePropertyDef.getFormFieldName())) continue;
            advancedPagePropertyDefs.add(pagePropertyDef);
        }
        return advancedPagePropertyDefs;
    }

    private static List<FilteringDashboardPropertyDef> createPropertyDefsFromTemplate(InvocationContext ic, BeanTreePath btpTemplate, Map<String, PagePropertyDef> templatePagePropertyDefs, List<PagePropertyDef> pagePropertyDefs) {
        ArrayList<FilteringDashboardPropertyDef> propertyDefs = new ArrayList<FilteringDashboardPropertyDef>();
        for (PagePropertyDef sourcePropertyDef : pagePropertyDefs) {
            if (sourcePropertyDef.isKey()) continue;
            String baseTemplatePropertyFormName = FilteringDashboardDefManager.getBaseTemplatePagePropertyDefName(sourcePropertyDef);
            String baseFormFieldName = sourcePropertyDef.getFormFieldName();
            CustomPagePropertyDef criteriaDef = FilteringDashboardDefManager.customizePropertyDef(ic, sourcePropertyDef.getLabel(), templatePagePropertyDefs.get(baseTemplatePropertyFormName + "Criteria"), "PropertyCriteria_" + baseFormFieldName).helpSummaryHTML(sourcePropertyDef.getHelpSummaryHTML()).detailedHelpHTML(sourcePropertyDef.getDetailedHelpHTML()).externalHelpDef(sourcePropertyDef.getExternalHelpDef());
            CustomPagePropertyDef valueDef = FilteringDashboardDefManager.customizePropertyDef(ic, LocalizedConstants.UNLABELED_PROPERTY, templatePagePropertyDefs.get(baseTemplatePropertyFormName + "Value"), "PropertyValue_" + baseFormFieldName);
            FilteringDashboardDefManager.setValuesPropertyUsedIfDef(criteriaDef, valueDef);
            valueDef.setLegalValueDefs(FilteringDashboardDefManager.getValuesPropertyLegalValueDefs(sourcePropertyDef));
            propertyDefs.add(new FilteringDashboardPropertyDef(sourcePropertyDef, criteriaDef, valueDef));
        }
        return propertyDefs;
    }

    private static String getBaseTemplatePagePropertyDefName(PagePropertyDef pagePropertyDef) {
        boolean isEnum;
        boolean bl = isEnum = !pagePropertyDef.getLegalValueDefs().isEmpty();
        if (!pagePropertyDef.isArray()) {
            if (pagePropertyDef.isInt()) {
                return isEnum ? "TemplateIntEnumProperty" : "TemplateIntProperty";
            }
            if (pagePropertyDef.isLong()) {
                return "TemplateLongProperty";
            }
            if (pagePropertyDef.isDouble()) {
                return "TemplateDoubleProperty";
            }
            if (pagePropertyDef.isBoolean()) {
                return "TemplateBooleanProperty";
            }
            if (pagePropertyDef.isDate()) {
                return "TemplateDateProperty";
            }
            if (pagePropertyDef.isDate()) {
                return "TemplateDateAsLongProperty";
            }
            if (pagePropertyDef.isString() || pagePropertyDef.isHealthState()) {
                return isEnum ? "TemplateStringEnumProperty" : "TemplateStringProperty";
            }
        }
        return "TemplateGenericProperty";
    }

    private static CustomPagePropertyDef customizePropertyDef(InvocationContext ic, LocalizableString label, PagePropertyDef uncustomizedPagePropertyDef, String formFieldName) {
        CustomPagePropertyDef rtn = new CustomPagePropertyDef(uncustomizedPagePropertyDef).formFieldName(formFieldName).writable(true);
        if (label != null) {
            rtn.setLabel(label);
        }
        return rtn;
    }

    private static void setValuesPropertyUsedIfDef(PagePropertyDef criteriaDef, CustomPagePropertyDef valueDef) {
        CustomPagePropertyUsedIfDef usedIfDef = new CustomPagePropertyUsedIfDef();
        usedIfDef.setPropertyDef(criteriaDef);
        usedIfDef.setParentPropertyDef(valueDef);
        for (LegalValueDef legalValueDef : criteriaDef.getLegalValueDefs()) {
            StringValue value = legalValueDef.getValue().asString();
            if ("unfiltered".equals(value.getValue())) continue;
            usedIfDef.getValues().add(value);
        }
        valueDef.setUsedIfDef(usedIfDef);
    }

    private static List<LegalValueDef> getValuesPropertyLegalValueDefs(PagePropertyDef sourcePropertyDef) {
        if (!sourcePropertyDef.isArray() && (sourcePropertyDef.isInt() || sourcePropertyDef.isString() || sourcePropertyDef.isHealthState())) {
            return sourcePropertyDef.getLegalValueDefs();
        }
        return List.of();
    }

    private static List<PageActionDef> createActionDefsFromTemplate(InvocationContext ic, BeanTreePath btpTemplate) {
        ArrayList<PageActionDef> rtn = new ArrayList<PageActionDef>();
        PageDef pageDef = FilteringDashboardDefManager.getPageRepoDef(ic).getPageDef(FilteringDashboardDefManager.getPageRepoDef(ic).newTablePagePath(btpTemplate.getTypeDef()));
        if (pageDef != null) {
            for (PageActionDef actionDef : pageDef.getActionDefs()) {
                String rows = actionDef.getRows();
                if (!"multiple".equals(rows) && !"one".equals(rows)) continue;
                rtn.add(actionDef);
            }
        }
        return rtn;
    }

    private static PageDef getUncustomizedCreateFormDef(InvocationContext ic, BeanTreePath btpTemplate) {
        String tree = btpTemplate.getSegments().get(0).getChildDef().getChildName();
        Path dashboardsPath = new Path(tree).childPath("Dashboards");
        BeanTreePath dashboardsBtp = BeanTreePath.create(btpTemplate.getBeanRepo(), dashboardsPath);
        PagesPath dashboardsPagesPath = FilteringDashboardDefManager.getPageRepoDef(ic).newPagesPath(dashboardsBtp.getTypeDef());
        CreateFormPagePath dashboardsCreateFormPagePath = PagePath.newCreateFormPagePath(dashboardsPagesPath);
        InvocationContext dashboardsIc = new InvocationContext(ic);
        dashboardsIc.setIdentity(dashboardsBtp);
        dashboardsIc.setPagePath(dashboardsCreateFormPagePath);
        return FilteringDashboardDefManager.getPageRepoDef(dashboardsIc).getPageDef(dashboardsCreateFormPagePath);
    }

    private static PageRepoDef getPageRepoDef(InvocationContext ic) {
        return ic.getPageRepo().getPageRepoDef();
    }
}

