/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.LocalizedConstants;
import weblogic.remoteconsole.common.repodef.PagePropertyDef;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.BeanTreePathSegment;
import weblogic.remoteconsole.server.repo.BooleanValue;
import weblogic.remoteconsole.server.repo.Dashboard;
import weblogic.remoteconsole.server.repo.DoubleValue;
import weblogic.remoteconsole.server.repo.FilteringDashboardConfig;
import weblogic.remoteconsole.server.repo.FilteringDashboardDef;
import weblogic.remoteconsole.server.repo.FilteringDashboardDefManager;
import weblogic.remoteconsole.server.repo.FilteringDashboardPathSegment;
import weblogic.remoteconsole.server.repo.FilteringDashboardPathSegmentDef;
import weblogic.remoteconsole.server.repo.FilteringDashboardProperty;
import weblogic.remoteconsole.server.repo.FilteringDashboardPropertyDef;
import weblogic.remoteconsole.server.repo.FormProperty;
import weblogic.remoteconsole.server.repo.IntValue;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.LongValue;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.Value;

public class FilteringDashboardConfigManager {
    public static Response<FilteringDashboardConfig> createConfig(InvocationContext ic, List<FormProperty> formProperties) {
        Response<FilteringDashboardConfig> response = new Response<FilteringDashboardConfig>();
        Response<FilteringDashboardConfig> configResponse = FilteringDashboardConfigManager.createDefaultConfig(ic, FilteringDashboardDefManager.getBeanTreePathFromPathQueryParam(ic), FormProperty.getStringPropertyValue("Name", formProperties, null), FormProperty.getStringPropertyValue("Description", formProperties, null), List.of());
        if (!configResponse.isSuccess()) {
            return configResponse;
        }
        FilteringDashboardConfig previousConfig = configResponse.getResults();
        FilteringDashboardConfig updatedConfig = FilteringDashboardConfigManager.updateConfig(previousConfig, formProperties);
        Response<Void> validateResponse = FilteringDashboardConfigManager.validateConfig(ic, updatedConfig);
        if (!validateResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(validateResponse);
        }
        return response.setSuccess(updatedConfig);
    }

    public static Response<FilteringDashboardConfig> updateConfig(InvocationContext ic, List<FormProperty> formProperties) {
        Response<FilteringDashboardConfig> response = new Response<FilteringDashboardConfig>();
        Response<Dashboard> dashboardResponse = ic.getPageRepo().asPageReaderRepo().getDashboardManager(ic).getDashboard(ic);
        if (!dashboardResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(dashboardResponse);
        }
        FilteringDashboardConfig previousConfig = dashboardResponse.getResults().asFilteringDashboard().getConfig();
        FilteringDashboardConfig updatedConfig = FilteringDashboardConfigManager.updateConfig(previousConfig, formProperties);
        Response<Void> validateResponse = FilteringDashboardConfigManager.validateConfig(ic, updatedConfig);
        if (!validateResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(validateResponse);
        }
        return response.setSuccess(updatedConfig);
    }

    private static FilteringDashboardConfig updateConfig(FilteringDashboardConfig previousConfig, List<FormProperty> formProperties) {
        ArrayList<FilteringDashboardPathSegment> updatedPath = new ArrayList<FilteringDashboardPathSegment>();
        Iterator<FilteringDashboardPathSegment> iterator = previousConfig.getPath().iterator();
        while (iterator.hasNext()) {
            FilteringDashboardPathSegment previousSegment;
            FilteringDashboardPathSegment updatedSegment = previousSegment = iterator.next();
            FilteringDashboardPathSegmentDef segmentDef = previousSegment.getSegmentDef();
            if (segmentDef.isFilterable()) {
                updatedSegment = new FilteringDashboardPathSegment(segmentDef, FormProperty.getStringPropertyValue(segmentDef.getCriteriaPropertyDef().getFormFieldName(), formProperties, previousSegment.getCriteria()), FormProperty.getStringPropertyValue(segmentDef.getValuePropertyDef().getFormFieldName(), formProperties, previousSegment.getValue()));
            }
            updatedPath.add(updatedSegment);
        }
        ArrayList<FilteringDashboardProperty> updatedProperties = new ArrayList<FilteringDashboardProperty>();
        for (FilteringDashboardProperty previousProperty : previousConfig.getProperties()) {
            FilteringDashboardPropertyDef propertyDef = previousProperty.getPropertyDef();
            updatedProperties.add(new FilteringDashboardProperty(propertyDef, FormProperty.getStringPropertyValue(propertyDef.getCriteriaPropertyDef().getFormFieldName(), formProperties, previousProperty.getCriteria()), FormProperty.getPropertyValue(propertyDef.getValuePropertyDef().getFormFieldName(), formProperties, previousProperty.getValue())));
        }
        return new FilteringDashboardConfig(previousConfig.getDashboardDef(), previousConfig.getName(), FormProperty.getStringPropertyValue("Description", formProperties, previousConfig.getDescription()), previousConfig.getDefaultColumns(), updatedPath, updatedProperties, previousConfig.getUnsupportedPropertyFilters());
    }

    private static Response<Void> validateConfig(InvocationContext ic, FilteringDashboardConfig config) {
        Response<Void> response = new Response<Void>();
        for (FilteringDashboardPathSegment segment : config.getPath()) {
            FilteringDashboardPathSegmentDef segmentDef = segment.getSegmentDef();
            if (!segmentDef.isFilterable() || !FilteringDashboardConfigManager.isFiltered(segment.getCriteria()) || !StringUtils.isEmpty((String)segment.getValue())) continue;
            FilteringDashboardConfigManager.reportUnspecifiedFilteredValue(ic, response, segmentDef.getResultPropertyDef());
        }
        for (FilteringDashboardProperty property : config.getProperties()) {
            if (!FilteringDashboardConfigManager.isFiltered(property.getCriteria()) || FilteringDashboardConfigManager.haveValue(property)) continue;
            FilteringDashboardConfigManager.reportUnspecifiedFilteredValue(ic, response, property.getPropertyDef().getSourcePropertyDef());
        }
        return response;
    }

    private static void reportUnspecifiedFilteredValue(InvocationContext ic, Response<Void> response, PagePropertyDef pagePropertyDef) {
        response.setUserBadRequest();
        response.addFailureMessage(ic.getLocalizer().localizeString(LocalizedConstants.UNSPECIFIED_CUSTOM_FILTERING_DASHBOARD_FILTERED_VALUE, ic.getLocalizer().localizeString(pagePropertyDef.getLabel(), new Object[0])));
    }

    private static boolean isFiltered(String criteria) {
        return !"unfiltered".equals(criteria);
    }

    private static boolean haveValue(FilteringDashboardProperty property) {
        Value value = property.getValue();
        if (value == null) {
            return false;
        }
        return !value.isString() || !StringUtils.isEmpty((String)value.asString().getValue());
    }

    public static Response<FilteringDashboardConfig> createDefaultConfig(InvocationContext ic, BeanTreePath btpTemplate, String name, String description, List<String> defaultColumns) {
        Response<FilteringDashboardConfig> response = new Response<FilteringDashboardConfig>();
        Response<FilteringDashboardDef> dashboardDefResponse = FilteringDashboardDefManager.createLocalizedDashboardDef(ic, btpTemplate);
        if (!dashboardDefResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(dashboardDefResponse);
        }
        FilteringDashboardDef dashboardDef = dashboardDefResponse.getResults();
        ArrayList<FilteringDashboardPathSegment> defaultPath = new ArrayList<FilteringDashboardPathSegment>();
        List<FilteringDashboardPathSegmentDef> segmentDefs = dashboardDef.getPathDef();
        List<BeanTreePathSegment> btpSegments = btpTemplate.getSegments();
        for (int i = 0; i < segmentDefs.size(); ++i) {
            FilteringDashboardPathSegmentDef segmentDef = segmentDefs.get(i);
            FilteringDashboardPathSegment segment = null;
            if (segmentDef.isFilterable()) {
                BeanTreePathSegment btpSegment = btpSegments.get(i);
                String beanKey = btpSegment.isKeySet() ? btpSegment.getKey() : null;
                segment = new FilteringDashboardPathSegment(segmentDef, "unfiltered", beanKey);
            } else {
                segment = new FilteringDashboardPathSegment(segmentDef);
            }
            defaultPath.add(segment);
        }
        ArrayList<FilteringDashboardProperty> defaultProperties = new ArrayList<FilteringDashboardProperty>();
        for (FilteringDashboardPropertyDef propertyDef : dashboardDef.getAllPropertyDefs()) {
            defaultProperties.add(new FilteringDashboardProperty(propertyDef, "unfiltered", FilteringDashboardConfigManager.getDefaultPropertyValue(propertyDef)));
        }
        return response.setSuccess(new FilteringDashboardConfig(dashboardDef, name, description, defaultColumns, defaultPath, defaultProperties));
    }

    private static Value getDefaultPropertyValue(FilteringDashboardPropertyDef propertyDef) {
        PagePropertyDef pagePropertyDef = propertyDef.getSourcePropertyDef();
        if (!pagePropertyDef.getLegalValueDefs().isEmpty() && (pagePropertyDef.isInt() || pagePropertyDef.isString() || pagePropertyDef.isHealthState())) {
            return pagePropertyDef.getLegalValueDefs().get(0).getValue();
        }
        if (pagePropertyDef.isInt()) {
            return new IntValue(0);
        }
        if (pagePropertyDef.isLong()) {
            return new LongValue(0L);
        }
        if (pagePropertyDef.isDouble()) {
            return new DoubleValue(0.0);
        }
        if (pagePropertyDef.isBoolean()) {
            return new BooleanValue(false);
        }
        return null;
    }
}

