/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import weblogic.remoteconsole.server.repo.FilteringDashboardDef;
import weblogic.remoteconsole.server.repo.FilteringDashboardPathSegment;
import weblogic.remoteconsole.server.repo.FilteringDashboardProperty;
import weblogic.remoteconsole.server.repo.PersistedPropertyFilter;

public class FilteringDashboardConfig {
    private String name;
    private String description;
    private FilteringDashboardDef dashboardDef;
    private List<FilteringDashboardPathSegment> path;
    private List<FilteringDashboardProperty> properties;
    private Map<String, PersistedPropertyFilter> unsupportedPropertyFilters;
    private List<String> defaultColumns;

    public FilteringDashboardConfig(FilteringDashboardDef dashboardDef, String name, String description, List<String> defaultColumns, List<FilteringDashboardPathSegment> path, List<FilteringDashboardProperty> properties) {
        this(dashboardDef, name, description, defaultColumns, path, properties, Map.of());
    }

    public FilteringDashboardConfig(String name, FilteringDashboardConfig toCopy) {
        this(toCopy.getDashboardDef(), name, toCopy.getDescription(), toCopy.getDefaultColumns(), toCopy.getPath(), toCopy.getProperties(), toCopy.getUnsupportedPropertyFilters());
    }

    public FilteringDashboardConfig(FilteringDashboardDef dashboardDef, String name, String description, List<String> defaultColumns, List<FilteringDashboardPathSegment> path, List<FilteringDashboardProperty> properties, Map<String, PersistedPropertyFilter> unsupportedPropertyFilters) {
        this.dashboardDef = dashboardDef;
        this.name = name;
        this.description = description;
        this.defaultColumns = Collections.unmodifiableList(defaultColumns);
        this.path = Collections.unmodifiableList(path);
        this.properties = Collections.unmodifiableList(properties);
        this.unsupportedPropertyFilters = Collections.unmodifiableMap(unsupportedPropertyFilters);
    }

    public FilteringDashboardDef getDashboardDef() {
        return this.dashboardDef;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getDefaultColumns() {
        return this.defaultColumns;
    }

    public List<FilteringDashboardPathSegment> getPath() {
        return this.path;
    }

    public List<FilteringDashboardProperty> getProperties() {
        return this.properties;
    }

    public Map<String, PersistedPropertyFilter> getUnsupportedPropertyFilters() {
        return this.unsupportedPropertyFilters;
    }
}

