/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import java.util.Date;
import java.util.List;
import weblogic.remoteconsole.server.repo.Dashboard;
import weblogic.remoteconsole.server.repo.FilteringDashboardConfig;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.SearchBeanResults;

public abstract class FilteringDashboard
extends Dashboard {
    private FilteringDashboardConfig config;
    private List<SearchBeanResults> results;
    private Date resultsDate;
    private Date expirationDate;

    protected FilteringDashboard(FilteringDashboardConfig config) {
        this(config, null, null, null);
    }

    protected FilteringDashboard(FilteringDashboardConfig config, List<SearchBeanResults> results, Date resultsDate, Date expirationDate) {
        this.config = config;
        this.results = results;
        this.resultsDate = resultsDate;
        this.expirationDate = expirationDate;
    }

    abstract FilteringDashboard clone(List<SearchBeanResults> var1, Date var2, Date var3);

    @Override
    public String getName() {
        return this.config.getName();
    }

    @Override
    public String getDescription() {
        return this.config.getDescription();
    }

    @Override
    public Response<String> copy(InvocationContext ic, String name) {
        return ic.getPageRepo().asPageReaderRepo().getDashboardManager(ic).createCustomFilteringDashboard(ic, new FilteringDashboardConfig(name, this.config));
    }

    public FilteringDashboardConfig getConfig() {
        return this.config;
    }

    public List<SearchBeanResults> getResults() {
        return this.results;
    }

    public Date getResultsDate() {
        return this.resultsDate;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public boolean isCurrent() {
        if (this.results == null) {
            return false;
        }
        Date now = new Date(System.currentTimeMillis());
        return now.before(this.expirationDate);
    }
}

