/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import java.util.Date;
import weblogic.remoteconsole.server.repo.DateValue;
import weblogic.remoteconsole.server.repo.LongValue;
import weblogic.remoteconsole.server.repo.Value;

public class DateAsLongValue
extends Value {
    private long value = 0L;

    public DateAsLongValue(long value) {
        this.value = value;
    }

    public DateAsLongValue(Date date) {
        if (date != null) {
            this.value = date.getTime();
        }
    }

    public DateAsLongValue(LongValue longValue) {
        this(longValue != null ? longValue.getValue() : 0L);
    }

    public DateAsLongValue(DateValue dateValue) {
        this(dateValue != null ? dateValue.getValue() : null);
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public LongValue asLong() {
        return new LongValue(this.value);
    }

    @Override
    public DateValue asDate() {
        Date date = this.value > 0L ? new Date(this.value) : null;
        return new DateValue(date);
    }

    public String toString() {
        return "DateAsLongValue<" + this.getValue() + ">";
    }
}

