/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import java.util.Date;
import java.util.HashMap;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanChildDef;
import weblogic.remoteconsole.common.repodef.PagePropertyDef;
import weblogic.remoteconsole.common.utils.DateUtils;
import weblogic.remoteconsole.server.repo.BeanTreePathSegment;
import weblogic.remoteconsole.server.repo.Dashboard;
import weblogic.remoteconsole.server.repo.Dashboards;
import weblogic.remoteconsole.server.repo.FilteringDashboardConfig;
import weblogic.remoteconsole.server.repo.FilteringDashboardPathSegment;
import weblogic.remoteconsole.server.repo.FilteringDashboardProperty;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.PersistedBeanKeyFilter;
import weblogic.remoteconsole.server.repo.PersistedDashboard;
import weblogic.remoteconsole.server.repo.PersistedDashboards;
import weblogic.remoteconsole.server.repo.PersistedFilteringDashboard;
import weblogic.remoteconsole.server.repo.PersistedPropertyFilter;
import weblogic.remoteconsole.server.repo.Value;

class DashboardsToPersistedDashboards {
    private DashboardsToPersistedDashboards() {
    }

    public static PersistedDashboards toPersistedData(InvocationContext ic, Dashboards dashboards) {
        PersistedDashboards persisted = new PersistedDashboards();
        HashMap<String, PersistedDashboard> persistedDashboards = new HashMap<String, PersistedDashboard>();
        for (Dashboard dashboard : dashboards.getDashboards().values()) {
            if (dashboard.isBuiltin()) continue;
            if (dashboard.isFilteringDashboard()) {
                FilteringDashboardConfig config = dashboard.asFilteringDashboard().getConfig();
                persistedDashboards.put(config.getName(), DashboardsToPersistedDashboards.customFilteringDashboardConfigtoPersistedData(config));
                continue;
            }
            throw new AssertionError((Object)("Unsupported dashboard: " + dashboard.getName() + " " + String.valueOf(dashboard.getClass())));
        }
        persistedDashboards.putAll(dashboards.getUnsupportedDashboards());
        persisted.setDashboards(persistedDashboards);
        return persisted;
    }

    private static PersistedDashboard customFilteringDashboardConfigtoPersistedData(FilteringDashboardConfig config) {
        PersistedFilteringDashboard persisted = new PersistedFilteringDashboard();
        persisted.setDescription(config.getDescription());
        persisted.setDefaultColumns(config.getDefaultColumns());
        HashMap<String, PersistedBeanKeyFilter> beanKeyFilters = new HashMap<String, PersistedBeanKeyFilter>();
        HashMap<String, PersistedPropertyFilter> propertyFilters = new HashMap<String, PersistedPropertyFilter>();
        Path beanTreePathTemplate = new Path();
        for (FilteringDashboardPathSegment pathSegment : config.getPath()) {
            BeanTreePathSegment btpSegment = pathSegment.getSegmentDef().getSegmentTemplate();
            beanTreePathTemplate.addPath(btpSegment.getChildDef().getChildPath());
            PersistedBeanKeyFilter filter = DashboardsToPersistedDashboards.pathSegmentToPersistedData(pathSegment);
            if (filter == null) continue;
            beanKeyFilters.put(btpSegment.getChildDef().getChildTypeDef().getInstanceName(), filter);
        }
        for (FilteringDashboardProperty property : config.getProperties()) {
            PersistedPropertyFilter filter = DashboardsToPersistedDashboards.propertyToPersistedData(property);
            if (filter == null) continue;
            propertyFilters.put(property.getPropertyDef().getSourcePropertyDef().getPropertyPath().getDotSeparatedPath(), filter);
        }
        propertyFilters.putAll(config.getUnsupportedPropertyFilters());
        persisted.setBeanTreePathTemplate(beanTreePathTemplate.getDotSeparatedPath());
        if (!beanKeyFilters.isEmpty()) {
            persisted.setBeanFilters(beanKeyFilters);
        }
        if (!propertyFilters.isEmpty()) {
            persisted.setPropertyFilters(propertyFilters);
        }
        return persisted;
    }

    private static PersistedBeanKeyFilter pathSegmentToPersistedData(FilteringDashboardPathSegment pathSegment) {
        String criteria = pathSegment.getCriteria();
        if ("unfiltered".equals(criteria)) {
            return null;
        }
        BeanChildDef childDef = pathSegment.getSegmentDef().getSegmentTemplate().getChildDef();
        if (!childDef.isCollection()) {
            return null;
        }
        PersistedBeanKeyFilter persisted = new PersistedBeanKeyFilter();
        String val = pathSegment.getValue();
        if ("equals".equals(criteria)) {
            persisted.setEquals(val);
        } else if ("contains".equals(criteria)) {
            persisted.setContains(val);
        } else {
            throw new AssertionError((Object)("Unsupported criteria " + String.valueOf(childDef) + " " + criteria));
        }
        return persisted;
    }

    private static PersistedPropertyFilter propertyToPersistedData(FilteringDashboardProperty property) {
        boolean isEnum;
        String criteria = property.getCriteria();
        Value value = property.getValue();
        if ("unfiltered".equals(criteria)) {
            return null;
        }
        PersistedPropertyFilter persisted = new PersistedPropertyFilter();
        PagePropertyDef sourceDef = property.getPropertyDef().getSourcePropertyDef();
        boolean bl = isEnum = !sourceDef.getLegalValueDefs().isEmpty();
        persisted = sourceDef.isString() || sourceDef.isHealthState() ? DashboardsToPersistedDashboards.stringPropertyToPersistedData(isEnum, criteria, value.asString().getValue(), persisted) : (sourceDef.isInt() ? DashboardsToPersistedDashboards.numberPropertyToPersistedData(isEnum, criteria, value.asInt().getValue(), persisted) : (sourceDef.isLong() ? DashboardsToPersistedDashboards.numberPropertyToPersistedData(criteria, value.asLong().getValue(), persisted) : (sourceDef.isDouble() ? DashboardsToPersistedDashboards.numberPropertyToPersistedData(criteria, value.asDouble().getValue(), persisted) : (sourceDef.isBoolean() ? DashboardsToPersistedDashboards.booleanPropertyToPersistedData(criteria, value.asBoolean().getValue(), persisted) : (sourceDef.isDate() ? DashboardsToPersistedDashboards.numberPropertyToPersistedData(criteria, DashboardsToPersistedDashboards.getPersistedValueFromDate(value.asDate().getValue()), persisted) : (sourceDef.isDateAsLong() ? DashboardsToPersistedDashboards.numberPropertyToPersistedData(criteria, DashboardsToPersistedDashboards.getPersistedValueFromDate(value.asDateAsLong().asDate().getValue()), persisted) : DashboardsToPersistedDashboards.genericPropertyToPersistedData(criteria, value.asString().getValue(), persisted)))))));
        if (persisted == null) {
            throw new AssertionError((Object)("Unsupported criteria " + String.valueOf(sourceDef) + " " + criteria));
        }
        return persisted;
    }

    private static String getPersistedValueFromDate(Date date) {
        return DateUtils.formatDate(date);
    }

    private static PersistedPropertyFilter stringPropertyToPersistedData(boolean isEnum, String criteria, String value, PersistedPropertyFilter persisted) {
        if ("equals".equals(criteria)) {
            persisted.setEquals(value);
        } else if ("notEquals".equals(criteria)) {
            persisted.setNotEquals(value);
        } else if (!isEnum && "contains".equals(criteria)) {
            persisted.setContains(value);
        } else {
            return null;
        }
        return persisted;
    }

    private static PersistedPropertyFilter numberPropertyToPersistedData(String criteria, Object value, PersistedPropertyFilter persisted) {
        return DashboardsToPersistedDashboards.numberPropertyToPersistedData(false, criteria, value, persisted);
    }

    private static PersistedPropertyFilter numberPropertyToPersistedData(boolean isEnum, String criteria, Object value, PersistedPropertyFilter persisted) {
        if ("equals".equals(criteria)) {
            persisted.setEquals(value);
        } else if ("notEquals".equals(criteria)) {
            persisted.setNotEquals(value);
        } else if (!isEnum && "lessThan".equals(criteria)) {
            persisted.setLessThan(value);
        } else if (!isEnum && "lessThanOrEquals".equals(criteria)) {
            persisted.setLessThanOrEquals(value);
        } else if (!isEnum && "greaterThan".equals(criteria)) {
            persisted.setGreaterThan(value);
        } else if (!isEnum && "greaterThanOrEquals".equals(criteria)) {
            persisted.setGreaterThanOrEquals(value);
        } else {
            return null;
        }
        return persisted;
    }

    private static PersistedPropertyFilter booleanPropertyToPersistedData(String criteria, Object value, PersistedPropertyFilter persisted) {
        if (!"equals".equals(criteria)) {
            return null;
        }
        persisted.setEquals(value);
        return persisted;
    }

    private static PersistedPropertyFilter genericPropertyToPersistedData(String criteria, String value, PersistedPropertyFilter persisted) {
        if (!"equals".equals(criteria)) {
            return null;
        }
        persisted.setEquals(value);
        return persisted;
    }
}

