/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.remoteconsole.common.repodef.BeanChildDef;
import weblogic.remoteconsole.common.repodef.LocalizedConstants;
import weblogic.remoteconsole.common.repodef.PageDef;
import weblogic.remoteconsole.common.repodef.PagePropertyDef;
import weblogic.remoteconsole.server.PersistableFeature;
import weblogic.remoteconsole.server.PersistenceManager;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchResults;
import weblogic.remoteconsole.server.repo.CustomFilteringDashboard;
import weblogic.remoteconsole.server.repo.Dashboard;
import weblogic.remoteconsole.server.repo.Dashboards;
import weblogic.remoteconsole.server.repo.DashboardsToPersistedDashboards;
import weblogic.remoteconsole.server.repo.FilteringDashboard;
import weblogic.remoteconsole.server.repo.FilteringDashboardConfig;
import weblogic.remoteconsole.server.repo.FilteringDashboardPathSegment;
import weblogic.remoteconsole.server.repo.FilteringDashboardProperty;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.PersistedDashboards;
import weblogic.remoteconsole.server.repo.PersistedDashboardsToDashboards;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.SearchBeanFilter;
import weblogic.remoteconsole.server.repo.SearchBeanFinder;
import weblogic.remoteconsole.server.repo.SearchBeanResults;
import weblogic.remoteconsole.server.repo.SearchCriteria;
import weblogic.remoteconsole.server.repo.SearchPathSegmentFilter;
import weblogic.remoteconsole.server.repo.SearchProperty;
import weblogic.remoteconsole.server.repo.SearchValueFilter;
import weblogic.remoteconsole.server.repo.TableCustomizations;
import weblogic.remoteconsole.server.repo.TableCustomizationsManager;
import weblogic.remoteconsole.server.repo.Value;

public class DashboardManager
extends PersistableFeature<PersistedDashboards> {
    private static final Logger LOGGER = Logger.getLogger(DashboardManager.class.getName());
    private static final String BUILTIN_DASHBOARDS_PATH = "builtin-dashboards.json";
    private PersistenceManager<PersistedDashboards> persistenceManager = new PersistenceManager<PersistedDashboards>(PersistedDashboards.class, "dashboards");
    private PersistedDashboards persistedBuiltinDashboards = DashboardManager.createPersistedBuiltinDashboards();
    private Dashboards dashboards = new Dashboards();
    private static final int MINIMUM_CACHEABLE_SEARCH_TIME = 3000;
    private static final int SEARCH_TIME_TO_EXPIRATION_TIME = 5;

    DashboardManager() {
    }

    @Override
    protected PersistenceManager<PersistedDashboards> getPersistenceManager() {
        return this.persistenceManager;
    }

    @Override
    protected void fromPersistedData(InvocationContext ic, PersistedDashboards persistedCustomDashboards) {
        this.dashboards = PersistedDashboardsToDashboards.fromPersistedData(ic, this.dashboards, this.persistedBuiltinDashboards, persistedCustomDashboards);
    }

    @Override
    protected PersistedDashboards toPersistedData(InvocationContext ic) {
        return DashboardsToPersistedDashboards.toPersistedData(ic, this.dashboards);
    }

    public synchronized Response<String> createCustomFilteringDashboard(InvocationContext ic, FilteringDashboardConfig config) {
        this.refresh(ic);
        Response<String> response = new Response<String>();
        String dashboardName = config.getName();
        if (this.dashboards.getDashboards().containsKey(dashboardName)) {
            response.setUserBadRequest();
            response.addFailureMessage(ic.getLocalizer().localizeString(LocalizedConstants.ALREADY_EXISTS, dashboardName));
            return response;
        }
        CustomFilteringDashboard dashboard = new CustomFilteringDashboard(config);
        this.dashboards.getDashboards().put(dashboardName, dashboard);
        this.update(ic);
        return response.setSuccess(dashboardName);
    }

    public synchronized Response<Void> deleteDashboard(InvocationContext ic, String dashboardName) {
        this.refresh(ic);
        Response response = new Response();
        Dashboard dashboard = this.dashboards.getDashboards().get(dashboardName);
        if (dashboard == null) {
            return response.setNotFound();
        }
        if (dashboard.isBuiltin()) {
            response.addFailureMessage(ic.getLocalizer().localizeString(LocalizedConstants.CANNOT_DELETE_BUILTIN_DASHBOARD, dashboardName));
            return response.setUserBadRequest();
        }
        if (dashboard.isFilteringDashboard()) {
            this.dashboards.getDashboards().remove(dashboardName);
            this.update(ic);
            TableCustomizationsManager tcManager = ic.getPageRepo().asPageReaderRepo().getTableCustomizationsManager(ic);
            tcManager.deleteTableCustomizations(ic, tcManager.getFilteringDashboardTableId(ic, dashboard.isBuiltin()));
            return response.setSuccess(null);
        }
        throw new AssertionError((Object)("Unsupported dashboard " + dashboardName + " " + String.valueOf(dashboard.getClass())));
    }

    public synchronized Response<Void> updateCustomFilteringDashboard(InvocationContext ic, FilteringDashboardConfig config) {
        this.refresh(ic);
        Response response = new Response();
        String dashboardName = config.getName();
        Dashboard dashboard = this.dashboards.getDashboards().get(dashboardName);
        if (dashboard == null) {
            return response.setNotFound();
        }
        if (dashboard.isBuiltin()) {
            response.addFailureMessage(ic.getLocalizer().localizeString(LocalizedConstants.CANNOT_MODIFY_BUILTIN_DASHBOARD, dashboardName));
            return response.setUserBadRequest();
        }
        CustomFilteringDashboard updatedDashboard = new CustomFilteringDashboard(config);
        this.dashboards.getDashboards().put(dashboardName, updatedDashboard);
        this.update(ic);
        return response.setSuccess(null);
    }

    public synchronized List<Dashboard> getDashboards(InvocationContext ic) {
        this.refresh(ic);
        return List.copyOf(this.dashboards.getDashboards().values());
    }

    public Response<Dashboard> getDashboard(InvocationContext ic) {
        return this.getDashboard(ic, ic.getBeanTreePath().getLastSegment().getKey());
    }

    public synchronized Response<Dashboard> getDashboard(InvocationContext ic, String dashboardName) {
        this.refresh(ic);
        Response<Dashboard> response = new Response<Dashboard>();
        Dashboard dashboard = this.getDashboardOrNull(ic, dashboardName);
        if (dashboard == null) {
            return response.setNotFound();
        }
        return response.setSuccess(dashboard);
    }

    public Dashboard getDashboardOrNull(InvocationContext ic) {
        return this.getDashboardOrNull(ic, ic.getBeanTreePath().getLastSegment().getKey());
    }

    public synchronized Dashboard getDashboardOrNull(InvocationContext ic, String dashboardName) {
        this.refresh(ic);
        return this.dashboards.getDashboards().get(dashboardName);
    }

    public synchronized Response<FilteringDashboard> getFilteringDashboardSearchResults(InvocationContext ic, PageDef pageDef, String dashboardName) {
        this.refresh(ic);
        Response<FilteringDashboard> response = new Response<FilteringDashboard>();
        Dashboard db = this.dashboards.getDashboards().get(dashboardName);
        if (db == null) {
            return response.setNotFound();
        }
        FilteringDashboard dashboard = db.asFilteringDashboard();
        if (!ic.isReload() && dashboard.isCurrent()) {
            return response.setSuccess(dashboard);
        }
        long startTime = System.currentTimeMillis();
        Response<List<SearchBeanResults>> searchResponse = this.doSearch(ic, pageDef, dashboard.getConfig());
        if (!searchResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(searchResponse);
        }
        long endTime = System.currentTimeMillis();
        FilteringDashboard newDashboard = dashboard.clone(searchResponse.getResults(), new Date(endTime), this.getExpirationDate(startTime, endTime));
        this.dashboards.getDashboards().put(dashboardName, newDashboard);
        return response.setSuccess(newDashboard);
    }

    private Response<List<SearchBeanResults>> doSearch(InvocationContext ic, PageDef pageDef, FilteringDashboardConfig config) {
        Response<List<SearchBeanResults>> response = new Response<List<SearchBeanResults>>();
        SearchCriteria genericCriteria = DashboardManager.createSearchCriteria(ic, pageDef, config);
        SearchBeanFinder finder = new SearchBeanFinder(ic, genericCriteria);
        boolean includeIsSet = false;
        BeanReaderRepoSearchBuilder builder = ic.getPageRepo().getBeanRepo().asBeanReaderRepo().createSearchBuilder(ic, includeIsSet);
        finder.addToSearchBuilder(builder);
        Response<BeanReaderRepoSearchResults> searchResponse = builder.search();
        if (!searchResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(searchResponse);
        }
        List<SearchBeanResults> searchResults = finder.getResults(searchResponse.getResults());
        return response.setSuccess(searchResults);
    }

    private static SearchCriteria createSearchCriteria(InvocationContext ic, PageDef pageDef, FilteringDashboardConfig config) {
        SearchCriteria criteria = new SearchCriteria();
        ArrayList<SearchBeanFilter> filters = new ArrayList<SearchBeanFilter>();
        ArrayList<SearchProperty> searchProperties = new ArrayList<SearchProperty>();
        filters.add(DashboardManager.createPathFilter(config));
        TableCustomizationsManager tcManager = ic.getPageRepo().asPageReaderRepo().getTableCustomizationsManager(ic);
        TableCustomizations customizations = tcManager.getTableCustomizations(ic, pageDef);
        List<String> displayedColumns = customizations != null && !customizations.getDisplayedColumns().isEmpty() ? customizations.getDisplayedColumns() : tcManager.getDefaultDisplayedColumns(pageDef);
        for (FilteringDashboardProperty property : config.getProperties()) {
            DashboardManager.addProperty(property, displayedColumns, filters, searchProperties);
        }
        criteria.setFilters(filters);
        criteria.setProperties(searchProperties);
        return criteria;
    }

    private static SearchBeanFilter createPathFilter(FilteringDashboardConfig config) {
        ArrayList<SearchPathSegmentFilter> segmentFilters = new ArrayList<SearchPathSegmentFilter>();
        for (FilteringDashboardPathSegment segment : config.getPath()) {
            BeanChildDef childDef = segment.getSegmentDef().getSegmentTemplate().getChildDef();
            SearchPathSegmentFilter segmentFilter = new SearchPathSegmentFilter();
            segmentFilter.setEquals(childDef.getChildName());
            segmentFilters.add(segmentFilter);
            if (!childDef.isCollection()) continue;
            String criteria = segment.getCriteria();
            SearchPathSegmentFilter segmentFilter2 = new SearchPathSegmentFilter();
            if ("equals".equals(criteria)) {
                segmentFilter2.setEquals(segment.getValue());
            } else if ("contains".equals(criteria)) {
                segmentFilter2.setContains(segment.getValue());
            } else if ("unfiltered".equals(criteria)) {
                segmentFilter2.setAnyValue(true);
            } else {
                throw new AssertionError((Object)("Unsupported path segment criteria: " + criteria));
            }
            segmentFilters.add(segmentFilter2);
        }
        SearchBeanFilter beanFilter = new SearchBeanFilter();
        beanFilter.setRequired(true);
        beanFilter.setBeanTreePath(segmentFilters);
        return beanFilter;
    }

    private static void addProperty(FilteringDashboardProperty property, List<String> displayedColumns, List<SearchBeanFilter> beanFilters, List<SearchProperty> searchProperties) {
        PagePropertyDef pagePropertyDef = property.getPropertyDef().getSourcePropertyDef();
        String propertyName = pagePropertyDef.getFormFieldName();
        if (!displayedColumns.contains(propertyName) && pagePropertyDef.isDontReturnIfHiddenColumn()) {
            return;
        }
        String criteria = property.getCriteria();
        if ("unfiltered".equals(criteria)) {
            SearchProperty searchProperty = new SearchProperty();
            searchProperty.setPropertyName(propertyName);
            searchProperties.add(searchProperty);
        } else {
            beanFilters.add(DashboardManager.createPropertyFilter(property));
        }
    }

    private static SearchBeanFilter createPropertyFilter(FilteringDashboardProperty property) {
        PagePropertyDef sourcePropertyDef = property.getPropertyDef().getSourcePropertyDef();
        SearchBeanFilter beanFilter = new SearchBeanFilter();
        String criteria = property.getCriteria();
        Value value = property.getValue();
        boolean completed = false;
        beanFilter.setRequired(true);
        beanFilter.setPropertyName(sourcePropertyDef.getFormFieldName());
        if (!sourcePropertyDef.isArray()) {
            boolean isEnum;
            completed = true;
            boolean bl = isEnum = !sourcePropertyDef.getLegalValueDefs().isEmpty();
            if (sourcePropertyDef.isString() || sourcePropertyDef.isHealthState()) {
                DashboardManager.completeStringPropertyFilter(isEnum, beanFilter, criteria, value);
            } else if (sourcePropertyDef.isInt()) {
                DashboardManager.completeNumberPropertyFilter(isEnum, beanFilter, criteria, value);
            } else if (sourcePropertyDef.isLong() || sourcePropertyDef.isDouble() || sourcePropertyDef.isDate() || sourcePropertyDef.isDateAsLong()) {
                DashboardManager.completeNumberPropertyFilter(false, beanFilter, criteria, value);
            } else if (sourcePropertyDef.isBoolean()) {
                DashboardManager.completeBooleanPropertyFilter(beanFilter, criteria, value);
            } else {
                completed = false;
            }
        }
        if (!completed) {
            DashboardManager.completeGenericPropertyFilter(beanFilter, criteria, value);
        }
        return beanFilter;
    }

    private static void completeStringPropertyFilter(boolean isEnum, SearchBeanFilter beanFilter, String criteria, Value value) {
        SearchValueFilter valueFilter = new SearchValueFilter();
        if ("equals".equals(criteria)) {
            valueFilter.setEquals(value);
        } else if ("notEquals".equals(criteria)) {
            valueFilter.setEquals(value);
            beanFilter.setMatches(false);
        } else if (!isEnum && "contains".equals(criteria)) {
            valueFilter.setContains(value.asString().getValue());
        } else {
            throw new AssertionError((Object)("Unsupported string property criteria:" + criteria));
        }
        beanFilter.setValueFilter(valueFilter);
    }

    private static void completeNumberPropertyFilter(boolean isEnum, SearchBeanFilter beanFilter, String criteria, Value value) {
        SearchValueFilter valueFilter = new SearchValueFilter();
        if ("equals".equals(criteria)) {
            valueFilter.setEquals(value);
        } else if ("notEquals".equals(criteria)) {
            valueFilter.setEquals(value);
            beanFilter.setMatches(false);
        } else if (!isEnum && "lessThan".equals(criteria)) {
            valueFilter.setLessThan(value);
        } else if (!isEnum && "lessThanOrEquals".equals(criteria)) {
            valueFilter.setLessThanOrEquals(value);
        } else if (!isEnum && "greaterThan".equals(criteria)) {
            valueFilter.setGreaterThan(value);
        } else if (!isEnum && "greaterThanOrEquals".equals(criteria)) {
            valueFilter.setGreaterThanOrEquals(value);
        } else {
            throw new AssertionError((Object)("Unsupported number property criteria:" + criteria));
        }
        beanFilter.setValueFilter(valueFilter);
    }

    private static void completeBooleanPropertyFilter(SearchBeanFilter beanFilter, String criteria, Value value) {
        SearchValueFilter valueFilter = new SearchValueFilter();
        if (!"equals".equals(criteria)) {
            throw new AssertionError((Object)("Unsupported boolean property criteria:" + criteria));
        }
        valueFilter.setEquals(value);
        beanFilter.setValueFilter(valueFilter);
    }

    private static void completeGenericPropertyFilter(SearchBeanFilter beanFilter, String criteria, Value value) {
        SearchValueFilter valueFilter = new SearchValueFilter();
        if (!"contains".equals(criteria)) {
            throw new AssertionError((Object)("Unsupported generic property criteria:" + criteria));
        }
        valueFilter.setContains(value.asString().getValue());
        beanFilter.setValueFilter(valueFilter);
    }

    private Date getExpirationDate(long startTime, long endTime) {
        long searchTime = endTime - startTime;
        if (searchTime < 3000L) {
            return new Date(endTime);
        }
        long expirationTime = endTime + 5L * searchTime;
        return new Date(expirationTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PersistedDashboards createPersistedBuiltinDashboards() {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(BUILTIN_DASHBOARDS_PATH);
        if (is != null) {
            try {
                ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
                try {
                    PersistedDashboards persistedDashboards = (PersistedDashboards)mapper.readValue(is, PersistedDashboards.class);
                    return persistedDashboards;
                }
                catch (Throwable t) {
                    LOGGER.severe("Problem reading builtin-dashboards.json : " + t.getMessage());
                    try {
                        is.close();
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Problem closing stream for builtin-dashboards.json", e);
                    }
                }
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Problem closing stream for builtin-dashboards.json", e);
                }
            }
        }
        return null;
    }
}

