/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import java.util.HashMap;
import java.util.Map;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchResults;
import weblogic.remoteconsole.server.repo.BeanSearchResults;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.Value;

public class CustomBeanSearchResults
implements BeanSearchResults {
    private BeanReaderRepoSearchResults searchResults;
    private BeanTreePath beanTreePath;
    private Map<String, PropertyResults> propertiesResults = new HashMap<String, PropertyResults>();

    public CustomBeanSearchResults(BeanReaderRepoSearchResults searchResults, BeanTreePath beanTreePath) {
        this.searchResults = searchResults;
        this.beanTreePath = beanTreePath;
    }

    @Override
    public BeanReaderRepoSearchResults getSearchResults() {
        return this.searchResults;
    }

    @Override
    public BeanTreePath getBeanTreePath() {
        return this.beanTreePath;
    }

    public void addPropertyResults(BeanPropertyDef propertyDef, Value value) {
        PropertyResults propertyResults = new PropertyResults(propertyDef, value);
        this.propertiesResults.put(this.getPropertyResultsKey(propertyDef), propertyResults);
    }

    @Override
    public Value getUnsortedValue(BeanPropertyDef propertyDef) {
        PropertyResults propertyResults = this.propertiesResults.get(this.getPropertyResultsKey(propertyDef));
        return propertyResults != null ? propertyResults.getValue() : null;
    }

    private String getPropertyResultsKey(BeanPropertyDef propertyDef) {
        return propertyDef.getPropertyPath().getDotSeparatedPath();
    }

    private static class PropertyResults {
        private BeanPropertyDef propertyDef;
        private Value value;

        private PropertyResults(BeanPropertyDef propertyDef, Value value) {
            this.propertyDef = propertyDef;
            this.value = value;
        }

        private BeanPropertyDef getPropertyDef() {
            return this.propertyDef;
        }

        private Value getValue() {
            return this.value;
        }
    }
}

