/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import java.util.List;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.PageDef;
import weblogic.remoteconsole.common.repodef.PagePropertyDef;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchResults;
import weblogic.remoteconsole.server.repo.BeanSearchResults;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.Form;
import weblogic.remoteconsole.server.repo.FormProperty;
import weblogic.remoteconsole.server.repo.FormReader;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Page;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.SettableValue;
import weblogic.remoteconsole.server.repo.Value;

class CreateFormReader
extends FormReader {
    CreateFormReader(InvocationContext invocationContext) {
        super(invocationContext);
    }

    Response<Page> getCreateForm() {
        return this.getCreateForm(this.getPageDef());
    }

    Response<Page> getCreateForm(Response<PageDef> pageDefResponse) {
        if (!pageDefResponse.isSuccess()) {
            return new Response().copyUnsuccessfulResponse(pageDefResponse);
        }
        List<PagePropertyDef> propDefs = pageDefResponse.getResults().getAllPropertyDefs();
        return this.processCreateFormSearchResults(pageDefResponse.getResults(), propDefs, this.performCreateFormSearch(propDefs));
    }

    private Response<BeanReaderRepoSearchResults> performCreateFormSearch(List<PagePropertyDef> propDefs) {
        boolean includeIsSet = true;
        BeanReaderRepoSearchBuilder builder = this.getBeanRepo().asBeanReaderRepo().createSearchBuilder(this.getInvocationContext(), includeIsSet);
        for (PagePropertyDef propDef : propDefs) {
            if (!propDef.isCreateWritable()) continue;
            this.addOptionsSourcesToSearch(builder, propDef);
            this.addParamsToSearch(builder, this.getBeanTreePath(), propDef.getGetOptionsCustomizerDef());
        }
        if (this.isDefaultValuesDependOnWebLogicDomainMode()) {
            builder.addProperty(this.getProductionModeEnabledBeanPath(), this.getProductionModeEnabledDef());
            builder.addProperty(this.getSecureModeEnabledBeanPath(), this.getSecureModeEnabledDef());
        }
        if (builder.isChangeManagerBeanRepoSearchBuilder()) {
            builder.asChangeManagerBeanRepoSearchBuilder().addChangeManagerStatus();
        }
        return builder.search();
    }

    private Response<Page> processCreateFormSearchResults(PageDef pageDef, List<PagePropertyDef> propDefs, Response<BeanReaderRepoSearchResults> searchResponse) {
        Response<Form> response = new Response<Form>();
        if (!searchResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(searchResponse);
        }
        BeanReaderRepoSearchResults searchResults = searchResponse.getResults();
        Boolean secureMode = null;
        Boolean productionMode = null;
        if (this.isDefaultValuesDependOnWebLogicDomainMode()) {
            secureMode = this.getSecureMode(searchResults);
            productionMode = this.getProductionMode(searchResults);
        }
        Form form = new Form();
        this.setPageDef(form, pageDef);
        this.addPageInfo(form);
        this.addChangeManagerStatus(form, searchResults);
        for (PagePropertyDef propDef : propDefs) {
            Response<FormProperty> propResponse = this.getFormProperty(propDef.asPagePropertyDef(), searchResults, secureMode, productionMode);
            if (!propResponse.isSuccess()) {
                return response.copyUnsuccessfulResponse(propResponse);
            }
            form.getProperties().add(propResponse.getResults());
        }
        this.addModelTokens(form);
        return response.setSuccess(form);
    }

    private Response<FormProperty> getFormProperty(PagePropertyDef propertyDef, BeanReaderRepoSearchResults searchResults, Boolean secureMode, Boolean productionMode) {
        BeanSearchResults beanResults;
        Response<FormProperty> optionsResponse;
        Response<FormProperty> response = new Response<FormProperty>();
        FormProperty formProperty = new FormProperty(propertyDef, new SettableValue(this.getDefaultValue(propertyDef, secureMode, productionMode), false));
        if (propertyDef.isCreateWritable() && !(optionsResponse = this.addOptionsAndOptionsSources(propertyDef, formProperty, beanResults = null, searchResults)).isSuccess()) {
            return response.copyUnsuccessfulResponse(optionsResponse);
        }
        return response.setSuccess(formProperty);
    }

    private Value getDefaultValue(PagePropertyDef propertyDef, Boolean secureModeEnabled, Boolean productionModeEnabled) {
        if (productionModeEnabled != null && secureModeEnabled != null) {
            return propertyDef.getDefaultValue(secureModeEnabled, productionModeEnabled);
        }
        return propertyDef.getDefaultValue();
    }

    private Boolean getSecureMode(BeanReaderRepoSearchResults searchResults) {
        Value enabled = Value.unsettableValue(searchResults.getBean(this.getSecureModeEnabledBeanPath()).getValue(this.getSecureModeEnabledDef()));
        if (enabled == null) {
            return null;
        }
        return enabled.isBoolean() ? Boolean.valueOf(enabled.asBoolean().getValue()) : null;
    }

    private Boolean getProductionMode(BeanReaderRepoSearchResults searchResults) {
        Value enabled = Value.unsettableValue(searchResults.getBean(this.getProductionModeEnabledBeanPath()).getValue(this.getProductionModeEnabledDef()));
        if (enabled == null) {
            return null;
        }
        return enabled.isBoolean() ? Boolean.valueOf(enabled.asBoolean().getValue()) : null;
    }

    private BeanPropertyDef getSecureModeEnabledDef() {
        return this.getSecureModeEnabledBeanPath().getTypeDef().getPropertyDef(new Path("SecureModeEnabled"));
    }

    private BeanPropertyDef getProductionModeEnabledDef() {
        return this.getProductionModeEnabledBeanPath().getTypeDef().getPropertyDef(new Path("ProductionModeEnabled"));
    }

    private BeanTreePath getSecureModeEnabledBeanPath() {
        return BeanTreePath.create(this.getBeanRepo(), new Path("Domain.SecurityConfiguration.SecureMode"));
    }

    private BeanTreePath getProductionModeEnabledBeanPath() {
        return BeanTreePath.create(this.getBeanRepo(), new Path("Domain"));
    }

    private boolean isDefaultValuesDependOnWebLogicDomainMode() {
        String root = this.getInvocationContext().getPageRepo().getPageRepoDef().getName();
        return "edit".equals(root) || "serverConfig".equals(root) || "compositeConfig".equals(root);
    }
}

