/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo;

import java.util.ArrayList;
import java.util.List;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.server.repo.BeanPropertyValue;
import weblogic.remoteconsole.server.repo.BeanPropertyValues;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.BeanTreePathSegment;
import weblogic.remoteconsole.server.repo.BeansPropertyValues;
import weblogic.remoteconsole.server.repo.ConfigurationTransactionHelper;
import weblogic.remoteconsole.server.repo.FormManager;
import weblogic.remoteconsole.server.repo.FormProperty;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Response;

public class CreateFormCreator
extends FormManager {
    public CreateFormCreator(InvocationContext ic, BeansPropertyValues beansPropertyValues) {
        super(ic, beansPropertyValues);
    }

    public CreateFormCreator(InvocationContext ic, List<FormProperty> formProperties) {
        super(ic, formProperties);
        this.getBeansPropertyValues().addBean(this.getInvocationContext().getBeanTreePath());
    }

    public Response<Void> create() {
        return ConfigurationTransactionHelper.editConfiguration(this.getInvocationContext(), new ConfigurationTransactionHelper.ConfigurationEditor(){

            @Override
            public Response<Void> editConfiguration() {
                return CreateFormCreator.this.doCreate();
            }
        });
    }

    private Response<Void> doCreate() {
        Response<Void> overallResponse = new Response<Void>();
        this.createTopLevelBean(overallResponse);
        if (overallResponse.isSuccess()) {
            this.updateChildBeans(overallResponse);
        }
        return overallResponse;
    }

    private void createTopLevelBean(Response<Void> overallResponse) {
        BeanPropertyValues beanPropertyValues = this.findTopLevelBeanPropertyValues();
        this.aggregateResponse(this.getBeanRepo().asBeanEditorRepo().createBean(this.getInvocationContext(), beanPropertyValues), beanPropertyValues, overallResponse);
    }

    private void updateChildBeans(Response<Void> overallResponse) {
        boolean first = true;
        for (BeanPropertyValues beanPropertyValues : this.getSortedBeansPropertyValues()) {
            if (!first) {
                this.aggregateResponse(this.getBeanRepo().asBeanEditorRepo().updateBean(this.getInvocationContext(), this.fixChildBeanPath(beanPropertyValues)), beanPropertyValues, overallResponse);
                if (!overallResponse.isSuccess()) {
                    return;
                }
            }
            first = false;
        }
    }

    private void aggregateResponse(Response<Void> oneResponse, BeanPropertyValues beanPropertyValues, Response<Void> overallResponse) {
        this.convertBeanMessagesToFormMessages(beanPropertyValues.getBeanTreePath(), oneResponse, overallResponse);
        if (!oneResponse.isSuccess()) {
            overallResponse.copyStatus(oneResponse);
        }
    }

    private BeanPropertyValues fixChildBeanPath(BeanPropertyValues beanPropertyValues) {
        BeanPropertyValues topLevelProps = this.findTopLevelBeanPropertyValues();
        BeanTreePath topLevelBeanTreePath = topLevelProps.getBeanTreePath();
        if (!topLevelBeanTreePath.isCollection()) {
            return beanPropertyValues;
        }
        BeanTreePath childBeanTreePath = beanPropertyValues.getBeanTreePath();
        BeanTreePathSegment firstRelativeSegment = childBeanTreePath.getSegments().get(topLevelBeanTreePath.getSegments().size() - 1);
        if (!firstRelativeSegment.getChildDef().isCollection() || firstRelativeSegment.isKeySet()) {
            throw new AssertionError((Object)("Child bean tree path didn't wildcard the key property: " + String.valueOf(childBeanTreePath)));
        }
        Path topLevelPath = topLevelBeanTreePath.getPath();
        Path childPath = childBeanTreePath.getPath();
        Path relativeChildPath = childPath.subPath(topLevelPath.length() + 1, childPath.length());
        String key = this.getKeyAsString(topLevelProps);
        Path actualChildPath = topLevelPath.childPath(key).childPath(relativeChildPath);
        BeanTreePath actualChildBeanTreePath = BeanTreePath.create(childBeanTreePath.getBeanRepo(), actualChildPath);
        BeanPropertyValues rtn = new BeanPropertyValues(actualChildBeanTreePath);
        for (BeanPropertyValue propertyValue : beanPropertyValues.getPropertyValues()) {
            rtn.addPropertyValue(propertyValue);
        }
        return rtn;
    }

    private String getKeyAsString(BeanPropertyValues topLevelPropertyValues) {
        BeanTreePath creatorBeanTreePath = topLevelPropertyValues.getBeanTreePath();
        if (!creatorBeanTreePath.isCollection()) {
            return null;
        }
        for (BeanPropertyValue propertyValue : topLevelPropertyValues.getPropertyValues()) {
            if (!propertyValue.getPropertyDef().isKey()) continue;
            return propertyValue.getValue().getValue().asString().getValue();
        }
        throw new AssertionError((Object)("Couldn't find the key property when creating a " + String.valueOf(creatorBeanTreePath)));
    }

    private BeanPropertyValues findTopLevelBeanPropertyValues() {
        return this.getSortedBeansPropertyValues().get(0);
    }

    private List<BeanPropertyValues> getSortedBeansPropertyValues() {
        ArrayList<BeanPropertyValues> beansValues = new ArrayList<BeanPropertyValues>();
        boolean first = true;
        for (BeanPropertyValues beanValues : this.getBeansPropertyValues().getSortedBeansPropertyValues()) {
            BeanPropertyValues setBeanValues = new BeanPropertyValues(beanValues.getBeanTreePath());
            for (BeanPropertyValue propertyValue : beanValues.getPropertyValues()) {
                if (propertyValue.getValue().isUnset()) continue;
                setBeanValues.addPropertyValue(propertyValue);
            }
            if (first || !setBeanValues.getPropertyValues().isEmpty()) {
                beansValues.add(setBeanValues);
            }
            first = false;
        }
        return beansValues;
    }
}

